/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    static final String PROPERTY_SHOW_FILES = "files";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    static final String PROPERTY_FILE_HIDING = "file_hiding";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    static File lastCurrentDir;
    private JFileChooser chooser;
    private boolean editable = true;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FileEditor;

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.env = propertyEnv;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.currentDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object object6 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILE_HIDING);
        if (object6 instanceof Boolean) {
            this.fileHiding = (Boolean)object6;
        }
        if (propertyEnv.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property property = (Node.Property)propertyEnv.getFeatureDescriptor();
            this.editable = property.canWrite();
        }
    }

    public String getAsText() {
        File file = (File)this.getValue();
        if (file == null) {
            return "";
        }
        String string = file.getPath();
        if (string.equals("")) {
            string = ".";
        }
        return string;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        if (string.equals("")) {
            this.setValue(null);
            return;
        }
        if (string.equals(".")) {
            string = "";
        }
        this.setValue(new File(string));
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            String string = "";
            Object object = this.getValue();
            if (object instanceof File) {
                string = ((File)object).getAbsolutePath();
            }
            return new StringCustomEditor(string, false);
        }
        if (this.chooser == null) {
            this.chooser = FileEditor.createHackedFileChooser();
            File file = (File)this.getValue();
            if (file != null && !file.isAbsolute() && this.baseDirectory != null) {
                file = new File(this.baseDirectory, file.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (file != null && file.getParentFile() != null) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else if (lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
        }
        return this.chooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return "null";
        }
        if (this.baseDirectory != null && !file.isAbsolute()) {
            return "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(file.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor.stringify(file.getAbsolutePath()) + ")";
    }

    static String stringify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2 + 2);
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$beaninfo$editors$FileEditor == null ? (class$org$netbeans$beaninfo$editors$FileEditor = FileEditor.class$("org.netbeans.beaninfo.editors.FileEditor")) : class$org$netbeans$beaninfo$editors$FileEditor);
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$FileEditor == null ? (class$org$netbeans$beaninfo$editors$FileEditor = FileEditor.class$("org.netbeans.beaninfo.editors.FileEditor")) : class$org$netbeans$beaninfo$editors$FileEditor)).getString(string);
    }

    static String getChildRelativePath(File file, File file2) {
        if (file2.equals(file)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(file2.getPath().length());
        stringBuffer.append(file2.getName());
        File file3 = file2.getParentFile();
        while (file3 != null) {
            if (file3.equals(file)) {
                return stringBuffer.toString();
            }
            stringBuffer.insert(0, File.separatorChar);
            stringBuffer.insert(0, file3.getName());
            file3 = file3.getParentFile();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!this.files && file.isFile()) {
            return;
        }
        if (!this.directories && file.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (string = FileEditor.getChildRelativePath(this.baseDirectory, file)) != null) {
            file = new File(string);
        }
        this.setValue(new File(file.getPath()));
        lastCurrentDir = jFileChooser.getCurrentDirectory();
    }

    static JFileChooser createHackedFileChooser() {
        Serializable serializable;
        Object object;
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.getAccessibleContext().setAccessibleDescription(FileEditor.getString("ACSD_FileEditor"));
        InputMap inputMap = jFileChooser.getInputMap(1);
        if (inputMap != null && (object = inputMap.get((KeyStroke)(serializable = KeyStroke.getKeyStroke(10, 0)))) == null) {
            inputMap.put((KeyStroke)serializable, "approveSelection");
        }
        if ((serializable = jFileChooser.getActionMap()) != null && (object = ((ActionMap)serializable).getParent()) != null) {
            final Action action = ((ActionMap)object).get("approveSelection");
            ((ActionMap)object).put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        jFileChooser.setCurrentDirectory(file);
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }
        return jFileChooser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter filenameFilter) {
            this.filter = filenameFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file.getParentFile(), file.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file);
        }

        public String getDescription() {
            return null;
        }
    }
}

