/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class StringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setAsText(String string) {
        this.setValue(string);
    }

    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        return "\"" + StringEditor.toAscii(string) + "\"";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object object = this.getValue();
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        return new StringCustomEditor(string, this.isEditable());
    }

    private static String toAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    int n2 = 0;
                    while (n2 < 4 - string2.length()) {
                        stringBuffer.append('0');
                        ++n2;
                    }
                    stringBuffer.append(string2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
        }
    }
}

