/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.projects.SystemFileSystem;
import org.netbeans.core.projects.XMLSettingsHandler;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

public class AutomountSupport
extends FolderInstance
implements TaskListener,
RepositoryListener,
Runnable {
    private static RequestProcessor RP = new RequestProcessor("Automount");
    private static ThreadLocal VAR = new ThreadLocal();
    private static DblTask defaultTask;
    private static final int DELAY = 1000;
    private static Set createdByMe;
    private static Set sticky;
    private static Set shineAway;
    private static Set errCookies;
    private static ErrorManager err;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;
    static /* synthetic */ Class array$Lorg$openide$filesystems$FileSystem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private AutomountSupport(DataObject.Container container) {
        super(container);
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < instanceCookieArray.length) {
            block8: {
                Object object;
                try {
                    object = instanceCookieArray[n].instanceCreate();
                }
                catch (IOException iOException) {
                    if (errCookies.add(instanceCookieArray[n])) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    break block8;
                }
                errCookies.remove(instanceCookieArray[n]);
                if (object instanceof FileSystem) {
                    arrayList.add(object);
                } else if (object instanceof FileSystem[]) {
                    arrayList.addAll(Arrays.asList((FileSystem[])object));
                }
            }
            ++n;
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        return arrayList.toArray(new FileSystem[0]);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new AutomountSupport(container);
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        if (instanceCookie instanceof InstanceCookie.Of) {
            InstanceCookie.Of of = (InstanceCookie.Of)instanceCookie;
            if (of.instanceOf(class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem) || of.instanceOf(array$Lorg$openide$filesystems$FileSystem == null ? (array$Lorg$openide$filesystems$FileSystem = AutomountSupport.class$("[Lorg.openide.filesystems.FileSystem;")) : array$Lorg$openide$filesystems$FileSystem)) {
                return instanceCookie;
            }
            return null;
        }
        Class<?> clazz = instanceCookie.instanceClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if ((class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).isAssignableFrom(clazz)) {
            return instanceCookie;
        }
        return null;
    }

    protected Task postCreationTask(Runnable runnable) {
        return RP.post(runnable);
    }

    public void taskFinished(Task task) {
        AutomountSupport.updateFileSystems(this.getList());
    }

    private List getList() {
        Object object = null;
        try {
            object = this.instanceCreate();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof FileSystem) {
            return Collections.nCopies(1, object);
        }
        return Arrays.asList((FileSystem[])object);
    }

    public static synchronized Task initialize() {
        if (defaultTask != null) {
            return defaultTask;
        }
        DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
        AutomountSupport automountSupport = new AutomountSupport((DataObject.Container)dataFolder);
        automountSupport.addTaskListener(automountSupport);
        RequestProcessor.Task task = RP.create((Runnable)automountSupport);
        task.setPriority(1);
        defaultTask = new DblTask((Task)automountSupport, task);
        Repository repository = Repository.getDefault();
        repository.addRepositoryListener((RepositoryListener)automountSupport);
        AutomountSupport automountSupport2 = automountSupport;
        synchronized (automountSupport2) {
            sticky.addAll(Arrays.asList(repository.toArray()));
            if (sticky.size() > 1) {
                defaultTask.store();
            }
        }
        automountSupport.recreate();
        return defaultTask;
    }

    public void run() {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    AutomountSupport.checkSaved(AutomountSupport.this.getList(), dataFolder, dataObjectArray);
                }
            });
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        defaultTask.fs(repositoryEvent);
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        defaultTask.fs(repositoryEvent);
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    private static boolean containsFS(FileSystem fileSystem) {
        FileSystem[] fileSystemArray = Repository.getDefault().toArray();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] == fileSystem) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String escape(String string) throws IOException {
        try {
            Method method = (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = AutomountSupport.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject).getDeclaredMethod("escapeAndCut", class$java$lang$String == null ? (class$java$lang$String = AutomountSupport.class$("java.lang.String")) : class$java$lang$String);
            ((AccessibleObject)method).setAccessible(true);
            return (String)method.invoke(null, (Object[])new String[]{string});
        }
        catch (Exception exception) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)exception);
        }
    }

    public static String computeNewName(String string, DataFolder dataFolder) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = true;
        String string2 = string;
        int n = 1;
        while (bl) {
            String string3;
            bl = false;
            String string4 = AutomountSupport.escape(string2);
            if (string4.equals(string3 = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string4, (String)"settings"))) continue;
            bl = true;
            string2 = string + "_" + n;
            ++n;
        }
        return string2;
    }

    private static void checkSaved(List list, DataFolder dataFolder, DataObject[] dataObjectArray) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            Object object;
            String string;
            Object object2;
            List<FileSystem> list2 = Arrays.asList(repository.toArray());
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(list2);
            arrayList.removeAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size() * 2);
            arrayList2.addAll(Arrays.asList(dataObjectArray));
            sticky.removeAll(list);
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list2);
            hashSet.retainAll(createdByMe);
            boolean bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FileSystem fileSystem = (FileSystem)iterator.next();
                if (fileSystem.isDefault()) continue;
                try {
                    Object object3 = object2 = XMLSettingsHandler.isProjectObject(fileSystem) ? null : "session";
                    if (object2 != null) {
                        SystemFileSystem.setLayerForNew(dataFolder.getPrimaryFile().toString(), (String)object2);
                    }
                    string = AutomountSupport.computeNewName(fileSystem.getDisplayName(), dataFolder);
                    try {
                        object = InstanceDataObject.create((DataFolder)dataFolder, (String)string, (Object)fileSystem, null);
                    }
                    catch (NotSerializableException notSerializableException) {
                        continue;
                    }
                    if (object2 != null) {
                        SystemFileSystem.setLayerForNew(dataFolder.getPrimaryFile().toString(), null);
                    }
                    if (object.instanceCreate() != fileSystem) {
                        StringBuffer stringBuffer = new StringBuffer(255);
                        stringBuffer.append("This bug is caused by wrong implementation of InstanceDataObject, see ");
                        stringBuffer.append("http://www.netbeans.org/issues/show_bug.cgi?id=14557");
                        stringBuffer.append("\nSTORING: ");
                        stringBuffer.append(fileSystem);
                        stringBuffer.append("\nINSTNCE: ");
                        stringBuffer.append(object.instanceCreate());
                        throw new IllegalStateException(stringBuffer.toString());
                    }
                    hashSet.add(fileSystem);
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log(" written to disk: " + fileSystem + " into: " + object);
                    }
                    arrayList2.add(object);
                    sticky.remove(fileSystem);
                    bl = true;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                }
            }
            int n = 0;
            while (n < dataObjectArray.length) {
                object2 = (InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (object2 != null) {
                    try {
                        object = object2.instanceCreate();
                        if (object instanceof FileSystem && !hashSet.contains(object)) {
                            dataObjectArray[n].delete();
                            if (AutomountSupport.isLog()) {
                                AutomountSupport.log("  deleted from disk: " + object + " from: " + dataObjectArray[n]);
                            }
                            ((AbstractCollection)arrayList2).remove(dataObjectArray[n]);
                            bl = true;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                ++n;
            }
            if (bl) {
                try {
                    dataFolder.setOrder(arrayList2.toArray(new DataObject[0]));
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("Changed order on the disk");
                        object2 = ((AbstractList)arrayList2).iterator();
                        int n2 = 0;
                        while (object2.hasNext()) {
                            string = (DataObject)object2.next();
                            InstanceCookie instanceCookie = (InstanceCookie)string.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (instanceCookie == null) continue;
                            AutomountSupport.log("  " + n2++ + " is: " + instanceCookie.instanceCreate());
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                }
            }
        }
    }

    private static void updateFileSystems(List list) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            int n;
            Object object;
            Object object2;
            Object object3;
            List<FileSystem> list2 = Arrays.asList(repository.toArray());
            LinkedList<FileSystem> linkedList = new LinkedList<FileSystem>(list2);
            linkedList.removeAll(list);
            linkedList.removeAll(sticky);
            AutomountSupport.log("sticky: " + sticky);
            linkedList.retainAll(createdByMe);
            if (AutomountSupport.isLog()) {
                object3 = linkedList.iterator();
                while (object3.hasNext()) {
                    object2 = (FileSystem)object3.next();
                    AutomountSupport.log("  r: " + object2 + " contains: " + sticky.contains(object2));
                }
            }
            object3 = new LinkedList(list);
            object3.removeAll(list2);
            object3.removeAll(shineAway);
            if (AutomountSupport.isLog()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FileSystem)object2.next();
                    AutomountSupport.log("  a: " + object + " contains: " + sticky.contains(object));
                }
            }
            VAR.set(VAR);
            AutomountSupport.cycleFileSystems(linkedList, false);
            AutomountSupport.cycleFileSystems((Collection)object3, true);
            VAR.set(null);
            createdByMe.addAll(list);
            createdByMe.retainAll(Arrays.asList(repository.toArray()));
            object2 = repository.toArray();
            object = new LinkedList(list);
            object.retainAll(Arrays.asList(object2));
            int[] nArray = new int[((Object)object2).length];
            int n2 = object.size() + 1;
            boolean bl = false;
            int n3 = 0;
            while (n3 < ((Object)object2).length) {
                if (object2[n3].isDefault()) {
                    nArray[n3] = 0;
                } else {
                    n = object.indexOf(object2[n3]);
                    n = n == -1 ? n2++ : ++n;
                    nArray[n] = n3;
                    bl |= n != n3;
                }
                ++n3;
            }
            if (bl) {
                if (AutomountSupport.isLog()) {
                    AutomountSupport.log("Doing reorder");
                    n = 0;
                    while (n < ((Object)object2).length) {
                        AutomountSupport.log("  " + n + " <- " + nArray[n] + " now: " + object2[n]);
                        ++n;
                    }
                    AutomountSupport.log("On disk");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        AutomountSupport.log("  " + iterator.next());
                    }
                    AutomountSupport.log("------");
                }
                repository.reorder(nArray);
            } else {
                AutomountSupport.log("No reoder");
            }
        }
    }

    private static void cycleFileSystems(Collection collection, boolean bl) {
        Repository repository = Repository.getDefault();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (bl) {
                FileSystem fileSystem2 = repository.findFileSystem(fileSystem.getSystemName());
                if (fileSystem2 != null && fileSystem2 != fileSystem && sticky.remove(fileSystem2)) {
                    repository.removeFileSystem(fileSystem2);
                }
                repository.addFileSystem(fileSystem);
                continue;
            }
            repository.removeFileSystem(fileSystem);
        }
    }

    private static boolean isLog() {
        if (err == null) {
            err = ErrorManager.getDefault().getInstance("org.netbeans.core.AutomountSupport");
        }
        return err.isLoggable(1);
    }

    private static void log(String string) {
        if (AutomountSupport.isLog()) {
            err.log(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$400(FileSystem fileSystem) {
        return AutomountSupport.containsFS(fileSystem);
    }

    static /* synthetic */ Set access$500() {
        return sticky;
    }

    static /* synthetic */ Set access$600() {
        return shineAway;
    }

    static /* synthetic */ DblTask access$700() {
        return defaultTask;
    }

    static {
        createdByMe = new WeakSet();
        sticky = new WeakSet();
        shineAway = new WeakSet();
        errCookies = new WeakSet();
    }

    private static final class DblTask
    extends Task
    implements TaskListener {
        private Task defaultInstance;
        private RequestProcessor.Task storeTask;
        private Task updateTask = Task.EMPTY;
        private boolean isStoring;

        public DblTask(Task task, RequestProcessor.Task task2) {
            this.defaultInstance = task;
            this.storeTask = task2;
            task.addTaskListener((TaskListener)this);
            task2.addTaskListener((TaskListener)this);
        }

        public void store() {
            DblTask dblTask = this;
            synchronized (dblTask) {
                this.storeTask.schedule(1000);
                this.isStoring = true;
            }
            this.notifyRunning();
        }

        private synchronized boolean areBothFinished() {
            boolean bl;
            boolean bl2 = bl = !this.isStoring || this.storeTask.isFinished();
            if (!bl) {
                return false;
            }
            boolean bl3 = this.defaultInstance.isFinished();
            if (!bl3) {
                return false;
            }
            boolean bl4 = this.updateTask.isFinished();
            return bl4;
        }

        public void waitFinished() {
            do {
                boolean bl;
                this.updateTask.waitFinished();
                this.defaultInstance.waitFinished();
                DblTask dblTask = this;
                synchronized (dblTask) {
                    bl = this.isStoring;
                }
                if (!bl) continue;
                this.storeTask.waitFinished();
            } while (!this.areBothFinished());
        }

        public void taskFinished(Task task) {
            if (this.areBothFinished()) {
                this.notifyFinished();
            }
        }

        public synchronized void fs(RepositoryEvent repositoryEvent) {
            boolean bl;
            boolean bl2 = bl = VAR.get() == null;
            if (!bl) {
                AutomountSupport.log("fs: " + repositoryEvent.getFileSystem() + " added: " + repositoryEvent.isAdded() + " by AU support");
                return;
            }
            RequestProcessor.Task task = RP.post(new Runnable(this, repositoryEvent){
                private final /* synthetic */ RepositoryEvent val$ev;
                private final /* synthetic */ DblTask this$0;
                {
                    this.this$0 = dblTask;
                    this.val$ev = repositoryEvent;
                }

                public void run() {
                    Repository repository;
                    Repository repository2 = repository = Repository.getDefault();
                    synchronized (repository2) {
                        FileSystem fileSystem = this.val$ev.getFileSystem();
                        boolean bl = AutomountSupport.access$400(fileSystem);
                        boolean bl2 = this.val$ev.isAdded();
                        AutomountSupport.access$300("fs: " + fileSystem + " added: " + bl2 + " contains: " + bl);
                        if (bl2) {
                            if (bl) {
                                AutomountSupport.access$500().add(fileSystem);
                                AutomountSupport.access$600().remove(fileSystem);
                                AutomountSupport.access$700().store();
                            }
                        } else if (!bl) {
                            AutomountSupport.access$500().remove(fileSystem);
                            AutomountSupport.access$600().add(fileSystem);
                            AutomountSupport.access$700().store();
                        }
                    }
                    this.this$0.removeTaskListener(this.this$0);
                }
            });
            task.addTaskListener((TaskListener)this);
            this.updateTask = task;
        }
    }
}

