/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.NotifyException;
import org.netbeans.core.execution.ExitSecurityException;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

final class NbErrorManager
extends ErrorManager {
    private static Map map = new WeakHashMap(11);
    private PrintWriter logWriter;
    private static Map lastException = new WeakHashMap(27);
    private int minLogSeverity = 2;
    private String prefix = null;
    private int uniquifier = 0;
    private static final Map uniquifiedIds = new HashMap(20);
    private static Map NESTS;
    static /* synthetic */ Class class$org$netbeans$core$NbErrorManager;
    static /* synthetic */ Class class$java$lang$Object;

    NbErrorManager() {
    }

    private PrintWriter getLogWriter() {
        NbErrorManager nbErrorManager = this;
        synchronized (nbErrorManager) {
            if (this.logWriter != null) {
                PrintWriter printWriter = this.logWriter;
                return printWriter;
            }
        }
        PrintWriter printWriter = NbTopManager.get().createErrorLogger(this.minLogSeverity);
        NbErrorManager nbErrorManager2 = this;
        synchronized (nbErrorManager2) {
            if (this.logWriter == null) {
                this.logWriter = printWriter;
            }
            PrintWriter printWriter2 = this.logWriter;
            return printWriter2;
        }
    }

    public synchronized Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        ArrayList<Ann> arrayList;
        Object v = map.get(throwable);
        if (v == null) {
            arrayList = new ArrayList<Ann>();
            map.put(throwable, arrayList);
        } else {
            arrayList = (ArrayList<Ann>)v;
        }
        arrayList.add(0, new Ann(n, string, string2, throwable2, date));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(throwable));
        return throwable;
    }

    public synchronized Throwable attachAnnotations(Throwable throwable, ErrorManager.Annotation[] annotationArray) {
        ArrayList<ErrorManager.Annotation> arrayList;
        Object v = map.get(throwable);
        if (v == null) {
            arrayList = new ArrayList<ErrorManager.Annotation>(annotationArray.length + 5);
            map.put(throwable, arrayList);
        } else {
            arrayList = (ArrayList<ErrorManager.Annotation>)v;
        }
        arrayList.addAll(0, Arrays.asList(annotationArray));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(throwable));
        return throwable;
    }

    public synchronized void notify(int n, Throwable throwable) {
        Object object;
        Object object2;
        ErrorManager.Annotation[] annotationArray = this.findAnnotations(throwable);
        if (annotationArray == null && (object2 = (Reference)lastException.get(Thread.currentThread())) != null && (object = (Throwable)((Reference)object2).get()) != null) {
            annotationArray = this.findAnnotations((Throwable)object);
        }
        lastException.remove(Thread.currentThread());
        object2 = new Exc(throwable, n, annotationArray, this.findAnnotations0(throwable, true, new HashSet()));
        object = this.getLogWriter();
        if (this.prefix != null) {
            ((PrintWriter)object).print("[" + this.prefix + "] ");
        }
        String string = ((Exc)object2).getSeverity() == 1 ? "INFORMATIONAL " : "";
        ((PrintWriter)object).println(string + "*********** Exception occurred ************ at " + ((Exc)object2).getDate());
        ((Exc)object2).printStackTrace((PrintWriter)object);
        ((PrintWriter)object).flush();
        if (((Exc)object2).getSeverity() > 1) {
            NotifyException.notify((Exc)object2);
        }
    }

    public void log(int n, String string) {
        if (this.isLoggable(n)) {
            PrintWriter printWriter = this.getLogWriter();
            if (this.prefix != null) {
                boolean bl;
                if (this.uniquifier > 1) {
                    bl = true;
                } else if (this.uniquifier == 1) {
                    Map map = uniquifiedIds;
                    synchronized (map) {
                        int n2 = (Integer)uniquifiedIds.get(this.prefix);
                        bl = n2 > 1;
                    }
                } else {
                    throw new IllegalStateException("prefix != null yet uniquifier == 0");
                }
                if (bl) {
                    printWriter.print("[" + this.prefix + " #" + this.uniquifier + "] ");
                } else {
                    printWriter.print("[" + this.prefix + "] ");
                }
            }
            printWriter.println(string);
            printWriter.flush();
        }
    }

    public boolean isLoggable(int n) {
        return n >= this.minLogSeverity;
    }

    public final ErrorManager getInstance(String string) {
        Object object;
        NbErrorManager nbErrorManager = new NbErrorManager();
        nbErrorManager.prefix = this.prefix == null ? string : this.prefix + '.' + string;
        Map map = uniquifiedIds;
        synchronized (map) {
            object = (Integer)uniquifiedIds.get(nbErrorManager.prefix);
            nbErrorManager.uniquifier = object == null ? 1 : (Integer)object + 1;
            uniquifiedIds.put(nbErrorManager.prefix, new Integer(nbErrorManager.uniquifier));
        }
        nbErrorManager.minLogSeverity = this.minLogSeverity;
        object = nbErrorManager.prefix;
        while (object != null) {
            String string2 = System.getProperty((String)object);
            if (string2 != null) {
                try {
                    nbErrorManager.minLogSeverity = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.notify(16, numberFormatException);
                }
                break;
            }
            int n = ((String)object).lastIndexOf(46);
            object = n == -1 ? null : ((String)object).substring(0, n);
        }
        return nbErrorManager;
    }

    private static Throwable extractNestedThrowable(Throwable throwable) {
        Class clazz = class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager;
        synchronized (clazz) {
            if (NESTS == null) {
                NESTS = new HashMap(50);
                NESTS.put("java.lang.ClassNotFoundException", "getException");
                NESTS.put("java.lang.ExceptionInInitializerError", "getException");
                NESTS.put("java.lang.reflect.InvocationTargetException", "getTargetException");
                NESTS.put("java.lang.reflect.UndeclaredThrowableException", "getUndeclaredThrowable");
                NESTS.put("java.security.PrivilegedActionException", "getException");
                NESTS.put("javax.naming.NamingException", "getRootCause");
                NESTS.put("javax.xml.parsers.FactoryConfigurationError", "getException");
                NESTS.put("javax.xml.transform.TransformerException", "getException");
                NESTS.put("javax.xml.transform.TransformerFactoryConfigurationError", "getException");
                NESTS.put("org.openide.compiler.CompilerGroupException", ".exception");
                NESTS.put("org.openide.src.SourceException$IO", "getReason");
                NESTS.put("org.openide.src.SourceException$Veto", "getReason");
                NESTS.put("org.openide.src.SourceVetoException", "getNestedException");
                NESTS.put("org.openide.util.MutexException", "getException");
                NESTS.put("org.openide.util.io.OperationException", "getException");
                NESTS.put("org.openide.util.io.SafeException", "getException");
                NESTS.put("org.xml.sax.SAXException", "getException");
            }
        }
        Class<?> clazz2 = throwable.getClass();
        while (clazz2 != (class$java$lang$Object == null ? NbErrorManager.class$("java.lang.Object") : class$java$lang$Object)) {
            String string = (String)NESTS.get(clazz2.getName());
            if (string != null) {
                try {
                    if (string.startsWith(".")) {
                        Field field = clazz2.getField(string.substring(1));
                        return (Throwable)field.get(throwable);
                    }
                    Method method = clazz2.getMethod(string, null);
                    return (Throwable)method.invoke((Object)throwable, null);
                }
                catch (Exception exception) {
                    System.err.println("From throwable class: " + clazz2.getName());
                    exception.printStackTrace();
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public synchronized ErrorManager.Annotation[] findAnnotations(Throwable throwable) {
        return this.findAnnotations0(throwable, false, new HashSet());
    }

    private synchronized ErrorManager.Annotation[] findAnnotations0(Throwable throwable, boolean bl, Set set) {
        String string;
        Object object;
        Object object2;
        ArrayList<Ann> arrayList = (ArrayList<Ann>)map.get(throwable);
        if (throwable instanceof MissingResourceException) {
            arrayList = arrayList == null ? new ArrayList<Ann>(1) : new ArrayList(arrayList);
            object2 = (MissingResourceException)throwable;
            object = object2.getClassName();
            if (object != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_MissingResourceException_class_name", (Object)object), null, null, null));
            }
            if ((string = object2.getKey()) != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_MissingResourceException_key", (Object)string), null, null, null));
            }
            if (arrayList.size() == 0) {
                arrayList = null;
            }
        } else {
            object2 = NbErrorManager.extractNestedThrowable(throwable);
            if (object2 != null) {
                arrayList = arrayList == null ? new ArrayList(1) : new ArrayList(arrayList);
                arrayList.add(new Ann(0, null, null, (Throwable)object2, null));
            }
        }
        if (throwable instanceof SAXParseException) {
            object2 = (SAXParseException)throwable;
            object = object2.getPublicId();
            string = object2.getSystemId();
            if (object != null || string != null) {
                int n = object2.getColumnNumber();
                int n2 = object2.getLineNumber();
                String string2 = n != -1 || n2 != -1 ? NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_sax_parse_col_line", (Object[])new Object[]{String.valueOf(object), String.valueOf(string), new Integer(n), new Integer(n2)}) : NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_sax_parse", (Object)String.valueOf(object), (Object)String.valueOf(string));
                arrayList = arrayList == null ? new ArrayList(1) : new ArrayList(arrayList);
                arrayList.add(new Ann(0, string2, null, null, null));
            }
        }
        if (bl && arrayList != null) {
            object2 = new ArrayList();
            object = arrayList.iterator();
            while (object.hasNext()) {
                string = (ErrorManager.Annotation)object.next();
                Throwable throwable2 = string.getStackTrace();
                if (throwable2 == null || set.contains(throwable2)) continue;
                set.add(throwable2);
                ErrorManager.Annotation[] annotationArray = this.findAnnotations0(throwable2, true, set);
                if (annotationArray == null || annotationArray.length <= 0) continue;
                object2.addAll(Arrays.asList(annotationArray));
            }
            arrayList.addAll((Collection<Ann>)object2);
        }
        if (arrayList == null) {
            object2 = null;
        } else {
            object2 = new ErrorManager.Annotation[arrayList.size()];
            arrayList.toArray((T[])object2);
        }
        return object2;
    }

    public String toString() {
        return super.toString() + "<" + this.prefix + "," + this.minLogSeverity + ">";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.NbErrorManager$AWTHandler");
        NESTS = null;
    }

    public static final class AWTHandler {
        public static void handle(Throwable throwable) {
            if (throwable instanceof ExitSecurityException) {
                return;
            }
            ErrorManager.getDefault().notify(131072, throwable);
        }
    }

    final class Exc {
        private Throwable t;
        private Date d;
        private ErrorManager.Annotation[] arr;
        private ErrorManager.Annotation[] arrAll;
        private int severity;

        Exc(Throwable throwable, int n, ErrorManager.Annotation[] annotationArray, ErrorManager.Annotation[] annotationArray2) {
            this.t = throwable;
            this.severity = n;
            this.arr = annotationArray == null ? new ErrorManager.Annotation[]{} : annotationArray;
            this.arrAll = annotationArray2 == null ? new ErrorManager.Annotation[]{} : annotationArray2;
        }

        String getMessage() {
            return (String)this.find(1);
        }

        String getLocalizedMessage() {
            if (this.arrAll == null) {
                return (String)this.find(2);
            }
            int n = 0;
            while (n < this.arrAll.length) {
                String string = this.arrAll[n].getLocalizedMessage();
                if (string != null) {
                    return string;
                }
                ++n;
            }
            return this.t.getLocalizedMessage();
        }

        boolean isLocalized() {
            if (this.find(2, false) == null) {
                String string = this.getLocalizedMessage();
                return string != null && !string.equals(this.getMessage());
            }
            return true;
        }

        String getClassName() {
            return (String)this.find(3);
        }

        int getSeverity() {
            if (this.severity != 0) {
                return this.severity;
            }
            int n = 0;
            while (n < this.arr.length) {
                int n2 = this.arr[n].getSeverity();
                if (n2 > this.severity) {
                    this.severity = n2;
                }
                ++n;
            }
            if (this.severity == 0) {
                this.severity = this.t instanceof Error ? 65536 : 4096;
            }
            return this.severity;
        }

        Date getDate() {
            if (this.d == null) {
                this.d = (Date)this.find(4);
            }
            return this.d;
        }

        void printStackTrace(PrintStream printStream) {
            this.printStackTrace(new PrintWriter(printStream, true));
        }

        void printStackTrace(PrintWriter printWriter) {
            this.printStackTrace(printWriter, new HashSet(10));
        }

        private void printStackTrace(PrintWriter printWriter, Set set) {
            Object object;
            Object object2;
            if (this.t != null && !set.add(this.t)) {
                NbErrorManager.this.log(16, "WARNING - ErrorManager detected cyclic exception nesting:");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable = (Throwable)iterator.next();
                    NbErrorManager.this.log(16, "\t" + throwable);
                    ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations(throwable);
                    if (annotationArray == null) continue;
                    int n = 0;
                    while (n < annotationArray.length) {
                        Throwable throwable2 = annotationArray[n].getStackTrace();
                        if (throwable2 != null) {
                            NbErrorManager.this.log(16, "\t=> " + throwable2);
                        }
                        ++n;
                    }
                }
                NbErrorManager.this.log(16, "Be sure not to annotate an exception with itself, directly or indirectly.");
                return;
            }
            int n = 0;
            while (n < this.arr.length) {
                if (this.arr[n] != null) {
                    object2 = this.arr[n].getStackTrace();
                    object = this.arr[n].getLocalizedMessage();
                    if (object == null) {
                        object = this.arr[n].getMessage();
                    }
                    if (object != null && object2 == null) {
                        printWriter.println("Annotation: " + (String)object);
                    }
                }
                ++n;
            }
            object2 = this.decompose(this.t);
            object = this.decompose(new Throwable());
            int n2 = -1;
            int n3 = 1;
            while (n3 <= Math.min(((String[])object2).length, ((String[])object).length)) {
                if (!object2[((String[])object2).length - n3].equals(object[((String[])object).length - n3])) {
                    n2 = ((String[])object2).length - n3;
                    break;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < ((String[])object2).length) {
                if (n4 == n2) {
                    printWriter.print("[catch]");
                    if (object2[n4].charAt(0) == '\t') {
                        printWriter.print(' ');
                        object2[n4] = object2[n4].substring(1);
                    }
                }
                printWriter.println(object2[n4]);
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.arr.length) {
                Throwable throwable;
                if (this.arr[n5] != null && (throwable = this.arr[n5].getStackTrace()) != null) {
                    ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations(throwable);
                    Exc exc = new Exc(throwable, 0, annotationArray, null);
                    printWriter.println("==>");
                    exc.printStackTrace(printWriter, set);
                }
                ++n5;
            }
        }

        private String[] decompose(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n\r");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            return stringArray;
        }

        private Object find(int n) {
            return this.find(n, true);
        }

        private Object find(int n, boolean bl) {
            int n2 = 0;
            while (n2 < this.arr.length) {
                ErrorManager.Annotation annotation = this.arr[n2];
                Object object = null;
                switch (n) {
                    case 1: {
                        object = annotation.getMessage();
                        break;
                    }
                    case 2: {
                        object = annotation.getLocalizedMessage();
                        break;
                    }
                    case 3: {
                        Throwable throwable = annotation.getStackTrace();
                        object = throwable == null ? null : throwable.getClass().getName();
                        break;
                    }
                    case 4: {
                        object = annotation.getDate();
                    }
                }
                if (object != null) {
                    return object;
                }
                ++n2;
            }
            if (!bl) {
                return null;
            }
            switch (n) {
                case 1: {
                    return this.t.getMessage();
                }
                case 2: {
                    return this.t.getLocalizedMessage();
                }
                case 3: {
                    return this.t.getClass().getName();
                }
                case 4: {
                    return new Date();
                }
            }
            throw new IllegalArgumentException("Unknown " + new Integer(n));
        }
    }

    private static final class Ann
    implements ErrorManager.Annotation {
        private int severity;
        private String message;
        private String localizedMessage;
        private Throwable stackTrace;
        private Date date;

        public Ann(int n, String string, String string2, Throwable throwable, Date date) {
            this.severity = n;
            this.message = string;
            this.localizedMessage = string2;
            this.stackTrace = throwable;
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }

        public Date getDate() {
            return this.date;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

