/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.netbeans.core.ui.ProductInformationPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class Splash
implements SwingConstants {
    static Reference splashRef;
    static Reference aboutRef;
    static /* synthetic */ Class class$org$netbeans$core$Splash;

    private static String getMainWindowTitle() {
        String string = System.getProperty("netbeans.buildnumber");
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_MainWindow_Title"), string);
    }

    public static void showSplashDialog() {
        SplashDialog splashDialog = new SplashDialog();
        splashDialog.show();
    }

    public static SplashOutput showSplash() {
        Window window = Splash.createW();
        window.show();
        window.toFront();
        return (SplashOutput)((Object)window);
    }

    public static void hideSplash(SplashOutput splashOutput) {
        final Window window = (Window)((Object)splashOutput);
        ((SplashOutputInternal)((Object)splashOutput)).hideRequested();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)window).setVisible(false);
                window.dispose();
            }
        });
    }

    public static boolean isVisible(SplashOutput splashOutput) {
        return !((SplashOutputInternal)((Object)splashOutput)).isHideRequested();
    }

    private static Window createW() {
        boolean bl = false;
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 1024) {
            bl = true;
        }
        if (Utilities.getOperatingSystem() == 16) {
            if (System.getProperty("env-kde_display") == null && System.getProperty("env-kdedir") == null) {
                bl = true;
            } else if (!System.getProperty("java.vm.vendor", "").startsWith("Sun")) {
                bl = true;
            } else if (!System.getProperty("java.vm.version", "").startsWith("1.3")) {
                bl = true;
            }
        }
        return bl ? new SplashWindow() : new SplashFrame();
    }

    public static final void center(Window window) {
        window.pack();
        ((Component)window).setBounds(Utilities.findCenterBounds((Dimension)window.getSize()));
    }

    static Image getSplash() {
        Image image;
        if (splashRef == null || (image = (Image)splashRef.get()) == null) {
            image = Splash.loadSplash();
            splashRef = new WeakReference<Image>(image);
        }
        return image;
    }

    static Image getAbout() {
        Image image;
        if (aboutRef == null || (image = (Image)aboutRef.get()) == null) {
            image = Splash.loadAbout();
            aboutRef = new WeakReference<Image>(image);
        }
        return image;
    }

    private static Image loadSplash() {
        URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.splash", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    private static Image loadAbout() {
        try {
            URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.about", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            return Splash.loadSplash();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SplashDialog
    extends JDialog
    implements SplashOutput,
    SplashOutputInternal,
    ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new AboutComponent();
        private ProductInformationPanel infoPanel;
        private boolean hideRequested = false;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashDialog() {
            super(WindowManager.getDefault().getMainWindow(), true);
            JPanel jPanel = new JPanel();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_About_Title"));
            jPanel.add((Component)this.splashComponent, "Center");
            jTabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Title"), jPanel);
            ProductInformationPanel productInformationPanel = new ProductInformationPanel();
            jTabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Detail"), productInformationPanel);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutDialog"));
            Splash.center(this);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)this).setVisible(false);
            this.dispose();
        }

        public void increment(int n) {
        }

        public void setMaxSteps(int n) {
        }

        public void addToMaxSteps(int n) {
        }

        public void addAndSetMaxSteps(int n) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class SplashFrame
    extends JFrame
    implements SplashOutput,
    SplashOutputInternal {
        static final long serialVersionUID = 3200319077899134000L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;

        public SplashFrame() {
            super(Splash.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(this.splashComponent);
            Splash.center(this);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void increment(int n) {
            this.splashComponent.increment(n);
        }

        public void setMaxSteps(int n) {
            this.splashComponent.setMaxSteps(n);
        }

        public void addToMaxSteps(int n) {
            this.splashComponent.addToMaxSteps(n);
        }

        public void addAndSetMaxSteps(int n) {
            this.splashComponent.addAndSetMaxSteps(n);
        }
    }

    static class SplashWindow
    extends Window
    implements SplashOutput,
    SplashOutputInternal {
        static final long serialVersionUID = 4838519880359397841L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)this.splashComponent, "Center");
            Splash.center(this);
        }

        public Dimension getPreferredSize() {
            int n = 520;
            int n2 = 316;
            n = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashWindow.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_WIDTH"));
            n2 = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashWindow.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_HEIGHT"));
            return new Dimension(n, n2);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void increment(int n) {
            this.splashComponent.increment(n);
        }

        public void setMaxSteps(int n) {
            this.splashComponent.setMaxSteps(n);
        }

        public void addToMaxSteps(int n) {
            this.splashComponent.addToMaxSteps(n);
        }

        public void addAndSetMaxSteps(int n) {
            this.splashComponent.addAndSetMaxSteps(n);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class AboutComponent
    extends SplashComponent {
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public AboutComponent() {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = AboutComponent.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            SplashComponent.image = new ImageIcon(Splash.getAbout()).getImage();
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("AboutTextBounds"), " ,");
            SplashComponent.view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            Integer n = Integer.decode(resourceBundle.getString("AboutTextColor"));
            SplashComponent.color_text = new Color(n);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class SplashComponent
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = -1162806313274828742L;
        private FontMetrics fm;
        static Rectangle view;
        static Color color_text;
        static Color color_bar;
        static Color color_edge;
        static Color color_corner;
        static boolean draw_bar;
        static Image image;
        private Rectangle dirty = new Rectangle();
        private String text;
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int tmpSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashComponent() {
            Object object;
            image = new ImageIcon(Splash.getSplash()).getImage();
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashComponent.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashRunningTextBounds"), " ,");
            view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            draw_bar = true;
            try {
                draw_bar = resourceBundle.getString("SplashShowProgressBar").equals("true");
                stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashProgressBarBounds"), " ,");
                this.bar = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                this.maxSteps = this.bar.width;
                Integer n = Integer.decode(resourceBundle.getString("SplashRunningTextColor"));
                color_text = new Color(n);
                n = Integer.decode(resourceBundle.getString("SplashProgressBarColor"));
                color_bar = new Color(n);
                n = Integer.decode(resourceBundle.getString("SplashProgressBarEdgeColor"));
                color_edge = new Color(n);
                n = Integer.decode(resourceBundle.getString("SplashProgressBarCornerColor"));
                color_corner = new Color(n);
            }
            catch (MissingResourceException missingResourceException) {
                draw_bar = false;
            }
            int n = 12;
            try {
                object = resourceBundle.getString("SplashRunningTextFontSize");
                n = Integer.parseInt((String)object);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            object = new Font("Dialog", 0, n);
            this.setFont((Font)object);
            this.fm = ((Component)this).getFontMetrics((Font)object);
        }

        public void setText(String string) {
            EventQueue.invokeLater(new Runnable(this, string){
                private final /* synthetic */ String val$text;
                private final /* synthetic */ SplashComponent this$0;
                {
                    this.this$0 = splashComponent;
                    this.val$text = string;
                }

                public void run() {
                    if (this.val$text == null) {
                        this.this$0.repaint(SplashComponent.access$000(this.this$0));
                        return;
                    }
                    if (SplashComponent.access$100(this.this$0) == null) {
                        return;
                    }
                    SplashComponent.access$200(this.this$0, this.val$text);
                    SwingUtilities.layoutCompoundLabel(SplashComponent.access$100(this.this$0), this.val$text, null, 3, 2, 3, 2, SplashComponent.view, new Rectangle(), SplashComponent.access$300(this.this$0), 0);
                    SplashComponent.access$002(this.this$0, SplashComponent.access$000(this.this$0).union(SplashComponent.access$300(this.this$0)));
                    this.this$0.repaint(SplashComponent.access$000(this.this$0));
                    SplashComponent.access$002(this.this$0, new Rectangle(SplashComponent.access$300(this.this$0)));
                }
            });
        }

        public void setMaxSteps(int n) {
            this.maxSteps = n;
        }

        public void addToMaxSteps(int n) {
            this.tmpSteps += n;
        }

        public void addAndSetMaxSteps(int n) {
            this.tmpSteps += n;
            this.maxSteps = this.tmpSteps;
        }

        public void increment(int n) {
            if (draw_bar) {
                this.progress += n;
                if (this.progress > this.maxSteps) {
                    this.progress = this.maxSteps;
                } else if (this.maxSteps > 0) {
                    this.barLength = this.bar.width * this.progress / this.maxSteps - this.barStart;
                    this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                    this.repaint(this.bar_inc);
                }
            }
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int n = this.fm.stringWidth(string);
            if (n > SplashComponent.view.width) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = string2 == null ? string3 : string2 + " " + string3;
                    if (this.fm.stringWidth(string4 + "...") > SplashComponent.view.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string4;
                }
            } else {
                this.text = string;
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(color_text);
            graphics.drawImage(image, 0, 0, null);
            if (this.text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, view, new Rectangle(), this.rect, 0);
            graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            if (draw_bar && !Boolean.getBoolean("netbeans.splash.nobar") && this.maxSteps > 0) {
                graphics.setColor(color_bar);
                graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                graphics.setColor(color_corner);
                graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                graphics.setColor(color_edge);
                graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(image.getWidth(null), image.getHeight(null));
        }

        public boolean isOpaque() {
            return true;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ Rectangle access$000(SplashComponent splashComponent) {
            return splashComponent.dirty;
        }

        static /* synthetic */ FontMetrics access$100(SplashComponent splashComponent) {
            return splashComponent.fm;
        }

        static /* synthetic */ void access$200(SplashComponent splashComponent, String string) {
            splashComponent.adjustText(string);
        }

        static /* synthetic */ Rectangle access$300(SplashComponent splashComponent) {
            return splashComponent.rect;
        }

        static /* synthetic */ Rectangle access$002(SplashComponent splashComponent, Rectangle rectangle) {
            splashComponent.dirty = rectangle;
            return splashComponent.dirty;
        }
    }

    private static interface SplashOutputInternal {
        public void hideRequested();

        public boolean isHideRequested();
    }

    public static interface SplashOutput {
        public void print(String var1);

        public void setMaxSteps(int var1);

        public void addToMaxSteps(int var1);

        public void addAndSetMaxSteps(int var1);

        public void increment(int var1);
    }
}

