/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.text.MessageFormat;
import org.netbeans.core.execution.DefaultSysProcess;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutorTaskImpl;
import org.netbeans.core.execution.IOThreadIfc;
import org.netbeans.core.execution.ProcessNode;
import org.netbeans.core.execution.TaskIO;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.TopManager;
import org.openide.windows.InputOutput;

final class RunClassThread
extends Thread
implements IOThreadIfc {
    private InputOutput io;
    String allName;
    private final ExecutionEngine engine;
    private final ExecutorTaskImpl task;
    private Runnable run;
    static int number = 0;
    TaskThreadGroup mygroup;
    boolean finalized;

    public RunClassThread(TaskThreadGroup taskThreadGroup, String string, int n, InputOutput inputOutput, ExecutionEngine executionEngine, ExecutorTaskImpl executorTaskImpl, Runnable runnable) {
        super((ThreadGroup)taskThreadGroup, "exec_" + string + "_" + n);
        this.mygroup = taskThreadGroup;
        this.mygroup.setRunClassThread(this);
        this.allName = string;
        this.io = inputOutput;
        this.engine = executionEngine;
        this.task = executorTaskImpl;
        this.run = runnable;
        this.finalized = false;
        this.start();
    }

    public void run() {
        Object object;
        DefaultSysProcess defaultSysProcess;
        this.mygroup.setFinalizable();
        boolean bl = true;
        if (this.allName == null) {
            this.allName = RunClassThread.generateName();
            bl = false;
        }
        String string = MessageFormat.format(ProcessNode.getBundle().getString("CTL_ProgramIO"), this.allName);
        if (this.io != null) {
            defaultSysProcess = new DefaultSysProcess(this, this.mygroup, this.io, this.allName);
            object = new TaskIO(this.io, string, true);
            this.io.select();
            ExecutionEngine.getTaskIOs().put(this.io, object);
        } else {
            object = null;
            object = ExecutionEngine.getTaskIOs().getTaskIO(string);
            if (object == null) {
                this.io = TopManager.getDefault().getIO(string);
                object = new TaskIO(this.io, string);
            } else {
                this.io = ((TaskIO)object).getInout();
            }
            this.io.select();
            this.io.setFocusTaken(true);
            ExecutionEngine.getTaskIOs().put(this.io, object);
            defaultSysProcess = new DefaultSysProcess(this, this.mygroup, this.io, this.allName);
        }
        object = null;
        try {
            object = new ExecutionEvent((Object)this.engine, defaultSysProcess, this.isUserImportant(this.run));
            if (bl) {
                this.engine.fireExecutionStarted((ExecutionEvent)object);
            }
            Object object2 = this.task.lock;
            synchronized (object2) {
                this.task.proc = defaultSysProcess;
                this.task.lock.notifyAll();
            }
            this.run.run();
            this.run = null;
            int n = 2;
            try {
                n = defaultSysProcess.result();
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
            this.task.result = n;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Thread.interrupted();
            if (object != null && bl) {
                this.engine.fireExecutionFinished((ExecutionEvent)object);
            }
            ExecutionEngine.closeGroup(this.mygroup);
            this.task.finished();
            ExecutionEngine.getTaskIOs().free(this.mygroup, this.io);
            this.mygroup = null;
            this.io = null;
            RunClassThread runClassThread = this;
            synchronized (runClassThread) {
                this.finalized = true;
                this.notifyAll();
            }
            throw throwable;
        }
        Thread.interrupted();
        if (object != null && bl) {
            this.engine.fireExecutionFinished((ExecutionEvent)object);
        }
        ExecutionEngine.closeGroup(this.mygroup);
        this.task.finished();
        ExecutionEngine.getTaskIOs().free(this.mygroup, this.io);
        this.mygroup = null;
        this.io = null;
        RunClassThread runClassThread = this;
        synchronized (runClassThread) {
            this.finalized = true;
            this.notifyAll();
        }
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public synchronized boolean waitForEnd() throws InterruptedException {
        if (this.finalized) {
            return true;
        }
        this.wait(1000L);
        return this.finalized;
    }

    private boolean isUserImportant(Runnable runnable) {
        return !"org.openide.compiler.CompilerExecutor$CERunnable".equals(runnable.getClass().getName());
    }

    static String generateName() {
        return MessageFormat.format(ProcessNode.getBundle().getString("CTL_GeneratedName"), new Integer(number++));
    }
}

