/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.core.actions.NextOutJumpAction;
import org.netbeans.core.actions.PreviousOutJumpAction;
import org.netbeans.core.output.OutputSettings;
import org.netbeans.core.output.OutputTabProvider;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.WellKnownModeNames;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.RegionException;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.WordDelineator;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PopupAction;
import org.openide.awt.MouseUtils;
import org.openide.awt.SplittedPanel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class OutputTabTerm
extends TopComponent
implements InputOutput,
WellKnownModeNames,
TopComponentListener {
    public static boolean DEBUG = false;
    public static final String ICON_RESOURCE = "/org/netbeans/core/resources/frames/output.gif";
    private boolean focusTaken = false;
    private boolean amISelected;
    private Reader inReader;
    PipedWriter inWriter = new PipedWriter();
    private boolean errSeparated;
    private boolean inVisible;
    private boolean errVisible;
    private static boolean compilerPrinted = false;
    static WeakHashMap ioCache = new WeakHashMap(7);
    private SplittedPanel splittedInside;
    private int splitTypeBackup = 2;
    private static OutputTabTerm standard;
    private static OutputTabTerm compiler;
    private static final long serialVersionUID = 3276412782250080205L;
    private static String compiler_name;
    private OutTermPane output;
    private OutTermPane error;
    private static Factory factory;
    private boolean hideOnly = false;
    private Replace replace;
    private static HashSet keyStrokeSet;
    private static HashSet keyStrokeSet2;
    private static final boolean safe_way = true;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

    private static void debug(String string) {
        if (!DEBUG) {
            return;
        }
        string = "OutputTabTerm:" + string + "\r\n";
        try {
            String string2 = OutputTabTerm.outputSettings().getDirectory().getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + "/debug.log", true);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private OutputTabTerm(String string) {
        Class clazz = class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm;
        synchronized (clazz) {
            this.setName(string);
            this.setActivatedNodes(null);
            ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
            this.errSeparated = false;
            ((WindowManagerImpl)WindowManager.getDefault()).addTopComponentListener(this);
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 0, 0);
            this.splittedInside = new SplittedPanel();
            ((Container)((Object)this)).add((Component)this.splittedInside, gridBagConstraints);
            this.output = new OutTermPane(this);
            this.error = new OutTermPane(this);
            this.splittedInside.add((Component)this.output, SplittedPanel.ADD_FIRST);
            this.splittedInside.add((Component)this.error, SplittedPanel.ADD_SECOND);
            this.errVisible = false;
            this.splittedInside.setSplitType(0);
            ioCache.put(string, this);
            this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("ACSN_OutputWindow"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("ACSD_OutputWindow"));
        }
    }

    static synchronized Factory getFactory() {
        if (factory == null) {
            factory = new Factory();
        }
        return factory;
    }

    public static InputOutput getIO(String string, boolean bl) {
        InputOutput inputOutput = OutputTabTerm.getFactory().getIO(string, bl);
        return inputOutput;
    }

    public static OutputWriter getStdOut() {
        return OutputTabTerm.getFactory().getStdOut();
    }

    public static TopComponent getStdOutputTab() {
        return OutputTabTerm.getFactory().getStdOutputTab();
    }

    public synchronized Object writeReplace() throws ObjectStreamException {
        if (!this.equals(standard) && !this.equals(compiler)) {
            return null;
        }
        if (this.replace == null) {
            this.replace = new Replace(this.equals(standard));
            if (this.equals(compiler)) {
                this.replace.setInstanceType(1);
            }
        }
        return this.replace;
    }

    public Term getTerm() {
        return this.getTerm(true);
    }

    public Term getTerm(boolean bl) {
        if (bl) {
            return this.output.getTerm();
        }
        return this.error.getTerm();
    }

    public String toString() {
        Term term = this.getTerm(true);
        if (term == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= term.getCursorCoord().row) {
            if (n > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(term.getRowText(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    void ensureOpen() {
        if (this.isClosed()) {
            this.open();
        }
    }

    private static synchronized void initialize() {
        if (standard == null) {
            standard = new OutputTabTerm(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_OutputWindow_OutputTab"));
            ((JComponent)((Object)standard)).putClientProperty("PersistenceType", null);
        }
    }

    private static synchronized void initializeComp() {
        if (compiler == null) {
            compiler = new OutputTabTerm(OutputTabTerm.getCompilerName());
            ((JComponent)((Object)compiler)).putClientProperty("PersistenceType", null);
        }
    }

    static String getOutDisplayName() {
        return NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle").getString("CTL_OutputWindow");
    }

    protected void componentActivated() {
        this.amISelected = true;
        this.output.activated();
    }

    public void requestFocus() {
        super.requestFocus();
        this.output.requestFocus();
    }

    protected void componentDeactivated() {
        this.amISelected = false;
        this.output.deactivated();
    }

    public boolean isFocusTaken() {
        return this.focusTaken;
    }

    public void setFocusTaken(boolean bl) {
        this.focusTaken = bl;
    }

    public OutputWriter getOut() {
        return this.output.writer;
    }

    public void select() {
        if (this.equals(compiler) && !compilerPrinted) {
            return;
        }
        this.ensureOpen();
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (OutputTabTerm.this.equals(compiler)) {
                    OutputTabTerm.this.requestVisible();
                } else {
                    OutputTabTerm.this.requestFocus();
                }
            }
        });
    }

    public OutputWriter getErr() {
        if (this.errSeparated) {
            return this.error.writer;
        }
        return this.output.writer;
    }

    public Reader getIn() {
        this.flushReader();
        this.setInputVisible(true);
        return this.inReader;
    }

    public void setErrSeparated(boolean bl) {
        if (this.errSeparated == bl) {
            return;
        }
        this.errSeparated = bl;
        this.setErrVisible(this.errSeparated);
    }

    public Reader flushReader() {
        this.output.setReadWrite();
        this.inWriter = new PipedWriter();
        try {
            this.inReader = new PipedReader(this.inWriter);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return this.inReader;
    }

    public void setOutputVisible(boolean bl) {
        if (bl) {
            this.ensureOpen();
            this.requestFocus();
        } else {
            this.hideOnly = true;
            this.doClose();
        }
    }

    public void setErrVisible(boolean bl) {
        if (this.errVisible == bl) {
            return;
        }
        this.errVisible = bl;
        if (this.errVisible && this.errSeparated) {
            this.splittedInside.setSplitType(this.splitTypeBackup);
        } else {
            this.splitTypeBackup = this.splittedInside.getSplitType();
            if (this.splitTypeBackup == 0) {
                this.splitTypeBackup = 2;
            }
            this.splittedInside.setSplitType(0);
        }
        ((Container)((Object)this)).invalidate();
        Container container = ((Component)((Object)this)).getParent();
        if (container != null) {
            container.validate();
        }
    }

    public boolean isClosed() {
        Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
        return !this.isOpened(workspace);
    }

    public void setInputVisible(boolean bl) {
        if (bl) {
            this.ensureOpen();
            this.requestFocus();
        }
    }

    public boolean isErrSeparated() {
        return this.errSeparated;
    }

    public void closeInputOutput() {
        this.doClose();
        try {
            this.inWriter.flush();
            this.inWriter.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.output.writer.close();
        this.error.writer.close();
    }

    private void doClose() {
        if (this.isOpened()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    OutputTabTerm.this.close();
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    public void open(Workspace workspace) {
        Mode mode;
        Workspace workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
        Mode mode2 = workspace2.findMode("output");
        if (mode2 == null) {
            mode2 = workspace2.createMode("output", OutputTabTerm.getOutDisplayName(), (class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm).getResource(ICON_RESOURCE));
            ((ModeImpl)mode2).addIgnoredNameClass(this.getClass());
        }
        if ((mode = workspace2.findMode((TopComponent)this)) == null) {
            mode2.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    public void setCompilationFinished() {
        this.output.setCompilationFinished();
    }

    static String getCompilerName() {
        if (compiler_name == null) {
            try {
                compiler_name = NbBundle.getBundle((String)"org.netbeans.core.compiler.Bundle").getString("CTL_CompileTab");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return compiler_name;
    }

    public void selectedNodesChanged(SelectedNodesChangedEvent selectedNodesChangedEvent) {
    }

    public void topComponentClosed(TopComponentChangedEvent topComponentChangedEvent) {
        if (topComponentChangedEvent.topComponent == this && !this.hideOnly) {
            this.output.doClear();
            this.error.doClear();
        }
        this.hideOnly = false;
    }

    public void topComponentOpened(TopComponentChangedEvent topComponentChangedEvent) {
    }

    public void topComponentActivated(TopComponentChangedEvent topComponentChangedEvent) {
    }

    private static OutputSettings outputSettings() {
        return (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutputTabTerm.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
    }

    private static void updateKeyStrokeSet() {
        keyStrokeSet.clear();
        keyStrokeSet.addAll(Arrays.asList(TopManager.getDefault().getGlobalKeymap().getBoundKeyStrokes()));
        int n = 65;
        while (n <= 90) {
            keyStrokeSet.add(KeyStroke.getKeyStroke(n, 8));
            ++n;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(new Character('\u0014'), 3);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(new Character('\u0014'), 2);
        keyStrokeSet2 = (HashSet)keyStrokeSet.clone();
        keyStrokeSet2.add(keyStroke);
        keyStrokeSet2.add(keyStroke2);
    }

    private static HashSet getCommonKeyStrokeSet() {
        if (keyStrokeSet != null) {
            return keyStrokeSet;
        }
        keyStrokeSet = new HashSet();
        TopManager topManager = TopManager.getDefault();
        topManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("globalKeymap")) {
                    OutputTabTerm.updateKeyStrokeSet();
                }
            }
        });
        OutputTabTerm.updateKeyStrokeSet();
        return keyStrokeSet;
    }

    private static HashSet getCommonKeyStrokeSet2() {
        OutputTabTerm.getCommonKeyStrokeSet();
        return keyStrokeSet2;
    }

    private static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compiler_name = null;
        keyStrokeSet = null;
        keyStrokeSet2 = null;
    }

    public static final class OutTermPane
    extends JPanel
    implements ActionPerformer,
    ActionListener,
    PropertyChangeListener,
    Runnable {
        static final long serialVersionUID = -633812012958420549L;
        private static final String REDIR_EXT = ".out";
        TermOutputWriter writer;
        OutputTabTerm tab;
        private static CopyAction copy = (CopyAction)SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = OutTermPane.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
        private static CutAction cut = (CutAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = OutTermPane.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), (boolean)true);
        private static DeleteAction delete = (DeleteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = OutTermPane.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), (boolean)true);
        private static PasteAction paste = (PasteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = OutTermPane.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
        private static NextOutJumpAction nextAction = (NextOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$actions$NextOutJumpAction == null ? (class$org$netbeans$core$actions$NextOutJumpAction = OutTermPane.class$("org.netbeans.core.actions.NextOutJumpAction")) : class$org$netbeans$core$actions$NextOutJumpAction));
        private static PreviousOutJumpAction previousAction = (PreviousOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$actions$PreviousOutJumpAction == null ? (class$org$netbeans$core$actions$PreviousOutJumpAction = OutTermPane.class$("org.netbeans.core.actions.PreviousOutJumpAction")) : class$org$netbeans$core$actions$PreviousOutJumpAction));
        private JumpActionPerformer jumpPerformer = new JumpActionPerformer();
        private ActionPerformer copyActionPerformer = null;
        CallbackSystemAction csa;
        private HashMap listeners = new HashMap();
        JPopupMenu jPopup;
        private JMenuItem selectAllItem;
        private JMenuItem clearItem;
        private JMenuItem redirItem;
        private TermListener listener;
        private TermInputListener input_listener;
        ActiveTerm term;
        private boolean redirection = false;
        private int tabSize;
        private static MessageFormat formatOfException;
        private ActiveRegion currentHyperlink = null;
        private ActiveRegion activeHyperlink = null;
        private boolean next_wrap_warned = false;
        private boolean prev_wrap_warned = false;
        private boolean linkOnStart = false;
        private boolean hyperlinkNavigationEnabled = false;
        private ArrayList runnables = new ArrayList();
        private boolean runningRunnables;
        private Object syncObject = new Object();
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$netbeans$core$actions$NextOutJumpAction;
        static /* synthetic */ Class class$org$netbeans$core$actions$PreviousOutJumpAction;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm$OutTermPane;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm;
        static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

        public OutTermPane() {
            this((OutputTabTerm)null);
        }

        public OutTermPane(OutputTabTerm outputTabTerm) {
            this.tab = outputTabTerm;
            this.listener = new TermListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void sizeChanged(Dimension dimension, Dimension dimension2) {
                }
            };
            this.term = new ActiveTerm();
            this.updateNextPrevActions();
            OutTermPane.outputSettings().addPropertyChangeListener(this);
            this.term.addListener(this.listener);
            this.term.setCursorVisible(false);
            this.term.setReadOnly(true);
            this.term.setHistorySize(OutTermPane.outputSettings().getHistorySize());
            this.term.pushStream((TermStream)new LineDiscipline());
            if (outputTabTerm != null) {
                this.input_listener = new TIListener(outputTabTerm);
                this.term.addInputListener(this.input_listener);
            }
            this.term.setClickToType(true);
            this.term.setAutoCopy(false);
            this.term.setScrollOnOutput(false);
            if (outputTabTerm != null) {
                this.term.getAccessibleContext().setAccessibleName(((Component)((Object)outputTabTerm)).getName());
            }
            this.writer = new TermOutputWriter(this.term);
            this.term.setWordDelineator(new WordDelineator(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public int charClass(char c) {
                    if (Character.isJavaIdentifierPart(c)) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.term);
            this.jPopup = SystemAction.createPopupMenu((SystemAction[])new SystemAction[]{copy});
            this.redirection = outputTabTerm == null ? false : OutTermPane.outputSettings().isRedirection();
            this.selectAllItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm$OutTermPane == null ? (class$org$netbeans$core$output$OutputTabTerm$OutTermPane = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm$OutTermPane")) : class$org$netbeans$core$output$OutputTabTerm$OutTermPane)).getString("CTL_SelectAll"));
            this.selectAllItem.addActionListener(this);
            this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.jPopup.add(this.selectAllItem);
            this.jPopup.addSeparator();
            this.clearItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm$OutTermPane == null ? (class$org$netbeans$core$output$OutputTabTerm$OutTermPane = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm$OutTermPane")) : class$org$netbeans$core$output$OutputTabTerm$OutTermPane)).getString("CTL_Clear"));
            this.clearItem.addActionListener(this);
            this.jPopup.add(this.clearItem);
            this.redirItem = new JMenuItem();
            this.redirItem.addActionListener(this);
            this.redirItem.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("HINT_Redirect_Tab"));
            if (outputTabTerm != null) {
                this.checkRedirItem();
                this.jPopup.addSeparator();
                this.jPopup.add(this.redirItem);
            }
            this.term.setActionListener(new ActiveTermListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void action(ActiveRegion activeRegion, InputEvent inputEvent) {
                    if (activeRegion.end.equals(new Coord())) {
                        return;
                    }
                    if (inputEvent instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)inputEvent;
                        if (activeRegion.parent() != this.this$0.term.regionManager().root()) {
                            activeRegion = activeRegion.parent();
                        }
                        OutTermPane.access$600(this.this$0, activeRegion);
                        OutTermPane.access$700(this.this$0, true);
                    }
                }
            });
            this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet());
            this.term.getCanvas().addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                        this.this$0.jPopup.show((Component)this.this$0.term, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.term.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectionExtent".equals(propertyChangeEvent.getPropertyName())) {
                        OutTermPane.access$900(this.this$0);
                    }
                }
            });
            this.term.getCanvas().addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    Object var2_2 = null;
                    switch (keyEvent.getKeyCode()) {
                        case 10: 
                        case 32: {
                            keyEvent.consume();
                            OutTermPane.access$700(this.this$0, true);
                            break;
                        }
                        case 84: {
                            if (keyEvent.getModifiers() == 3) {
                                OutTermPane.access$1000(this.this$0);
                                keyEvent.consume();
                                break;
                            }
                            if (keyEvent.getModifiers() != 2) break;
                            OutTermPane.access$1102(this.this$0, false);
                            OutTermPane.access$1200(this.this$0);
                            keyEvent.consume();
                            break;
                        }
                        case 65: {
                            if (keyEvent.getModifiers() != 2) break;
                            OutTermPane.access$1300(this.this$0);
                        }
                    }
                }
            });
            this.setSettings();
        }

        public Term getTerm() {
            return this.term;
        }

        public OutputWriter getOut() {
            return this.writer;
        }

        void updateNextPrevActions() {
            if (this.firstHyperlink() != null) {
                nextAction.setActionPerformer(this.jumpPerformer);
                previousAction.setActionPerformer(this.jumpPerformer);
            } else {
                nextAction.setActionPerformer(null);
                previousAction.setActionPerformer(null);
            }
        }

        private boolean updateCopyCutAction() {
            boolean bl;
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
            if (this.term.getSelectedText() != null && this.term.getSelectedText().length() > 0) {
                copy.setActionPerformer(this.getCopyActionPerformer());
                bl = true;
            } else {
                copy.setActionPerformer(null);
                bl = false;
            }
            this.updatePasteAction();
            return bl;
        }

        private void updatePasteAction() {
            if (this.term.isReadOnly()) {
                paste.setPasteTypes(null);
                return;
            }
            Clipboard clipboard = OutTermPane.getClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) {
                paste.setPasteTypes(null);
                return;
            }
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                paste.setPasteTypes(null);
                return;
            }
            paste.setPasteTypes(new PasteType[]{new PasteType(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public Transferable paste() throws IOException {
                    this.this$0.term.paste();
                    return null;
                }
            }});
        }

        private ActionPerformer getCopyActionPerformer() {
            if (this.copyActionPerformer == null) {
                this.copyActionPerformer = new CopyActionPerformer(this.term);
            }
            return this.copyActionPerformer;
        }

        private static Clipboard getClipboard() {
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = OutTermPane.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
            if (clipboard == null) {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            return clipboard;
        }

        private void activateHyperlink(boolean bl) {
            if (this.currentHyperlink != null) {
                int n;
                int n2;
                int n3;
                this.invokeJumpListener(this.currentHyperlink.begin, bl);
                if (this.activeHyperlink != null) {
                    n3 = this.activeHyperlink.begin.row;
                    n2 = this.activeHyperlink.end.row;
                    n = n3;
                    while (n <= n2) {
                        this.term.setRowGlyph(n, 0, 0);
                        ++n;
                    }
                }
                this.activeHyperlink = this.currentHyperlink;
                if (this.activeHyperlink != null) {
                    n3 = this.activeHyperlink.begin.row;
                    n2 = this.activeHyperlink.end.row;
                    n = n3;
                    while (n <= n2) {
                        this.term.setRowGlyph(n, 0, 59);
                        ++n;
                    }
                    this.term.flush();
                }
            }
        }

        private ActiveRegion firstHyperlink() {
            ActiveRegion activeRegion = this.term.regionManager().root();
            if (activeRegion != null) {
                activeRegion = activeRegion.firstChild();
            }
            return activeRegion;
        }

        private ActiveRegion lastHyperlink() {
            ActiveRegion activeRegion = this.term.regionManager().root();
            if (activeRegion != null) {
                activeRegion = activeRegion.lastChild();
            }
            return activeRegion;
        }

        private boolean nextHyperlink() {
            return this.nextHyperlink(false);
        }

        private boolean nextHyperlink(boolean bl) {
            ActiveRegion activeRegion = this.currentHyperlink;
            if (activeRegion == null) {
                activeRegion = this.firstHyperlink();
            } else if (bl && this.linkOnStart) {
                activeRegion = this.firstHyperlink();
            } else {
                this.prev_wrap_warned = false;
                if ((activeRegion = activeRegion.getNextSibling()) == null) {
                    if (this.next_wrap_warned) {
                        this.next_wrap_warned = false;
                        activeRegion = this.firstHyperlink();
                    } else {
                        String string = NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("MSG_AtLastError");
                        TopManager.getDefault().setStatusText(string);
                        this.next_wrap_warned = true;
                        return false;
                    }
                }
            }
            this.gotoHyperlink(activeRegion);
            return true;
        }

        private boolean prevHyperlink() {
            ActiveRegion activeRegion = this.currentHyperlink;
            if (activeRegion == null) {
                activeRegion = this.lastHyperlink();
            } else {
                this.next_wrap_warned = false;
                if ((activeRegion = activeRegion.getPreviousSibling()) == null) {
                    if (this.prev_wrap_warned) {
                        this.prev_wrap_warned = false;
                        activeRegion = this.lastHyperlink();
                    } else {
                        String string = NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("MSG_AtFirstError");
                        TopManager.getDefault().setStatusText(string);
                        this.prev_wrap_warned = true;
                        return false;
                    }
                }
            }
            this.gotoHyperlink(activeRegion);
            return true;
        }

        private void gotoHyperlink(ActiveRegion activeRegion) {
            if (activeRegion == null) {
                return;
            }
            ActiveRegion activeRegion2 = activeRegion.firstChild();
            if (activeRegion2 == null) {
                activeRegion2 = activeRegion;
            }
            this.currentHyperlink = activeRegion;
            this.term.setSelectionExtent(activeRegion2.getExtent());
            this.term.possiblyNormalize(activeRegion);
        }

        private void invokeJumpListener(Coord coord, boolean bl) {
            OutputListener outputListener = (OutputListener)this.listeners.get(coord);
            String string = this.term.textWithin(this.currentHyperlink.begin, this.currentHyperlink.end);
            this.linkOnStart = false;
            if (outputListener != null) {
                if (bl) {
                    outputListener.outputLineAction((OutputEvent)new OutputEventImpl(InputOutput.NULL, string));
                } else {
                    outputListener.outputLineSelected((OutputEvent)new OutputEventImpl(InputOutput.NULL, string));
                }
            } else if (bl) {
                this.parseException(string, true);
            }
        }

        public void activated() {
            this.updateCopyCutAction();
            if (this.csa == null) {
                try {
                    Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                    ErrorManager.getDefault().annotate((Throwable)noClassDefFoundError, (Throwable)classNotFoundException);
                    throw noClassDefFoundError;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this);
        }

        public void deactivated() {
            if (this.csa != null && this.equals(this.csa.getActionPerformer())) {
                this.csa.setActionPerformer(null);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        boolean parseException(String string, boolean bl) {
            if ((string = string.trim()).length() <= 0) {
                return false;
            }
            try {
                if (OutTermPane.isExceptionHeuristic(string)) {
                    String string2;
                    int n = string.indexOf("at ");
                    if (n < 0) {
                        return false;
                    }
                    string = string.substring(n += 3);
                    Object[] objectArray = OutTermPane.getExceptionFormat().parse(string);
                    String string3 = objectArray[0].toString();
                    String string4 = objectArray[1].toString();
                    String string5 = objectArray[2].toString();
                    int n2 = Integer.parseInt(objectArray[3].toString());
                    int n3 = string3.lastIndexOf(string4);
                    if (n3 < 0) {
                        int n4 = string3.lastIndexOf(46);
                        n4 = string3.lastIndexOf(46, n4 - 1);
                        string2 = string3.substring(0, n4 + 1).replace('.', '/') + string4 + ".java";
                    } else {
                        string2 = string3.substring(0, n3 + string4.length()).replace('.', '/') + ".java";
                    }
                    FileObject fileObject = Repository.getDefault().findResource(string2);
                    if (fileObject == null) {
                        return false;
                    }
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutTermPane.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (editorCookie == null) {
                        return false;
                    }
                    Line line = editorCookie.getLineSet().getOriginal(n2 - 1);
                    if (bl) {
                        line.show(2, 0);
                    }
                    return true;
                }
            }
            catch (ParseException parseException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return false;
        }

        static boolean isExceptionHeuristic(String string) {
            return OutTermPane.startsOK(string = string.trim()) && string.charAt(string.length() - 1) == ')';
        }

        private static boolean startsOK(String string) {
            return string.startsWith("at ") || string.startsWith("[catch] at ");
        }

        static MessageFormat getExceptionFormat() {
            if (formatOfException == null) {
                formatOfException = new MessageFormat("{0}({1}.{2}:{3})");
            }
            return formatOfException;
        }

        public void performAction(SystemAction systemAction) {
            if (!(systemAction instanceof PopupAction)) {
                return;
            }
            Mutex.EVENT.readAccess(new Runnable(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = outTermPane;
                }

                public void run() {
                    Coord coord = null;
                    if (!this.this$0.term.isReadOnly() && this.this$0.term.isCoordVisible(this.this$0.term.getCursorCoord())) {
                        coord = this.this$0.term.getCursorCoord();
                    } else if (this.this$0.term.getSelectionExtent() != null) {
                        if (this.this$0.term.isCoordVisible(this.this$0.term.getSelectionExtent().begin)) {
                            coord = this.this$0.term.getSelectionExtent().begin;
                        } else if (this.this$0.term.isCoordVisible(this.this$0.term.getSelectionExtent().end)) {
                            coord = this.this$0.term.getSelectionExtent().end;
                        }
                    }
                    if (coord == null && OutTermPane.access$4500(this.this$0) != null) {
                        if (this.this$0.term.isCoordVisible(OutTermPane.access$4500((OutTermPane)this.this$0).begin)) {
                            coord = OutTermPane.access$4500((OutTermPane)this.this$0).begin;
                        } else if (this.this$0.term.isCoordVisible(OutTermPane.access$4500((OutTermPane)this.this$0).end)) {
                            coord = OutTermPane.access$4500((OutTermPane)this.this$0).end;
                        }
                    }
                    Point point = null;
                    point = coord == null ? new Point(0, 0) : this.this$0.term.toPixel(coord);
                    if (point == null) {
                        return;
                    }
                    this.this$0.jPopup.show((Component)this.this$0.term, point.x, point.y);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.selectAllItem) {
                this.selectAll();
            } else if (actionEvent.getSource() == this.clearItem) {
                this.doClear();
            } else if (actionEvent.getSource() == this.redirItem) {
                this.redirection = !this.redirection;
                this.checkRedirItem();
            }
        }

        void doClear() {
            this.term.clearHistory();
            this.term.clear();
            this.setHyperlinkNavigationEnabled(false);
            Iterator iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                OutputListener outputListener = (OutputListener)iterator.next();
                outputListener.outputLineCleared((OutputEvent)new OutputEventImpl(InputOutput.NULL, null));
            }
            this.listeners.clear();
            this.activeHyperlink = null;
            this.currentHyperlink = null;
            this.updateNextPrevActions();
            if (this.tab != null && this.tab.equals(compiler)) {
                compilerPrinted = false;
            }
        }

        private static OutputSettings outputSettings() {
            return (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutTermPane.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        }

        private void setHyperlinkNavigationEnabled(boolean bl) {
            if (this.hyperlinkNavigationEnabled == bl) {
                return;
            }
            this.hyperlinkNavigationEnabled = bl;
            if (bl) {
                this.term.setScrollOnInput(false);
                this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet2());
            } else {
                this.term.setScrollOnInput(true);
                this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet());
            }
        }

        private void checkRedirItem() {
            if (this.tab == null) {
                return;
            }
            if (!this.redirection && this.writer != null) {
                this.writer.redirClose();
            }
            if (this.redirItem == null) {
                return;
            }
            if (this.redirection) {
                this.redirItem.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_Redirect_Off"));
            } else {
                this.redirItem.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_Redirect_On"));
            }
        }

        private void checkFont() {
            Font font = this.term.getFont();
            if (font != null && font.isPlain() && font.getSize() == OutTermPane.outputSettings().getFontSize()) {
                return;
            }
            Font font2 = new Font("monospaced", 0, OutTermPane.outputSettings().getFontSize());
            this.term.setFont(font2);
        }

        private void setSettings() {
            this.checkFont();
            this.term.setForeground(OutTermPane.outputSettings().getBaseForeground());
            this.term.setBackground(OutTermPane.outputSettings().getBaseBackground());
            this.term.setCustomColor(1, OutTermPane.outputSettings().getJumpCursorBackground());
            this.term.setHistorySize(OutTermPane.outputSettings().getHistorySize());
            this.tabSize = OutTermPane.outputSettings().getTabSize();
            this.term.setTabSize(this.tabSize);
            this.term.setCustomColor(0, OutTermPane.outputSettings().getJumpLinkForeground());
            this.term.setHighlightColor(OutTermPane.outputSettings().getSelectionBackground());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("redirection".equals(propertyChangeEvent.getPropertyName())) {
                if (this.tab != null) {
                    this.redirection = (Boolean)propertyChangeEvent.getNewValue();
                    this.checkRedirItem();
                }
            } else if ("directory".equals(propertyChangeEvent.getPropertyName())) {
                if (this.tab != null && this.redirection && this.writer != null) {
                    this.writer.redirClose();
                    this.writer.redirOpen();
                }
            } else {
                this.setSettings();
            }
        }

        private void selectAll() {
            Extent extent = new Extent(Coord.make((int)0, (int)0), this.term.getCursorCoord());
            this.term.setSelectionExtent(extent);
        }

        private void ensureOpen() {
            if (this.tab != null) {
                this.tab.ensureOpen();
                if (this.tab.equals(compiler) && !compilerPrinted) {
                    this.tab.requestVisible();
                    compilerPrinted = true;
                }
            }
        }

        private void invokeNow(Runnable runnable) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                Object object = this.syncObject;
                synchronized (object) {
                    if (this.runningRunnables) {
                        try {
                            this.syncObject.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.runnables.add(runnable);
                    if (this.runnables.size() > 50) {
                        try {
                            this.syncObject.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.runnables.size() == 1) {
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }

        public void run() {
            ArrayList arrayList;
            Object object = this.syncObject;
            synchronized (object) {
                this.runningRunnables = true;
                arrayList = (ArrayList)this.runnables.clone();
                this.runnables = new ArrayList();
            }
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                Object var5_5;
                try {
                    ((Runnable)iterator.next()).run();
                    var5_5 = null;
                    this.runningRunnables = false;
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    this.runningRunnables = false;
                    throw throwable;
                }
            }
            Object object2 = this.syncObject;
            synchronized (object2) {
                this.syncObject.notifyAll();
            }
        }

        private int getLinkAttr() {
            return 50;
        }

        void setCompilationFinished() {
            this.nextHyperlink();
            this.linkOnStart = true;
            this.updateNextPrevActions();
        }

        public void requestFocus() {
            super.requestFocus();
            this.term.requestFocus();
        }

        void setReadWrite() {
            this.term.setCursorVisible(true);
            this.term.setReadOnly(false);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ void access$600(OutTermPane outTermPane, ActiveRegion activeRegion) {
            outTermPane.gotoHyperlink(activeRegion);
        }

        static /* synthetic */ void access$700(OutTermPane outTermPane, boolean bl) {
            outTermPane.activateHyperlink(bl);
        }

        static /* synthetic */ boolean access$900(OutTermPane outTermPane) {
            return outTermPane.updateCopyCutAction();
        }

        static /* synthetic */ boolean access$1000(OutTermPane outTermPane) {
            return outTermPane.prevHyperlink();
        }

        static /* synthetic */ boolean access$1102(OutTermPane outTermPane, boolean bl) {
            outTermPane.linkOnStart = bl;
            return outTermPane.linkOnStart;
        }

        static /* synthetic */ boolean access$1200(OutTermPane outTermPane) {
            return outTermPane.nextHyperlink();
        }

        static /* synthetic */ void access$1300(OutTermPane outTermPane) {
            outTermPane.selectAll();
        }

        static /* synthetic */ boolean access$2102(OutTermPane outTermPane, boolean bl) {
            outTermPane.prev_wrap_warned = bl;
            return outTermPane.prev_wrap_warned;
        }

        static /* synthetic */ boolean access$2202(OutTermPane outTermPane, boolean bl) {
            outTermPane.next_wrap_warned = bl;
            return outTermPane.next_wrap_warned;
        }

        static /* synthetic */ boolean access$4200(OutTermPane outTermPane, boolean bl) {
            return outTermPane.nextHyperlink(bl);
        }

        static /* synthetic */ void access$4300(OutTermPane outTermPane, Coord coord, boolean bl) {
            outTermPane.invokeJumpListener(coord, bl);
        }

        static /* synthetic */ ActiveRegion access$4500(OutTermPane outTermPane) {
            return outTermPane.currentHyperlink;
        }

        private class TIListener
        implements TermInputListener {
            private OutputTabTerm tab;

            public TIListener(OutputTabTerm outputTabTerm) {
                this.tab = outputTabTerm;
            }

            public void sendChar(char c) {
                try {
                    this.tab.inWriter.write(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void sendChars(char[] cArray, int n, int n2) {
                try {
                    this.tab.inWriter.write(cArray, n, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class CopyActionPerformer
        implements ActionPerformer {
            ActiveTerm at;

            public CopyActionPerformer(ActiveTerm activeTerm) {
                this.at = activeTerm;
            }

            public void performAction(SystemAction systemAction) {
                OutputTabTerm.invokeLater(new Runnable(this){
                    private final /* synthetic */ CopyActionPerformer this$1;
                    {
                        this.this$1 = copyActionPerformer;
                    }

                    public void run() {
                        this.this$1.at.copy();
                    }
                });
            }
        }

        final class JumpActionPerformer
        implements ActionPerformer {
            JumpActionPerformer() {
            }

            public void performAction(SystemAction systemAction) {
                OutputTabTerm.invokeLater(new Runnable(this, systemAction){
                    private final /* synthetic */ SystemAction val$action;
                    private final /* synthetic */ JumpActionPerformer this$1;
                    {
                        this.this$1 = jumpActionPerformer;
                        this.val$action = systemAction;
                    }

                    public void run() {
                        Coord coord = null;
                        if (this.val$action instanceof NextOutJumpAction && OutTermPane.access$4200(JumpActionPerformer.access$4100(this.this$1), true)) {
                            OutTermPane.access$700(JumpActionPerformer.access$4100(this.this$1), true);
                        }
                        if (this.val$action instanceof PreviousOutJumpAction && OutTermPane.access$1000(JumpActionPerformer.access$4100(this.this$1))) {
                            OutTermPane.access$700(JumpActionPerformer.access$4100(this.this$1), true);
                        }
                        if (coord != null) {
                            OutTermPane.access$4300(JumpActionPerformer.access$4100(this.this$1), coord, true);
                        }
                        JumpActionPerformer.access$4100(this.this$1).updateNextPrevActions();
                    }
                });
            }

            static /* synthetic */ OutTermPane access$4100(JumpActionPerformer jumpActionPerformer) {
                return jumpActionPerformer.OutTermPane.this;
            }
        }

        class TermOutputWriter
        extends OutputWriter {
            private int lastParsedRow = -1;
            ActiveTerm aterm = null;
            boolean timerSet = false;
            Boolean timerMode = null;
            boolean redirOpened = false;
            FileWriter redirWriter = null;
            private ActiveRegion region = null;
            private State state = State.init;
            private StringBuffer line_buf = new StringBuffer();

            TermOutputWriter(ActiveTerm activeTerm) {
                super((Writer)new OutputStreamWriter((OutputStream)new NullOutputStream()));
                this.aterm = activeTerm;
                this.setPageMode(false);
                this.aterm.setRefreshEnabled(false);
                if (OutTermPane.this.tab != null) {
                    OutTermPane.this.redirection = OutTermPane.outputSettings().isRedirection();
                }
                OutTermPane.this.checkRedirItem();
                if (OutTermPane.this.redirection) {
                    this.redirOpen();
                }
            }

            public void reset() throws IOException {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                    }

                    public void run() {
                        TermOutputWriter.access$1700(this.this$1).doClear();
                        this.this$1.aterm.setRefreshEnabled(false);
                        TermOutputWriter.access$1802(this.this$1, -1);
                        TermOutputWriter.access$1900(this.this$1);
                        TermOutputWriter.access$2002(this.this$1, State.init);
                        OutTermPane.access$2102(TermOutputWriter.access$1700(this.this$1), false);
                        OutTermPane.access$2202(TermOutputWriter.access$1700(this.this$1), false);
                    }
                });
            }

            public void println(String string, OutputListener outputListener) throws IOException {
                String string2 = new String(string);
                OutTermPane.this.ensureOpen();
                OutTermPane.this.invokeNow(new Runnable(this, outputListener, string2){
                    private final /* synthetic */ OutputListener val$outputListener;
                    private final /* synthetic */ String val$strCopy;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                        this.val$outputListener = outputListener;
                        this.val$strCopy = string;
                    }

                    public void run() {
                        TermOutputWriter.access$2500(this.this$1);
                        if (this.val$outputListener != null) {
                            if (TermOutputWriter.access$2600(this.this$1, this.val$outputListener)) {
                                if (TermOutputWriter.access$2700(this.this$1, this.val$outputListener)) {
                                    TermOutputWriter.access$2800(this.this$1, this.val$strCopy);
                                    TermOutputWriter.access$3000(this.this$1, TermOutputWriter.access$2900(this.this$1), this.val$outputListener);
                                } else {
                                    TermOutputWriter.access$3100(this.this$1, this.val$strCopy);
                                }
                            } else {
                                TermOutputWriter.access$3200(this.this$1, this.val$strCopy, true);
                                TermOutputWriter.access$3000(this.this$1, TermOutputWriter.access$2900(this.this$1), this.val$outputListener);
                            }
                        } else {
                            TermOutputWriter.access$3300(this.this$1, this.val$strCopy, false);
                        }
                        TermOutputWriter.access$3400(this.this$1);
                    }
                });
            }

            public void println() {
                OutTermPane.this.ensureOpen();
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                    }

                    public void run() {
                        TermOutputWriter.access$3400(this.this$1);
                    }
                });
            }

            public void write(char[] cArray, int n, int n2) {
                OutTermPane.this.ensureOpen();
                char[] cArray2 = new char[cArray.length];
                System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                OutTermPane.this.invokeNow(new Runnable(this, cArray2, n, n2){
                    private final /* synthetic */ char[] val$cbufCopy;
                    private final /* synthetic */ int val$off;
                    private final /* synthetic */ int val$len;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                        this.val$cbufCopy = cArray;
                        this.val$off = n;
                        this.val$len = n2;
                    }

                    public void run() {
                        TermOutputWriter.access$3300(this.this$1, new String(this.val$cbufCopy, this.val$off, this.val$len), !TermOutputWriter.access$3500(this.this$1));
                    }
                });
            }

            public void write(int n) {
                OutTermPane.this.invokeNow(new Runnable(this, n){
                    private final /* synthetic */ int val$ch;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                        this.val$ch = n;
                    }

                    public void run() {
                        this.this$1.write(new char[]{(char)this.val$ch}, 0, 1);
                    }
                });
            }

            public void write(String string, int n, int n2) {
                char[] cArray = new char[n2];
                string.getChars(n, n + n2, cArray, 0);
                OutTermPane.this.invokeNow(new Runnable(this, cArray, n2){
                    private final /* synthetic */ char[] val$chars;
                    private final /* synthetic */ int val$len;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                        this.val$chars = cArray;
                        this.val$len = n;
                    }

                    public void run() {
                        this.this$1.write(this.val$chars, 0, this.val$len);
                    }
                });
            }

            public void flush() {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                    }

                    public void run() {
                        this.this$1.aterm.flush();
                        if (this.this$1.redirWriter != null) {
                            try {
                                this.this$1.redirWriter.flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }

            public void close() {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = termOutputWriter;
                    }

                    public void run() {
                        if (this.this$1.redirOpened) {
                            TermOutputWriter.access$3600(this.this$1);
                        }
                    }
                });
            }

            private void tryParsing() {
                int n = this.aterm.getCursorRow() - 1;
                int n2 = this.lastParsedRow + 1;
                while (n2 <= n) {
                    this.linkException(n2);
                    ++n2;
                }
                this.lastParsedRow = n;
            }

            private void linkException(int n) {
                try {
                    if (!this.aterm.regionManager().findRegion(Coord.make((int)n, (int)0)).equals(this.aterm.regionManager().root())) {
                        return;
                    }
                    String string = this.aterm.getRowText(n);
                    if (string != null && OutTermPane.this.parseException(string, false)) {
                        Coord coord = Coord.make((int)n, (int)this.getStartOfLink(string));
                        Coord coord2 = Coord.make((int)n, (int)string.length());
                        this.aterm.setCharacterAttribute(coord, coord2, OutTermPane.this.getLinkAttr(), true);
                        this.aterm.setCharacterAttribute(coord, coord2, 4, true);
                        this.resetRegion();
                        this.setPageMode(true);
                        this.region = this.aterm.regionManager().beginRegion(coord);
                        this.region.setFeedbackEnabled(false);
                        this.region.setSelectable(false);
                        this.aterm.regionManager().endRegion(coord2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private int getStartOfLink(String string) {
                int n = 0;
                int n2 = 0;
                while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t' || string.charAt(n2) == '\n')) {
                    if (string.charAt(n2) == ' ') {
                        ++n;
                    } else if (string.charAt(n2) == '\t') {
                        n += OutTermPane.this.tabSize;
                    }
                    ++n2;
                }
                return n;
            }

            private void redirOpen() {
                File file = null;
                try {
                    int n;
                    File file2 = OutTermPane.outputSettings().getDirectory();
                    String string = "";
                    if (OutTermPane.this.tab != null && (n = (string = ((Component)((Object)OutTermPane.this.tab)).getName()).indexOf(32)) > 0) {
                        string = string.substring(0, n);
                    }
                    string = string.replace(File.separatorChar, '_');
                    string = string + OutTermPane.REDIR_EXT;
                    file = new File(file2, string);
                    file.createNewFile();
                    this.redirWriter = new FileWriter(file.getAbsolutePath(), true);
                    this.redirOpened = true;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().annotate((Throwable)exception, 0, "Redir file: " + file, null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }

            private void redirClose() {
                if (this.redirWriter != null) {
                    try {
                        this.redirWriter.close();
                        this.redirWriter = null;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            }

            private void redirPrint(char[] cArray, int n, int n2) {
                if (this.redirWriter == null) {
                    this.redirOpen();
                }
                if (this.redirWriter == null) {
                    return;
                }
                try {
                    this.redirWriter.write(cArray, n, n2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }

            private void redirPrint(String string) {
                if (this.redirWriter == null) {
                    this.redirOpen();
                }
                if (this.redirWriter == null) {
                    return;
                }
                try {
                    this.redirWriter.write(string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }

            private ActiveRegion createRegion(String string, boolean bl) {
                this.beginRegion(string, bl);
                return this.endRegion(null);
            }

            private ActiveRegion beginRegion(String string, boolean bl) {
                this.resetRegion();
                this.setPageMode(true);
                Coord coord = Coord.make((int)this.aterm.getCursorCoord().row, (int)0);
                try {
                    this.region = this.aterm.regionManager().beginRegion(coord);
                }
                catch (RegionException regionException) {
                    return null;
                }
                this.region.setFeedbackEnabled(false);
                this.region.setSelectable(false);
                if (bl) {
                    this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                    this.aterm.setAttribute(4);
                }
                if (string != null) {
                    this.appendText(string, false, false);
                }
                return this.region;
            }

            private ActiveRegion endRegion(String string) {
                this.aterm.setAttribute(0);
                if (string != null) {
                    this.appendText(string, false);
                }
                this.aterm.endRegion();
                OutTermPane.this.updateNextPrevActions();
                return this.region;
            }

            private void firstHalf(String string) {
                this.setPageMode(true);
                Coord coord = Coord.make((int)this.aterm.getCursorCoord().row, (int)0);
                try {
                    this.region = this.aterm.regionManager().beginRegion(coord);
                }
                catch (RegionException regionException) {
                    return;
                }
                this.region.setFeedbackEnabled(false);
                this.region.setSelectable(false);
                try {
                    ActiveRegion activeRegion = this.aterm.regionManager().beginRegion(coord);
                }
                catch (RegionException regionException) {
                    return;
                }
                this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                this.aterm.setAttribute(4);
                this.appendText(string, false);
                this.aterm.setAttribute(0);
                this.aterm.endRegion();
            }

            private void secondHalf(String string) {
                this.appendText(string, false);
                this.aterm.endRegion();
                OutTermPane.this.updateNextPrevActions();
            }

            private boolean isTimerMode() {
                if (this.timerMode == null) {
                    String string = System.getProperty("org.netbeans.core.output.OutputTabTerm.timerMode");
                    this.timerMode = new Boolean(string == null || !string.equalsIgnoreCase("false"));
                }
                return this.timerMode;
            }

            private void repaintTimer() {
                if (!this.timerSet) {
                    this.timerSet = true;
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ TermOutputWriter this$1;
                        {
                            this.this$1 = termOutputWriter;
                        }

                        public void run() {
                            this.this$1.flush();
                            this.this$1.timerSet = false;
                        }
                    }, 120);
                }
            }

            private void setPageMode(boolean bl) {
                if (this.isPageMode()) {
                    return;
                }
                this.aterm.setAnchored(bl);
            }

            private boolean isPageMode() {
                return this.aterm.isAnchored();
            }

            private void historySizeKeeper() {
                if (!this.isPageMode()) {
                    return;
                }
                if (this.aterm.getHistoryBuffSize() - this.aterm.getHistorySize() > 0) {
                    try {
                        this.reset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private boolean isHyperLink(OutputListener outputListener) {
                return outputListener.getClass().getName().indexOf("CompilerDisplayer$ErrorCtl") != -1;
            }

            private boolean isFromCompiler(OutputListener outputListener) {
                return outputListener.getClass().getName().indexOf("CompilerDisplayer") != -1;
            }

            private void resetRegion() {
                if (this.region != null) {
                    this.aterm.endRegion();
                    this.region = null;
                }
            }

            private void registerListener(ActiveRegion activeRegion, OutputListener outputListener) {
                if (activeRegion != null && outputListener != null) {
                    OutTermPane.this.listeners.put(activeRegion.begin, outputListener);
                }
            }

            private void printEOL() {
                this.appendText("\n", !this.isTimerMode());
            }

            private void putException(String string, boolean bl) {
                if (string == null) {
                    return;
                }
                if (!OutTermPane.this.parseException(string, false)) {
                    this.aterm.appendText(string, bl);
                    return;
                }
                Coord coord = this.aterm.getCursorCoord();
                try {
                    ActiveRegion activeRegion = this.aterm.regionManager().beginRegion(coord);
                    this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                    this.aterm.setAttribute(4);
                    this.aterm.appendText(string, bl);
                    this.aterm.setAttribute(0);
                    this.aterm.endRegion();
                    OutTermPane.this.setHyperlinkNavigationEnabled(true);
                }
                catch (RegionException regionException) {
                    return;
                }
            }

            private synchronized void appendText(String string, boolean bl) {
                this.appendText(string, bl, true);
            }

            private synchronized void appendText(String string, boolean bl, boolean bl2) {
                if (this.isTimerMode()) {
                    if (OutTermPane.this.redirection) {
                        this.redirPrint(string);
                    }
                    int n = 0;
                    while (n < string.length()) {
                        char c = string.charAt(n);
                        if (this.state == State.init) {
                            if (c == '\n') {
                                this.aterm.putChar(c);
                            } else if (c == ' ' || c == '\t') {
                                this.aterm.putChar(c);
                            } else if (bl2 && c == 'a') {
                                this.line_buf.setLength(0);
                                this.line_buf.append(c);
                                this.state = State.collect;
                            } else {
                                this.aterm.putChar(c);
                                this.state = State.pass;
                            }
                        } else if (this.state == State.collect) {
                            if (c == '\n') {
                                this.line_buf.append(c);
                                this.putException(this.line_buf.toString(), bl);
                                this.state = State.init;
                            } else {
                                this.line_buf.append(c);
                            }
                        } else if (this.state == State.pass) {
                            if (c == '\n') {
                                this.aterm.putChar(c);
                                this.state = State.init;
                            } else {
                                this.aterm.putChar(c);
                            }
                        }
                        ++n;
                    }
                    this.repaintTimer();
                    return;
                }
                char[] cArray = new char[string.length()];
                string.getChars(0, string.length(), cArray, 0);
                this.appendChars(cArray, 0, string.length(), bl);
                this.tryParsing();
            }

            private void appendChars(char[] cArray, int n, int n2, boolean bl) {
                if (this.isTimerMode()) {
                    this.appendText(new String(cArray, n, n2), bl);
                    return;
                }
                if (OutTermPane.this.redirection) {
                    this.redirPrint(cArray, n, n2);
                }
                if (!bl && this.aterm.isRefreshEnabled()) {
                    this.aterm.setRefreshEnabled(false);
                    this.aterm.putChars(cArray, n, n2);
                    this.aterm.setRefreshEnabled(true);
                } else {
                    this.aterm.putChars(cArray, n, n2);
                }
            }

            static /* synthetic */ OutTermPane access$1700(TermOutputWriter termOutputWriter) {
                return termOutputWriter.OutTermPane.this;
            }

            static /* synthetic */ int access$1802(TermOutputWriter termOutputWriter, int n) {
                termOutputWriter.lastParsedRow = n;
                return termOutputWriter.lastParsedRow;
            }

            static /* synthetic */ void access$1900(TermOutputWriter termOutputWriter) {
                termOutputWriter.resetRegion();
            }

            static /* synthetic */ State access$2002(TermOutputWriter termOutputWriter, State state) {
                termOutputWriter.state = state;
                return termOutputWriter.state;
            }

            static /* synthetic */ void access$2500(TermOutputWriter termOutputWriter) {
                termOutputWriter.historySizeKeeper();
            }

            static /* synthetic */ boolean access$2600(TermOutputWriter termOutputWriter, OutputListener outputListener) {
                return termOutputWriter.isFromCompiler(outputListener);
            }

            static /* synthetic */ boolean access$2700(TermOutputWriter termOutputWriter, OutputListener outputListener) {
                return termOutputWriter.isHyperLink(outputListener);
            }

            static /* synthetic */ void access$2800(TermOutputWriter termOutputWriter, String string) {
                termOutputWriter.firstHalf(string);
            }

            static /* synthetic */ ActiveRegion access$2900(TermOutputWriter termOutputWriter) {
                return termOutputWriter.region;
            }

            static /* synthetic */ void access$3000(TermOutputWriter termOutputWriter, ActiveRegion activeRegion, OutputListener outputListener) {
                termOutputWriter.registerListener(activeRegion, outputListener);
            }

            static /* synthetic */ void access$3100(TermOutputWriter termOutputWriter, String string) {
                termOutputWriter.secondHalf(string);
            }

            static /* synthetic */ ActiveRegion access$3200(TermOutputWriter termOutputWriter, String string, boolean bl) {
                return termOutputWriter.createRegion(string, bl);
            }

            static /* synthetic */ void access$3300(TermOutputWriter termOutputWriter, String string, boolean bl) {
                termOutputWriter.appendText(string, bl);
            }

            static /* synthetic */ void access$3400(TermOutputWriter termOutputWriter) {
                termOutputWriter.printEOL();
            }

            static /* synthetic */ boolean access$3500(TermOutputWriter termOutputWriter) {
                return termOutputWriter.isTimerMode();
            }
        }

        private final class OutputEventImpl
        extends OutputEvent {
            private String txt;
            static final long serialVersionUID = -437312125483471519L;

            public OutputEventImpl(InputOutput inputOutput, String string) {
                super(inputOutput);
                this.txt = string;
            }

            public String getLine() {
                return this.txt;
            }
        }
    }

    public static class Factory
    implements OutputTabProvider {
        Factory() {
        }

        public OutputWriter getStdOut() {
            OutputTabTerm.initialize();
            return standard.getOut();
        }

        public InputOutput getIO(String string, boolean bl) {
            OutputTabTerm.initialize();
            if (string != null && string.equals(OutputTabTerm.getCompilerName())) {
                OutputTabTerm.initializeComp();
                return compiler;
            }
            if (bl) {
                return new OutputTabTerm(string);
            }
            InputOutput inputOutput = (InputOutput)ioCache.get(string);
            if (inputOutput == null) {
                inputOutput = new OutputTabTerm(string);
            }
            return inputOutput;
        }

        public TopComponent getStdOutputTab() {
            OutputTabTerm.initialize();
            return standard;
        }

        public TopComponent getCompOutputTab() {
            OutputTabTerm.initializeComp();
            return compiler;
        }
    }

    static class Replace
    implements Serializable {
        static final int COMPILER_INSTANCE = 1;
        boolean defaultInstance;
        int instanceType;
        private static final long serialVersionUID = -3126744916624172415L;

        public Replace(boolean bl) {
            this.defaultInstance = bl;
        }

        public void setInstanceType(int n) {
            this.instanceType = n;
        }

        public Object readResolve() throws ObjectStreamException {
            if (this.defaultInstance) {
                return OutputTabTerm.getFactory().getStdOutputTab();
            }
            if (this.instanceType == 1) {
                return OutputTabTerm.getFactory().getCompOutputTab();
            }
            return null;
        }
    }

    private static class State {
        private final String name;
        public static final State init = new State("init");
        public static final State collect = new State("collect");
        public static final State pass = new State("pass");

        private State(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

