/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.core.perftool.Parser;

final class Extractor {
    private Extractor() {
    }

    public static Parser.Field[] extractDateValues(String string, File[] fileArray) throws IOException {
        Parser.Field[] fieldArray = Extractor.extractFields(string, fileArray);
        Arrays.sort(fieldArray, new FieldDateComparator());
        return fieldArray;
    }

    public static Parser.Field[] extractTimeValues(String string, File[] fileArray) throws IOException {
        Parser.Field[] fieldArray = Extractor.extractFields(string, fileArray);
        Arrays.sort(fieldArray, new FieldTimeComparator());
        return fieldArray;
    }

    private static Parser.Field[] extractFields(String string, File[] fileArray) throws IOException {
        ArrayList<Parser.Field> arrayList = new ArrayList<Parser.Field>(200);
        int n = 0;
        while (n < fileArray.length) {
            Parser.SessionInfo[] sessionInfoArray = Parser.getData(fileArray[n]);
            int n2 = 0;
            while (n2 < sessionInfoArray.length) {
                Parser.Field field = sessionInfoArray[n2].getField(string);
                if (field != null) {
                    arrayList.add(field);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new Parser.Field[arrayList.size()]);
    }

    static final class FieldDateComparator
    implements Comparator {
        FieldDateComparator() {
        }

        public boolean equals(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            Parser.Field field = (Parser.Field)object;
            Parser.Field field2 = (Parser.Field)object2;
            return field.getSessionInfo().getDate().equals(field2.getSessionInfo().getDate());
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Parser.Field field = (Parser.Field)object;
            Parser.Field field2 = (Parser.Field)object2;
            return field.getSessionInfo().getDate().compareTo(field2.getSessionInfo().getDate());
        }
    }

    static final class FieldTimeComparator
    implements Comparator {
        FieldTimeComparator() {
        }

        public boolean equals(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            Parser.Field field = (Parser.Field)object;
            Parser.Field field2 = (Parser.Field)object2;
            return field.getTime() == field2.getTime();
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Parser.Field field = (Parser.Field)object;
            Parser.Field field2 = (Parser.Field)object2;
            if (field.getTime() == field2.getTime()) {
                return 0;
            }
            if (field.getTime() > field2.getTime()) {
                return 1;
            }
            return -1;
        }
    }
}

