/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.netbeans.core.perftool.Util;

final class Parser {
    private static final String nline = System.getProperty("line.separator");
    private static final String SESSION_START_PATTERN = "^([\\-]+)" + nline + "^(>Log Session: .*)";
    private static final String SESSION_END_PATTERN = "^([\\-]+)".concat(nline);
    private static final String ENTRY_PATTERN = "^[IDE-Perf] ([^0-9]+)([0-9]+)\\.([0-9]+) s";
    private static RE logstart;
    private static RE logend;
    private static RE entries;

    static RE getLogStart() throws RESyntaxException {
        if (logstart == null) {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile(SESSION_START_PATTERN);
            logstart = new RE(rEProgram, 2);
        }
        return logstart;
    }

    static RE getLogEnd() throws RESyntaxException {
        if (logend == null) {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile(SESSION_END_PATTERN);
            logend = new RE(rEProgram, 2);
        }
        return logend;
    }

    static RE getEntries() throws RESyntaxException {
        if (entries == null) {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile(ENTRY_PATTERN);
            entries = new RE(rEProgram, 2);
        }
        return entries;
    }

    private Parser() {
    }

    public static SessionInfo[] getData(File file) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            ReaderCharacterIterator readerCharacterIterator = new ReaderCharacterIterator(bufferedReader);
            RE rE = Parser.getLogStart();
            RE rE2 = Parser.getLogEnd();
            ArrayList<SessionInfo> arrayList = new ArrayList<SessionInfo>(20);
            int n = 0;
            while (rE.match(readerCharacterIterator, n)) {
                int n2 = rE.getParenStart(0);
                Parser.parseEntries(readerCharacterIterator, n, n2, arrayList);
                if (!rE2.match(readerCharacterIterator, rE.getParenEnd(0))) break;
                int n3 = rE2.getParenEnd(0);
                SessionInfo sessionInfo = new SessionInfo(Parser.trimString(readerCharacterIterator.substring(n2, n3)));
                arrayList.add(sessionInfo);
                n = n3;
            }
            ((Reader)bufferedReader).close();
            return arrayList.toArray(new SessionInfo[arrayList.size()]);
        }
        catch (RESyntaxException rESyntaxException) {
            rESyntaxException.printStackTrace();
            return null;
        }
    }

    private static void parseEntries(CharacterIterator characterIterator, int n, int n2, List list) throws IOException, RESyntaxException {
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        SessionInfo sessionInfo = (SessionInfo)list.get(n3 - 1);
        RE rE = Parser.getEntries();
        while (n2 > n && rE.match(characterIterator, n)) {
            if (rE.getParenStart(0) > n2) {
                n = rE.getParenStart(0);
                continue;
            }
            String string = rE.getParen(0);
            double d = Parser.strings2Double(rE.getParen(2), rE.getParen(3));
            Field field = new Field(sessionInfo, rE.getParen(1), d);
            sessionInfo.addField(field);
            n = rE.getParenEnd(0);
        }
        if (sessionInfo.size() == 0) {
            list.remove(n3 - 1);
        }
    }

    private static double strings2Double(String string, String string2) {
        try {
            double d = Double.parseDouble(string);
            return d += Double.parseDouble(string2) / Util.tenpower(string2.length());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return -1.0;
        }
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    public static class Field {
        private String name;
        private double time;
        private SessionInfo session;

        Field(SessionInfo sessionInfo, String string, double d) {
            this.name = string;
            this.time = d;
            this.session = sessionInfo;
        }

        public String getName() {
            return this.name;
        }

        public double getTime() {
            return this.time;
        }

        public SessionInfo getSessionInfo() {
            return this.session;
        }
    }

    public static class SessionInfo {
        private String desc;
        private Map fields;
        private int build;
        private Date date;

        SessionInfo(String string) {
            this.desc = string;
            this.fields = new HashMap(80);
            this.build = SessionInfo.getBuildNumber(string);
            Locale locale = SessionInfo.getLocale(string);
            this.date = SessionInfo.getDate(string, locale);
        }

        public String getDescription() {
            return this.desc;
        }

        void addField(Field field) {
            this.fields.put(field.getName(), field);
        }

        public Field getField(String string) {
            return (Field)this.fields.get(string);
        }

        public int getBuildNumber() {
            return this.build;
        }

        public Date getDate() {
            return this.date;
        }

        int size() {
            return this.fields.size();
        }

        private static int getBuildNumber(String string) {
            try {
                int n = string.indexOf("(Build ");
                int n2 = string.indexOf(41, n);
                String string2 = string.substring(n + 7, n2);
                if (string2.equals("@BUILD_NUMBER_SUBST@")) {
                    return -1;
                }
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -1;
            }
        }

        private static Locale getLocale(String string) {
            int n = string.indexOf("System Locale");
            n = string.indexOf("= ", n);
            String[] stringArray = new String[]{null, "", ""};
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(3);
            char c = string.charAt(n += 2);
            while (Character.isLetter(c)) {
                if (c == ':') {
                    stringArray[n2++] = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
                c = string.charAt(++n);
            }
            stringArray[n2] = stringBuffer.toString();
            return new Locale(stringArray[0], stringArray[1], stringArray[2]);
        }

        private static Date getDate(String string, Locale locale) {
            int n = string.indexOf(">Log Session: ");
            int n2 = string.indexOf(62, n + 14);
            String string2 = Parser.trimString(string.substring(n + 14, n2));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, locale);
            Date date = dateFormat.parse(string2, new ParsePosition(0));
            return date;
        }
    }
}

