/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class ParsingLayerCacheManager
extends LayerCacheManager
implements ContentHandler,
ErrorHandler,
EntityResolver {
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue"};
    private static final String DTD_1_0 = "-//NetBeans//DTD Filesystem 1.0//EN";
    private static final String DTD_1_1 = "-//NetBeans//DTD Filesystem 1.1//EN";
    private Locator locator;
    private MemFolder root;
    private Stack curr;
    private URL base;
    private StringBuffer buf = new StringBuffer();
    private int fileCount;
    private int folderCount;
    private int attrCount;

    protected ParsingLayerCacheManager(File file) throws IOException {
        super(file);
    }

    public void store(FileSystem fileSystem, List arrayList) throws IOException {
        this.root = new MemFolder();
        this.curr = new Stack();
        this.curr.push(this.root);
        try {
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            Exception exception = null;
            arrayList = new ArrayList(arrayList);
            Collections.reverse(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.base = (URL)iterator.next();
                LayerCacheManager.err.log("Parsing: " + this.base);
                try {
                    xMLReader.parse(this.base.toExternalForm());
                }
                catch (Exception exception2) {
                    this.curr.clear();
                    this.curr.push(this.root);
                    if (exception == null) {
                        exception = exception2;
                        continue;
                    }
                    LayerCacheManager.err.annotate((Throwable)exception, (Throwable)exception2);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            LayerCacheManager.err.annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
        this.base = null;
        this.locator = null;
        this.curr = null;
        LayerCacheManager.err.log("Finished layer parsing; " + this.fileCount + " files, " + this.folderCount + " folders, " + this.attrCount + " attributes");
        this.attrCount = 0;
        this.folderCount = 0;
        this.fileCount = 0;
        this.store(fileSystem, this.root);
        this.root = null;
    }

    protected abstract void store(FileSystem var1, MemFolder var2) throws IOException;

    protected abstract boolean openURLs();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3 == "filesystem") {
            return;
        }
        if (string3 == "folder") {
            this.fileOrFolder(string3, attributes);
        } else if (string3 == "file") {
            MemFile memFile = (MemFile)this.fileOrFolder(string3, attributes);
            memFile.contents = null;
            String string4 = attributes.getValue("url");
            if (string4 != null) {
                try {
                    memFile.ref = new URL(this.base, string4);
                }
                catch (MalformedURLException malformedURLException) {
                    SAXException sAXException = new SAXException(malformedURLException.toString());
                    LayerCacheManager.err.annotate((Throwable)sAXException, (Throwable)malformedURLException);
                    throw sAXException;
                }
            } else {
                memFile.ref = null;
            }
        } else if (string3 == "attr") {
            Object object;
            ++this.attrCount;
            MemAttr memAttr = new MemAttr();
            memAttr.name = attributes.getValue("name");
            int n = 0;
            while (n < ATTR_TYPES.length) {
                object = attributes.getValue(ATTR_TYPES[n]);
                if (object != null) {
                    memAttr.type = ATTR_TYPES[n];
                    memAttr.data = object;
                    break;
                }
                ++n;
            }
            if (memAttr.type == null) {
                throw new SAXParseException("unknown <attr> value type for " + memAttr.name, this.locator);
            }
            object = (MemFileOrFolder)this.curr.peek();
            if (((MemFileOrFolder)object).attrs == null) {
                ((MemFileOrFolder)object).attrs = new LinkedList();
            }
            Iterator iterator = ((MemFileOrFolder)object).attrs.iterator();
            while (iterator.hasNext()) {
                if (!((MemAttr)iterator.next()).name.equals(memAttr.name)) continue;
                --this.attrCount;
                iterator.remove();
            }
            ((MemFileOrFolder)object).attrs.add(memAttr);
        } else {
            throw new SAXException(string3);
        }
    }

    private MemFileOrFolder fileOrFolder(String string, Attributes attributes) {
        String string2 = attributes.getValue("name");
        if (string2 == null) {
            throw new NullPointerException("No name");
        }
        if (!(this.curr.peek() instanceof MemFolder)) {
            throw new ClassCastException("Stack: " + this.curr);
        }
        MemFolder memFolder = (MemFolder)this.curr.peek();
        if (memFolder.children == null) {
            memFolder.children = new LinkedList();
        }
        MemFileOrFolder memFileOrFolder = null;
        Iterator iterator = memFolder.children.iterator();
        while (iterator.hasNext()) {
            MemFileOrFolder memFileOrFolder2 = (MemFileOrFolder)iterator.next();
            if (!memFileOrFolder2.name.equals(string2)) continue;
            memFileOrFolder = memFileOrFolder2;
            break;
        }
        if (memFileOrFolder == null) {
            if (string == "folder") {
                memFileOrFolder = new MemFolder();
                ++this.folderCount;
            } else {
                memFileOrFolder = new MemFile();
                ++this.fileCount;
            }
            memFileOrFolder.name = string2;
            memFolder.children.add(memFileOrFolder);
        }
        this.curr.push(memFileOrFolder);
        return memFileOrFolder;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        Object object2;
        if (string3 == "file" && this.buf.length() > 0) {
            object2 = this.buf.toString().trim();
            if (((String)object2).length() > 0) {
                object = (MemFile)this.curr.peek();
                if (((MemFile)object).ref != null) {
                    throw new SAXParseException("CDATA plus url= in <file>", this.locator);
                }
                ((MemFile)object).contents = ((String)object2).getBytes();
            }
            this.buf.setLength(0);
        }
        if (string3 == "file" && this.openURLs()) {
            object2 = (MemFile)this.curr.peek();
            if (((MemFile)object2).ref != null && ((MemFile)object2).ref.toExternalForm().startsWith("jar:file:")) {
                try {
                    object = ((MemFile)object2).ref.openConnection();
                    ((URLConnection)object).connect();
                    byte[] byArray = new byte[((URLConnection)object).getContentLength()];
                    InputStream inputStream = ((URLConnection)object).getInputStream();
                    try {
                        int n = 0;
                        while (n < byArray.length) {
                            int n2 = inputStream.read(byArray, n, byArray.length - n);
                            if (n2 < 1) {
                                throw new IOException();
                            }
                            n += n2;
                        }
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    ((MemFile)object2).contents = byArray;
                    ((MemFile)object2).ref = null;
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        if (string3 == "file" || string3 == "folder") {
            this.curr.pop();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object e = this.curr.peek();
        if (!(e instanceof MemFile)) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        LayerCacheManager.err.notify(1, (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string != null && (string.equals(DTD_1_0) || string.equals(DTD_1_1))) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endDocument() throws SAXException {
        if (this.curr.size() != 1) {
            throw new SAXException("Wrong stack: " + this.curr);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    protected static final class MemAttr {
        public String name;
        public String type;
        public String data;

        protected MemAttr() {
        }

        public String toString() {
            return "MemAttr[" + this.name + "," + this.type + "," + this.data + "]";
        }
    }

    protected static final class MemFile
    extends MemFileOrFolder {
        public byte[] contents = null;
        public URL ref = null;

        protected MemFile() {
        }

        public String toString() {
            return "MemFile[" + this.name + "]";
        }
    }

    protected static final class MemFolder
    extends MemFileOrFolder {
        public List children = null;

        protected MemFolder() {
        }

        public String toString() {
            return "MemFolder[" + this.name + "]";
        }
    }

    protected static abstract class MemFileOrFolder {
        public String name;
        public List attrs = null;

        protected MemFileOrFolder() {
        }
    }
}

