/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.core.IDESettings;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;

public class MiniStatusBar
extends JLabel {
    public static final String PROP_NODE_DESCRIPTION = "nodeDescription";
    private static final WeakSet loggedClasses = new WeakSet();
    private static boolean LOG_NODE_DESCRIPTION = Boolean.getBoolean("netbeans.log.node.description");
    private ExplorerManager explorerMgr;
    private PropertyChangeListener selectedNodesListener;
    private PropertyChangeListener miniStatusBarStateListener;
    private static IDESettings ideSettings;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;

    private MiniStatusBar() {
        this((ExplorerManager)null);
    }

    public MiniStatusBar(ExplorerManager explorerManager) {
        this.initialize();
        this.setExplorerManager(explorerManager);
        this.setNodeDescription(null);
    }

    private void initialize() {
        this.setOpaque(false);
        this.setEnabled(true);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))));
    }

    private static IDESettings ideSettings() {
        if (ideSettings == null) {
            ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = MiniStatusBar.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        }
        return ideSettings;
    }

    public static void setMiniStatusBarEnabled(boolean bl) {
        if (MiniStatusBar.isMiniStatusBarEnabled() == bl) {
            return;
        }
        MiniStatusBar.ideSettings().setMiniStatusBarState(bl);
    }

    public static boolean isMiniStatusBarEnabled() {
        return MiniStatusBar.ideSettings().getMiniStatusBarState();
    }

    private void setNodeDescription(String string) {
        if (!MiniStatusBar.isMiniStatusBarEnabled()) {
            return;
        }
        if (this.getRootPane() != null) {
            this.getRootPane().revalidate();
        }
        if (string != null) {
            if (string.startsWith("<html>")) {
                this.setText("<html>&nbsp;" + string.substring(6));
            } else {
                this.setText(" " + string);
            }
        } else {
            this.setText(" ");
        }
    }

    public void setExplorerManager(ExplorerManager explorerManager) {
        if (this.explorerMgr != null && this.explorerMgr.equals(explorerManager)) {
            this.selectedNodesListener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, explorerManager.getSelectedNodes()));
            return;
        }
        if (this.explorerMgr != null) {
            this.explorerMgr.removePropertyChangeListener(this.selectedNodesListener);
        }
        if (explorerManager != null) {
            if (this.selectedNodesListener == null) {
                this.selectedNodesListener = new SelectedNodesListener();
            }
            this.selectedNodesListener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, explorerManager.getSelectedNodes()));
            explorerManager.addPropertyChangeListener(this.selectedNodesListener);
        }
        this.explorerMgr = explorerManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SelectedNodesListener
    implements PropertyChangeListener {
        private Node[] describedNodes;
        static /* synthetic */ Class class$org$openide$nodes$FilterNode;

        SelectedNodesListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                if (this.describedNodes != null && this.describedNodes.equals(object) && propertyChangeEvent.getOldValue() != null) {
                    return;
                }
                if (object instanceof Node[]) {
                    this.describedNodes = (Node[])object;
                    String string = null;
                    int n = 0;
                    while (n < this.describedNodes.length) {
                        String string2 = this.getNodeDesc(this.describedNodes[n]);
                        if (string == null) {
                            string = string2;
                        } else if (!string.equals(string2)) {
                            string = null;
                            break;
                        }
                        ++n;
                    }
                    MiniStatusBar.this.setNodeDescription(string);
                }
            }
        }

        private String getNodeDesc(Node node) {
            String string = (String)node.getValue(MiniStatusBar.PROP_NODE_DESCRIPTION);
            if (string == null && (string = node.getShortDescription()) != null && string.equals(node.getDisplayName())) {
                string = null;
            }
            this.logDescription(node, string);
            return string;
        }

        private void logDescription(Node node, String string) {
            if (LOG_NODE_DESCRIPTION) {
                String string2;
                Object object;
                if (node instanceof FilterNode) {
                    try {
                        object = (class$org$openide$nodes$FilterNode == null ? (class$org$openide$nodes$FilterNode = SelectedNodesListener.class$("org.openide.nodes.FilterNode")) : class$org$openide$nodes$FilterNode).getDeclaredMethod("getOriginal", new Class[0]);
                        ((AccessibleObject)object).setAccessible(true);
                        try {
                            node = (Node)((Method)object).invoke((Object)node, new Object[0]);
                            string2 = null;
                            ((AccessibleObject)object).setAccessible(false);
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            ((AccessibleObject)object).setAccessible(false);
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                object = node.getClass().getName();
                if (!loggedClasses.add(object)) {
                    return;
                }
                ErrorManager errorManager = ErrorManager.getDefault();
                if (string == null || string.equals(node.getDisplayName())) {
                    string2 = MessageFormat.format("Node description of {0}: Warning! No description is provided. More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", object);
                    errorManager.log(16, string2);
                } else {
                    string2 = MessageFormat.format("Node description of {0}: {1} More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", object, string);
                    errorManager.log(16, string2);
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

