/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

final class WeakHash {
    final Entry[] entries = new Entry[7];
    final ReferenceQueue refq = new ReferenceQueue();

    int computeHash(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.entries.length;
    }

    public Value put(Workspace workspace, Value value) {
        this.checkq();
        int n = this.computeHash(workspace);
        Entry entry = this.entries[n];
        while (entry != null && !entry.wkey.equals(workspace)) {
            entry = entry.next;
        }
        if (entry == null) {
            this.entries[n] = new Entry(null, workspace, value, this.refq, this.entries, n);
            return null;
        }
        Value value2 = entry.val;
        entry.val = value;
        return value2;
    }

    public Value get(Workspace workspace) {
        this.checkq();
        int n = this.computeHash(workspace);
        Entry entry = this.entries[n];
        while (entry != null && !entry.wkey.equals(workspace)) {
            entry = entry.next;
        }
        if (entry == null) {
            return null;
        }
        return entry.val;
    }

    private void checkq() {
        WeakKey weakKey = (WeakKey)this.refq.poll();
        if (weakKey != null) {
            weakKey.remove();
        }
    }

    static class Value {
        private WeakReference[] currentNodes;
        private WeakReference[] activeNodes;
        TopComponent activatedTC;

        public Value(Node[] nodeArray, Node[] nodeArray2, TopComponent topComponent) {
            if (nodeArray == null) {
                nodeArray = new Node[]{};
            }
            if (nodeArray2 == null) {
                nodeArray2 = new Node[]{};
            }
            this.activatedTC = topComponent;
            this.currentNodes = new WeakReference[nodeArray.length];
            int n = 0;
            while (n < this.currentNodes.length) {
                this.currentNodes[n] = new WeakReference<Node>(nodeArray[n]);
                ++n;
            }
            this.activeNodes = new WeakReference[nodeArray2.length];
            int n2 = 0;
            while (n2 < this.activeNodes.length) {
                this.activeNodes[n2] = new WeakReference<Node>(nodeArray2[n2]);
                ++n2;
            }
        }

        public Node[] getActivatedNodes() {
            return Value.asNonNullNodes(this.activeNodes);
        }

        public Node[] getCurrentNodes() {
            return Value.asNonNullNodes(this.currentNodes);
        }

        private static Node[] asNonNullNodes(WeakReference[] weakReferenceArray) {
            ArrayList<Node> arrayList = new ArrayList<Node>(weakReferenceArray.length);
            int n = 0;
            while (n < weakReferenceArray.length) {
                Node node = (Node)weakReferenceArray[n].get();
                if (node != null) {
                    arrayList.add(node);
                }
                ++n;
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }
    }

    static class WeakKey
    extends WeakReference {
        int hash;
        Entry my;

        WeakKey(Workspace workspace, ReferenceQueue referenceQueue, Entry entry) {
            super(workspace, referenceQueue);
            this.hash = workspace.hashCode();
            this.my = entry;
        }

        void remove() {
            this.my.remove();
        }

        Workspace getWorkspace() {
            return (Workspace)this.get();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Workspace)) {
                return false;
            }
            Workspace workspace = this.getWorkspace();
            if (workspace == null) {
                return object == null;
            }
            return workspace.equals(object);
        }
    }

    static class Entry {
        Entry next;
        Entry prev;
        WeakKey wkey;
        Value val;
        int hash;
        Entry[] entries;

        Entry(Entry entry, Workspace workspace, Value value, ReferenceQueue referenceQueue, Entry[] entryArray, int n) {
            this.next = entry;
            if (entry != null) {
                entry.prev = this;
            }
            this.wkey = new WeakKey(workspace, referenceQueue, this);
            this.val = value;
            this.hash = n;
            this.entries = entryArray;
        }

        void remove() {
            if (this.prev == null && this.next == null) {
                return;
            }
            if (this.prev == null) {
                this.entries[this.hash] = this.next;
                this.next.prev = null;
            } else {
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

