/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WorkspaceExplorerPanel;
import org.netbeans.core.windows.WorkspaceImpl;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.windows.WindowManager;

public class WorkspaceExplorerDialog {
    private Dialog dialogWE = null;
    private static WorkspaceExplorerPanel panel;
    public static DialogDescriptor dialogDesc;
    private static JButton[] buttons;
    private static WorkspaceExplorerDialog explorerDialog;

    public static WorkspaceExplorerDialog showWEDialog(boolean bl) {
        if (bl && explorerDialog == null) {
            explorerDialog = new WorkspaceExplorerDialog();
        }
        explorerDialog.setVisibleWEDialog(bl);
        return explorerDialog;
    }

    public void setVisibleWEDialog(boolean bl) {
        if (bl) {
            this.createWEDialog();
        } else {
            if (panel != null) {
                panel = null;
            }
            if (this.dialogWE.isVisible()) {
                this.dialogWE.dispose();
            }
        }
    }

    public WorkspaceExplorerDialog getWEDialog() {
        return explorerDialog;
    }

    private WorkspaceExplorerPanel getPanel() {
        if (panel == null) {
            panel = new WorkspaceExplorerPanel(explorerDialog);
        }
        return panel;
    }

    public void requestFocus() {
        this.dialogWE.requestFocus();
        this.getPanel().requestFocus();
    }

    protected KeyListener weKeyListener() {
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                this.change(keyEvent, "Pressed", 1);
            }

            public void keyReleased(KeyEvent keyEvent) {
                this.change(keyEvent, "Released", 2);
            }

            public void keyTyped(KeyEvent keyEvent) {
                this.change(keyEvent, "Typed", 3);
            }

            private void change(KeyEvent keyEvent, String string, int n) {
                char c = keyEvent.getKeyChar();
                int n2 = keyEvent.getKeyCode();
                int n3 = keyEvent.getModifiers();
                if (n2 == 27) {
                    WorkspaceExplorerDialog.this.setVisibleWEDialog(false);
                } else if (n == 1 && (n2 == 10 || n2 == 32)) {
                    WorkspaceExplorerDialog.this.activateNodeSelected();
                }
            }
        };
        return keyListener;
    }

    private JButton[] getButtons() {
        if (buttons == null) {
            JButton[] jButtonArray = new JButton[2];
            this.getPanel();
            jButtonArray[0] = new JButton(WorkspaceExplorerPanel.bundle().getString("CTL_Open"));
            this.getPanel();
            jButtonArray[1] = new JButton(WorkspaceExplorerPanel.bundle().getString("CTL_Cancel"));
            buttons = jButtonArray;
            String string = "O";
            if (string != null && string.length() > 0) {
                buttons[0].setMnemonic(string.charAt(0));
            }
            this.getPanel();
            String string2 = WorkspaceExplorerPanel.bundle().getString("ACS_Open");
            if (string2 != null) {
                buttons[0].getAccessibleContext().setAccessibleDescription(string2);
            }
            if ((string = "C") != null && string.length() > 0) {
                buttons[1].setMnemonic(string.charAt(0));
            }
            this.getPanel();
            string2 = WorkspaceExplorerPanel.bundle().getString("ACS_Cancel");
            if (string2 != null) {
                buttons[1].getAccessibleContext().setAccessibleDescription(string2);
            }
        }
        return buttons;
    }

    private DialogDescriptor createWEDialog() {
        this.getPanel();
        String string = WorkspaceExplorerPanel.bundle().getString("CTL_WorkExplorer");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getPanel(), string, true, (Object[])this.getButtons(), null, 0, null, null);
        dialogDescriptor.setClosingOptions((Object[])this.getButtons());
        this.dialogWE = TopManager.getDefault().createDialog(dialogDescriptor);
        this.dialogWE.show();
        if (dialogDescriptor.getValue() != null) {
            if (dialogDescriptor.getValue().equals(this.getButtons()[0])) {
                this.activateNodeSelected();
            }
            if (dialogDescriptor.getValue().equals(this.getButtons()[1])) {
                this.setVisibleWEDialog(false);
            }
        }
        return dialogDescriptor;
    }

    private DefaultMutableTreeNode getAktiveNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPanel().getSelectedObject();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode;
    }

    private Object getNodeObject() {
        if (this.getAktiveNode() == null) {
            return null;
        }
        return this.getAktiveNode().getUserObject();
    }

    private int getWorkspaceIndex() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPanel().getSelectedObject();
        if (defaultMutableTreeNode == null) {
            return 0;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        WorkspaceExplorerPanel.NodeInfo nodeInfo = (WorkspaceExplorerPanel.NodeInfo)object;
        return nodeInfo.nodeWorkspaceOrder;
    }

    private int getModeIndex() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPanel().getSelectedObject();
        if (defaultMutableTreeNode == null) {
            return 0;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        WorkspaceExplorerPanel.NodeInfo nodeInfo = (WorkspaceExplorerPanel.NodeInfo)object;
        return nodeInfo.nodeModeOrder;
    }

    private void activateNodeSelected() {
        int n = this.getWorkspaceIndex();
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)WindowManager.getDefault().getWorkspaces()[n];
        ModeImpl[] modeImplArray = workspaceImpl.getModes().toArray(new ModeImpl[0]);
        ModeImpl modeImpl = modeImplArray[this.getModeIndex()];
        this.setVisibleWEDialog(false);
        workspaceImpl.activate();
        workspaceImpl.setActiveMode(modeImpl);
        workspaceImpl.fireModeChange();
        modeImpl.requestFocus();
    }

    private void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == buttons[0] || object == panel) {
            this.activateNodeSelected();
        } else if (object == buttons[1] || object == panel) {
            this.setVisibleWEDialog(false);
        }
    }

    static {
        dialogDesc = null;
        explorerDialog = null;
    }
}

