/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.core.awt.TabControl;
import org.netbeans.core.windows.KeyFocuseWorkspace;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WorkspaceSwitcher {
    private WindowManagerImpl pool;
    static TabControl control;
    private static WorkspaceSwitcher workspaceSwitcher;
    private ArrayList workspaces;
    private HashMap listeners;
    private KeyFocuseWorkspace FocuseListen;
    boolean changeCurrentAllowed = true;
    int index;
    Workspace workspace;
    private static final int MOUSE_ADAPTOR = 0;
    private static final int IN_OUT_WORKSPACES = 1;
    private static final int EVENTS_ON_CONTROL = 2;
    private static final int ADD_NEW_WORKSPACES = 3;
    private static final int SWITCH_TO_WORKSPACE = 4;
    private static final int DELETE_WORKSPACE = 5;
    private static final int CUSTOMIZE_WORKSPACE = 6;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceSwitcher;
    static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;

    public WorkspaceSwitcher(WindowManager windowManager) {
        int n;
        this.pool = (WindowManagerImpl)windowManager;
        control = new TabControl();
        control.putClientProperty("Toolbar", "Fixed");
        HelpCtx.setHelpIDString((JComponent)control, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        this.workspaces = new ArrayList(5);
        this.listeners = new HashMap(7);
        control.setDirection(false);
        this.addNew(this.pool.getWorkspaces());
        Workspace workspace = this.pool.getCurrentWorkspace();
        if (this.pool.getWorkspacesNoLoad() != null && (n = this.workspaces.indexOf(workspace)) >= 0) {
            control.setSelectedIndex(n);
        }
        this.FocuseListen = new KeyFocuseWorkspace();
        control.addKeyListener(this.FocuseListen);
        this.pool.addPropertyChangeListener(new PoolListener(1));
        PoolListener poolListener = new PoolListener(2);
        control.addIndexChangeListener(poolListener);
        PoolListener poolListener2 = new PoolListener(0);
        control.addMouseListener(poolListener2);
    }

    private void propChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        Workspace workspace;
        if (propertyChangeEvent.getPropertyName().equals("workspaces")) {
            workspace = (Workspace)propertyChangeEvent.getNewValue();
            this.changeCurrentAllowed = false;
            this.removeOld();
            this.addNew((Workspace[])workspace);
            n = this.workspaces.indexOf(this.pool.getCurrentWorkspace());
            if (n >= 0) {
                control.setSelectedIndex(n);
            }
            control.revalidate();
            this.changeCurrentAllowed = true;
        }
        if (propertyChangeEvent.getPropertyName().equals("currentWorkspace")) {
            workspace = (Workspace)propertyChangeEvent.getNewValue();
            n = this.workspaces.indexOf(workspace);
            if (n < 0) {
                this.addNew(new Workspace[]{workspace});
                control.revalidate();
                return;
            }
            control.setSelectedIndex(n);
            control.repaint();
        }
    }

    void showPopup(int n, int n2) {
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        this.index = control.pointToIndex(n);
        this.workspace = WindowManager.getDefault().getWorkspaces()[this.index];
        String string = Actions.cutAmpersand((String)this.workspace.getDisplayName());
        boolean bl = this.index == control.getSelectedIndex();
        JMenuItem jMenuItem = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_SwitchToWorkspace", string));
        HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        jMenuItem.addActionListener(new PoolListener(4));
        jMenuItem.setEnabled(!bl);
        jPopupMenuPlus.add(jMenuItem);
        jPopupMenuPlus.addSeparator();
        jMenuItem = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_DeleteWorkspace", string));
        HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        jMenuItem.addActionListener(new PoolListener(5));
        jMenuItem.setEnabled(!bl);
        jPopupMenuPlus.add(jMenuItem);
        jPopupMenuPlus.addSeparator();
        jMenuItem = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_CustomizeWorkspaces"));
        HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        jMenuItem.addActionListener(new PoolListener(6));
        jPopupMenuPlus.add(jMenuItem);
        jPopupMenuPlus.show(control, n, n2);
    }

    protected void addNew(Workspace[] workspaceArray) {
        if (workspaceArray == null) {
            return;
        }
        String string = null;
        PoolListener poolListener = null;
        int n = 0;
        while (n < workspaceArray.length) {
            string = Actions.cutAmpersand((String)workspaceArray[n].getDisplayName());
            control.addTab(string);
            this.workspaces.add(workspaceArray[n]);
            poolListener = new PoolListener(3);
            workspaceArray[n].addPropertyChangeListener((PropertyChangeListener)poolListener);
            this.listeners.put(workspaceArray[n], poolListener);
            ++n;
        }
    }

    protected void removeOld() {
        Workspace[] workspaceArray = this.workspaces.toArray(new Workspace[0]);
        PropertyChangeListener propertyChangeListener = null;
        int n = 0;
        while (n < workspaceArray.length) {
            propertyChangeListener = (PropertyChangeListener)this.listeners.remove(workspaceArray[n]);
            if (propertyChangeListener != null) {
                workspaceArray[n].removePropertyChangeListener(propertyChangeListener);
            }
            ++n;
        }
        this.workspaces.clear();
        control.removeAllTabs();
    }

    public Component getComponent() {
        return control;
    }

    public static synchronized TabControl getDefault() {
        return control;
    }

    public static Component createSwitcher() {
        return WorkspaceSwitcher.getInstance().getComponent();
    }

    public static synchronized WorkspaceSwitcher getInstance() {
        if (workspaceSwitcher == null) {
            workspaceSwitcher = new WorkspaceSwitcher(WindowManager.getDefault());
        }
        return workspaceSwitcher;
    }

    public static String stripAmpersand(String string) {
        int n = string.indexOf(38);
        return n < 0 ? string : string.substring(0, n) + string.substring(n + 1);
    }

    private static String getMainString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WorkspaceSwitcher.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl)).getString(string);
    }

    private static String getMainString(String string, Object object) {
        MessageFormat messageFormat = new MessageFormat(WorkspaceSwitcher.getMainString(string));
        return messageFormat.format(new Object[]{object});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class PoolListener
    extends MouseAdapter
    implements ActionListener,
    PropertyChangeListener {
        private int id;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceSwitcher;

        public PoolListener(int n) {
            this.id = n;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (this.id) {
                case 1: {
                    if (EventQueue.isDispatchThread()) {
                        WorkspaceSwitcher.this.propChange(propertyChangeEvent);
                        break;
                    }
                    EventQueue.invokeLater(new Runnable(this, propertyChangeEvent){
                        private final /* synthetic */ PropertyChangeEvent val$che;
                        private final /* synthetic */ PoolListener this$1;
                        {
                            this.this$1 = poolListener;
                            this.val$che = propertyChangeEvent;
                        }

                        public void run() {
                            WorkspaceSwitcher.access$000(PoolListener.access$100(this.this$1), this.val$che);
                        }
                    });
                    break;
                }
                case 2: {
                    if (!WorkspaceSwitcher.this.changeCurrentAllowed) break;
                    int n = control.getSelectedIndex();
                    if (n < 0 || n >= WorkspaceSwitcher.this.workspaces.size()) {
                        return;
                    }
                    ((Workspace)WorkspaceSwitcher.this.workspaces.get(n)).activate();
                    break;
                }
                case 3: {
                    if (!propertyChangeEvent.getPropertyName().equals("displayName")) break;
                    Workspace workspace = (Workspace)propertyChangeEvent.getSource();
                    int n = WorkspaceSwitcher.this.workspaces.indexOf(workspace);
                    if (n < 0) {
                        return;
                    }
                    control.replaceTabAt(Actions.cutAmpersand((String)workspace.getDisplayName()), n);
                    control.revalidate();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.id) {
                case 4: {
                    control.setSelectedIndex(WorkspaceSwitcher.this.index);
                    break;
                }
                case 5: {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = PoolListener.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher), (String)"MSG_ConfirmDeleteObject", (Object)Actions.cutAmpersand((String)WorkspaceSwitcher.this.workspace.getDisplayName())), NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = PoolListener.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher), (String)"MSG_ConfirmDeleteObjectTitle"), 0);
                    if (!NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation))) break;
                    WorkspaceSwitcher.this.workspace.remove();
                    break;
                }
                case 6: {
                    TopManager topManager = TopManager.getDefault();
                    topManager.getNodeOperation().explore(topManager.getPlaces().nodes().workspaces());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                WorkspaceSwitcher.this.showPopup(mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }

        static /* synthetic */ WorkspaceSwitcher access$100(PoolListener poolListener) {
            return poolListener.WorkspaceSwitcher.this;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

