/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.netbeans.core.windows.frames.TopComponentContainer;

public final class DropTargetGlassPane
extends JPanel {
    private Point location;
    private TopComponentContainer.DropIndicator dropIndicator;

    public DropTargetGlassPane() {
        this((TopComponentContainer.DropIndicator)null);
    }

    public DropTargetGlassPane(TopComponentContainer.DropIndicator dropIndicator) {
        this.dropIndicator = dropIndicator;
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.isVisible()) {
            this.revalidate();
        } else {
            this.setVisible(true);
        }
    }

    public void uninitialize() {
        if (this.location != null) {
            this.dragFinished();
        }
        this.setVisible(false);
    }

    public void dragOver(Point point) {
        this.location = point;
        this.repaint();
    }

    public void dragExited() {
        this.location = null;
        this.repaint();
    }

    public void dragExitedHack() {
        if (this.location == null) {
            return;
        }
        this.dragExited();
    }

    public void dragActionChanged(Point point) {
        this.location = point;
        this.repaint();
    }

    public void dragFinished() {
        this.location = null;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Point point = this.location;
        if (point == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(DropTargetGlassPane.createIndicationStroke());
        Rectangle rectangle = this.getIndicatorRectangle(point);
        String string = this.dropIndicator.getDescriptionForLocation(this.location);
        if (rectangle != null) {
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            graphics2D.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            if (string != null) {
                Font font = graphics2D.getFont();
                Font font2 = font.deriveFont(1);
                FontMetrics fontMetrics = ((Component)this).getFontMetrics(font2);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                graphics2D.setColor(new Color(255, 255, 255, 200));
                graphics2D.fillRect((int)rectangle2D.getX() + rectangle.x + 18, (int)rectangle2D.getY() + rectangle.y + 18, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
                graphics2D.setColor(Color.black);
                graphics2D.setFont(font2);
                graphics2D.drawString(string, rectangle.x + 20, rectangle.y + 20);
                graphics2D.setFont(font);
            }
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private Rectangle getIndicatorRectangle(Point point) {
        Shape shape = this.dropIndicator.getIndicationForLocation(point);
        return shape instanceof Rectangle ? (Rectangle)shape : null;
    }

    private static Stroke createIndicationStroke() {
        float[] fArray = new float[]{1.0f, 1.0f};
        return new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 0.0f);
    }
}

