/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TopComponentDragSupport
extends KeyAdapter
implements AWTEventListener,
DragGestureListener,
DragSourceListener {
    public static final String MIME_TOP_COMPONENT = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent";
    public static final String MIME_TOP_COMPONENT_CLONEABLE = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable";
    private static final int CURSOR_COPY = 0;
    private static final int CURSOR_COPY_NO = 1;
    private static final int CURSOR_MOVE = 2;
    private static final int CURSOR_MOVE_NO = 3;
    private static final int CURSOR_COPY_NO_MOVE = 4;
    private static final String NAME_CURSOR_COPY = "CursorTopComponentCopy";
    private static final String NAME_CURSOR_COPY_NO = "CursorTopComponentCopyNo";
    private static final String NAME_CURSOR_MOVE = "CursorTopComponentMove";
    private static final String NAME_CURSOR_MOVE_NO = "CursorTopComponentMoveNo";
    private static final String NAME_CURSOR_COPY_NO_MOVE = "CursorTopComponentCopyNoMove";
    private static TopComponentDragSupport defaultDragSupport;
    private Reference dragContextWRef = new WeakReference<Object>(null);
    private boolean canCopy;
    int hackUserDropAction;
    private boolean hackESC;
    private final Set keyObservers = new WeakSet(4);
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
    static /* synthetic */ Class class$java$awt$dnd$DragSourceEvent;

    private TopComponentDragSupport() {
    }

    public static synchronized TopComponentDragSupport getDefault() {
        if (defaultDragSupport == null) {
            defaultDragSupport = new TopComponentDragSupport();
            Toolkit.getDefaultToolkit().addAWTEventListener(defaultDragSupport, 32L);
        }
        return defaultDragSupport;
    }

    public boolean copyOperationPossible() {
        return this.canCopy;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Serializable serializable;
        if (aWTEvent.getID() != 506) {
            return;
        }
        if (WindowDnDManager.getDefault().isDragging()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        Object object = mouseEvent.getSource();
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        if (component instanceof JTree && ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
            return;
        }
        component = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY());
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        TopComponent topComponent = null;
        if (bl || bl2) {
            topComponent = component instanceof TopComponent ? (TopComponent)component : (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponentDragSupport.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, component);
        }
        if (topComponent == null) {
            serializable = (JTabbedPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = TopComponentDragSupport.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane, component);
            if (serializable == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)serializable);
            int n = JdkBug4620540Hack.findTabForCoordinate((JTabbedPane)serializable, point.x, point.y);
            if (n >= 0 && ((JTabbedPane)serializable).getComponentAt(n) instanceof TopComponent) {
                topComponent = (TopComponent)((JTabbedPane)serializable).getComponentAt(n);
            }
        }
        if (topComponent == null) {
            return;
        }
        this.hackUserDropAction = bl2 ? 1 : 2;
        serializable = new ArrayList();
        serializable.add(mouseEvent);
        this.doStartDrag(topComponent, new DragGestureEvent(new FakeDragGestureRecognizer(mouseEvent), this.hackUserDropAction, mouseEvent.getPoint(), (List<? extends InputEvent>)((Object)serializable)));
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n;
        Point point;
        if (WindowDnDManager.getDefault().isDragging()) {
            return;
        }
        Component component = dragGestureEvent.getComponent();
        if (!(component instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)component;
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent) {
            point = ((MouseEvent)inputEvent).getPoint();
            n = jTabbedPane.getUI().tabForCoordinate(jTabbedPane, point.x, point.y);
            if (n == -1) {
                return;
            }
        } else {
            return;
        }
        component = jTabbedPane.getComponentAt(n);
        if (!(component instanceof TopComponent)) {
            return;
        }
        point = (TopComponent)component;
        n = dragGestureEvent.getDragAction();
        if (n != 2 && n != 1) {
            return;
        }
        this.hackUserDropAction = n;
        this.doStartDrag((TopComponent)point, dragGestureEvent);
    }

    private void doStartDrag(TopComponent topComponent, DragGestureEvent dragGestureEvent) {
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = TopComponentDragSupport.class$("java.awt.Dialog")) : class$java$awt$Dialog, (Component)topComponent);
        if (dialog != null && dialog.isModal()) {
            return;
        }
        this.canCopy = topComponent instanceof TopComponent.Cloneable;
        WindowDnDManager.getDefault().setOriginalBounds(topComponent.getBounds());
        WindowDnDManager.getDefault().dragStarting();
        Cursor cursor = this.hackUserDropAction == 2 ? TopComponentDragSupport.getDragCursor(2) : (this.canCopy ? TopComponentDragSupport.getDragCursor(0) : TopComponentDragSupport.getDragCursor(4));
        Container container = SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = TopComponentDragSupport.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer, (Component)topComponent);
        if (container == null) {
            this.addListening((Container)topComponent);
        } else {
            this.addListening(container);
        }
        this.hackESC = false;
        try {
            dragGestureEvent.startDrag(cursor, new TopComponentTransferable(topComponent), this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            invalidDnDOperationException.printStackTrace();
            this.removeListening();
            WindowDnDManager.getDefault().resetDragSource();
        }
    }

    private void addListening(Container container) {
        container.addKeyListener(this);
        this.keyObservers.add(container);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].addKeyListener(this);
            this.keyObservers.add(componentArray[n]);
            if (componentArray[n] instanceof Container) {
                this.addListening((Container)componentArray[n]);
            }
            ++n;
        }
    }

    private void removeListening() {
        Iterator iterator = this.keyObservers.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            component.removeKeyListener(this);
        }
        this.keyObservers.clear();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceDragEvent.getDragSourceContext());
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        Point point;
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceEvent.getDragSourceContext());
        }
        if ((point = TopComponentDragSupport.getLocationForEvent(dragSourceEvent)) == null) {
            return;
        }
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        MainWindow mainWindow = WindowManagerImpl.mainWindow();
        Point point2 = new Point(point);
        Rectangle rectangle = mainWindow.getBounds();
        if (rectangle.contains(point2)) {
            Component[] componentArray = WindowManagerImpl.mainWindow().getContentPane().getComponents();
            Component component = null;
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof DesktopPane) {
                    component = componentArray[n];
                    break;
                }
                ++n;
            }
            if (component != null && (component = ((DesktopPane)component).getComponentAt("CENTER")) != null) {
                SwingUtilities.convertPointFromScreen(point, component);
                rectangle = component.getBounds();
                if (new Rectangle(0, 0, rectangle.width, rectangle.height).contains(point)) {
                    this.dragEnterHack(this.hackUserDropAction);
                    return;
                }
            }
            this.dragExitHack();
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n;
        int n2;
        String string = dragSourceDragEvent.getDragSourceContext().getCursor().getName();
        if (string == null) {
            return;
        }
        this.hackUserDropAction = n2 = dragSourceDragEvent.getUserAction();
        if ((NAME_CURSOR_COPY.equals(string) || NAME_CURSOR_COPY_NO_MOVE.equals(string)) && n2 == 2) {
            n = 2;
        } else if (NAME_CURSOR_COPY_NO.equals(string) && n2 == 2) {
            n = 3;
        } else if (NAME_CURSOR_MOVE.equals(string) && n2 == 1) {
            n = 0;
        } else if (NAME_CURSOR_MOVE_NO.equals(string) && n2 == 1) {
            n = 1;
        } else {
            return;
        }
        if (n == 0 && !this.canCopy) {
            n = 4;
        }
        dragSourceDragEvent.getDragSourceContext().setCursor(TopComponentDragSupport.getDragCursor(n));
    }

    public void dragDropEnd(final DragSourceDropEvent dragSourceDropEvent) {
        WindowManagerImpl windowManagerImpl;
        WindowDnDManager.getDefault().dragFinished();
        if (WindowDnDManager.getDefault().isDropSuccess()) {
            this.removeListening();
            return;
        }
        final Point point = TopComponentDragSupport.getLocationForEvent(dragSourceDropEvent);
        if (point == null) {
            this.removeListening();
            return;
        }
        boolean bl = false;
        if (WindowUtils.isMdi()) {
            windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            MainWindow mainWindow = WindowManagerImpl.mainWindow();
            Point point2 = new Point(point);
            SwingUtilities.convertPointFromScreen(point2, mainWindow);
            Rectangle rectangle = mainWindow.getBounds();
            if (!new Rectangle(0, 0, rectangle.width, rectangle.height).contains(point2)) {
                if (dragSourceDropEvent.getDropSuccess()) {
                    this.removeListening();
                    return;
                }
                bl = true;
            } else {
                Component[] componentArray = WindowManagerImpl.mainWindow().getContentPane().getComponents();
                Component component = null;
                int n = 0;
                while (n < componentArray.length) {
                    if (componentArray[n] instanceof DesktopPane) {
                        component = componentArray[n];
                        break;
                    }
                    ++n;
                }
                if (component == null) {
                    this.removeListening();
                    return;
                }
                if ((component = ((DesktopPane)component).getComponentAt("CENTER")) == null) {
                    this.removeListening();
                    return;
                }
                SwingUtilities.convertPointFromScreen(point, component);
                rectangle = component.getBounds();
                if (!new Rectangle(0, 0, rectangle.width, rectangle.height).contains(point)) {
                    this.removeListening();
                    return;
                }
            }
        } else {
            windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            MainWindow mainWindow = WindowManagerImpl.mainWindow();
            Point point3 = new Point(point);
            SwingUtilities.convertPointFromScreen(point3, mainWindow);
            Rectangle rectangle = mainWindow.getBounds();
            if (new Rectangle(0, 0, rectangle.width, rectangle.height).contains(point3)) {
                this.removeListening();
                return;
            }
        }
        final boolean bl2 = bl;
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (TopComponentDragSupport.access$100(1.access$000(this.this$1))) {
                            TopComponentDragSupport.access$200(1.access$000(this.this$1));
                            return;
                        }
                        TopComponent topComponent = TopComponentDragSupport.extractTopComponent(false, 1.access$300(this.this$1).getDragSourceContext().getTransferable(), this.getClass().getClassLoader());
                        if (topComponent != null) {
                            Rectangle rectangle = TopComponentDragSupport.access$500(topComponent, 1.access$400(this.this$1));
                            if (1.access$000(this.this$1).hackUserDropAction == 1 && topComponent instanceof TopComponent.Cloneable) {
                                WindowUtils.dockIntoNewMode(topComponent, true, rectangle, 1.access$600(this.this$1) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : (WindowUtils.isMdi() ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : null));
                            } else if (1.access$000(this.this$1).hackUserDropAction == 2) {
                                TopComponent[] topComponentArray;
                                ModeImpl modeImpl = (ModeImpl)WindowManager.getDefault().getCurrentWorkspace().findMode(topComponent);
                                if (modeImpl != null && !"org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(modeImpl.getFrameType()) && (topComponentArray = modeImpl.getTopComponents()).length == 1 && topComponentArray[0] == topComponent) {
                                    modeImpl.release(topComponent);
                                }
                                WindowUtils.dockIntoNewMode(topComponent, false, rectangle, 1.access$600(this.this$1) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : (WindowUtils.isMdi() ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : null));
                            }
                        }
                    }
                });
            }

            static /* synthetic */ TopComponentDragSupport access$000(1 var0) {
                return var0.TopComponentDragSupport.this;
            }

            static /* synthetic */ DragSourceDropEvent access$300(1 var0) {
                return var0.dragSourceDropEvent;
            }

            static /* synthetic */ Point access$400(1 var0) {
                return var0.point;
            }

            static /* synthetic */ boolean access$600(1 var0) {
                return var0.bl2;
            }
        }, (int)250);
    }

    private static Rectangle getBoundsForNewMode(TopComponent topComponent, Point point) {
        Cloneable cloneable;
        int n = topComponent.getWidth();
        int n2 = topComponent.getHeight();
        Window window = SwingUtilities.getWindowAncestor((Component)topComponent);
        if (window != null) {
            cloneable = window.getInsets();
            n += cloneable.left + cloneable.right;
            n2 += cloneable.top + cloneable.bottom;
        }
        cloneable = topComponent.getBounds();
        Rectangle rectangle = new Rectangle(point.x, point.y, n, n2);
        return rectangle;
    }

    public void dragEnterHack(int n) {
        int n2;
        DragSourceContext dragSourceContext = (DragSourceContext)this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        if (n == 2) {
            n2 = 2;
        } else if (n == 1) {
            n2 = this.canCopy ? 0 : 4;
        } else {
            return;
        }
        dragSourceContext.setCursor(TopComponentDragSupport.getDragCursor(n2));
    }

    public void dragExitHack() {
        int n;
        DragSourceContext dragSourceContext = (DragSourceContext)this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        String string = dragSourceContext.getCursor().getName();
        if (NAME_CURSOR_COPY.equals(string) || NAME_CURSOR_COPY_NO_MOVE.equals(string)) {
            n = 1;
        } else if (NAME_CURSOR_MOVE.equals(string)) {
            n = 3;
        } else {
            return;
        }
        dragSourceContext.setCursor(TopComponentDragSupport.getDragCursor(n));
    }

    void dragFinished() {
        this.dragContextWRef = new WeakReference<Object>(null);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.hackESC = true;
        }
    }

    static Point getLocationForEvent(DragSourceEvent dragSourceEvent) {
        try {
            Method method = (class$java$awt$dnd$DragSourceEvent == null ? (class$java$awt$dnd$DragSourceEvent = TopComponentDragSupport.class$("java.awt.dnd.DragSourceEvent")) : class$java$awt$dnd$DragSourceEvent).getMethod("getLocation", new Class[0]);
            return (Point)method.invoke((Object)dragSourceEvent, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    private static Cursor getDragCursor(int n) {
        Image image = null;
        String string = null;
        if (n == 0) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopy.gif");
            string = NAME_CURSOR_COPY;
        } else if (n == 1) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO;
        } else if (n == 2) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMove.gif");
            string = NAME_CURSOR_MOVE;
        } else if (n == 3) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMoveNo.gif");
            string = NAME_CURSOR_MOVE_NO;
        } else if (n == 4) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO_MOVE;
        } else {
            throw new IllegalArgumentException("Unknown cursor type=" + n);
        }
        return TopComponentDragSupport.createCustomCursor(image, string);
    }

    private static Cursor createCustomCursor(Image image, String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(16, 16);
        Image image2 = image;
        if (dimension.width != image.getWidth(null)) {
            BufferedImage bufferedImage = TopComponentDragSupport.createBufferedImage(dimension.width, dimension.height);
            image2 = Utilities.mergeImages((Image)image, (Image)bufferedImage, (int)0, (int)0);
        }
        return toolkit.createCustomCursor(image2, new Point(11, 9), string);
    }

    private static final BufferedImage createBufferedImage(int n, int n2) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    public static TopComponent extractTopComponent(boolean bl, Transferable transferable, ClassLoader classLoader) {
        DataFlavor dataFlavor = TopComponentDragSupport.getDataFlavorForDropAction(bl, classLoader);
        if (dataFlavor == null) {
            return null;
        }
        if (transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                TopComponent topComponent;
                if (bl) {
                    TopComponent.Cloneable cloneable = (TopComponent.Cloneable)transferable.getTransferData(dataFlavor);
                    topComponent = cloneable.cloneComponent();
                } else {
                    topComponent = (TopComponent)transferable.getTransferData(dataFlavor);
                }
                return topComponent;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static DataFlavor getDataFlavorForDropAction(boolean bl, ClassLoader classLoader) {
        DataFlavor dataFlavor;
        if (bl) {
            try {
                dataFlavor = new DataFlavor(MIME_TOP_COMPONENT_CLONEABLE, null, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException("Can't create DataFlavor with MIME_TOP_COMPONENT_CLONEABLE using " + classLoader), (Throwable)classNotFoundException);
            }
        } else {
            dataFlavor = new DataFlavor(MIME_TOP_COMPONENT, null);
        }
        return dataFlavor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$100(TopComponentDragSupport topComponentDragSupport) {
        return topComponentDragSupport.hackESC;
    }

    static /* synthetic */ void access$200(TopComponentDragSupport topComponentDragSupport) {
        topComponentDragSupport.removeListening();
    }

    static /* synthetic */ Rectangle access$500(TopComponent topComponent, Point point) {
        return TopComponentDragSupport.getBoundsForNewMode(topComponent, point);
    }

    private static class FakeDragGestureRecognizer
    extends DragGestureRecognizer {
        public FakeDragGestureRecognizer(MouseEvent mouseEvent) {
            super(WindowDnDManager.getDefault().getWindowDragSource(), (Component)mouseEvent.getSource(), 3, null);
            this.appendEvent(mouseEvent);
        }

        public void registerListeners() {
        }

        public void unregisterListeners() {
        }
    }

    private static class TopComponentTransferable
    implements Transferable {
        private TopComponent tc;

        public TopComponentTransferable(TopComponent topComponent) {
            this.tc = topComponent;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return this.tc;
            }
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && this.tc instanceof TopComponent.Cloneable) {
                return this.tc;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (this.tc instanceof TopComponent.Cloneable) {
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null), new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE, null)};
            }
            return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null)};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return true;
            }
            return TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && this.tc instanceof TopComponent.Cloneable;
        }
    }
}

