/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.openide.util.WeakSet;
import org.openide.windows.WindowManager;

public final class WindowDnDManager {
    private static WindowDnDManager defaultDnDManager;
    private DragSource windowDragSource;
    private boolean dragging;
    private boolean dropSuccess;
    private final Set dropIndicators = new WeakSet(4);
    private final Set floatingFrames = new WeakSet(4);
    private Reference lastTargetWRef = new WeakReference<Object>(null);
    private Rectangle originalBounds;

    private WindowDnDManager() {
    }

    public static synchronized WindowDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new WindowDnDManager();
        }
        return defaultDnDManager;
    }

    public synchronized DragSource getWindowDragSource() {
        if (this.windowDragSource == null) {
            this.windowDragSource = new DragSource();
            new MotionListener();
        }
        return this.windowDragSource;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDropSuccess(boolean bl) {
        this.dropSuccess = bl;
    }

    public boolean isDropSuccess() {
        return this.dropSuccess;
    }

    public void setOriginalBounds(Rectangle rectangle) {
        this.originalBounds = rectangle;
    }

    public Rectangle getOriginalBounds() {
        return this.originalBounds;
    }

    public void setLastDropTarget(TopComponentContainer.DropIndicator dropIndicator) {
        if (dropIndicator != this.lastTargetWRef.get()) {
            this.lastTargetWRef = new WeakReference<TopComponentContainer.DropIndicator>(dropIndicator);
        }
    }

    public void resetDragSource() {
        this.dragFinished();
    }

    public void dragStarting() {
        Set set = WindowManager.getDefault().getCurrentWorkspace().getModes();
        Set set2 = this.dropIndicators;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FrameType frameType;
                ModeImpl modeImpl = (ModeImpl)iterator.next();
                TopComponentContainer topComponentContainer = modeImpl.getContainerInstance();
                if (topComponentContainer instanceof TopComponentContainer.DropIndicator) {
                    ((TopComponentContainer.DropIndicator)((Object)topComponentContainer)).windowDragStarting();
                    this.dropIndicators.add(topComponentContainer);
                }
                if ((frameType = modeImpl.getFrameInstance()) == null) continue;
                this.floatingFrames.add(frameType);
            }
        }
        this.dragging = true;
        this.dropSuccess = false;
    }

    public void dragFinished() {
        TopComponentDragSupport.getDefault().dragFinished();
        this.dragging = false;
        Set set = this.dropIndicators;
        synchronized (set) {
            Iterator iterator = this.dropIndicators.iterator();
            while (iterator.hasNext()) {
                TopComponentContainer.DropIndicator dropIndicator = (TopComponentContainer.DropIndicator)iterator.next();
                dropIndicator.windowDragFinished();
                iterator.remove();
            }
            this.floatingFrames.clear();
        }
        this.setOriginalBounds(null);
    }

    private static void dragSourceMoved(DragSourceDragEvent dragSourceDragEvent) {
        Point point = TopComponentDragSupport.getLocationForEvent(dragSourceDragEvent);
        if (point == null) {
            return;
        }
        Point point2 = new Point(point);
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        Rectangle rectangle = WindowManagerImpl.mainWindow().getBounds();
        if (!rectangle.contains(point2)) {
            boolean bl = false;
            Iterator iterator = WindowDnDManager.getDefault().floatingFrames.iterator();
            while (iterator.hasNext()) {
                FrameType frameType = (FrameType)iterator.next();
                if (!frameType.getRootPaneContainer().getBounds().contains(point2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                WindowDnDManager.setCursorInFreeArea();
            }
        }
    }

    private static void setCursorInFreeArea() {
        TopComponentDragSupport.getDefault().dragEnterHack(TopComponentDragSupport.getDefault().hackUserDropAction);
        WindowDnDManager.dragExitedHack();
    }

    private static void dragExitedHack() {
        WindowDnDManager windowDnDManager = WindowDnDManager.getDefault();
        TopComponentContainer.DropIndicator dropIndicator = (TopComponentContainer.DropIndicator)windowDnDManager.lastTargetWRef.get();
        if (dropIndicator instanceof SplitContainerImpl) {
            ((SplitContainerImpl)dropIndicator).dragExitedHack();
        } else if (dropIndicator instanceof MultiTabbedContainerImpl) {
            ((MultiTabbedContainerImpl)dropIndicator).dragExitedHack();
        }
        if (dropIndicator != null) {
            windowDnDManager.lastTargetWRef = new WeakReference<Object>(null);
        }
    }

    private static class MotionListener {
        private MotionListener() {
            try {
                Class<?> clazz = Class.forName("java.awt.dnd.DragSourceMotionListener");
                DragSource dragSource = WindowDnDManager.getDefault().getWindowDragSource();
                Method method = dragSource.getClass().getMethod("addDragSourceMotionListener", clazz);
                Object object = Proxy.newProxyInstance(dragSource.getClass().getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

                    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                        WindowDnDManager.dragSourceMoved((DragSourceDragEvent)objectArray[0]);
                        return null;
                    }
                });
                method.invoke((Object)dragSource, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }
}

