/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.netbeans.core.windows.frames.CloseButtonTabbedPane;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.openide.awt.MouseUtils;
import org.openide.windows.TopComponent;

class TabHandlePopupListener
implements AWTEventListener {
    private static boolean installed = false;

    private TabHandlePopupListener() {
    }

    static synchronized void install() {
        if (installed) {
            return;
        }
        installed = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(new TabHandlePopupListener(), 16L);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() != 501 || !MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
            return;
        }
        Component component = (Component)mouseEvent.getSource();
        while (component != null && !(component instanceof CloseButtonTabbedPane)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        final JTabbedPane jTabbedPane = (JTabbedPane)component;
        while (component != null && !(component instanceof SplitContainerImpl) && !(component instanceof MultiTabbedContainerImpl)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        final DefaultContainerImpl defaultContainerImpl = (DefaultContainerImpl)component;
        final Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), jTabbedPane);
        final int n = JdkBug4620540Hack.findTabForCoordinate(jTabbedPane, point.x, point.y);
        if (n < 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent;
                if (n != jTabbedPane.getSelectedIndex()) {
                    topComponent = (TopComponent)jTabbedPane.getComponentAt(n);
                    defaultContainerImpl.setSelectedTopComponent(topComponent);
                    defaultContainerImpl.reactivateSelectedComponent();
                }
                if ((topComponent = (TopComponent)jTabbedPane.getSelectedComponent()) == null || !topComponent.equals(TopComponent.getRegistry().getActivated())) {
                    return;
                }
                defaultContainerImpl.showPopupMenu(DefaultContainerImpl.createPopupMenu(topComponent), point, jTabbedPane);
            }
        });
    }
}

