/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.InvalidDataException;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.ProducerCookie;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WorkspaceData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Workspace Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Workspace Properties 1.1//EN";
    private FileObject workspaceConfigFO;
    private InstanceCookieImpl instCookieImpl;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ProducerCookie;

    public WorkspaceData(FileObject fileObject, FileObject fileObject2, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.initCookies();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = WorkspaceData.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isDeleteAllowed() {
        try {
            return this.getWorkspaceImpl() != WindowManager.getDefault().getCurrentWorkspace();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void handleDelete() throws IOException {
        this.getWorkspaceImpl().remove();
        super.handleDelete();
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WorkspaceData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WorkspaceData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie, (CookieSet.Factory)this);
    }

    WorkspaceImpl getWorkspaceImpl() throws IOException {
        return this.instanceCookieImpl().obtainWorkspaceImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WorkspaceData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WorkspaceData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie) || clazz == (class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = WorkspaceData.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie)) {
            return this.instanceCookieImpl();
        }
        return null;
    }

    private synchronized InstanceCookieImpl instanceCookieImpl() {
        if (this.instCookieImpl != null) {
            return this.instCookieImpl;
        }
        this.instCookieImpl = new InstanceCookieImpl(this);
        return this.instCookieImpl;
    }

    FileObject getWorkspaceConfigFO() {
        if (this.workspaceConfigFO == null) {
            Iterator iterator = this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                this.workspaceConfigFO = ((MultiDataObject.Entry)iterator.next()).getFile();
            }
        }
        return this.workspaceConfigFO;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler
    implements FileSystem.AtomicAction {
        private WorkspaceData folder;
        private FileObject fo;
        private WorkspaceConfig workspaceConfig;
        private StringBuffer buffer;
        boolean hasMdiSdi = false;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;

        public PropertyHandler(WorkspaceData workspaceData) {
            this.folder = workspaceData;
            this.fo = workspaceData.getWorkspaceConfigFO();
        }

        public WorkspaceConfig readData() throws SAXException, IOException {
            this.hasMdiSdi = false;
            this.workspaceConfig = new WorkspaceConfig();
            this.workspaceConfig.invalid = true;
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
            }
            return this.workspaceConfig;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("name".equals(string3)) {
                this.handleName(attributes);
            } else if ("module".equals(string3)) {
                this.handleModule(attributes);
            } else if ("ui-type".equals(string3)) {
                this.handleUIType(attributes);
            } else if ("cascade".equals(string3)) {
                this.handleCascade(attributes);
            } else if ("active".equals(string3)) {
                this.handleActive(attributes);
            } else if ("mode".equals(string3)) {
                this.handleMode(attributes);
            } else if ("toolbar".equals(string3)) {
                this.handleToolbar(attributes);
            } else if ("description".equals(string3)) {
                this.handleDescription(attributes);
            } else if ("desktop".equals(string3)) {
                this.handleDesktop(attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            WindowManagerImpl windowManagerImpl;
            if ("ui-type".equals(string3) && this.workspaceConfig.uiType == (windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault()).uiModeManager().getUIMode()) {
                this.hasMdiSdi = true;
                this.workspaceConfig.invalid = false;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        private void handleName(Attributes attributes) {
            this.workspaceConfig.name = attributes.getValue("unique");
            this.workspaceConfig.displayName = attributes.getValue("display");
            this.workspaceConfig.fromBundle = "true".equals(attributes.getValue("from-bundle"));
            if (this.workspaceConfig.fromBundle) {
                this.workspaceConfig.nameBundle = attributes.getValue("bundle");
            }
        }

        private void handleDescription(Attributes attributes) {
            this.workspaceConfig.description = attributes.getValue("display");
            this.workspaceConfig.descriptionBundle = attributes.getValue("bundle");
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.workspaceConfig.moduleCodeNameBase = null;
            this.workspaceConfig.moduleCodeNameRelease = null;
            this.workspaceConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.workspaceConfig.moduleCodeNameBase = string.substring(0, n);
                    this.workspaceConfig.moduleCodeNameRelease = string.substring(n + 1);
                    PropertyHandler.checkReleaseCode(this.workspaceConfig);
                } else {
                    this.workspaceConfig.moduleCodeNameBase = string;
                }
                this.workspaceConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private static void checkReleaseCode(WorkspaceConfig workspaceConfig) {
            if ("null".equals(workspaceConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + workspaceConfig.moduleCodeNameBase + "! Repairing."));
                workspaceConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleUIType(Attributes attributes) {
            String string = attributes.getValue("type");
            if ("mdi".equals(string)) {
                this.workspaceConfig.clear();
                this.workspaceConfig.uiType = 2;
            } else if ("sdi".equals(string)) {
                this.workspaceConfig.clear();
                this.workspaceConfig.uiType = 1;
            } else {
                this.workspaceConfig.uiType = 0;
                this.workspaceConfig.invalid = false;
            }
        }

        private void handleCascade(Attributes attributes) {
            String string;
            if (this.hasMdiSdi) {
                return;
            }
            if (this.workspaceConfig.cascadeOrigin == null) {
                this.workspaceConfig.cascadeOrigin = new Point();
            }
            if (this.workspaceConfig.cascadeCurrent == null) {
                this.workspaceConfig.cascadeCurrent = new Point();
            }
            if (this.workspaceConfig.cascadeStep == null) {
                this.workspaceConfig.cascadeStep = new Dimension();
            }
            try {
                this.workspaceConfig.cascadeOrigin.x = Integer.parseInt(attributes.getValue("origin-x"));
                this.workspaceConfig.cascadeOrigin.y = Integer.parseInt(attributes.getValue("origin-y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.workspaceConfig.cascadeOrigin = null;
                string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WorkspaceCascadeOrigin"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
            try {
                this.workspaceConfig.cascadeStep.width = Integer.parseInt(attributes.getValue("step-x"));
                this.workspaceConfig.cascadeStep.height = Integer.parseInt(attributes.getValue("step-y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.workspaceConfig.cascadeStep = null;
                string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WorkspaceCascadeStep"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
            try {
                this.workspaceConfig.cascadeCount = Integer.parseInt(attributes.getValue("count"));
            }
            catch (NumberFormatException numberFormatException) {
                this.workspaceConfig.cascadeCount = 0;
                string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WorkspaceCascadeCount"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
            try {
                this.workspaceConfig.cascadeCurrent.x = Integer.parseInt(attributes.getValue("current-x"));
                this.workspaceConfig.cascadeCurrent.y = Integer.parseInt(attributes.getValue("current-y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.workspaceConfig.cascadeCurrent = null;
                string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = PropertyHandler.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WorkspaceCascadeCurrent"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
        }

        private void handleActive(Attributes attributes) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.activeModeName = attributes.getValue("mode");
        }

        private void handleMode(Attributes attributes) {
            if (this.hasMdiSdi) {
                return;
            }
            String string = attributes.getValue("z-order");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (this.workspaceConfig.zOrder == null) {
                this.workspaceConfig.zOrder = new ArrayList();
            } else {
                this.workspaceConfig.zOrder.clear();
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.workspaceConfig.zOrder.add(string2);
            }
        }

        private void handleToolbar(Attributes attributes) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.toolbarConfiguration = attributes.getValue("configuration");
        }

        private void handleDesktop(Attributes attributes) {
            if (this.hasMdiSdi) {
                return;
            }
            this.workspaceConfig.desktopMaximized = "true".equals(attributes.getValue("maximized"));
        }

        public void endDocument() throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void writeData() throws IOException {
            this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            }
        }

        private void fillBuffer() throws IOException {
            WorkspaceImpl workspaceImpl = this.folder.getWorkspaceImpl();
            this.buffer = new StringBuffer(800);
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            this.buffer.append("<workspace version=\"1.1\">\n");
            this.appendName(workspaceImpl);
            this.appendDescription(workspaceImpl);
            this.appendModule(workspaceImpl);
            this.buffer.append("    <ui-type type=\"any\">\n");
            this.appendCascade(workspaceImpl);
            this.appendActive(workspaceImpl);
            this.appendMode(workspaceImpl);
            this.appendToolbar(workspaceImpl);
            this.appendDesktop(workspaceImpl);
            this.buffer.append("    </ui-type>\n");
            this.buffer.append("</workspace>\n");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileLock fileLock;
            block3: {
                fileLock = this.fo.lock();
                OutputStreamWriter outputStreamWriter = null;
                try {
                    OutputStream outputStream = this.fo.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(this.buffer.toString());
                    Object var5_4 = null;
                    this.buffer = null;
                    if (outputStreamWriter == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.buffer = null;
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    fileLock.releaseLock();
                    throw throwable;
                }
                outputStreamWriter.close();
            }
            fileLock.releaseLock();
        }

        private void appendName(WorkspaceImpl workspaceImpl) throws CharConversionException {
            this.buffer.append("    <name");
            this.buffer.append(" unique=\"");
            this.buffer.append(XMLUtil.toAttributeValue((String)workspaceImpl.getName()));
            this.buffer.append("\" display=\"");
            this.buffer.append(XMLUtil.toAttributeValue((String)workspaceImpl.getDisplayNameXML()));
            this.buffer.append("\" from-bundle=\"");
            if (workspaceImpl.isNameFromBundle()) {
                this.buffer.append("true");
                this.buffer.append("\" bundle=\"");
                this.buffer.append(workspaceImpl.getNameBundle());
            } else {
                this.buffer.append("false");
            }
            this.buffer.append("\" />\n");
        }

        private void appendDescription(WorkspaceImpl workspaceImpl) throws CharConversionException {
            if (workspaceImpl.getDescriptionXML() == null) {
                return;
            }
            this.buffer.append("    <description display=\"");
            this.buffer.append(XMLUtil.toAttributeValue((String)workspaceImpl.getDescriptionXML()));
            this.buffer.append("\" bundle=\"");
            this.buffer.append(workspaceImpl.getDescriptionBundle());
            this.buffer.append("\" />\n");
        }

        private void appendModule(WorkspaceImpl workspaceImpl) {
            if (this.workspaceConfig == null) {
                return;
            }
            if (this.workspaceConfig.moduleCodeNameBase != null) {
                this.buffer.append("    <module");
                this.buffer.append(" name=\"");
                this.buffer.append(this.workspaceConfig.moduleCodeNameBase);
                if (this.workspaceConfig.moduleCodeNameRelease != null) {
                    this.buffer.append("/" + this.workspaceConfig.moduleCodeNameRelease);
                }
                if (this.workspaceConfig.moduleSpecificationVersion != null) {
                    this.buffer.append("\" spec=\"");
                    this.buffer.append(this.workspaceConfig.moduleSpecificationVersion);
                }
                this.buffer.append("\" />\n");
            }
        }

        private void appendCascade(WorkspaceImpl workspaceImpl) {
            this.buffer.append("        <cascade");
            Point point = workspaceImpl.getCascadingOrigin();
            this.buffer.append(" origin-x=\"");
            this.buffer.append(point.x);
            this.buffer.append("\" origin-y=\"");
            this.buffer.append(point.y);
            Dimension dimension = workspaceImpl.getCascadeStep();
            this.buffer.append("\" step-x=\"");
            this.buffer.append(dimension.width);
            this.buffer.append("\" step-y=\"");
            this.buffer.append(dimension.height);
            this.buffer.append("\" count=\"");
            this.buffer.append(workspaceImpl.getCascadeStepsCount());
            Point point2 = workspaceImpl.getCascadePoint();
            this.buffer.append("\" current-x=\"");
            this.buffer.append(point2.x);
            this.buffer.append("\" current-y=\"");
            this.buffer.append(point2.y);
            this.buffer.append("\" />\n");
        }

        private void appendActive(WorkspaceImpl workspaceImpl) throws CharConversionException {
            this.buffer.append("        <active");
            this.buffer.append(" mode=\"");
            Mode mode = workspaceImpl.getActiveMode();
            if (mode != null) {
                this.buffer.append(XMLUtil.toAttributeValue((String)mode.getName()));
            }
            this.buffer.append("\" />\n");
        }

        private void appendMode(WorkspaceImpl workspaceImpl) throws CharConversionException {
            this.buffer.append("        <mode");
            this.buffer.append(" z-order=\"");
            List list = workspaceImpl.getLoadedModeArray();
            int n = 0;
            while (n < list.size()) {
                if (n > 0) {
                    this.buffer.append(",");
                }
                Mode mode = (Mode)list.get(n);
                this.buffer.append(XMLUtil.toAttributeValue((String)mode.getName()));
                ++n;
            }
            this.buffer.append("\" />\n");
        }

        private void appendToolbar(WorkspaceImpl workspaceImpl) throws CharConversionException {
            this.buffer.append("        <toolbar");
            this.buffer.append(" configuration=\"");
            if (workspaceImpl.getToolbarConfigName() != null) {
                this.buffer.append(XMLUtil.toAttributeValue((String)workspaceImpl.getToolbarConfigName()));
            }
            this.buffer.append("\" />\n");
        }

        private void appendDesktop(WorkspaceImpl workspaceImpl) {
            if (!WindowUtils.isMdi()) {
                return;
            }
            this.buffer.append("        <desktop");
            this.buffer.append(" maximized=\"");
            this.buffer.append(workspaceImpl.desktopPane().isMaxMode() ? "true" : "false");
            this.buffer.append("\" />\n");
        }

        private XMLReader getXMLParser() throws SAXException {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            return xMLReader;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (WorkspaceData.INSTANCE_DTD_ID_1_0.equals(string) || WorkspaceData.INSTANCE_DTD_ID_1_1.equals(string)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return new InputSource(byteArrayInputStream);
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static final class InstanceCookieImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    ProducerCookie,
    PropertyChangeListener {
        InstanceCookie[] childrenCookies;
        WorkspaceImpl workspaceImpl;
        PropertyHandler propertyHandler;
        WorkspaceConfig wc;
        private boolean modesUpdated;
        private int loadedSections;
        private int currLoadedSections;
        private PropertyChangeListener weakPropertyChangeL;
        private IOException ioException;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$openide$windows$Mode;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public InstanceCookieImpl(DataFolder dataFolder) {
            super(dataFolder, FileUtil.findBrother((FileObject)dataFolder.getPrimaryFile(), (String)"wswksp"), class$org$openide$windows$Mode == null ? (class$org$openide$windows$Mode = InstanceCookieImpl.class$("org.openide.windows.Mode")) : class$org$openide$windows$Mode);
        }

        protected void clean() {
            this.childrenCookies = null;
            if (this.workspaceImpl != null) {
                this.workspaceImpl.removeModes();
                this.workspaceImpl.attachUpdater(null);
                this.workspaceImpl = null;
            }
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            if (!(this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((WorkspaceData)this.folder).getWorkspaceConfigFO().isValid())) {
                throw new FileNotFoundException();
            }
            WorkspaceImpl workspaceImpl = this.obtainWorkspaceImpl();
            if (this.childrenCookies == null) {
                workspaceImpl.attachUpdater(this);
            }
            InstanceCookie[] instanceCookieArray2 = this.childrenCookies;
            this.childrenCookies = instanceCookieArray;
            this.updateAll(instanceCookieArray2, instanceCookieArray);
            return workspaceImpl;
        }

        private void deleteFiles(boolean bl) {
            WindowUtils.deleteOneFO(((WorkspaceData)this.folder).getWorkspaceConfigFO());
            if (bl) {
                WindowUtils.deleteOneFO(this.folder.getPrimaryFile());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.deleteFiles(false);
                }
            }
        }

        private void updateAll(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException, ClassNotFoundException {
            if ((this.loadedSections & 1) != 0 || (this.loadedSections & 2) != 0) {
                this.readProperties();
                if (this.wc.moduleCodeNameBase != null) {
                    ModuleInfo moduleInfo = WindowUtils.findModule(this.wc.moduleCodeNameBase, this.wc.moduleCodeNameRelease, this.wc.moduleSpecificationVersion);
                    if (moduleInfo != null && moduleInfo.isEnabled()) {
                        if (this.weakPropertyChangeL == null) {
                            this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)moduleInfo);
                            moduleInfo.addPropertyChangeListener(this.weakPropertyChangeL);
                        }
                    } else {
                        this.deleteFiles(false);
                        return;
                    }
                }
                this.setProperties();
            }
            if ((this.loadedSections & 1) != 0) {
                // empty if block
            }
            if ((this.loadedSections & 2) != 0) {
                this.updateModes(instanceCookieArray, instanceCookieArray2);
            }
        }

        protected void updateProperties() throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private boolean readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WorkspaceData)this.folder);
            }
            this.wc = null;
            try {
                this.wc = this.propertyHandler.readData();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = InstanceCookieImpl.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WorkspaceParse"), this.folder.getName());
                IOException iOException = new IOException(string);
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
            return true;
        }

        protected void setProperties() throws IOException {
            if (this.wc.invalid) {
                return;
            }
            this.workspaceImpl.setNameFromBundleXML(this.wc.fromBundle);
            this.workspaceImpl.setNameBundle(this.wc.nameBundle);
            this.workspaceImpl.setDisplayNameXML(this.wc.displayName);
            this.workspaceImpl.setDescriptionBundle(this.wc.descriptionBundle);
            this.workspaceImpl.setDescriptionXML(this.wc.description);
            this.workspaceImpl.setCascadingOrigin(this.wc.cascadeOrigin);
            this.workspaceImpl.setCascadeStep(this.wc.cascadeStep);
            this.workspaceImpl.setCascadeStepsCount(this.wc.cascadeCount);
            this.workspaceImpl.setToolbarConfigName(this.wc.toolbarConfiguration);
            this.workspaceImpl.setWasMaxMode(this.wc.desktopMaximized);
        }

        private void updateModes(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException, ClassNotFoundException {
            if (instanceCookieArray2 == null) {
                System.err.println("COOKIES == null");
                Thread.dumpStack();
                return;
            }
            ModeImpl[] modeImplArray = instanceCookieArray == null || instanceCookieArray.length == 0 ? this.createModes(instanceCookieArray2) : this.removeAddModes(instanceCookieArray, instanceCookieArray2);
            ModeImpl modeImpl = null;
            int n = modeImplArray.length - 1;
            while (n >= 0) {
                if (modeImplArray[n] != null) {
                    if (modeImplArray[n].getName() == null) {
                        System.err.println("NAME IS NULL: " + modeImplArray[n]);
                    }
                    if (this.wc == null) {
                        System.err.println("WC is NULL");
                    }
                    if (modeImplArray[n].getName().equals(this.wc.activeModeName)) {
                        modeImpl = modeImplArray[n];
                    }
                }
                --n;
            }
            this.workspaceImpl.setActiveMode(modeImpl);
            this.childrenCookies = instanceCookieArray2;
        }

        private ModeImpl[] removeAddModes(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException, ClassNotFoundException {
            Object object;
            WorkspaceImpl workspaceImpl = this.obtainWorkspaceImpl();
            HashSet<InstanceCookie> hashSet = new HashSet<InstanceCookie>(Arrays.asList(instanceCookieArray2));
            int n = 0;
            while (n < instanceCookieArray.length) {
                if (!hashSet.contains(instanceCookieArray[n])) {
                    object = null;
                    try {
                        object = (ModeImpl)instanceCookieArray[n].instanceCreate();
                    }
                    catch (InvalidDataException invalidDataException) {
                        Object object2 = invalidDataException.getData();
                        if (object2 != null && object2 instanceof String) {
                            String string = (String)object2;
                            object = (ModeImpl)workspaceImpl.findLoadedMode(string);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    if (object != null) {
                        object.close();
                        workspaceImpl.removeMode((Mode)object);
                    }
                }
                ++n;
            }
            object = new ModeImpl[instanceCookieArray2.length];
            int n2 = 0;
            while (n2 < instanceCookieArray2.length) {
                object[n2] = (ModeImpl)instanceCookieArray2[n2].instanceCreate();
                ++n2;
            }
            return object;
        }

        private ModeImpl[] createModes(InstanceCookie[] instanceCookieArray) throws IOException {
            ModeImpl[] modeImplArray = new ModeImpl[instanceCookieArray.length];
            int n = 0;
            while (n < instanceCookieArray.length) {
                try {
                    modeImplArray[n] = (ModeImpl)instanceCookieArray[n].instanceCreate();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                ++n;
            }
            return modeImplArray;
        }

        private List orderModes(List list, List list2) throws IOException {
            Object object;
            ModeData[] modeDataArray = new ModeData[list2.size()];
            Iterator iterator = list.iterator();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (iterator.hasNext()) {
                object = (ModeData)((Object)iterator.next());
                ModeImpl modeImpl = object.getModeImpl();
                int n = list2.indexOf(modeImpl.getConstraints());
                if (-1 != n) {
                    modeDataArray[n] = object;
                    continue;
                }
                linkedList.add(object);
            }
            object = new LinkedList<ModeData>(Arrays.asList(modeDataArray));
            ((LinkedList)object).addAll(linkedList);
            return object;
        }

        private WorkspaceImpl obtainWorkspaceImpl() throws IOException {
            if (this.workspaceImpl == null) {
                FileObject fileObject = this.folder.getPrimaryFile();
                String string = WindowUtils.unescape(fileObject.getName());
                WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
                this.workspaceImpl = (WorkspaceImpl)windowManagerImpl.findLoadedWorkspace(string);
                if (this.workspaceImpl == null) {
                    this.workspaceImpl = new WorkspaceImpl(string, null);
                }
            }
            return this.workspaceImpl;
        }

        public void save() throws IOException {
            Object object;
            Object object2;
            String string;
            DataObject dataObject;
            FileObject fileObject;
            Object object3;
            if (this.wc != null && this.wc.invalid) {
                return;
            }
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WorkspaceData)this.folder);
            }
            this.propertyHandler.writeData();
            WorkspaceImpl workspaceImpl = this.obtainWorkspaceImpl();
            List list = workspaceImpl.getLoadedModeArray();
            FileObject fileObject2 = this.folder.getPrimaryFile();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
            int n = 0;
            while (n < list.size()) {
                object3 = WindowUtils.escape(((Mode)list.get(n)).getName());
                fileObject2.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, fileObject2, (String)object3){
                    private final /* synthetic */ FileObject val$wFo;
                    private final /* synthetic */ String val$modeName;
                    private final /* synthetic */ InstanceCookieImpl this$0;
                    {
                        this.this$0 = instanceCookieImpl;
                        this.val$wFo = fileObject;
                        this.val$modeName = string;
                    }

                    public void run() throws IOException {
                        FileObject fileObject = this.val$wFo.getFileObject(this.val$modeName, "wsmode");
                        if (fileObject == null) {
                            fileObject = this.val$wFo.createData(this.val$modeName, "wsmode");
                        }
                        if ((fileObject = this.val$wFo.getFileObject(this.val$modeName)) == null) {
                            this.val$wFo.createFolder(this.val$modeName);
                        }
                    }
                });
                fileObject = fileObject2.getFileObject((String)object3);
                dataObject = DataObject.find((FileObject)fileObject);
                string = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (string != null) {
                    string.save();
                } else {
                    System.out.println("No save cookie for data obj " + dataObject);
                    Thread.dumpStack();
                }
                arrayList.add(dataObject);
                ++n;
            }
            object3 = workspaceImpl.getRemovedModeIds();
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    string = (String)object2.next();
                    fileObject = fileObject2.getFileObject(string);
                    if (fileObject != null) {
                        dataObject = DataObject.find((FileObject)fileObject);
                        ((AbstractCollection)arrayList).remove(dataObject);
                    }
                    if ((fileObject = fileObject2.getFileObject(string, "wsmode")) == null) continue;
                    FileLock fileLock = fileObject.lock();
                    fileObject.delete(fileLock);
                    fileLock.releaseLock();
                }
                workspaceImpl.clearRemovedModeIds();
            }
            object2 = this.obtainWorkspaceImpl();
            ArrayList arrayList2 = new ArrayList();
            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(this, arrayList2, arrayList){
                private final /* synthetic */ List val$dSides;
                private final /* synthetic */ ArrayList val$arrModes;
                private final /* synthetic */ InstanceCookieImpl this$0;
                {
                    this.this$0 = instanceCookieImpl;
                    this.val$dSides = list;
                    this.val$arrModes = arrayList;
                }

                public void run() {
                    try {
                        if (!this.val$dSides.isEmpty()) {
                            List list = InstanceCookieImpl.access$100(this.this$0, this.val$arrModes, this.val$dSides);
                            this.this$0.folder.setOrder(list.toArray(new DataObject[list.size()]));
                        }
                        this.this$0.childrenCookies = this.this$0.createCookies();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.this$0.childrenCookies = null;
                        FoldingIOException foldingIOException = new FoldingIOException((Throwable)classNotFoundException);
                        ErrorManager.getDefault().annotate((Throwable)classNotFoundException, (Throwable)foldingIOException);
                        InstanceCookieImpl.access$202(this.this$0, (IOException)foldingIOException);
                    }
                    catch (IOException iOException) {
                        InstanceCookieImpl.access$202(this.this$0, iOException);
                    }
                }
            });
            if (SwingUtilities.isEventDispatchThread()) {
                object = ((WorkspaceImpl)object2).getDominanceList();
                if (object != null) {
                    arrayList2.addAll(object);
                }
                task.run();
            } else {
                SwingUtilities.invokeLater(new Runnable(this, (WorkspaceImpl)object2, arrayList2, task){
                    private final /* synthetic */ WorkspaceImpl val$wsImpl;
                    private final /* synthetic */ List val$dSides;
                    private final /* synthetic */ RequestProcessor.Task val$rpTask;
                    private final /* synthetic */ InstanceCookieImpl this$0;
                    {
                        this.this$0 = instanceCookieImpl;
                        this.val$wsImpl = workspaceImpl;
                        this.val$dSides = list;
                        this.val$rpTask = task;
                    }

                    public void run() {
                        List list = this.val$wsImpl.getDominanceList();
                        if (list != null) {
                            this.val$dSides.addAll(list);
                        }
                        this.val$rpTask.schedule(0);
                    }
                });
                task.waitFinished();
            }
            if (this.ioException != null) {
                object = this.ioException;
                this.ioException = null;
                throw object;
            }
        }

        public int getLoadedSections() {
            return this.currLoadedSections;
        }

        public int disposeDataSection(int n) throws IOException {
            this.loadedSections &= ~n;
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int n) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (n == (this.loadedSections & n)) {
                    int n2 = this.loadedSections;
                    return n2;
                }
                this.loadedSections |= n;
                try {
                    try {
                        this.updateAll(null, this.childrenCookies);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FoldingIOException foldingIOException = new FoldingIOException((Throwable)classNotFoundException);
                        ErrorManager.getDefault().annotate((Throwable)foldingIOException, (Throwable)classNotFoundException);
                        throw foldingIOException;
                    }
                    Object var6_5 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
            }
            return this.loadedSections;
        }

        public Object getProduct() throws IOException {
            return this.obtainWorkspaceImpl();
        }

        public void resetComponents() {
        }

        public void destroy() throws IOException {
            this.deleteFiles(true);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ List access$100(InstanceCookieImpl instanceCookieImpl, List list, List list2) throws IOException {
            return instanceCookieImpl.orderModes(list, list2);
        }

        static /* synthetic */ IOException access$202(InstanceCookieImpl instanceCookieImpl, IOException iOException) {
            instanceCookieImpl.ioException = iOException;
            return instanceCookieImpl.ioException;
        }
    }

    private static final class WorkspaceConfig {
        public boolean fromBundle;
        public String name;
        public String displayName;
        public String nameBundle;
        public String description;
        public String descriptionBundle;
        public String moduleCodeNameBase;
        public String moduleCodeNameRelease;
        public String moduleSpecificationVersion;
        public int uiType;
        public String activeModeName;
        public String toolbarConfiguration;
        public Point cascadeOrigin;
        public Point cascadeCurrent;
        public Dimension cascadeStep;
        public int cascadeCount;
        public ArrayList zOrder;
        public boolean invalid;
        public boolean desktopMaximized;

        private WorkspaceConfig() {
        }

        public void clear() {
            this.activeModeName = null;
            this.toolbarConfiguration = null;
            this.cascadeOrigin = null;
            this.cascadeCurrent = null;
            this.cascadeStep = null;
            this.cascadeCount = 0;
            this.zOrder = null;
        }
    }
}

