/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.core.actions.DisplayToolbarsAction;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.toolbars.ToolbarDnDListener;
import org.netbeans.core.windows.toolbars.ToolbarLayout;
import org.netbeans.core.windows.toolbars.ToolbarPanel;
import org.netbeans.core.windows.toolbars.ToolbarRow;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class ToolbarConfiguration
implements ToolbarPool.Configuration,
PropertyChangeListener {
    protected static final String TOOLBAR_DTD_WEB = "http://www.netbeans.org/dtds/toolbar.dtd";
    protected static final String TOOLBAR_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD toolbar//EN";
    protected static final Class TOOLBAR_PROCESSOR_CLASS = class$org$netbeans$core$windows$toolbars$ToolbarProcessor == null ? (class$org$netbeans$core$windows$toolbars$ToolbarProcessor = ToolbarConfiguration.class$("org.netbeans.core.windows.toolbars.ToolbarProcessor")) : class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    protected static final String TOOLBAR_ICON_BASE = "/org/netbeans/core/windows/toolbars/xmlToolbars";
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.core.windows.toolbars");
    private volatile long lastReload;
    protected static final String EXT_XML = "xml";
    protected static final String TAG_CONFIG = "Configuration";
    protected static final String TAG_ROW = "Row";
    protected static final String TAG_TOOLBAR = "Toolbar";
    protected static final String ATT_TOOLBAR_NAME = "name";
    protected static final String ATT_TOOLBAR_POSITION = "position";
    protected static final String ATT_TOOLBAR_VISIBLE = "visible";
    private static ToolbarPanel toolbarPanel;
    private static WeakHashMap confs2Names;
    private ToolbarLayout toolbarLayout;
    private ToolbarDnDListener toolbarListener;
    private static XMLDataObject.Info xmlinfo;
    private WeakHashMap allToolbars;
    private Vector toolbarRows;
    private HashMap invisibleToolbars;
    private WeakHashMap waitingToolbars;
    private String configName;
    private String configDisplayName;
    private int prefWidth;
    PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarConfiguration;
    static /* synthetic */ Class class$org$netbeans$core$actions$DisplayToolbarsAction;

    public ToolbarConfiguration(String string, String string2) {
        this.configName = string;
        this.configDisplayName = string2;
        this.initInstance();
        confs2Names.put(this, string);
    }

    public ToolbarConfiguration(XMLDataObject xMLDataObject) throws IOException {
        this(xMLDataObject.getNodeDelegate().getName(), xMLDataObject.getNodeDelegate().getDisplayName());
        this.readConfig(xMLDataObject);
    }

    private void readConfig(XMLDataObject xMLDataObject) throws IOException {
        Parser parser = XMLDataObject.createParser();
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        HandlerBase handlerBase = new HandlerBase(){
            private ToolbarRow currentRow = null;

            public void startElement(String string, AttributeList attributeList) throws SAXException {
                if (ToolbarConfiguration.TAG_ROW.equals(string)) {
                    this.currentRow = new ToolbarRow(ToolbarConfiguration.this);
                    ToolbarConfiguration.this.addRow(this.currentRow);
                } else if (this.currentRow != null && ToolbarConfiguration.TAG_TOOLBAR.equals(string)) {
                    String string2;
                    String string3 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_NAME);
                    if (string3 == null || string3.equals("")) {
                        return;
                    }
                    String string4 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_POSITION);
                    Integer n = null;
                    if (string4 != null) {
                        n = new Integer(string4);
                    }
                    Boolean bl = (string2 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_VISIBLE)) != null ? new Boolean(string2) : Boolean.TRUE;
                    ToolbarConfiguration.this.addToolbar(this.currentRow, ToolbarConfiguration.this.checkToolbarConstraints(string3, n, bl));
                }
            }

            public void endElement(String string) throws SAXException {
                if (ToolbarConfiguration.TAG_ROW.equals(string)) {
                    this.currentRow = null;
                }
            }
        };
        parser.setDocumentHandler(handlerBase);
        try {
            parser.parse(new InputSource(xMLDataObject.getPrimaryFile().getInputStream()));
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
        this.checkToolbarRows();
    }

    private void initInstance() {
        this.allToolbars = new WeakHashMap();
        this.waitingToolbars = new WeakHashMap();
        this.toolbarRows = new Vector();
        this.invisibleToolbars = new HashMap();
        this.toolbarListener = new ToolbarDnDListener(this);
    }

    static final String getBundleString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$windows$toolbars$ToolbarConfiguration == null ? (class$org$netbeans$core$windows$toolbars$ToolbarConfiguration = ToolbarConfiguration.class$("org.netbeans.core.windows.toolbars.ToolbarConfiguration")) : class$org$netbeans$core$windows$toolbars$ToolbarConfiguration)).getString(string);
    }

    public static final ToolbarConfiguration findConfiguration(String string) {
        Map.Entry entry = null;
        Iterator iterator = confs2Names.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!string.equals((String)entry.getValue())) continue;
            return (ToolbarConfiguration)entry.getKey();
        }
        return null;
    }

    void addToolbar(ToolbarRow toolbarRow, ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        if (toolbarConstraints.isVisible()) {
            toolbarRow.addToolbar(toolbarConstraints);
        } else {
            int n = toolbarRow == null ? this.toolbarRows.size() : this.toolbarRows.indexOf(toolbarRow);
            this.invisibleToolbars.put(toolbarConstraints, new Integer(n));
        }
        this.allToolbars.put(toolbarConstraints.getName(), toolbarConstraints);
    }

    ToolbarConstraints removeToolbar(String string) {
        ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.allToolbars.remove(string);
        if (toolbarConstraints.destroy()) {
            this.checkToolbarRows();
        }
        return toolbarConstraints;
    }

    void addRow(ToolbarRow toolbarRow) {
        this.addRow(toolbarRow, this.toolbarRows.size());
    }

    void addRow(ToolbarRow toolbarRow, int n) {
        ToolbarRow toolbarRow2 = null;
        ToolbarRow toolbarRow3 = null;
        try {
            toolbarRow2 = (ToolbarRow)this.toolbarRows.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            toolbarRow3 = (ToolbarRow)this.toolbarRows.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (toolbarRow2 != null) {
            toolbarRow2.setNextRow(toolbarRow);
        }
        toolbarRow.setPrevRow(toolbarRow2);
        toolbarRow.setNextRow(toolbarRow3);
        if (toolbarRow3 != null) {
            toolbarRow3.setPrevRow(toolbarRow);
        }
        this.toolbarRows.insertElementAt(toolbarRow, n);
        this.updateBounds(toolbarRow);
    }

    void removeRow(ToolbarRow toolbarRow) {
        ToolbarRow toolbarRow2 = toolbarRow.getPrevRow();
        ToolbarRow toolbarRow3 = toolbarRow.getNextRow();
        if (toolbarRow2 != null) {
            toolbarRow2.setNextRow(toolbarRow3);
        }
        if (toolbarRow3 != null) {
            toolbarRow3.setPrevRow(toolbarRow2);
        }
        this.toolbarRows.removeElement(toolbarRow);
        this.updateBounds(toolbarRow3);
        this.revalidateWindow();
    }

    void updateBounds(ToolbarRow toolbarRow) {
        while (toolbarRow != null) {
            toolbarRow.updateBounds();
            toolbarRow = toolbarRow.getNextRow();
        }
    }

    private static final ToolbarPool toolbarPool() {
        return ToolbarPool.getDefault();
    }

    void revalidateWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolbarConfiguration.this.doRevalidateWindow();
            }
        });
    }

    private void doRevalidateWindow() {
        ToolbarConfiguration.toolbarPanel().revalidate();
        Window window = SwingUtilities.windowForComponent((Component)ToolbarConfiguration.toolbarPool());
        if (window != null) {
            window.validate();
        }
    }

    int rowIndex(ToolbarRow toolbarRow) {
        return this.toolbarRows.indexOf(toolbarRow);
    }

    void updatePrefWidth() {
        Iterator iterator = ((AbstractList)this.toolbarRows).iterator();
        this.prefWidth = 0;
        while (iterator.hasNext()) {
            this.prefWidth = Math.max(this.prefWidth, ((ToolbarRow)iterator.next()).getPrefWidth());
        }
    }

    int getPrefWidth() {
        return this.prefWidth;
    }

    int getPrefHeight() {
        if (this.getRowCount() == 0) {
            return 8;
        }
        ToolbarRow toolbarRow = (ToolbarRow)this.toolbarRows.lastElement();
        return this.getRowVertLocation(toolbarRow) + toolbarRow.getPreferredHeight();
    }

    void checkToolbarRows() {
        Object[] objectArray = this.toolbarRows.toArray();
        int n = objectArray.length - 1;
        while (n >= 0) {
            ToolbarRow toolbarRow = (ToolbarRow)objectArray[n];
            if (toolbarRow.isEmpty()) {
                this.removeRow(toolbarRow);
            }
            --n;
        }
    }

    int getRowCount() {
        return this.toolbarRows.size();
    }

    ToolbarConstraints getToolbarConstraints(String string) {
        return (ToolbarConstraints)this.allToolbars.get(string);
    }

    ToolbarConstraints checkToolbarConstraints(String string, Integer n, Boolean bl) {
        ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.allToolbars.get(string);
        if (toolbarConstraints == null) {
            toolbarConstraints = new ToolbarConstraints(this, string, n, bl);
        } else {
            toolbarConstraints.checkNextPosition(n, bl);
        }
        return toolbarConstraints;
    }

    boolean checkConfigurationOver() {
        String string;
        boolean bl = false;
        Object[] objectArray = ((AbstractMap)this.waitingToolbars).keySet().toArray();
        Object[] objectArray2 = ((AbstractMap)this.allToolbars).keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = (String)objectArray[n];
            if (ToolbarConfiguration.toolbarPool().findToolbar(string) != null) {
                ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.waitingToolbars.remove(string);
                this.allToolbars.put(string, toolbarConstraints);
                this.addInvisible(toolbarConstraints);
                bl = true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            string = (String)objectArray2[n2];
            if (ToolbarConfiguration.toolbarPool().findToolbar(string) == null) {
                ToolbarConstraints toolbarConstraints = this.removeToolbar(string);
                this.waitingToolbars.put(string, toolbarConstraints);
                this.invisibleToolbars.put(toolbarConstraints, new Integer(toolbarConstraints.rowIndex()));
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    void removeVisible(ToolbarConstraints toolbarConstraints) {
        this.invisibleToolbars.put(toolbarConstraints, new Integer(toolbarConstraints.rowIndex()));
        if (toolbarConstraints.destroy()) {
            this.checkToolbarRows();
        }
        toolbarConstraints.setVisible(false);
    }

    void addInvisible(ToolbarConstraints toolbarConstraints) {
        int n = this.toolbarRows.size();
        int n2 = (Integer)this.invisibleToolbars.remove(toolbarConstraints);
        toolbarConstraints.setVisible(true);
        int n3 = n2;
        while (n3 < n2 + toolbarConstraints.getRowCount()) {
            this.getRow(n3).addToolbar(toolbarConstraints, toolbarConstraints.getPosition());
            ++n3;
        }
        if (n != this.toolbarRows.size()) {
            this.revalidateWindow();
        }
    }

    ToolbarRow getRow(int n) {
        ToolbarRow toolbarRow;
        int n2 = this.toolbarRows.size();
        if (n < 0) {
            toolbarRow = new ToolbarRow(this);
            this.addRow(toolbarRow, 0);
        } else if (n >= n2) {
            toolbarRow = new ToolbarRow(this);
            this.addRow(toolbarRow);
        } else {
            toolbarRow = (ToolbarRow)this.toolbarRows.elementAt(n);
        }
        return toolbarRow;
    }

    ToolbarRow createLastRow() {
        return this.getRow(this.toolbarRows.size());
    }

    void reactivatePanel(boolean bl, boolean bl2) {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] toolbarArray = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow toolbarRow = null;
        boolean bl3 = false;
        int n = 0;
        while (n < toolbarArray.length) {
            Toolbar toolbar = toolbarArray[n];
            String string = toolbar.getName();
            ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.allToolbars.get(string);
            if (toolbarConstraints == null) {
                if (toolbarRow == null) {
                    toolbarRow = this.createLastRow();
                }
                toolbarConstraints = new ToolbarConstraints(this, string, null, Boolean.TRUE);
                this.addToolbar(toolbarRow, toolbarConstraints);
                bl3 = true;
            }
            ToolbarConfiguration.toolbarPanel().add((Component)toolbar, toolbarConstraints);
            ++n;
        }
        this.revalidateWindow();
        if (!bl2 || bl || bl3) {
            // empty if block
        }
    }

    boolean isImportantActivateComponent() {
        Toolbar[] toolbarArray;
        Object[] objectArray = ((AbstractMap)this.allToolbars).keySet().toArray();
        if (objectArray.length != (toolbarArray = ToolbarConfiguration.toolbarPool().getToolbars()).length) {
            return true;
        }
        return !this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration());
    }

    void reflectChanges() {
        try {
            this.writeDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Component activate() {
        return this.activate(this.isImportantActivateComponent(), true);
    }

    private Component activate(boolean bl, boolean bl2) {
        ToolbarConfiguration.toolbarPool().setToolbarsListener((Toolbar.DnDListener)this.toolbarListener);
        boolean bl3 = this.checkConfigurationOver();
        if (bl || bl3) {
            if (this.toolbarLayout == null) {
                this.toolbarLayout = new ToolbarLayout(this);
            }
            ToolbarConfiguration.toolbarPanel().setLayout(this.toolbarLayout);
            this.reactivatePanel(bl3, bl2);
        }
        return ToolbarConfiguration.toolbarPanel();
    }

    public String getName() {
        return this.configName;
    }

    public String getDisplayName() {
        return this.configDisplayName;
    }

    public JPopupMenu getContextMenu() {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        Object object3;
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        Iterator<Object> iterator = Arrays.asList(ToolbarPool.getDefault().getToolbars()).iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = (ToolbarConstraints)this.allToolbars.get(((Component)object3).getName());
            object = new JCheckBoxMenuItem(object3.getDisplayName(), ((ToolbarConstraints)object2).isVisible());
            ((AbstractButton)object).addActionListener(new ActionListener((Toolbar)object3, (ToolbarConstraints)object2){
                private final /* synthetic */ Toolbar val$tb;
                private final /* synthetic */ ToolbarConstraints val$tc;
                {
                    this.val$tb = toolbar;
                    this.val$tc = toolbarConstraints;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolbarConfiguration.this.setToolbarVisible(this.val$tb, !this.val$tc.isVisible());
                }
            });
            jPopupMenuPlus.add((JMenuItem)object);
        }
        jPopupMenuPlus.add(new JPopupMenu.Separator());
        iterator = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
        object3 = new ButtonGroup();
        object2 = ToolbarPool.getDefault().getConfiguration();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            jMenuItem = new JRadioButtonMenuItem(ToolbarConfiguration.findConfiguration((String)object).getDisplayName(), ((String)object).compareTo((String)object2) == 0);
            jMenuItem.addActionListener(new ActionListener((String)object){
                private final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WorkspaceImpl workspaceImpl = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
                    workspaceImpl.setToolbarConfigName(this.val$name);
                }
            });
            ((ButtonGroup)object3).add(jMenuItem);
            jPopupMenuPlus.add(jMenuItem);
        }
        jPopupMenuPlus.add(new JPopupMenu.Separator());
        object = new JMenuItem(((DisplayToolbarsAction)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$DisplayToolbarsAction == null ? (class$org$netbeans$core$actions$DisplayToolbarsAction = ToolbarConfiguration.class$("org.netbeans.core.actions.DisplayToolbarsAction")) : class$org$netbeans$core$actions$DisplayToolbarsAction), (boolean)true)).getName());
        ((AbstractButton)object).addActionListener(new ActionListener(){
            static /* synthetic */ Class class$org$netbeans$core$actions$DisplayToolbarsAction;

            public void actionPerformed(ActionEvent actionEvent) {
                ((DisplayToolbarsAction)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$DisplayToolbarsAction == null ? (class$org$netbeans$core$actions$DisplayToolbarsAction = 6.class$("org.netbeans.core.actions.DisplayToolbarsAction")) : class$org$netbeans$core$actions$DisplayToolbarsAction), (boolean)true)).performAction();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        jPopupMenuPlus.add((JMenuItem)object);
        jMenuItem = new JMenuItem(ToolbarConfiguration.getBundleString("PROP_saveAs"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ToolbarConfiguration.getBundleString("PROP_saveLabel"), ToolbarConfiguration.getBundleString("PROP_saveDialog"));
                inputLine.setInputText(ToolbarConfiguration.getBundleString("PROP_saveName"));
                Object object = TopManager.getDefault().notify((NotifyDescriptor)inputLine);
                if (object == NotifyDescriptor.OK_OPTION && (string = inputLine.getInputText()).length() != 0) {
                    try {
                        String string2 = inputLine.getInputText();
                        if (ToolbarConfiguration.this.tryWriteDocument(string2)) {
                            WorkspaceImpl workspaceImpl = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
                            workspaceImpl.setToolbarConfigName(string2);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        });
        jPopupMenuPlus.add(jMenuItem);
        return jPopupMenuPlus;
    }

    public void setToolbarVisible(Toolbar toolbar, boolean bl) {
        ToolbarConstraints toolbarConstraints = this.getToolbarConstraints(toolbar.getName());
        if (bl) {
            this.addInvisible(toolbarConstraints);
        } else {
            this.removeVisible(toolbarConstraints);
        }
        toolbar.setVisible(bl);
        this.reflectChanges();
        this.firePropertyChange();
    }

    public boolean isToolbarVisible(Toolbar toolbar) {
        ToolbarConstraints toolbarConstraints = this.getToolbarConstraints(toolbar.getName());
        return toolbarConstraints.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void firePropertyChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("constraints", null, null);
        }
    }

    boolean tryWriteDocument(String string) throws IOException {
        FileObject fileObject;
        FileObject fileObject2 = TopManager.getDefault().getPlaces().folders().toolbars().getPrimaryFile();
        FileSystem fileSystem = fileObject2.getFileSystem();
        FileObject fileObject3 = fileSystem.find(fileObject2.getName(), string, EXT_XML);
        if (Utilities.isWindows() && fileObject3 == null) {
            fileObject = fileSystem.find(fileObject2.getName(), null, null);
            FileObject[] fileObjectArray = fileObject.getChildren();
            int n = 0;
            while (n < fileObjectArray.length) {
                if (fileObjectArray[n].getExt().equals(EXT_XML) && string.toLowerCase().equals(fileObjectArray[n].getName().toLowerCase())) {
                    fileObject3 = fileObjectArray[n];
                    string = fileObjectArray[n].getName();
                }
                ++n;
            }
        }
        if (fileObject3 != null) {
            fileObject = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(ToolbarConfiguration.getBundleString("MSG_replaceConfiguration"), string), 2, 2);
            TopManager.getDefault().notify((NotifyDescriptor)fileObject);
            if (fileObject.getValue() != NotifyDescriptor.OK_OPTION) {
                return false;
            }
        }
        this.writeDocument(string);
        return true;
    }

    public void writeDocument() throws IOException {
        this.writeDocument(this.configName);
    }

    private void writeDocument(final String string) throws IOException {
        ERR.log("writeDocument: " + string);
        WritableToolbarConfiguration writableToolbarConfiguration = new WritableToolbarConfiguration(this.toolbarRows, this.invisibleToolbars);
        final StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>\n\n");
        stringBuffer.append("<!DOCTYPE ").append(TAG_CONFIG).append(" PUBLIC \"").append(TOOLBAR_DTD_PUBLIC_ID).append("\" \"http://www.netbeans.org/dtds/toolbar.dtd\">\n\n").append(writableToolbarConfiguration.toString());
        final FileObject fileObject = TopManager.getDefault().getPlaces().folders().toolbars().getPrimaryFile();
        final FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileLock fileLock = null;
                OutputStream outputStream = null;
                FileObject fileObject2 = fileSystem.find(fileObject.getName(), string, ToolbarConfiguration.EXT_XML);
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createData(string, ToolbarConfiguration.EXT_XML);
                }
                try {
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                    ((Writer)outputStreamWriter).close();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                    ERR.log("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    throw throwable;
                }
                ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                ERR.log("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        });
        ERR.log("writeDocument finished");
    }

    private static final synchronized ToolbarPanel toolbarPanel() {
        if (toolbarPanel == null) {
            toolbarPanel = new ToolbarPanel();
        }
        return toolbarPanel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"document".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        this.updateConfiguration((XMLDataObject)propertyChangeEvent.getSource());
    }

    void updateConfiguration(final XMLDataObject xMLDataObject) {
        long l = xMLDataObject.getPrimaryFile().lastModified().getTime();
        ERR.log("Checking modified: " + this.lastReload);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ToolbarConfiguration.this.initInstance();
                    ToolbarConfiguration.this.readConfig(xMLDataObject);
                    ToolbarConfiguration.this.checkConfigurationOver();
                    if (ToolbarConfiguration.this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration())) {
                        ERR.log("Activating the configuration");
                        ToolbarConfiguration.this.activate(true, false);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        });
    }

    int getRowVertLocation(ToolbarRow toolbarRow) {
        int n = this.rowIndex(toolbarRow);
        int n2 = n * 1;
        Iterator iterator = ((AbstractList)this.toolbarRows).iterator();
        int n3 = 0;
        while (n3 < n) {
            n2 += ((ToolbarRow)iterator.next()).getPreferredHeight();
            ++n3;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        confs2Names = new WeakHashMap(10);
    }

    class WritableToolbarConfiguration {
        Vector rows;

        public WritableToolbarConfiguration(Vector vector, Map map) {
            this.initRows(vector);
            this.initInvisible(map);
            this.removeEmptyRows();
        }

        void initRows(Vector vector) {
            this.rows = new Vector();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow((ToolbarRow)iterator.next()));
            }
        }

        void initInvisible(Map map) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int n;
                ToolbarConstraints toolbarConstraints = (ToolbarConstraints)iterator.next();
                int n2 = n = ((Integer)map.get(toolbarConstraints)).intValue();
                while (n2 < n + toolbarConstraints.getRowCount()) {
                    this.getRow(n2).addToolbar(toolbarConstraints);
                    ++n2;
                }
            }
        }

        void removeEmptyRows() {
            int n = this.rows.size() - 1;
            while (n >= 0) {
                ToolbarRow.WritableToolbarRow writableToolbarRow = (ToolbarRow.WritableToolbarRow)this.rows.elementAt(n);
                if (writableToolbarRow.isEmpty()) {
                    this.rows.removeElement(writableToolbarRow);
                }
                --n;
            }
        }

        ToolbarRow.WritableToolbarRow getRow(int n) {
            try {
                return (ToolbarRow.WritableToolbarRow)this.rows.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow());
                return this.getRow(n);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            Iterator iterator = ((AbstractList)this.rows).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("</").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            return stringBuffer.toString();
        }
    }
}

