/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowUtils {
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    static /* synthetic */ Class class$org$netbeans$core$windows$util$WindowUtils;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private WindowUtils() {
    }

    public static void convertRectangle(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        if (dimension.equals(dimension2)) {
            return;
        }
        double d = (double)dimension2.width / (double)dimension.width;
        double d2 = (double)dimension2.height / (double)dimension.height;
        rectangle.x = (int)((double)rectangle.x * d);
        rectangle.y = (int)((double)rectangle.y * d2);
        rectangle.width = (int)((double)rectangle.width * d);
        rectangle.height = (int)((double)rectangle.height * d2);
    }

    public static final boolean isMdi() {
        return ((WindowManagerImpl)WindowManager.getDefault()).uiModeManager().getUIMode() == 2;
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object object) {
        return WindowUtils.findConstrainedMode(workspace, object, false);
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object object, boolean bl) {
        List list = ((WorkspaceImpl)workspace).getLoadedModeArray();
        ModeImpl modeImpl = null;
        Object object2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            modeImpl = (ModeImpl)iterator.next();
            if (bl && modeImpl.getLoadedOpenedTopComponents().length <= 0) continue;
            object2 = modeImpl.getLoadedConstraints();
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return modeImpl;
        }
        return null;
    }

    public static void changeModeConstraints(ModeImpl modeImpl, Object object) {
        WindowUtils.changeModeConstraints(modeImpl, object, false);
    }

    public static void changeModeConstraints(ModeImpl modeImpl, Object object, boolean bl) {
        ModeImpl modeImpl2;
        boolean bl2 = true;
        if (object != null && !"CENTER".equals(object) && (modeImpl2 = WindowUtils.findConstrainedMode(modeImpl.getWorkspace(), object)) != null && modeImpl2.isVisible() && !modeImpl.equals(modeImpl2)) {
            String string = WindowTypesManager.getDefaultFrame();
            if (bl) {
                modeImpl.setConstraints(null);
                modeImpl.setFrameType(string);
                bl2 = false;
            } else {
                modeImpl2.setConstraints(null);
                modeImpl2.setFrameType(string);
            }
        }
        if (bl2) {
            modeImpl.setConstraints(object);
        }
    }

    public static ModeImpl getActiveMode() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)WindowManager.getDefault().getCurrentWorkspace();
        return (ModeImpl)workspaceImpl.findMode(topComponent);
    }

    public static boolean changeActiveMode(Object object, String string) {
        ModeImpl modeImpl = WindowUtils.getActiveMode();
        if (modeImpl == null) {
            return false;
        }
        boolean bl = modeImpl.isVisible();
        if (bl) {
            modeImpl.setVisible(false);
        }
        WindowUtils.changeModeConstraints(modeImpl, object);
        modeImpl.setFrameType(string);
        if (bl) {
            modeImpl.setVisible(true);
            WindowManagerImpl.mainWindow().getContentPane().validate();
        }
        return true;
    }

    public static ModeImpl dockIntoNewMode(TopComponent topComponent, boolean bl) {
        return WindowUtils.dockIntoNewMode(topComponent, bl, null, null);
    }

    public static ModeImpl dockIntoNewMode(TopComponent topComponent, boolean bl, Rectangle rectangle) {
        return WindowUtils.dockIntoNewMode(topComponent, bl, rectangle, null);
    }

    public static ModeImpl dockIntoNewMode(TopComponent topComponent, boolean bl, Rectangle rectangle, String string) {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspace();
        String string2 = WindowManagerImpl.findUnusedModeName(topComponent.getName(), workspaceImpl);
        ModeImpl modeImpl = (ModeImpl)workspaceImpl.createMode(string2, string2, bl ? ((ModeImpl)workspaceImpl.findMode(topComponent)).getIconURL() : WindowUtils.getIconURL("nbresboot:/org/netbeans/core/resources/frames/default.gif"), true);
        if (string != null) {
            modeImpl.setFrameType(string);
        }
        if (rectangle != null) {
            modeImpl.setBounds(rectangle);
        }
        if (bl) {
            TopComponent topComponent2 = ((TopComponent.Cloneable)topComponent).cloneComponent();
            topComponent2.setIcon(topComponent.getIcon());
            modeImpl.dockInto(topComponent2);
            topComponent2.open();
        } else {
            modeImpl.dockInto(topComponent);
        }
        return modeImpl;
    }

    public static boolean hasObjectStreamField(ObjectInputStream.GetField getField, String string) {
        ObjectStreamField[] objectStreamFieldArray = getField.getObjectStreamClass().getFields();
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            if (string.equals(objectStreamFieldArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final URL getIconURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$util$WindowUtils == null ? (class$org$netbeans$core$windows$util$WindowUtils = WindowUtils.class$("org.netbeans.core.windows.util.WindowUtils")) : class$org$netbeans$core$windows$util$WindowUtils)).getString("LOG_NoIcon");
            ErrorManager.getDefault().log(16, MessageFormat.format(string2, string));
        }
        return uRL;
    }

    public static final String convertConstraint2Perim(String string) {
        if ("left".equals(string)) {
            return "WEST";
        }
        if ("right".equals(string)) {
            return "EAST";
        }
        if ("top".equals(string)) {
            return "NORTH";
        }
        if ("bottom".equals(string)) {
            return "SOUTH";
        }
        if ("center".equals(string)) {
            return "CENTER";
        }
        return null;
    }

    public static final String stringId2RefName(String string) {
        return string.substring(string.indexOf(47) + 1);
    }

    public static final String refName2StringId(String string) {
        return "wstopcomp/" + string;
    }

    public static final String convertConstraint2Xml(String string) {
        if ("WEST".equals(string)) {
            return "left";
        }
        if ("EAST".equals(string)) {
            return "right";
        }
        if ("NORTH".equals(string)) {
            return "top";
        }
        if ("SOUTH".equals(string)) {
            return "bottom";
        }
        if ("CENTER".equals(string)) {
            return "center";
        }
        return null;
    }

    public static final int parseUIType(String string) {
        if ("mdi".equals(string)) {
            return 2;
        }
        if ("sdi".equals(string)) {
            return 1;
        }
        return -1;
    }

    public static final ModuleInfo findModule(String string, String string2, String string3) {
        SpecificationVersion specificationVersion = null;
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
        }
        if (string3 != null) {
            specificationVersion = new SpecificationVersion(string3);
        }
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = WindowUtils.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
        Collection collection = result.allInstances();
        ModuleInfo moduleInfo = null;
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.getCodeNameBase().equals(string)) continue;
            if (n < 0 && specificationVersion == null || moduleInfo.getCodeNameRelease() > n) {
                return moduleInfo;
            }
            if (n >= 0 && moduleInfo.getCodeNameRelease() != n || specificationVersion != null && moduleInfo.getSpecificationVersion().compareTo((Object)specificationVersion) < 0) continue;
            return moduleInfo;
        }
        return null;
    }

    public static final String convertFrameType(int n, Object object) {
        if (n == 1) {
            return "org.netbeans.core.windows.frames.TopFrameTypeImpl";
        }
        if (n == 2) {
            if (object != null && !"CENTER".equals(object)) {
                return "org.netbeans.core.windows.frames.DesktopFrameTypeImpl";
            }
            return "org.netbeans.core.windows.frames.InternalFrameTypeImpl";
        }
        return null;
    }

    public static String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && n2 == n - 1 || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                stringBuffer.append('#');
                String string2 = Integer.toString(c, 16).toUpperCase();
                if (string2.length() < 4) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 3) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '#') {
                block6: {
                    if (n2 + 4 >= n) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                        System.err.println("trailing garbage in instance name: " + string);
                        break;
                    }
                    try {
                        char[] cArray = new char[4];
                        string.getChars(n2 + 1, n2 + 5, cArray, 0);
                        stringBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                        numberFormatException.printStackTrace();
                    }
                }
                n2 += 4;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteOneFO(FileObject fileObject) {
        FileLock fileLock = null;
        if (!fileObject.isValid()) return;
        try {
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                Object var4_3 = null;
                if (fileLock == null) return;
                fileLock.releaseLock();
                return;
            }
            Object var4_2 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public static void hideAllFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            ((Component)frameArray[n]).setVisible(false);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

