/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassFileReader;
import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.CompatibilityChecker;
import com.sun.tools.javamake.PCDContainer;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.Adler32;

public class PCDManager {
    private PCDContainer pcdc;
    private Hashtable pcd;
    private String[] projectJavaFilesArray;
    private String[] addedJavaFilesArray;
    private String[] removedJavaFilesArray;
    private String[] updatedJavaFilesArray;
    private ArrayList newJavaFiles;
    private HashSet updatedJavaFiles;
    private HashSet recompiledJavaFiles;
    private HashSet updatedClasses;
    private HashSet allUpdatedClasses;
    private HashSet updatedAndCheckedClasses;
    private HashSet deletedClasses;
    private String destDir;
    private boolean destDirSpecified;
    private ArrayList javacAddArgs;
    private Class compilerClass;
    private Method compileMethod;
    private String jcExecApp;
    private Object externalApp;
    private Method externalCompileSourceFilesMethod;
    private Adler32 checkSum;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private CompatibilityChecker cv;
    private ClassFileReader cfr;
    private boolean newProject = false;
    private static boolean backSlashFileSeparator = File.separatorChar != '/';
    static /* synthetic */ Class array$Ljava$lang$String;

    public PCDManager(PCDContainer pCDContainer, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, ArrayList arrayList) {
        this.pcdc = pCDContainer;
        if (pCDContainer.pcd == null) {
            this.pcd = new Hashtable();
            pCDContainer.pcd = this.pcd;
            this.newProject = true;
        } else {
            this.pcd = pCDContainer.pcd;
        }
        this.projectJavaFilesArray = stringArray;
        this.addedJavaFilesArray = stringArray2;
        this.removedJavaFilesArray = stringArray3;
        this.updatedJavaFilesArray = stringArray4;
        this.newJavaFiles = new ArrayList();
        this.updatedJavaFiles = new HashSet();
        this.recompiledJavaFiles = new HashSet();
        this.updatedAndCheckedClasses = new HashSet();
        this.deletedClasses = new HashSet();
        this.allUpdatedClasses = new HashSet();
        this.initializeDestDir(string);
        this.javacAddArgs = arrayList;
        this.checkSum = new Adler32();
        this.cv = new CompatibilityChecker(this);
        this.cfr = new ClassFileReader();
    }

    public Enumeration entriesEnum() {
        return this.pcd.elements();
    }

    public ClassFileReader getClassFileReader() {
        return this.cfr;
    }

    public ClassInfo getClassInfoForName(int n, String string) {
        PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
        if (pCDEntry != null) {
            return this.getClassInfoForPCDEntry(n, pCDEntry);
        }
        return null;
    }

    public ClassInfo getClassInfoForPCDEntry(int n, PCDEntry pCDEntry) {
        if (n == 0) {
            return pCDEntry.oldClassInfo;
        }
        ClassInfo classInfo = pCDEntry.newClassInfo;
        if (classInfo == null) {
            File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
            if (file == null) {
                return null;
            }
            byte[] byArray = this.readFileIntoBuffer(file);
            String string = pCDEntry.classFileFullPath;
            pCDEntry.newClassInfo = classInfo = new ClassInfo(byArray, n, this, string);
        }
        return classInfo;
    }

    public boolean classAlreadyRecompiled(String string) {
        PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
        if (pCDEntry == null) {
            throw this.internalException(string + " not in project when it should be");
        }
        return this.recompiledJavaFiles.contains(pCDEntry.javaFileFullPath);
    }

    public void initializeCompiler(String string, String string2, String string3, String string4, Object object, Method method) {
        Object object2;
        if (object != null) {
            this.externalApp = object;
            this.externalCompileSourceFilesMethod = method;
            return;
        }
        if (string != null) {
            this.jcExecApp = string;
            return;
        }
        if (string2 == null) {
            object2 = System.getProperty("java.home");
            if (((String)object2).endsWith(File.separator + "jre") || ((String)object2).endsWith(File.separator + "bin")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
            }
            string2 = (String)object2 + "/lib/tools.jar";
        }
        if (!string2.startsWith("file://") && !string2.startsWith("http://")) {
            if (File.separatorChar == '\\' && string2.charAt(1) == ':') {
                string2 = "/" + string2;
            }
            string2 = "file://" + string2;
        }
        if (!(string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(File.separator))) {
            string2 = string2 + File.separator;
        }
        if (string3 == null) {
            string3 = "com.sun.tools.javac.Main";
        }
        if (string4 == null) {
            string4 = "compile";
        }
        object2 = null;
        try {
            object2 = new URLClassLoader(new URL[]{new URL(string2)});
        }
        catch (MalformedURLException malformedURLException) {
            throw this.compilerInteractionException("Error opening compiler path", malformedURLException, 0);
        }
        try {
            this.compilerClass = ((ClassLoader)object2).loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.compilerInteractionException("Error loading compiler main class com.sun.tools.javac.Main", classNotFoundException, 0);
        }
        Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = PCDManager.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        try {
            this.compileMethod = this.compilerClass.getMethod(string4, classArray);
        }
        catch (Exception exception) {
            throw this.compilerInteractionException("Error getting method com.sun.tools.javac.Main.compile(String args[])", exception, 0);
        }
    }

    public void run() {
        Utils.startTiming(2);
        this.synchronizeProjectFilesAndPCD();
        Utils.stopAndPrintTiming("Synchro", 2);
        Utils.printTiming("of which synchro check file", 3);
        Utils.startTiming(4);
        this.findUpdatedJavaFiles();
        Utils.stopAndPrintTiming("findUpdatedJavaFiles", 4);
        Utils.printTiming("of which classFileObsoleteOrDeleted", 5);
        this.projectJavaFilesArray = null;
        int n = 0;
        int n2 = 0;
        while (n == 0 || this.updatedJavaFiles.size() != 0) {
            if (this.updatedJavaFiles.size() > 0) {
                Utils.startTiming(6);
                int n3 = this.recompileUpdatedJavaFiles();
                Utils.stopAndPrintTiming("Compile", 6);
                if (n3 != 0) {
                    n2 = n3;
                }
            }
            Utils.startTiming(12);
            if (n++ == 0 && n2 == 0) {
                this.findClassFilesForNewJavaFiles();
                this.dealWithNestedClassesForUpdatedJavaFiles();
            }
            Utils.stopAndPrintTiming("Entering new classes in PDB", 12);
            this.updatedJavaFiles = new HashSet();
            this.newJavaFiles = new ArrayList();
            Utils.startTiming(7);
            this.findUpdatedClasses();
            Utils.stopAndPrintTiming("Find updated classes", 7);
            Utils.startTiming(8);
            this.checkDeletedClasses();
            this.checkUpdatedClasses();
            Utils.stopAndPrintTiming("Check updated classes", 8);
        }
        Utils.startTiming(9);
        this.updateClassFilesInfoInPCD(n2);
        this.pcdc.save();
        Utils.stopAndPrintTiming("PDB write", 9);
        if (n2 != 0) {
            throw this.compilerInteractionException("Compilation error(s)", null, n2);
        }
    }

    public String[] getAllUpdatedClassesAsStringArray() {
        String[] stringArray = new String[this.allUpdatedClasses.size()];
        int n = 0;
        Iterator iterator = this.allUpdatedClasses.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((String)iterator.next()).replace('/', '.');
        }
        return stringArray;
    }

    private void synchronizeProjectFilesAndPCD() {
        if (this.projectJavaFilesArray != null) {
            HashSet<String> hashSet = new HashSet<String>(this.pcd.size() * 3 / 2);
            Enumeration enumeration = this.entriesEnum();
            while (enumeration.hasMoreElements()) {
                hashSet.add(((PCDEntry)enumeration.nextElement()).javaFileFullPath);
            }
            HashSet<String> hashSet2 = new HashSet<String>(this.projectJavaFilesArray.length * 3 / 2);
            int n = 0;
            while (n < this.projectJavaFilesArray.length) {
                String string = this.projectJavaFilesArray[n];
                Utils.startTiming(10);
                File file = Utils.checkFileForName(string);
                Utils.stopAndAddTiming(10, 3);
                if (file == null) {
                    throw new PrivateException(new FileNotFoundException("Specified source file " + string + " not found."));
                }
                String string2 = PCDManager.getCanonicalPath(file);
                hashSet2.add(string2);
                if (!hashSet.contains(string2)) {
                    this.newJavaFiles.add(string2);
                    this.updatedJavaFiles.add(string2);
                }
                ++n;
            }
            Enumeration enumeration2 = this.pcd.keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
                pCDEntry.oldClassInfo.restorePCDM(this);
                if (hashSet2.contains(pCDEntry.javaFileFullPath)) continue;
                this.addToDeletedClasses(string);
            }
        } else {
            if (this.addedJavaFilesArray != null) {
                int n = 0;
                while (n < this.addedJavaFilesArray.length) {
                    this.newJavaFiles.add(this.addedJavaFilesArray[n]);
                    this.updatedJavaFiles.add(this.addedJavaFilesArray[n]);
                    ++n;
                }
            }
            HashSet<String> hashSet = null;
            if (this.removedJavaFilesArray != null) {
                hashSet = new HashSet<String>();
                int n = 0;
                while (n < this.removedJavaFilesArray.length) {
                    hashSet.add(this.removedJavaFilesArray[n]);
                    ++n;
                }
            }
            Enumeration enumeration = this.pcd.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
                pCDEntry.oldClassInfo.restorePCDM(this);
                if (hashSet == null || !hashSet.contains(pCDEntry.javaFileFullPath)) continue;
                this.addToDeletedClasses(string);
            }
        }
    }

    private void updateClassFilesInfoInPCD(int n) {
        Iterator iterator = this.updatedAndCheckedClasses.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
            if (pCDEntry.checkResult == 3) {
                if (n != 0) continue;
                this.pcd.remove(string);
                continue;
            }
            if (pCDEntry.checkResult != 1 && pCDEntry.checkResult != 4 && (pCDEntry.checkResult != 2 || n != 0)) continue;
            if (pCDEntry.newClassInfo == null) {
                Utils.printWarningMessage("Warning: internal information inconsistency detected during pdb updating");
                Utils.printWarningMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
                Utils.printWarningMessage("Class name: " + string);
                if (pCDEntry.checkResult != 4) continue;
                this.pcd.remove(string);
            }
            pCDEntry.oldClassFileLastModified = pCDEntry.newClassFileLastModified;
            pCDEntry.oldClassFileFingerprint = pCDEntry.newClassFileFingerprint;
            pCDEntry.oldClassInfo = pCDEntry.newClassInfo;
        }
    }

    private void findUpdatedJavaFiles() {
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (this.deletedClasses.contains(pCDEntry.className)) continue;
            this.initializeClassFileFullPath(pCDEntry);
            if (this.projectJavaFilesArray == null) continue;
            Utils.startTiming(11);
            if (this.classFileObsoleteOrDeleted(pCDEntry)) {
                this.updatedJavaFiles.add(pCDEntry.javaFileFullPath);
            }
            Utils.stopAndAddTiming(11, 5);
        }
        if (this.projectJavaFilesArray == null && this.updatedJavaFilesArray != null) {
            int n = 0;
            while (n < this.updatedJavaFilesArray.length) {
                this.updatedJavaFiles.add(this.updatedJavaFilesArray[n]);
                ++n;
            }
        }
    }

    private boolean classFileObsoleteOrDeleted(PCDEntry pCDEntry) {
        File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
        if (file == null || !file.exists()) {
            return true;
        }
        File file2 = new File(pCDEntry.javaFileFullPath);
        return file.lastModified() < file2.lastModified();
    }

    public int recompileUpdatedJavaFiles() {
        Object[] objectArray;
        if (this.externalApp != null) {
            int n = this.updatedJavaFiles.size();
            String[] stringArray = new String[n];
            Iterator iterator = this.updatedJavaFiles.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                stringArray[n2++] = (String)iterator.next();
            }
            try {
                Integer n3 = (Integer)this.externalCompileSourceFilesMethod.invoke(this.externalApp, new Object[]{stringArray});
                return n3;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.compilerInteractionException("Compiler method is not accessible", illegalAccessException, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.compilerInteractionException("Illegal arguments passed to compiler method", illegalArgumentException, 0);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.compilerInteractionException("Exception when executing the compiler method", invocationTargetException, 0);
            }
        }
        int n = this.updatedJavaFiles.size();
        int n4 = this.javacAddArgs.size();
        int n5 = n4 + n;
        if (this.jcExecApp != null) {
            ++n5;
        }
        String[] stringArray = new String[n5];
        int n6 = 0;
        if (this.jcExecApp != null) {
            stringArray[n6++] = this.jcExecApp;
        }
        int n7 = 0;
        while (n7 < n4) {
            stringArray[n6++] = (String)this.javacAddArgs.get(n7);
            ++n7;
        }
        Iterator iterator = this.updatedJavaFiles.iterator();
        if (!this.newProject) {
            Utils.printInfoMessage("Recompiling source files:");
        }
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (!this.newProject) {
                Utils.printInfoMessage((String)objectArray);
            }
            stringArray[n6++] = objectArray;
            this.recompiledJavaFiles.add(objectArray);
        }
        if (this.jcExecApp == null) {
            objectArray = new Object[]{stringArray};
            try {
                Object t = this.compilerClass.newInstance();
                Integer n8 = (Integer)this.compileMethod.invoke(t, objectArray);
                return n8;
            }
            catch (Exception exception) {
                throw this.compilerInteractionException("Exception thrown when trying to invoke the compiler method", exception, 0);
            }
        }
        int n9 = 0;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            boolean bl = false;
            while (!bl) {
                try {
                    n9 = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Utils.delay(100);
                }
                try {
                    Utils.readAndPrintBytesFromStream(inputStream, System.err);
                    Utils.readAndPrintBytesFromStream(inputStream2, System.out);
                }
                catch (IOException iOException) {
                    throw this.compilerInteractionException("I/O error when reading the compiler application output", iOException, n9);
                }
            }
            return n9;
        }
        catch (IOException iOException) {
            throw this.compilerInteractionException("I/O error when trying to invoke the compiler application", iOException, n9);
        }
    }

    private void findClassFilesForNewJavaFiles() {
        int n = 0;
        while (n < this.newJavaFiles.size()) {
            String string = (String)this.newJavaFiles.get(n);
            PCDEntry pCDEntry = this.findClassFile(string, null, null);
            if (pCDEntry != null && pCDEntry.checkResult == 4 || pCDEntry == null) {
                this.updatedJavaFiles.remove(string);
                if (pCDEntry != null) {
                    this.findAllNestedClassesForClass(pCDEntry);
                }
            } else {
                this.updateJavaFileFullPathForNestedClasses(pCDEntry);
            }
            ++n;
        }
    }

    private PCDEntry findClassFile(String string, PCDEntry pCDEntry, String string2) {
        String string3 = null;
        String string4 = null;
        File file = null;
        if (pCDEntry == null) {
            string4 = string.substring(0, string.length() - 5);
            if (this.destDirSpecified) {
                while (file == null) {
                    string3 = this.destDir + string4 + ".class";
                    file = Utils.checkFileForName(string3);
                    if (file != null) continue;
                    int n = string4.indexOf(File.separatorChar);
                    if (n == -1) {
                        Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + string);
                        return null;
                    }
                    string4 = string4.substring(n + 1);
                }
            } else {
                string3 = string4 + ".class";
                file = Utils.checkFileForName(string3);
                if (file == null) {
                    Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + string);
                    return null;
                }
            }
        } else {
            string3 = Utils.getClassFileFullPathForNestedClass(pCDEntry.classFileFullPath, string2);
            file = Utils.checkFileForName(string3);
            if (file == null) {
                Utils.printWarningMessage("Warning: unable to find .class file corresponding to nested class " + string2);
                return null;
            }
            string4 = string2;
        }
        if (backSlashFileSeparator) {
            string4 = string4.replace(File.separatorChar, '/');
        }
        byte[] byArray = this.readFileIntoBuffer(file);
        ClassInfo classInfo = new ClassInfo(byArray, 1, this, string3);
        if (pCDEntry != null && classInfo.directlyEnclosingClass != pCDEntry.newClassInfo.name) {
            throw new PrivateException(new PublicExceptions.ClassFileParseException("Enclosing class names for class " + classInfo.name + " don't match:\n" + classInfo.directlyEnclosingClass + " and " + pCDEntry.oldClassInfo.name));
        }
        if (this.destDirSpecified) {
            if (!string4.equals(classInfo.name)) {
                throw new PrivateException(new PublicExceptions.ClassNameMismatchException("Deduced class name is different from the real one for source " + string + "\n" + string4 + " and " + classInfo.name));
            }
        } else {
            string4 = classInfo.name;
        }
        if (pCDEntry != null) {
            string = pCDEntry.javaFileFullPath;
        }
        long l = file.lastModified();
        long l2 = this.computeFP(byArray);
        if (this.pcd.containsKey(string4)) {
            PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(string4);
            pCDEntry2.javaFileFullPath = string;
            pCDEntry2.classFileFullPath = string3;
            if (this.deletedClasses.contains(string4)) {
                this.deletedClasses.remove(string4);
            }
            return pCDEntry2;
        }
        PCDEntry pCDEntry3 = new PCDEntry(string4, string, string3, l, l2, classInfo);
        pCDEntry3.checkResult = 4;
        this.updatedAndCheckedClasses.add(string4);
        this.pcd.put(string4, pCDEntry3);
        return pCDEntry3;
    }

    private void findAllNestedClassesForClass(PCDEntry pCDEntry) {
        ClassInfo classInfo = pCDEntry.newClassInfo;
        if (classInfo.nestedClasses == null) {
            return;
        }
        String[] stringArray = classInfo.nestedClasses;
        int n = 0;
        while (n < stringArray.length) {
            if (!this.pcd.containsKey(stringArray[n])) {
                PCDEntry pCDEntry2 = this.findClassFile(null, pCDEntry, stringArray[n]);
                if (pCDEntry2 == null) {
                    return;
                }
                pCDEntry2.newClassInfo.accessFlags = pCDEntry.newClassInfo.nestedClassAccessFlags[n];
                pCDEntry2.newClassInfo.isNonMemberNestedClass = pCDEntry.newClassInfo.nestedClassNonMember[n];
                this.findAllNestedClassesForClass(pCDEntry2);
            }
            ++n;
        }
    }

    private void updateJavaFileFullPathForNestedClasses(PCDEntry pCDEntry) {
        String string = pCDEntry.javaFileFullPath;
        String string2 = pCDEntry.classFileFullPath;
        ClassInfo classInfo = pCDEntry.oldClassInfo;
        if (classInfo.nestedClasses == null) {
            return;
        }
        String[] stringArray = classInfo.nestedClasses;
        int n = 0;
        while (n < stringArray.length) {
            if (this.pcd.containsKey(stringArray[n])) {
                PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                pCDEntry2.javaFileFullPath = string;
                pCDEntry2.classFileFullPath = Utils.getClassFileFullPathForNestedClass(string2, stringArray[n]);
                if (this.deletedClasses.contains(stringArray[n])) {
                    this.deletedClasses.remove(stringArray[n]);
                }
                this.updateJavaFileFullPathForNestedClasses(pCDEntry2);
            }
            ++n;
        }
    }

    private void dealWithNestedClassesForUpdatedJavaFiles() {
        if (this.updatedJavaFiles.size() == 0) {
            return;
        }
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            int n;
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (pCDEntry.checkResult == 4 || !this.updatedJavaFiles.contains(pCDEntry.javaFileFullPath)) continue;
            ClassInfo classInfo = pCDEntry.oldClassInfo;
            ClassInfo classInfo2 = this.getClassInfoForPCDEntry(1, pCDEntry);
            if (classInfo2 == null) continue;
            if (classInfo.directlyEnclosingClass != "") {
                ClassInfo classInfo3 = this.getClassInfoForName(1, classInfo.directlyEnclosingClass);
                if (classInfo3 == null || classInfo3.nestedClasses == null) continue;
                n = 0;
                while (n < classInfo3.nestedClasses.length) {
                    if (classInfo.name == classInfo3.nestedClasses[n]) break;
                    ++n;
                }
                if (n == classInfo3.nestedClasses.length) {
                    this.addToDeletedClasses(classInfo.name);
                    continue;
                }
                classInfo2.accessFlags = classInfo3.nestedClassAccessFlags[n];
                classInfo2.isNonMemberNestedClass = classInfo3.nestedClassNonMember[n];
            }
            if (classInfo.nestedClasses == null && classInfo2.nestedClasses == null) continue;
            if (classInfo.nestedClasses == null) {
                this.findAllNestedClassesForClass(pCDEntry);
                continue;
            }
            if (classInfo2.nestedClasses == null) {
                n = 0;
                while (n < classInfo.nestedClasses.length) {
                    this.addToDeletedClasses(classInfo.nestedClasses[n]);
                    ++n;
                }
                continue;
            }
            boolean bl = false;
            n = 0;
            while (n < classInfo.nestedClasses.length) {
                String string = classInfo.nestedClasses[n];
                int n2 = 0;
                while (n2 < classInfo2.nestedClasses.length) {
                    if (string == classInfo2.nestedClasses[n2]) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.addToDeletedClasses(string);
                }
                ++n;
            }
            this.findAllNestedClassesForClass(pCDEntry);
        }
    }

    private void findUpdatedClasses() {
        this.updatedClasses = new HashSet();
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            String string = pCDEntry.className;
            if (this.updatedAndCheckedClasses.contains(string) || this.deletedClasses.contains(string) || !this.classFileUpdated(pCDEntry)) continue;
            this.updatedClasses.add(string);
            this.allUpdatedClasses.add(string);
        }
    }

    private boolean classFileUpdated(PCDEntry pCDEntry) {
        File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
        if (file == null) {
            return false;
        }
        long l = file.lastModified();
        if (l > pCDEntry.oldClassFileLastModified) {
            pCDEntry.newClassFileLastModified = l;
            long l2 = this.computeFP(file);
            if (l2 != pCDEntry.oldClassFileFingerprint) {
                pCDEntry.newClassFileFingerprint = l2;
                return true;
            }
        }
        return false;
    }

    private void checkUpdatedClasses() {
        Iterator iterator = this.updatedClasses.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
            if (!pCDEntry.oldClassInfo.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking " + pCDEntry.className);
                pCDEntry.checkResult = this.cv.compareClassVersions(pCDEntry) ? 1 : 2;
                String[] stringArray = this.cv.getAffectedClasses();
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                        this.updatedJavaFiles.add(pCDEntry2.javaFileFullPath);
                        ++n;
                    }
                }
            } else {
                this.getClassInfoForPCDEntry(1, pCDEntry);
                pCDEntry.checkResult = 1;
            }
            this.updatedAndCheckedClasses.add(string);
        }
    }

    private void checkDeletedClasses() {
        Iterator iterator = this.deletedClasses.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
            ClassInfo classInfo = pCDEntry.oldClassInfo;
            if (!classInfo.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking deleted class " + classInfo.name);
                this.cv.checkDeletedClass(classInfo);
                String[] stringArray = this.cv.getAffectedClasses();
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                        if (!this.deletedClasses.contains(pCDEntry2.className)) {
                            this.updatedJavaFiles.add(pCDEntry2.javaFileFullPath);
                        }
                        ++n;
                    }
                }
            }
            pCDEntry.checkResult = 3;
            this.updatedAndCheckedClasses.add(string);
        }
        this.deletedClasses.clear();
    }

    private void addToDeletedClasses(String string) {
        this.deletedClasses.add(string);
    }

    private void initializeDestDir(String string) {
        if (string != null && !string.equals("")) {
            File file = Utils.checkOrCreateDirForName(string);
            if (file == null) {
                throw new PrivateException(new IOException("Specified directory " + string + " cannot be created."));
            }
            string = PCDManager.getCanonicalPath(file);
            if (!string.endsWith(File.separator)) {
                string = string + File.separatorChar;
            }
            this.destDir = string;
            this.destDirSpecified = true;
        } else {
            this.destDirSpecified = false;
        }
    }

    private void initializeClassFileFullPath(PCDEntry pCDEntry) {
        String string;
        if (this.destDirSpecified) {
            string = this.destDir + pCDEntry.className + ".class";
        } else {
            String string2;
            String string3 = pCDEntry.javaFileFullPath;
            int n = string3.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string3 = string3.substring(0, n + 1);
            }
            if ((n = (string2 = pCDEntry.className).lastIndexOf(47)) != -1) {
                string2 = string2.substring(n + 1);
            }
            string = string3 + string2 + ".class";
        }
        if (backSlashFileSeparator) {
            string = string.replace('/', File.separatorChar);
        }
        pCDEntry.classFileFullPath = string;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }

    private byte[] readFileIntoBuffer(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = ((InputStream)fileInputStream).available();
            byte[] byArray = new byte[n];
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }

    private long computeFP(File file) {
        byte[] byArray = this.readFileIntoBuffer(file);
        return this.computeFP(byArray);
    }

    private long computeFP(byte[] byArray) {
        this.checkSum.reset();
        this.checkSum.update(byArray);
        return this.checkSum.getValue();
    }

    private PrivateException compilerInteractionException(String string, Exception exception, int n) {
        return new PrivateException(new PublicExceptions.CompilerInteractionException(string, exception, n));
    }

    private PrivateException internalException(String string) {
        return new PrivateException(new PublicExceptions.InternalException(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

