/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.openide.filesystems.FileUtil;
import org.openide.util.io.ReaderInputStream;

public abstract class StreamSource {
    public abstract String getName();

    public abstract String getTitle();

    public abstract String getMIMEType();

    public abstract Reader createReader() throws IOException;

    public abstract Writer createWriter(Difference[] var1) throws IOException;

    public void close() {
    }

    public static StreamSource createSource(String string, String string2, String string3, Reader reader) {
        return new Impl(string, string2, string3, reader);
    }

    public static StreamSource createSource(String string, String string2, String string3, File file) {
        return new Impl(string, string2, string3, file);
    }

    private static class Impl
    extends StreamSource {
        private String name;
        private String title;
        private String MIMEType;
        private Reader r;
        private File readerSource;
        private Writer w;
        private File file;

        Impl(String string, String string2, String string3, Reader reader) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.r = reader;
            this.readerSource = null;
            this.w = null;
            this.file = null;
        }

        Impl(String string, String string2, String string3, File file) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.readerSource = null;
            this.w = null;
            this.file = file;
        }

        private File createReaderSource(Reader reader) throws IOException {
            File file = null;
            file = File.createTempFile("ss", "tmp");
            file.deleteOnExit();
            file.createNewFile();
            FileUtil.copy((InputStream)new ReaderInputStream(reader), (OutputStream)new FileOutputStream(file));
            return file;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.MIMEType;
        }

        public Reader createReader() throws IOException {
            if (this.file != null) {
                return new BufferedReader(new FileReader(this.file));
            }
            Impl impl = this;
            synchronized (impl) {
                if (this.r != null) {
                    this.readerSource = this.createReaderSource(this.r);
                    this.r = null;
                }
            }
            return new BufferedReader(new FileReader(this.readerSource));
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            if (differenceArray != null && differenceArray.length > 0) {
                return null;
            }
            if (this.file != null) {
                return new BufferedWriter(new FileWriter(this.file));
            }
            return this.w;
        }

        public void notifyClosed() {
        }
    }
}

