/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ProjectManager
implements TaskListener {
    public static final String PROP_FINISHED = "finished";
    private static ProjectManager manager = null;
    private RequestProcessor PROCESSOR = new RequestProcessor("Projects processor");
    private RequestProcessor.Task projectTask = null;
    private Vector listeners = new Vector(1);

    public static synchronized ProjectManager getDefault() {
        if (manager == null) {
            manager = new ProjectManager();
        }
        return manager;
    }

    public Task processTask(Runnable runnable) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (!this.isFinished()) {
                throw new IllegalStateException("Previous task is still in progress.");
            }
            this.projectTask = this.PROCESSOR.create(runnable);
            this.projectTask.addTaskListener((TaskListener)this);
        }
        this.fireFinishedChanged(false);
        ProjectManager projectManager2 = this;
        synchronized (projectManager2) {
            this.projectTask.schedule(0);
            RequestProcessor.Task task = this.projectTask;
            return task;
        }
    }

    public synchronized boolean isFinished() {
        return this.projectTask == null || this.projectTask.isFinished();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.listeners.contains(propertyChangeListener)) {
            this.listeners.add(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    private ProjectManager() {
    }

    private void fireFinishedChanged(boolean bl) {
        Vector vector = (Vector)this.listeners.clone();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext() && bl == this.isFinished()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, PROP_FINISHED, new Boolean(!bl), new Boolean(bl)));
        }
    }

    public void taskFinished(Task task) {
        task.removeTaskListener((TaskListener)this);
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            this.projectTask = null;
        }
        this.fireFinishedChanged(true);
    }
}

