/*
 * Decompiled with CFR 0.152.
 */
package tyrex.concurrency.engine;

import tyrex.concurrency.LockMode;
import tyrex.concurrency.LockNotHeldException;

abstract class InternalLockSet {
    private static final int LockSetSize = 5;
    private static final int LockIntentRead = 0;
    private static final int LockRead = 1;
    private static final int LockUpgrade = 2;
    private static final int LockIntentWrite = 3;
    private static final int LockWrite = 4;
    private Lock[] _locks = new Lock[5];
    private Waiting _waiting;
    private Subordinate _subordinate;
    private static int[][] _conflicts;

    static {
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[]{4};
        nArrayArray[1] = new int[]{4, 3};
        nArrayArray[2] = new int[]{4, 3, 2};
        nArrayArray[3] = new int[]{4, 2, 1};
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 1;
        nArrayArray[4] = nArray;
        _conflicts = nArrayArray;
    }

    protected InternalLockSet(InternalLockSet internalLockSet) {
        if (internalLockSet != null) {
            internalLockSet.addSubordinate(this);
        }
    }

    private void addSubordinate(InternalLockSet internalLockSet) {
        this._subordinate = new Subordinate(internalLockSet, this._subordinate);
    }

    int getLock(LockMode lockMode) {
        if (lockMode == LockMode.Write) {
            return 4;
        }
        if (lockMode == LockMode.IntentionWrite) {
            return 3;
        }
        if (lockMode == LockMode.Read) {
            return 1;
        }
        if (lockMode == LockMode.IntentionRead) {
            return 0;
        }
        if (lockMode == LockMode.Upgrade) {
            return 2;
        }
        throw new IllegalArgumentException("Lock mode argument is invalid");
    }

    synchronized void internalChange(int n, int n2, Object object) throws LockNotHeldException {
        this.internalLock(n2, object);
        this.internalUnlock(n, object);
    }

    /*
     * Unable to fully structure code
     */
    synchronized void internalDropLocks(Object var1_1) {
        var2_2 = 0;
        ** GOTO lbl15
        {
            this._locks[var2_2] = this._locks[var2_2].next;
            do {
                if (this._locks[var2_2] != null && this.isRelated(this._locks[var2_2].owner, var1_1)) continue block0;
                var3_3 = this._locks[var2_2];
                if (var3_3 != null) {
                    while (var3_3.next != null) {
                        if (this.isRelated(var3_3.next.owner, var1_1)) {
                            var3_3.next = var3_3.next.next;
                            continue;
                        }
                        var3_3 = var3_3.next;
                    }
                }
                ++var2_2;
lbl15:
                // 2 sources

            } while (var2_2 < this._locks.length);
        }
        var3_3 = this._subordinate;
        while (var3_3 != null) {
            var3_3.internal.internalDropLocks(var1_1);
            var3_3 = var3_3.next;
        }
        if (this._waiting != null) {
            this.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void internalLock(int var1_1, Object var2_2) {
        block14: {
            if (this.internalTryLock(var1_1, var2_2)) {
                return;
            }
            var3_3 = new Waiting();
            try {
                if (this._waiting == null) {
                    this._waiting = var3_3;
                } else {
                    var4_4 = this._waiting;
                    while (var4_4.next != null) {
                        var4_4 = var4_4.next;
                    }
                    var4_4.next = var3_3;
                }
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException v0) {}
                } while (this._waiting != var3_3 || !this.internalTryLock(var1_1, var2_2));
                this._waiting = this._waiting.next;
                return;
            }
            catch (Throwable var4_5) {
                if (this._waiting == var3_3) {
                    this._waiting = this._waiting.next;
                    break block14;
                }
                var5_6 = this._waiting;
                ** while (var5_6.next != null)
            }
lbl-1000:
            // 1 sources

            {
                if (var5_6.next == var3_3) {
                    var5_6.next = var5_6.next.next;
                    break;
                }
                var5_6 = var5_6.next;
                continue;
            }
        }
        this.notifyAll();
        if (var4_5 instanceof RuntimeException) {
            throw (RuntimeException)var4_5;
        }
        if (var4_5 instanceof Error) {
            throw (Error)var4_5;
        }
    }

    synchronized boolean internalTryLock(int n, Object object) {
        if (this._locks[n] != null && this.isRelated(this._locks[n].owner, object)) {
            this._locks[n] = new Lock(object, this._locks[n]);
            return true;
        }
        int[] nArray = _conflicts[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            Lock lock = this._locks[nArray[n2]];
            while (lock != null) {
                if (!this.isRelated(lock.owner, object)) {
                    return false;
                }
                lock = lock.next;
            }
            ++n2;
        }
        this._locks[n] = new Lock(object, this._locks[n]);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void internalUnlock(int var1_1, Object var2_2) throws LockNotHeldException {
        block6: {
            var3_3 = this._locks[var1_1];
            if (var3_3 == null) break block6;
            if (var3_3.owner != var2_2) ** GOTO lbl19
            try {
                this._locks[var1_1] = var3_3.next;
                this.notifyAll();
            }
            finally {
                var5_4 = null;
                this.notifyAll();
            }
            return;
lbl-1000:
            // 1 sources

            {
                if (var3_3.next.owner == var2_2) {
                    var3_3.next = var3_3.next.next;
                    return;
                }
                var3_3 = var3_3.next;
lbl19:
                // 2 sources

                ** while (var3_3.next != null)
            }
        }
        throw new LockNotHeldException();
    }

    protected abstract boolean isRelated(Object var1, Object var2);

    static class Lock {
        final Object owner;
        Lock next;

        Lock(Object object) {
            this.owner = object;
            this.next = null;
        }

        Lock(Object object, Lock lock) {
            this.owner = object;
            this.next = lock;
        }
    }

    static class Waiting {
        Waiting next;

        Waiting() {
        }
    }

    static class Subordinate {
        final InternalLockSet internal;
        final Subordinate next;

        Subordinate(InternalLockSet internalLockSet, Subordinate subordinate) {
            this.internal = internalLockSet;
            this.next = subordinate;
        }
    }
}

