/*
 * Decompiled with CFR 0.152.
 */
package tyrex.conf;

import java.io.Serializable;
import java.util.Enumeration;
import tyrex.conf.AppPath;
import tyrex.conf.Visible;
import tyrex.resource.ResourceFactoryBuilder;
import tyrex.resource.ResourcePoolManager;
import tyrex.util.Logger;
import tyrex.util.Messages;

public class Resource
implements Serializable {
    private String _name;
    private String _type;
    private Object _param;
    private ResourcePoolManager _pool;
    private String _auth;
    private Visible _visible;

    public Object createParam() {
        try {
            return Class.forName(this._type).newInstance();
        }
        catch (Exception exception) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.cannotCreateFactory", this._type, exception));
            return null;
        }
    }

    public Object createResourceFactory() {
        if (this._param == null) {
            return null;
        }
        Enumeration enumeration = ResourceFactoryBuilder.listFactoryBuilders();
        while (enumeration.hasMoreElements()) {
            ResourceFactoryBuilder resourceFactoryBuilder = (ResourceFactoryBuilder)enumeration.nextElement();
            Object object = resourceFactoryBuilder.buildResourceFactory(this._param, this._pool);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object getParam() {
        return this._param;
    }

    public ResourcePoolManager getPool() {
        return this._pool;
    }

    public String getResAuth() {
        return this._auth;
    }

    public String getResName() {
        return this._name;
    }

    public String getResType() {
        return this._type;
    }

    public Visible getVisible() {
        if (this._visible == null) {
            this._visible = new Visible();
        }
        return this._visible;
    }

    public boolean isApplicationAuth() {
        return this._auth != null && this._auth.equals("application");
    }

    public boolean isVisible(String string) {
        if (this._visible == null) {
            return false;
        }
        return this._visible.isVisible(string);
    }

    public void setParam(Object object) {
        this._param = object;
    }

    public void setPool(ResourcePoolManager resourcePoolManager) {
        this._pool = resourcePoolManager;
    }

    public void setResAuth(String string) {
        this._auth = string;
    }

    public void setResName(String string) {
        this._name = string;
    }

    public void setResType(String string) {
        this._type = string;
    }

    public void setVisible(Visible visible) {
        if (this._visible != null) {
            Enumeration enumeration = visible.listAppPaths();
            while (enumeration.hasMoreElements()) {
                this._visible.addAppPath((AppPath)enumeration.nextElement());
            }
        } else {
            this._visible = visible;
        }
    }

    public static class Authentication {
        public static final String Container = "container";
        public static final String Application = "application";
    }
}

