/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import tyrex.jdbc.ConnectionPoolEntry;
import tyrex.jdbc.EnlistedConnection;
import tyrex.jdbc.xa.EnabledDataSource;
import tyrex.naming.ReferenceRefAddr;
import tyrex.recovery.LogWriter;
import tyrex.resource.ResourceLimits;
import tyrex.resource.ResourcePool;
import tyrex.resource.ResourcePoolManager;
import tyrex.resource.ResourcePoolManagerImpl;
import tyrex.resource.ResourceTimeoutException;
import tyrex.tm.ResourceManager;
import tyrex.util.Logger;
import tyrex.util.Messages;

public class ServerDataSource
implements DataSource,
ConnectionEventListener,
ObjectFactory,
Referenceable,
Serializable,
ResourcePool {
    public static final int DEFAULT_TIMEOUT = 120;
    public static final int DEFAULT_RETRY_ATTEMPTS = 5;
    private int _timeout = 120;
    private int _retryAttempts = 5;
    private String _dataSourceName;
    private String _description = "DataSource";
    private transient PrintWriter _logWriter;
    private transient Object _dataSource;
    private transient Vector _pool = new Vector();
    private transient Hashtable _active = new Hashtable();
    private ResourcePoolManager _poolManager;

    public ServerDataSource() {
    }

    public ServerDataSource(String string) {
        this._dataSourceName = string;
    }

    public ServerDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this._dataSource = connectionPoolDataSource;
    }

    public ServerDataSource(XADataSource xADataSource) {
        this._dataSource = xADataSource;
    }

    public synchronized void close() throws IllegalStateException {
        if (this.getActiveCount() != 0) {
            throw new IllegalStateException("Data source " + this.toString() + " has active connections");
        }
        if (this.getPooledCount() != 0) {
            Iterator iterator = ((AbstractList)this._pool).iterator();
            while (iterator.hasNext()) {
                try {
                    ((ConnectionPoolEntry)iterator.next()).conn.close();
                }
                catch (Exception exception) {}
            }
            this._pool.clear();
        }
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            ConnectionPoolEntry connectionPoolEntry = (ConnectionPoolEntry)this._active.remove(pooledConnection);
            if (connectionPoolEntry != null) {
                this._pool.addElement(connectionPoolEntry);
                this._poolManager.released();
                if (this.getLogWriter() != null) {
                    this.getLogWriter().println(Messages.format("tyrex.jdbc.pool.returned", connectionPoolEntry.conn));
                }
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            ConnectionPoolEntry connectionPoolEntry = (ConnectionPoolEntry)this._active.remove(pooledConnection);
            if (connectionPoolEntry.xaRes != null) {
                ResourceManager.discardResource(connectionPoolEntry.xaRes);
            }
            this._poolManager.released();
            if (connectionPoolEntry != null && this.getLogWriter() != null) {
                this.getLogWriter().println(Messages.format("tyrex.jdbc.pool.faulty", connectionPoolEntry.conn));
            }
        }
        catch (Exception exception) {}
    }

    private PooledConnection createConnection(String string, String string2) throws SQLException {
        if (this._dataSource == null) {
            try {
                if (this._dataSourceName == null) {
                    throw new SQLException(Messages.message("tyrex.jdbc.pool.noDataSource"));
                }
                Object object = new InitialContext().lookup(this._dataSourceName);
                if (object == null) {
                    throw new SQLException(Messages.format("tyrex.jdbc.pool.missingDataSource", this._dataSourceName));
                }
                if (!(object instanceof ConnectionPoolDataSource) && !(object instanceof XADataSource)) {
                    throw new SQLException(Messages.format("tyrex.jdbc.pool.incorrectDataSource", this._dataSourceName));
                }
                this._dataSource = object;
            }
            catch (NamingException namingException) {
                throw new SQLException(namingException.toString());
            }
        }
        if (this._dataSource instanceof XADataSource) {
            if (!(this._dataSource instanceof EnabledDataSource)) {
                LogWriter.out.open_connection(string, string2, this._dataSourceName);
            }
            if (string == null) {
                return ((XADataSource)this._dataSource).getXAConnection();
            }
            return ((XADataSource)this._dataSource).getXAConnection(string, string2);
        }
        if (string == null) {
            return ((ConnectionPoolDataSource)this._dataSource).getPooledConnection();
        }
        return ((ConnectionPoolDataSource)this._dataSource).getPooledConnection(string, string2);
    }

    private String getAccount(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return String.valueOf(string) + ":" + string2;
    }

    public int getActiveCount() {
        return this._active.size();
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        int n = 0;
        SQLException sQLException = null;
        while (this._retryAttempts == -1 || n <= this._retryAttempts) {
            ConnectionPoolEntry connectionPoolEntry;
            try {
                connectionPoolEntry = this.getPoolEntry(string, string2);
            }
            catch (ResourceTimeoutException resourceTimeoutException) {
                throw new SQLException(resourceTimeoutException.getMessage());
            }
            try {
                Connection connection = connectionPoolEntry.conn.getConnection();
                if (connectionPoolEntry.xaRes != null) {
                    connection = new EnlistedConnection(connection, connectionPoolEntry.xaRes);
                }
                this._active.put(connectionPoolEntry.conn, connectionPoolEntry);
                connectionPoolEntry.conn.addConnectionEventListener(this);
                return connection;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                ++n;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        throw new SQLException("Failed to get a connection.");
    }

    private byte[] getDataSourceBytes() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this._dataSource);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            objectOutputStream.close();
        }
        catch (IOException iOException) {}
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getDataSourceFromBytes(byte[] byArray) throws ClassNotFoundException, IOException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            object = objectInputStream.readObject();
            Object var5_4 = null;
            if (objectInputStream == null) return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (objectInputStream == null) throw throwable;
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    public String getDataSourceName() {
        return this._dataSourceName;
    }

    public String getDescription() {
        return this._description;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public int getLoginTimeout() {
        return this._timeout;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.getClassName().equals(this.getClass().getName())) {
                ServerDataSource serverDataSource = new ServerDataSource();
                serverDataSource._timeout = Integer.parseInt((String)reference.get("loginTimeout").getContent());
                RefAddr refAddr = reference.get("description");
                if (refAddr != null) {
                    serverDataSource._description = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("dataSourceName")) != null) {
                    serverDataSource._dataSourceName = (String)refAddr.getContent();
                } else {
                    refAddr = reference.get("dataSource");
                    if (refAddr != null) {
                        try {
                            serverDataSource._dataSource = refAddr instanceof BinaryRefAddr ? this.getDataSourceFromBytes((byte[])refAddr.getContent()) : refAddr.getContent();
                        }
                        catch (Exception exception) {
                            throw new NamingException(exception.toString());
                        }
                    }
                }
                return serverDataSource;
            }
            throw new NamingException(Messages.format("tyrex.jdbc.pool.badReference", this.getClass().getName()));
        }
        if (object instanceof Remote) {
            return object;
        }
        return null;
    }

    private synchronized ConnectionPoolEntry getPoolEntry(String string, String string2) throws SQLException, ResourceTimeoutException {
        ConnectionPoolEntry connectionPoolEntry;
        long l = 0L;
        String string3 = this.getAccount(string, string2);
        this.getPoolManager();
        ResourcePoolManager resourcePoolManager = this._poolManager;
        synchronized (resourcePoolManager) {
            this._poolManager.canActivate();
            int n = this._pool.size();
            while (n-- > 0) {
                connectionPoolEntry = (ConnectionPoolEntry)this._pool.elementAt(n);
                if ((connectionPoolEntry.account != null || string3 != null) && (connectionPoolEntry.account == null || !connectionPoolEntry.account.equals(string3))) continue;
                this._pool.removeElementAt(n);
                if (this.getLogWriter() != null) {
                    this.getLogWriter().println(Messages.format("tyrex.jdbc.pool.reusing", connectionPoolEntry.conn));
                }
                ConnectionPoolEntry connectionPoolEntry2 = connectionPoolEntry;
                Object var9_9 = null;
                return connectionPoolEntry2;
            }
            this._poolManager.canCreateNew();
            connectionPoolEntry = new ConnectionPoolEntry();
            connectionPoolEntry.conn = this.createConnection(string, string2);
            if (connectionPoolEntry.conn instanceof XAConnection) {
                connectionPoolEntry.xaRes = ((XAConnection)connectionPoolEntry.conn).getXAResource();
            }
            connectionPoolEntry.account = string3;
            if (this.getLogWriter() != null) {
                this.getLogWriter().println(Messages.format("tyrex.jdbc.pool.creating", connectionPoolEntry.conn));
            }
        }
        return connectionPoolEntry;
    }

    public ResourcePoolManager getPoolManager() {
        if (this._poolManager == null) {
            this._poolManager = new ResourcePoolManagerImpl(this, true);
        }
        return this._poolManager;
    }

    public int getPooledCount() {
        return this._pool.size();
    }

    public Reference getReference() {
        Reference reference;
        block9: {
            block10: {
                reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
                reference.add(new StringRefAddr("loginTimeout", Integer.toString(this._timeout)));
                if (this._description != null) {
                    reference.add(new StringRefAddr("description", this._description));
                }
                if (this._dataSourceName == null) break block10;
                reference.add(new StringRefAddr("dataSourceName", this._dataSourceName));
                break block9;
            }
            if (this._dataSource == null) break block9;
            try {
                if (this._dataSource instanceof Referenceable) {
                    reference.add(new ReferenceRefAddr("dataSource", (Referenceable)this._dataSource));
                } else if (this._dataSource instanceof Reference) {
                    reference.add(new ReferenceRefAddr("dataSource", (Reference)this._dataSource));
                } else if (this._dataSource instanceof Serializable) {
                    reference.add(new BinaryRefAddr("dataSource", this.getDataSourceBytes()));
                }
            }
            catch (NamingException namingException) {
                Logger.getSystemLogger().print("Failed to bind data source");
                Logger.getSystemLogger().print(this._dataSource);
                Logger.getSystemLogger().println(namingException);
            }
            catch (IOException iOException) {}
        }
        return reference;
    }

    public ResourceLimits getResourceLimits() {
        return this.getPoolManager().getResourceLimits();
    }

    public int getRetryAttempts() {
        return this._retryAttempts;
    }

    public synchronized void releasePooled(int n) {
        int n2 = this._pool.size() - n;
        if (n2 < 0) {
            n2 = 0;
        }
        n = this._pool.size();
        while (n-- > n2) {
            try {
                ((ConnectionPoolEntry)this._pool.remove((int)n)).conn.close();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void setDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        if (connectionPoolDataSource == null) {
            throw new NullPointerException("Argument 'dataSource' is null");
        }
        this._dataSourceName = null;
        this._dataSource = connectionPoolDataSource;
    }

    public synchronized void setDataSource(XADataSource xADataSource) {
        if (xADataSource == null) {
            throw new NullPointerException("Argument 'dataSource' is null");
        }
        this._dataSourceName = null;
        this._dataSource = xADataSource;
    }

    public synchronized void setDataSourceName(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'dataSourceName' is null");
        }
        this._dataSourceName = string;
        this._dataSource = null;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'description' is null");
        }
        this._description = string;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Argument 'writer' is null");
        }
        this._logWriter = printWriter;
    }

    public void setLoginTimeout(int n) {
        this._timeout = n;
    }

    public synchronized void setPoolManager(ResourcePoolManager resourcePoolManager) {
        if (resourcePoolManager == null) {
            throw new IllegalArgumentException("Argument 'poolManager' is null");
        }
        if (this._poolManager != null) {
            this._poolManager.unmanage();
        }
        this._poolManager = resourcePoolManager;
        this._poolManager.manage(this, true);
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this.getPoolManager().setResourceLimits(resourceLimits);
    }

    public void setRetryAttempts(int n) {
        this._retryAttempts = Math.max(-1, n);
    }
}

