/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OptionalDataException;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.xml.core.XMLDataObjectLook;
import org.netbeans.modules.xml.tree.editor.CustomizerView;
import org.netbeans.modules.xml.tree.editor.TreeEditorSupport;
import org.netbeans.modules.xml.tree.editor.Util;
import org.openide.TopManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class TreeEditorComponent
extends CloneableTopComponent {
    private static final long serialVersionUID = 8465527461926411443L;
    private transient TreeEditorSupport support;
    private static final String MODIFIED_APPENDIX = " *";
    private static final String XML_EDITOR_MODE_BADGE_ICON = "org/netbeans/modules/xml/tree/resources/penbadge.gif";
    private transient Image mergeIcon;
    private transient LocalExplorerPanel explorerPanel;
    private transient Exception trapExc;
    private transient boolean initDone;
    private transient BeanTreeView treeView;
    private transient Node rootNode;

    public TreeEditorComponent() {
        this.trapExc = new RuntimeException("Public constructor of TreeEditorComponent should be called while de-externalization only!!!\nSee http://www.netbeans.org/issues/show_bug.cgi?id=19855 for current status.\nIf you know steps to reproduce it, please add them to the issue report. Thanks a lot.");
        this.initDone = false;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Init TreeEditorComponent -- default constructor!!!", this.trapExc);
        }
    }

    public TreeEditorComponent(TreeEditorSupport support) {
        this.support = support;
        this.init();
        this.dockIntoEditorMode();
    }

    private void init() {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
        XMLDataObjectLook xmlDO = this.getXMLDataObjectLook();
        this.rootNode = new TreeEditorNode(xmlDO.getNodeDelegate());
        InnerListener listener = new InnerListener();
        xmlDO.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)listener, (Object)xmlDO));
        this.rootNode.addPropertyChangeListener((PropertyChangeListener)listener);
        this.rootNode.addNodeListener((NodeListener)listener);
        this.explorerPanel = new LocalExplorerPanel();
        SplittedPanel splittedPanel = new SplittedPanel();
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        this.treeView = new BeanTreeView();
        this.treeView.addPropertyChangeListener(listener);
        CustomizerView customizerView = new CustomizerView();
        treePanel.add((Component)this.treeView, "Center");
        splittedPanel.add((Component)treePanel, SplittedPanel.ADD_LEFT);
        splittedPanel.add((Component)customizerView, SplittedPanel.ADD_RIGHT);
        ((Container)((Object)this.explorerPanel)).setLayout(new BorderLayout());
        ((Container)((Object)this.explorerPanel)).add((Component)splittedPanel, "Center");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)((Object)this.explorerPanel), "Center");
        ExplorerManager explorerManager = this.explorerPanel.getExplorerManager();
        explorerManager.setRootContext(this.rootNode);
        explorerManager.addPropertyChangeListener((PropertyChangeListener)listener);
        TopComponent.Registry reg = TopComponent.getRegistry();
        reg.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)listener, (Object)reg));
        this.updateIcon();
        this.updateName();
        this.initDone = true;
    }

    public void open() {
        super.open();
        if (this.treeView != null) {
            try {
                int recursionLevel = 2;
                this.expandNode(this.rootNode, recursionLevel);
            }
            catch (Exception ex) {
                Util.THIS.debug("Ignoring ex. while auto-expanding XML editor.", ex);
            }
        }
        try {
            this.explorerPanel.getExplorerManager().setSelectedNodes(new Node[]{this.rootNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void expandNode(Node n, int recursionLevel) {
        if (recursionLevel-- <= 0) {
            return;
        }
        this.treeView.expandNode(n);
        Children ch = n.getChildren();
        Enumeration nodes = ch.nodes();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            this.expandNode(node, recursionLevel);
        }
    }

    private void dockIntoEditorMode() {
        Workspace current = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        Mode editorMode = current.findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)this);
        }
    }

    private XMLDataObjectLook getXMLDataObjectLook() {
        return this.support.getXMLDataObjectLook();
    }

    protected void updateName() {
        String name = this.rootNode.getDisplayName();
        if (this.getXMLDataObjectLook().isModified()) {
            this.setName(name + MODIFIED_APPENDIX);
        } else {
            this.setName(name);
        }
    }

    protected boolean closeLast() {
        this.testTrap("closeLast");
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        return true;
    }

    private void updateIcon() {
        this.setIcon(this.createIcon());
    }

    private Image createIcon() {
        if (this.mergeIcon == null) {
            this.mergeIcon = Utilities.loadImage((String)XML_EDITOR_MODE_BADGE_ICON);
        }
        return Utilities.mergeImages((Image)this.rootNode.getIcon(1), (Image)this.mergeIcon, (int)0, (int)0);
    }

    protected void updateTitle() {
    }

    private void testTrap(String context) {
        if (!this.initDone) {
            Util.THIS.getErrorManager().log(16, "TreeEditorSupport." + context + ": It looks somebody call just default constructor and \"forgot\" init(). Who was that?");
            Util.THIS.getErrorManager().notify(16, (Throwable)this.trapExc);
        }
    }

    protected void componentActivated() {
        this.testTrap("componentActivated");
        super.componentActivated();
        this.explorerPanel.componentActivated();
    }

    protected void componentDeactivated() {
        this.testTrap("componentDeactivated");
        super.componentDeactivated();
        this.explorerPanel.componentDeactivated();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.support == null) {
            return null;
        }
        DataObject dataObject = this.support.getDataObject();
        if (!dataObject.isValid()) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Skipping serialization of " + dataObject);
            }
            return null;
        }
        return super.writeReplace();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorComponent.writeExternal()");
        }
        super.writeExternal(out);
        out.writeObject((Object)this.support.getEnv());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tdone.");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorComponent.readExternal();");
        }
        super.readExternal(in);
        try {
            TreeEditorSupport.Env env = (TreeEditorSupport.Env)((Object)in.readObject());
            this.support = env.findTreeEditorSupport();
        }
        catch (OptionalDataException exc) {
            if (exc.eof) {
                return;
            }
            throw exc;
        }
        catch (ClassCastException exc) {
            return;
        }
        if (!((DataObject)this.getXMLDataObjectLook()).isValid()) {
            return;
        }
        this.init();
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.support == null) {
            return null;
        }
        if (this.getXMLDataObjectLook() == null) {
            return null;
        }
        if (!((DataObject)this.getXMLDataObjectLook()).isValid()) {
            return null;
        }
        return this;
    }

    private static class TreeEditorChildren
    extends FilterNode.Children {
        public TreeEditorChildren(Node original) {
            super(original);
        }

        protected Node copyNode(Node node) {
            return new TreeEditorNode(node);
        }
    }

    private static class TreeEditorNode
    extends FilterNode {
        public TreeEditorNode(Node original) {
            super(original, (Children)(original.isLeaf() ? Children.LEAF : new TreeEditorChildren(original)));
        }

        public SystemAction getDefaultAction() {
            if (this.isLeaf()) {
                return super.getDefaultAction();
            }
            return null;
        }
    }

    private static class LocalExplorerPanel
    extends ExplorerPanel {
        private static final long serialVersionUID = 2219619113909147429L;

        private LocalExplorerPanel() {
        }

        protected void componentActivated() {
            super.componentActivated();
        }

        protected void componentDeactivated() {
            super.componentDeactivated();
        }
    }

    private class InnerListener
    extends NodeAdapter
    implements PropertyChangeListener {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private InnerListener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\nTreeEditorComponent::InnerListener::propertyChange: property name = " + ev.getPropertyName());
            }
            if ("selectedNodes".equals(ev.getPropertyName())) {
                TreeEditorComponent.this.setActivatedNodes(((ExplorerManager)ev.getSource()).getSelectedNodes());
                TreeEditorComponent.this.explorerPanel.setActivatedNodes(((ExplorerManager)ev.getSource()).getSelectedNodes());
            } else if ("activatedNodes".equals(ev.getPropertyName())) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("                   ::InnerListener::propertyChange: TopComponent.Registry.PROP_ACTIVATED_NODES");
                }
                Node[] ns = TreeEditorComponent.this.getActivatedNodes();
                DataObject dobj = (DataObject)TreeEditorComponent.this.getXMLDataObjectLook().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = InnerListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (ns != null && ns.length == 0 && dobj != null && dobj.isValid()) {
                    TreeEditorComponent.this.setActivatedNodes(new Node[]{TreeEditorComponent.this.rootNode});
                    TreeEditorComponent.this.explorerPanel.setActivatedNodes(new Node[]{TreeEditorComponent.this.rootNode});
                }
            } else if ("valid".equals(ev.getPropertyName())) {
                if (Boolean.FALSE.equals(ev.getNewValue())) {
                    TreeEditorComponent.this.close();
                }
            } else if ("modified".equals(ev.getPropertyName())) {
                TreeEditorComponent.this.updateName();
            } else if ("name".equals(ev.getPropertyName())) {
                TreeEditorComponent.this.updateName();
            } else if ("icon".equals(ev.getPropertyName())) {
                TreeEditorComponent.this.updateIcon();
            }
        }

        public void nodeDestroyed(NodeEvent ev) {
            TreeEditorComponent.this.getXMLDataObjectLook().setModified(false);
            TreeEditorComponent.this.close();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

