/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.lib;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.modules.xml.tree.lib.GuiUtil;
import org.netbeans.modules.xml.tree.lib.Util;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.openide.nodes.IndexedPropertySupport;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public final class BeanUtil {
    public static boolean hasCustomizer(Object object) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::hasCustomizer: object = " + object);
        }
        if (object == null) {
            return false;
        }
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer: declaringClass = " + object.getClass().getDeclaringClass());
            }
            BeanInfo bi = Introspector.getBeanInfo(object.getClass());
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer: beanInfo = " + bi);
            }
            BeanDescriptor bd = bi.getBeanDescriptor();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer: beanDescriptor = " + bd);
            }
            Class<?> cc = bd.getCustomizerClass();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer: customizerClass = " + cc);
            }
            return cc != null;
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer: exception = " + e);
            }
            return false;
        }
    }

    public static Component getCustomizer(Object object) {
        Object o;
        BeanInfo beanInfo;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::getCustomizer: object = " + object);
        }
        if (object == null) {
            return null;
        }
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer: exception = " + e);
            }
            return null;
        }
        Class<?> clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer: exception = " + e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer: exception = " + e);
            }
            return null;
        }
        if (!(o instanceof Customizer)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer: is NOT instanceof Customizer: " + o);
            }
            return null;
        }
        Customizer cust = (Customizer)o;
        Component comp = null;
        if (!(o instanceof Component)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer: is NOT instanceof Component: " + o);
            }
            return null;
        }
        comp = (Component)o;
        cust.setObject(object);
        return comp;
    }

    public static boolean hasCustomizer(Class classClass, String propertyName) {
        Object peo;
        BeanInfo beanInfo;
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: declaringClass = " + classClass.getDeclaringClass());
            }
            beanInfo = Introspector.getBeanInfo(classClass);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: beanInfo = " + beanInfo);
            }
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: exception = " + e);
            }
            return false;
        }
        PropertyDescriptor[] propDescrs = beanInfo.getPropertyDescriptors();
        PropertyDescriptor propertyDescriptor = null;
        int i = 0;
        while (i < propDescrs.length) {
            if (propertyName.equals(propDescrs[i].getName())) {
                propertyDescriptor = propDescrs[i];
                break;
            }
            ++i;
        }
        if (propertyDescriptor == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: have NOT property: " + propertyName);
            }
            return false;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::hasCustomizer2: propertyDescriptor: " + propertyDescriptor);
        }
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::hasCustomizer2: propertyEditorClass: " + clazz);
        }
        if (clazz == null) {
            return false;
        }
        try {
            peo = clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: exception = " + e);
            }
            return false;
        }
        catch (IllegalAccessException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: exception = " + e);
            }
            return false;
        }
        if (!(peo instanceof PropertyEditor)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::hasCustomizer2: is NOT instanceof PropertyEditor: " + peo);
            }
            return false;
        }
        PropertyEditor editor = (PropertyEditor)peo;
        return editor.supportsCustomEditor();
    }

    public static Component getCustomizer(Class classClass, Object property, String propertyName) {
        Object peo;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(classClass);
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: exception = " + e);
            }
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::getCustomizer2: beaninfo = " + beanInfo);
        }
        PropertyDescriptor[] propDescrs = beanInfo.getPropertyDescriptors();
        PropertyDescriptor propertyDescriptor = null;
        int i = 0;
        while (i < propDescrs.length) {
            if (propertyName.equals(propDescrs[i].getName())) {
                propertyDescriptor = propDescrs[i];
                break;
            }
            ++i;
        }
        if (propertyDescriptor == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: have NOT property: " + propertyName);
            }
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::getCustomizer2: propertyDescriptor: " + propertyDescriptor);
        }
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::getCustomizer2: propertyEditorClass: " + clazz);
        }
        if (clazz == null) {
            return null;
        }
        try {
            peo = clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: exception = " + e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: exception = " + e);
            }
            return null;
        }
        if (!(peo instanceof PropertyEditor)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: is NOT instanceof PropertyEditor: " + peo);
            }
            return null;
        }
        PropertyEditor editor = (PropertyEditor)peo;
        editor.setValue(property);
        Component comp = editor.getCustomEditor();
        if (comp == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: have NOT customizer: " + editor);
            }
            return null;
        }
        if (!(comp instanceof Customizer)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("BeanUtil::getCustomizer2: is NOT instanceof Customizer: " + comp);
            }
            return null;
        }
        Customizer cust = (Customizer)((Object)comp);
        return comp;
    }

    public static Node.Property[][] computeProperties(TreeObject bean, BeanInfo info) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("BeanUtil::computeProperties: bean = " + bean);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::computeProperties: info = " + info);
        }
        ArrayList<TreePropertySupport> property = new ArrayList<TreePropertySupport>();
        ArrayList<TreePropertySupport> expert = new ArrayList<TreePropertySupport>();
        ArrayList<TreePropertySupport> hidden = new ArrayList<TreePropertySupport>();
        PropertyDescriptor[] propertyDescriptor = info.getPropertyDescriptors();
        int k = propertyDescriptor.length;
        int i = 0;
        while (i < k) {
            TreePropertySupport prop;
            String aname;
            Enumeration<String> e;
            TreePropertySupport support;
            PropertyDescriptor p;
            if (propertyDescriptor[i] instanceof IndexedPropertyDescriptor) {
                p = (IndexedPropertyDescriptor)propertyDescriptor[i];
                support = new IndexedPropertySupport((Object)bean, p.getPropertyType(), ((IndexedPropertyDescriptor)p).getIndexedPropertyType(), p.getReadMethod(), p.getWriteMethod(), ((IndexedPropertyDescriptor)p).getIndexedReadMethod(), ((IndexedPropertyDescriptor)p).getIndexedWriteMethod());
                support.setName(p.getName());
                support.setDisplayName(p.getDisplayName());
                support.setShortDescription(p.getShortDescription());
                e = p.attributeNames();
                while (e.hasMoreElements()) {
                    aname = e.nextElement();
                    ((FeatureDescriptor)((Object)support)).setValue(aname, p.getValue(aname));
                }
                prop = support;
            } else {
                p = propertyDescriptor[i];
                support = new TreePropertySupport(bean, p.getPropertyType(), p.getReadMethod(), p.getWriteMethod());
                ((FeatureDescriptor)((Object)support)).setName(p.getName());
                ((FeatureDescriptor)((Object)support)).setDisplayName(p.getDisplayName());
                ((FeatureDescriptor)((Object)support)).setShortDescription(p.getShortDescription());
                support.setPropertyEditorClass(p.getPropertyEditorClass());
                e = p.attributeNames();
                while (e.hasMoreElements()) {
                    aname = e.nextElement();
                    ((FeatureDescriptor)((Object)support)).setValue(aname, p.getValue(aname));
                }
                prop = support;
            }
            Object help = propertyDescriptor[i].getValue("helpID");
            if (help != null && help instanceof String) {
                ((FeatureDescriptor)((Object)prop)).setValue("helpID", help);
            }
            if (propertyDescriptor[i].isHidden()) {
                hidden.add(prop);
            } else if (propertyDescriptor[i].isExpert()) {
                expert.add(prop);
            } else {
                property.add(prop);
            }
            ++i;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::computeProperties: property = " + property);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::computeProperties: expert   = " + expert);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::computeProperties: hidden   = " + hidden);
        }
        Node.Property[][] properties = new Node.Property[3][];
        properties[0] = new Node.Property[property.size()];
        property.toArray(properties[0]);
        properties[1] = new Node.Property[expert.size()];
        expert.toArray(properties[1]);
        properties[2] = new Node.Property[hidden.size()];
        hidden.toArray(properties[2]);
        return properties;
    }

    public static class TreePropertySupport
    extends PropertySupport.Reflection {
        public TreePropertySupport(TreeObject instance, Class valueType, Method getter, Method setter) {
            super((Object)instance, valueType, getter, setter);
        }

        public boolean canWrite() {
            return super.canWrite() && !((TreeObject)this.instance).isReadOnly();
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\n\nBeanUtil::TreePropertySupport::setValue: value = " + value);
                }
                boolean toSet = true;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("        ::                   ::setValue: instance = " + this.instance);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("        ::                   ::setValue: instance.class = " + this.instance.getClass());
                }
                if (this.instance instanceof TreeAttribute) {
                    TreeAttribute attr = (TreeAttribute)this.instance;
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("\nBeanUtil::TreePropertySupport::setValue: value = " + value);
                    }
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("        ::                   ::setValue: getName() = " + ((FeatureDescriptor)((Object)this)).getName());
                    }
                    if ("name".equals(((FeatureDescriptor)((Object)this)).getName())) {
                        String name = (String)value;
                        TreeElement element = attr.getOwnerElement();
                        TreeAttribute oldAttribute = element.getAttribute(name);
                        if (oldAttribute != null) {
                            toSet = GuiUtil.confirmAction(Util.THIS.getString("MSG_replace_attribute", name));
                        }
                    }
                }
                if (toSet) {
                    super.setValue(value);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("        ::TreePropertySupport::setValue: OK");
                    }
                }
            }
            catch (InvocationTargetException exc) {
                Throwable targetExc;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("        ::TreePropertySupport::setValue: InvocationTargetException", new RuntimeException());
                }
                if ((targetExc = exc.getTargetException()) instanceof TreeException) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("        ::TreePropertySupport::setValue: targetException", targetExc);
                    }
                    GuiUtil.notifyTreeException((TreeException)targetExc);
                }
                throw exc;
            }
        }
    }
}

