/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class Formatter
implements SettingsChangeListener {
    private static Map kitClass2Formatter = new HashMap();
    private static final int ISC_MAX_TAB_SIZE = 16;
    private static final int ISC_MAX_INDENT_SIZE = 32;
    private static final String[][] indentStringCache = new String[16][];
    private final Class kitClass;
    private boolean inited;
    private int tabSize;
    private boolean customTabSize;
    private Integer shiftWidth;
    private boolean customShiftWidth;
    private boolean expandTabs;
    private boolean customExpandTabs;
    private int spacesPerTab;
    private boolean customSpacesPerTab;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;

    public static synchronized Formatter getFormatter(Class clazz) {
        Formatter formatter = (Formatter)kitClass2Formatter.get(clazz);
        if (formatter == null) {
            formatter = BaseKit.getKit(clazz).createFormatter();
            kitClass2Formatter.put(clazz, formatter);
        }
        return formatter;
    }

    public static synchronized void setFormatter(Class clazz, Formatter formatter) {
        kitClass2Formatter.put(clazz, formatter);
    }

    public Formatter(Class clazz) {
        this.kitClass = clazz;
        Settings.addSettingsChangeListener(this);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Object object;
        String string;
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (!(this.inited && string != null && !"tab-size".equals(string) || this.customTabSize)) {
            this.tabSize = SettingsUtil.getInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if (!this.customShiftWidth && (object = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)object;
        }
        if (!(this.inited && string != null && !"expand-tabs".equals(string) || this.customExpandTabs)) {
            this.expandTabs = SettingsUtil.getBoolean(this.kitClass, "expand-tabs", SettingsDefaults.defaultExpandTabs);
        }
        if (!(this.inited && string != null && !"spaces-per-tab".equals(string) || this.customSpacesPerTab)) {
            this.spacesPerTab = SettingsUtil.getInteger(this.kitClass, "spaces-per-tab", SettingsDefaults.defaultSpacesPerTab);
        }
        this.inited = true;
    }

    public int getTabSize() {
        if (!this.customTabSize && !this.inited) {
            this.settingsChange(null);
        }
        return this.tabSize;
    }

    public void setTabSize(int n) {
        this.customTabSize = true;
        this.tabSize = n;
    }

    public int getShiftWidth() {
        if (!this.customShiftWidth && !this.inited) {
            this.settingsChange(null);
        }
        return this.shiftWidth != null ? this.shiftWidth.intValue() : this.getSpacesPerTab();
    }

    public void setShiftWidth(int n) {
        this.customShiftWidth = true;
        if (this.shiftWidth == null || this.shiftWidth != n) {
            this.shiftWidth = new Integer(n);
        }
    }

    public boolean expandTabs() {
        if (!this.customExpandTabs && !this.inited) {
            this.settingsChange(null);
        }
        return this.expandTabs;
    }

    public void setExpandTabs(boolean bl) {
        this.customExpandTabs = true;
        this.expandTabs = bl;
    }

    public int getSpacesPerTab() {
        if (!this.customSpacesPerTab && !this.inited) {
            this.settingsChange(null);
        }
        return this.spacesPerTab;
    }

    public void setSpacesPerTab(int n) {
        this.customSpacesPerTab = true;
        this.spacesPerTab = n;
    }

    static String getIndentString(int n, boolean bl, int n2) {
        if (n <= 0) {
            return "";
        }
        if (bl) {
            n2 = 0;
        }
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = Formatter.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            boolean bl2 = n2 >= indentStringCache.length || n > 32;
            String string = null;
            String[] stringArray = null;
            if (!bl2) {
                stringArray = indentStringCache[n2];
                if (stringArray == null) {
                    stringArray = new String[32];
                    Formatter.indentStringCache[n2] = stringArray;
                }
                string = stringArray[n - 1];
            }
            if (string == null) {
                string = Analyzer.getIndentString(n, bl, n2);
                if (!bl2) {
                    stringArray[n - 1] = string;
                }
            }
            String string2 = string;
            return string2;
        }
    }

    public String getIndentString(BaseDocument baseDocument, int n) {
        return Formatter.getIndentString(n, this.expandTabs(), baseDocument.getTabSize());
    }

    public String getIndentString(int n) {
        return Formatter.getIndentString(n, this.expandTabs(), this.getTabSize());
    }

    public void insertTabString(BaseDocument baseDocument, int n) throws BadLocationException {
        baseDocument.atomicLock();
        try {
            int n2 = Utilities.getRowStart(baseDocument, n);
            int n3 = Utilities.getFirstNonWhiteBwd(baseDocument, n, n2);
            n3 = n3 >= 0 ? n3 + 1 : n2;
            int n4 = Utilities.getVisualColumn(baseDocument, n3);
            int n5 = Utilities.getNextTabColumn(baseDocument, n);
            String string = Analyzer.getWhitespaceString(n4, n5, this.expandTabs(), baseDocument.getTabSize());
            char[] cArray = baseDocument.getChars(n3, n - n3);
            int n6 = 0;
            while (n6 < cArray.length && cArray[n6] == string.charAt(n6)) {
                ++n6;
            }
            baseDocument.remove(n3 += n6, n - n3);
            baseDocument.insertString(n3, string.substring(n6), null);
            Object var11_10 = null;
            baseDocument.atomicUnlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            baseDocument.atomicUnlock();
            throw throwable;
        }
    }

    public void changeRowIndent(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        baseDocument.atomicLock();
        try {
            int n3;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n3 = Utilities.getRowFirstNonWhite(baseDocument, n)) == -1) {
                n3 = Utilities.getRowEnd(baseDocument, n);
            }
            int n4 = Utilities.getRowStart(baseDocument, n);
            baseDocument.remove(n4, n3 - n4);
            baseDocument.insertString(n4, this.getIndentString(baseDocument, n2), null);
            Object var7_6 = null;
            baseDocument.atomicUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            baseDocument.atomicUnlock();
            throw throwable;
        }
    }

    public void changeBlockIndent(BaseDocument baseDocument, int n, int n2, int n3) throws BadLocationException {
        int n4;
        GuardedDocument guardedDocument;
        GuardedDocument guardedDocument2 = guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
        if (guardedDocument != null) {
            n4 = n;
            while (n4 < n2) {
                if (guardedDocument.isPosGuarded(n4)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ++n4;
            }
        }
        baseDocument.atomicLock();
        try {
            n4 = n3 * baseDocument.getShiftWidth();
            if (n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2) {
                --n2;
            }
            int n5 = Utilities.getRowStart(baseDocument, n);
            int n6 = Utilities.getRowCount(baseDocument, n, n2);
            while (n6 > 0) {
                int n7 = Utilities.getRowIndent(baseDocument, n5);
                if (Utilities.isRowWhite(baseDocument, n5)) {
                    n7 = -n4;
                }
                this.changeRowIndent(baseDocument, n5, Math.max(n7 + n4, 0));
                n5 = Utilities.getRowStart(baseDocument, n5, 1);
                --n6;
            }
            Object var11_10 = null;
            baseDocument.atomicUnlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            baseDocument.atomicUnlock();
            throw throwable;
        }
    }

    public void shiftLine(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        int n2 = baseDocument.getShiftWidth();
        if (!bl) {
            n2 = -n2;
        }
        n2 = Utilities.isRowWhite(baseDocument, n) ? (n2 += Utilities.getVisualColumn(baseDocument, n)) : (n2 += Utilities.getRowIndent(baseDocument, n));
        n2 = Math.max(n2, 0);
        this.changeRowIndent(baseDocument, n, n2);
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            Writer writer = this.createWriter(baseDocument, n, charArrayWriter);
            writer.write(baseDocument.getChars(n, n2 - n));
            writer.close();
            String string = new String(charArrayWriter.toCharArray());
            baseDocument.remove(n, n2 - n);
            baseDocument.insertString(n, string, null);
            return string.length();
        }
        catch (IOException iOException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                iOException.printStackTrace();
            }
            return 0;
        }
    }

    public int indentLine(Document document, int n) {
        return n;
    }

    public int indentNewLine(Document document, int n) {
        block3: {
            try {
                document.insertString(n, "\n", null);
                ++n;
            }
            catch (GuardedException guardedException) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                badLocationException.printStackTrace();
            }
        }
        return n;
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return writer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

