/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.HTMLJavaDocView;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JavaCompletion;

public class CompletionJavaDoc
implements ActionListener,
SettingsChangeListener,
PropertyChangeListener {
    protected ExtEditorUI extEditorUI;
    private List history = new ArrayList(5);
    private int curHistoryItem = -1;
    private JavaDocPane pane;
    private JavaDocView view;
    private int javaDocDelay;
    private Timer timer;
    protected Object currentContent;
    private ListSelectionListener completionListener;
    private boolean javaDocAutoPopup;
    private CaretListener caretL;
    public static final String BUNDLE_PREFIX = "javadoc-tag-";
    public static final String LOADING = "javadoc-loading";
    private static ArrayList omittedTags = new ArrayList();

    public CompletionJavaDoc(ExtEditorUI extEditorUI) {
        Object object;
        this.extEditorUI = extEditorUI;
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        this.javaDocDelay = this.getJavaDocDelay();
        this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        final ExtEditorUI extEditorUI2 = extEditorUI;
        this.completionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CompletionJavaDoc completionJavaDoc;
                        Completion completion = 1.access$000(this.this$1).getCompletion();
                        if (completion != null && completion.isPaneVisible() && (completionJavaDoc = 1.access$000(this.this$1).getCompletionJavaDoc()) != null) {
                            if (completionJavaDoc.autoPopup()) {
                                completionJavaDoc.setContent(LocaleSupport.getString("javadoc-loading"));
                                1.access$100(this.this$1).clearHistory();
                                completionJavaDoc.setContent(completion.getSelectedValue());
                                1.access$100(this.this$1).addToHistory(completion.getSelectedValue());
                            } else {
                                completionJavaDoc.setContent(null);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ ExtEditorUI access$000(1 var0) {
                return var0.extEditorUI2;
            }

            static /* synthetic */ CompletionJavaDoc access$100(1 var0) {
                return var0.CompletionJavaDoc.this;
            }
        };
        Completion completion = extEditorUI.getCompletion();
        if (completion != null && completion.getView() instanceof JList) {
            object = (JList)((Object)completion.getView());
            ((JList)object).addListSelectionListener(this.completionListener);
        }
        this.caretL = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                Completion completion = extEditorUI2.getCompletion();
                if (completion != null && !completion.isPaneVisible()) {
                    CompletionJavaDoc.this.setJavaDocVisible(false);
                }
            }
        };
        object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jTextComponent != null) {
                jTextComponent.addCaretListener(this.caretL);
            } else {
                jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                if (jTextComponent != null) {
                    jTextComponent.removeCaretListener(this.caretL);
                }
            }
        }
    }

    private JDCPopupPanel getJDCPopupPanel() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanel();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanel().getJavaDocPane();
        }
        if (this.pane == null) {
            this.pane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.pane;
    }

    public JavaDocView getJavaDocView() {
        if (this.view == null) {
            this.view = new HTMLJavaDocView(this.getJavaDocBGColor());
        }
        return this.view;
    }

    public void setJavaDocVisible(final boolean bl) {
        final JDCPopupPanel jDCPopupPanel = this.getJDCPopupPanel();
        if (jDCPopupPanel != null) {
            this.getJavaDocPane().setShowWebEnabled(this.isExternalJavaDocMounted());
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jDCPopupPanel.setJavaDocVisible(bl);
                    }
                });
            } else {
                jDCPopupPanel.setJavaDocVisible(bl);
            }
        }
    }

    public synchronized void addToHistory(Object object) {
        int n = this.history.size();
        int n2 = this.curHistoryItem + 1;
        while (n2 < n) {
            this.history.remove(this.history.size() - 1);
            ++n2;
        }
        this.history.add(object);
        this.curHistoryItem = this.history.size() - 1;
        if (this.curHistoryItem > 0) {
            this.getJavaDocPane().setBackEnabled(true);
        }
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public synchronized void backHistory() {
        if (this.curHistoryItem > 0) {
            --this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false);
            if (this.curHistoryItem == 0) {
                this.getJavaDocPane().setBackEnabled(false);
            }
            this.getJavaDocPane().setForwardEnabled(true);
        }
    }

    public synchronized void forwardHistory() {
        if (this.curHistoryItem < this.history.size() - 1) {
            ++this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false);
            if (this.curHistoryItem == this.history.size() - 1) {
                this.getJavaDocPane().setForwardEnabled(false);
            }
            this.getJavaDocPane().setBackEnabled(true);
        }
    }

    public synchronized void clearHistory() {
        this.curHistoryItem = -1;
        this.history.clear();
        this.getJavaDocPane().setBackEnabled(false);
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public boolean isVisible() {
        return this.getJavaDocPane().getComponent().isVisible();
    }

    public void cancelPerformingThread() {
        this.timer.stop();
    }

    public synchronized void setContent(Object object, boolean bl) {
        this.timer.stop();
        if (object == null) {
            this.setJavaDocVisible(false);
            return;
        }
        this.currentContent = object;
        if (bl) {
            this.timer.setInitialDelay(this.javaDocDelay);
            this.timer.setDelay(this.javaDocDelay);
            this.timer.start();
        } else {
            this.actionPerformed(null);
        }
    }

    public void setContent(Object object) {
        this.setContent(object, true);
    }

    public void setContent(String string) {
        if (string == null) {
            this.setJavaDocVisible(false);
            return;
        }
        this.getJavaDocView().setContent(string);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
    }

    private Color getJavaDocBGColor() {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            return (Color)SettingsUtil.getValue(clazz, "javadoc-bg-color", ExtSettingsDefaults.defaultJavaDocBGColor);
        }
        return ExtSettingsDefaults.defaultJavaDocBGColor;
    }

    private int getJavaDocDelay() {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            return (Integer)SettingsUtil.getValue(clazz, "javadoc-auto-popup-delay", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopupDelay;
    }

    private boolean getJavaDocAutoPopup() {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            return (Boolean)SettingsUtil.getValue(clazz, "javadoc-auto-popup", ExtSettingsDefaults.defaultJavaDocAutoPopup);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopup;
    }

    public boolean autoPopup() {
        return this.javaDocAutoPopup;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if ("javadoc-bg-color".equals(settingsChangeEvent.getSettingName())) {
            this.getJavaDocView().setBGColor(this.getJavaDocBGColor());
        }
        if ("javadoc-auto-popup-delay".equals(settingsChangeEvent.getSettingName())) {
            this.javaDocDelay = this.getJavaDocDelay();
        }
        if ("javadoc-auto-popup".equals(settingsChangeEvent.getSettingName())) {
            this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        }
    }

    public String prepareJavaDocContent(JCClass jCClass, String string, String string2) {
        return this.prepareJavaDocContent(jCClass, string, string2, null);
    }

    public boolean isOmittedJavaDocTag(String string) {
        return omittedTags.contains(string);
    }

    public Object parseLink(String string, JCClass jCClass) {
        return null;
    }

    protected boolean isNotFullyQualifiedInnerClass(String string, JCClass jCClass) {
        if (string.indexOf(".") != string.lastIndexOf(".")) {
            return false;
        }
        String string2 = jCClass.getPackageName();
        return JavaCompletion.getFinder().getExactClass(string2.length() > 0 ? string2 + "." + string : string) != null;
    }

    protected String findProperClass(String string, JCClass jCClass) {
        if (jCClass == null) {
            return null;
        }
        String string2 = null;
        JCClass jCClass2 = jCClass.getPackageName() != null && jCClass.getPackageName().length() > 0 ? JavaCompletion.getFinder().getExactClass(jCClass.getPackageName() + "." + string) : JavaCompletion.getFinder().getExactClass(string);
        if (jCClass2 != null) {
            return jCClass2.getFullName();
        }
        List list = JavaCompletion.getFinder().findClasses(null, string, true);
        if (list.size() > 0) {
            string2 = ((JCClass)list.get(0)).getFullName();
        }
        return string2;
    }

    public String createAnchor(String string, JCClass jCClass) {
        String string2 = "";
        String string3 = "";
        int n = string.lastIndexOf(")");
        boolean bl = this.parseLink(string, jCClass) != null;
        int n2 = string.indexOf(" ", n);
        if (n2 > 0) {
            string3 = string.substring(n2 + 1);
        }
        if (string.startsWith("#")) {
            string2 = bl ? "<a href='" + jCClass.getFullName() + (string3.length() > 0 ? string.substring(0, n2 - 1) : string) + "'><code>" + (string3.length() > 0 ? string3 : string.substring(1)) + "</code></a>" : "<code>" + (string3.length() > 0 ? string3 : string.substring(1)) + "</code>";
        } else if (bl) {
            String string4;
            String string5 = string4 = string3.length() > 0 ? string.substring(0, n2) : string;
            if (string4.indexOf(".") < 0 || this.isNotFullyQualifiedInnerClass(string4, jCClass)) {
                String string6 = string4.indexOf("#") > 0 ? string4.substring(0, string4.indexOf("#")) : string4;
                String string7 = string4.indexOf("#") > 0 ? string4.substring(string4.indexOf("#") + 1) : "";
                String string8 = this.findProperClass(string6, jCClass);
                if (string8 != null) {
                    string4 = string7.length() > 0 ? string8 + "#" + string7 : string8;
                } else {
                    return "<a href='" + string4 + "'><code>" + (string3.length() > 0 ? string3 : string.replace('#', '.')) + "</code></a>";
                }
            }
            string2 = "<a href='" + string4 + "'><code>" + (string3.length() > 0 ? string3 : string.replace('#', '.')) + "</code></a>";
        } else {
            string2 = "<code>" + (string3.length() > 0 ? string3 : string.replace('#', '.')) + "</code>";
        }
        return string2;
    }

    public String createLinks(String string, JCClass jCClass) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{");
        String string2 = "";
        boolean bl = false;
        try {
            while (true) {
                string2 = stringTokenizer.nextToken("{");
                String string3 = stringTokenizer.nextToken("}");
                bl = false;
                if (string3.indexOf("@link ") > 0) {
                    int n = string3.indexOf("@link ") + 6;
                    if (string2.startsWith("}")) {
                        string2 = string2.substring(1);
                    }
                    string3 = this.createAnchor(string3.substring(n), jCClass);
                    bl = true;
                }
                stringBuffer.append(string2);
                stringBuffer.append(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (bl && string2.startsWith("}")) {
                string2 = string2.substring(1);
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }

    public String prepareJavaDocContent(JCClass jCClass, String string, String string2, JavaDocTagItem[] javaDocTagItemArray) {
        StringBuffer stringBuffer;
        block19: {
            string2 = string2 != null ? this.createLinks(string2, jCClass) : "";
            stringBuffer = new StringBuffer();
            stringBuffer.insert(0, "<font size='+0'><b>" + this.createAnchor(jCClass.getFullName(), jCClass) + "</b></font>");
            if (string.length() > 0) {
                stringBuffer.append("<pre>" + string + "</pre>");
            }
            stringBuffer.append("<blockquote>" + string2 + "</blockquote>");
            if (javaDocTagItemArray == null) break block19;
            Arrays.sort(javaDocTagItemArray);
            String string3 = "";
            int n = 0;
            int n2 = 0;
            while (n2 < javaDocTagItemArray.length) {
                block21: {
                    String string4;
                    block20: {
                        if (string3.equals(javaDocTagItemArray[n2].getName())) break block20;
                        if (this.isOmittedJavaDocTag(javaDocTagItemArray[n2].getName())) break block21;
                        if (!string3.equals("")) {
                            stringBuffer.append("</blockquote>");
                        }
                        stringBuffer.append("<b>" + LocaleSupport.getString(BUNDLE_PREFIX + javaDocTagItemArray[n2].getName(), javaDocTagItemArray[n2].getName()) + "</b><blockquote>");
                        string3 = javaDocTagItemArray[n2].getName();
                        n = 0;
                    }
                    if (n > 0) {
                        stringBuffer.append("<br>");
                    }
                    if (string3.equals("@param")) {
                        string4 = javaDocTagItemArray[n2].getText();
                        int n3 = string4.indexOf(" ");
                        if (n3 > 0) {
                            stringBuffer.append("<code>" + string4.substring(0, n3) + "</code> - " + string4.substring(n3));
                        } else {
                            stringBuffer.append(string4);
                        }
                    } else if (string3.equals("@see")) {
                        string4 = javaDocTagItemArray[n2].getText();
                        if (string4.startsWith("\"")) {
                            if ((string4 = string4.substring(1)).endsWith("\"")) {
                                string4 = string4.substring(0, string4.length() - 1);
                            }
                            stringBuffer.append(string4);
                        } else if (string4.startsWith("<")) {
                            stringBuffer.append(string4);
                        } else {
                            stringBuffer.append(this.createAnchor(javaDocTagItemArray[n2].getText(), jCClass));
                        }
                    } else {
                        stringBuffer.append(this.createLinks(javaDocTagItemArray[n2].getText(), jCClass));
                    }
                    ++n;
                }
                ++n2;
            }
            if (!string3.equals("")) {
                stringBuffer.append("</blockquote>");
            }
        }
        return stringBuffer.toString();
    }

    public void goToSource() {
    }

    public void openInExternalBrowser() {
    }

    public boolean isExternalJavaDocMounted() {
        return false;
    }

    static {
        omittedTags.add("@serial");
        omittedTags.add("@serialField");
        omittedTags.add("@serialData");
        omittedTags.add("@author");
        omittedTags.add("@version");
        omittedTags.add("@since");
        omittedTags.add("@beaninfo");
    }

    public static interface JavaDocTagItem
    extends Comparable {
        public String getName();

        public String getText();
    }
}

