/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Utilities;

public class ExtFinderFactory {

    public static abstract class LineBlocksFinder
    extends FinderFactory.AbstractBlocksFinder {
        private char[] lineBuffer = Analyzer.EMPTY_CHAR_ARRAY;
        private int lineLen;
        private int origStartPos;
        private int origLimitPos;

        public int adjustStartPos(BaseDocument baseDocument, int n) {
            this.origStartPos = n;
            try {
                return Utilities.getRowStart(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int adjustLimitPos(BaseDocument baseDocument, int n) {
            this.origLimitPos = n;
            try {
                return Utilities.getRowEnd(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (true) {
                int n7;
                int n8;
                boolean bl;
                boolean bl2 = bl = (n8 = Analyzer.findFirstLFOffset(cArray, n6, n3 - n6)) >= 0;
                if (!bl) {
                    n8 = n3;
                }
                if ((n7 = this.lineFound(cArray, n6, n8, Math.max(this.origStartPos - n, n6), Math.min(this.origLimitPos - n, n8))) >= 0) {
                    this.found = true;
                    return n + n6 + n7;
                }
                if (!bl) break;
                n6 = n8 + 1;
            }
            return n + n3;
        }

        protected abstract int lineFound(char[] var1, int var2, int var3, int var4, int var5);
    }

    public static abstract class LineBwdFinder
    extends FinderFactory.AbstractFinder {
        private char[] lineBuffer = Analyzer.EMPTY_CHAR_ARRAY;
        private int lineLen;
        private int origStartPos;
        private int origLimitPos;

        public int adjustStartPos(BaseDocument baseDocument, int n) {
            this.origStartPos = n;
            try {
                return Utilities.getRowEnd(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int adjustLimitPos(BaseDocument baseDocument, int n) {
            this.origLimitPos = n;
            try {
                return Utilities.getRowStart(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n + 1;
            while (true) {
                int n7;
                boolean bl = false;
                int n8 = n6;
                while (n8 > n2) {
                    if (cArray[--n8] != '\n') continue;
                    bl = true;
                    ++n8;
                    break;
                }
                if (!bl) {
                    n8 = n2;
                }
                if ((n7 = this.lineFound(cArray, n8, n6, Math.max(this.origLimitPos - n, n8), Math.min(this.origStartPos - n, n6))) >= 0) {
                    this.found = true;
                    return n + n6 + n7;
                }
                if (!bl) break;
                n6 = n8 - 1;
            }
            return n + n2 - 1;
        }

        protected abstract int lineFound(char[] var1, int var2, int var3, int var4, int var5);
    }

    public static abstract class LineFwdFinder
    extends FinderFactory.AbstractFinder {
        private char[] lineBuffer = Analyzer.EMPTY_CHAR_ARRAY;
        private int lineLen;
        private int origStartPos;
        private int origLimitPos;

        public int adjustStartPos(BaseDocument baseDocument, int n) {
            this.origStartPos = n;
            try {
                return Utilities.getRowStart(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int adjustLimitPos(BaseDocument baseDocument, int n) {
            this.origLimitPos = n;
            try {
                return Utilities.getRowEnd(baseDocument, n);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (true) {
                int n7;
                int n8;
                boolean bl;
                boolean bl2 = bl = (n8 = Analyzer.findFirstLFOffset(cArray, n6, n3 - n6)) >= 0;
                if (!bl) {
                    n8 = n3;
                }
                if ((n7 = this.lineFound(cArray, n6, n8, Math.max(this.origStartPos - n, n6), Math.min(this.origLimitPos - n, n8))) >= 0) {
                    this.found = true;
                    return n + n6 + n7;
                }
                if (!bl) break;
                n6 = n8 + 1;
            }
            return n + n3;
        }

        protected abstract int lineFound(char[] var1, int var2, int var3, int var4, int var5);
    }
}

