/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaImport;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaSyntaxSupport
extends ExtSyntaxSupport {
    static final int INIT = 0;
    static final int AFTER_TYPE = 1;
    static final int AFTER_VARIABLE = 2;
    static final int AFTER_COMMA = 3;
    static final int AFTER_DOT = 4;
    static final int AFTER_TYPE_LSB = 5;
    static final int AFTER_MATCHING_VARIABLE_LSB = 6;
    static final int AFTER_MATCHING_VARIABLE = 7;
    static final int AFTER_EQUAL = 8;
    private static final TokenID[] COMMENT_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT};
    private static final TokenID[] BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL};
    private static final char[] COMMAND_SEPARATOR_CHARS = new char[]{';', '{', '}'};
    private JavaImport javaImport;

    public JavaSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        this.tokenNumericIDsValid = true;
        this.javaImport = new JavaImport();
    }

    protected void documentModified(DocumentEvent documentEvent) {
        super.documentModified(documentEvent);
        this.javaImport.documentModifiedAtPosition(documentEvent.getOffset());
    }

    public TokenID[] getCommentTokens() {
        return COMMENT_TOKENS;
    }

    public TokenID[] getBracketSkipTokens() {
        return BRACKET_SKIP_TOKENS;
    }

    public int getLastCommandSeparator(int n) throws BadLocationException {
        TextBatchProcessor textBatchProcessor = new TextBatchProcessor(){

            public int processTextBatch(BaseDocument baseDocument, int n, int n2, boolean bl) {
                try {
                    int[] nArray = JavaSyntaxSupport.this.getCommentBlocks(n2, n);
                    FinderFactory.CharArrayBwdFinder charArrayBwdFinder = new FinderFactory.CharArrayBwdFinder(COMMAND_SEPARATOR_CHARS);
                    return JavaSyntaxSupport.this.findOutsideBlocks(charArrayBwdFinder, n, n2, nArray);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return -1;
                }
            }
        };
        return this.getDocument().processText(textBatchProcessor, n, 0);
    }

    public JCClass getClassFromName(String string, boolean bl) {
        this.refreshJavaImport();
        JCClass jCClass = JavaCompletion.getPrimitiveClass(string);
        if (jCClass == null) {
            jCClass = this.javaImport.getClazz(string);
        }
        if (jCClass == null && bl) {
            if (this.isUnknownImport(string)) {
                return null;
            }
            List list = JavaCompletion.getFinder().findClasses(null, string, true);
            if (list != null && list.size() > 0 && list.size() > 0) {
                jCClass = (JCClass)list.get(0);
            }
        }
        return jCClass;
    }

    protected boolean isUnknownImport(String string) {
        return this.javaImport.isUnknownImport(string);
    }

    protected List getUnknownImports() {
        return this.javaImport.getUnknownImports();
    }

    public boolean isImported(JCClass jCClass) {
        return this.javaImport.isImported(jCClass);
    }

    public void refreshJavaImport() {
        this.javaImport.update(this.getDocument());
    }

    protected void refreshClassInfo() {
    }

    public JCClass getClass(int n) {
        return null;
    }

    public boolean isStaticBlock(int n) {
        return false;
    }

    protected ExtSyntaxSupport.DeclarationTokenProcessor createDeclarationTokenProcessor(String string, int n, int n2) {
        return new JavaDeclarationTokenProcessor(this, string);
    }

    protected ExtSyntaxSupport.VariableMapTokenProcessor createVariableMapTokenProcessor(int n, int n2) {
        return new JavaDeclarationTokenProcessor(this, null);
    }

    private boolean insideMethod(JTextComponent jTextComponent, int n) {
        try {
            int n2 = 0;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n3 = n - 1;
            while (n3 > 0) {
                char c = baseDocument.getChars(n3, 1)[0];
                if (c == ';') {
                    return false;
                }
                if (c == ')') {
                    ++n2;
                }
                if (c == '(') {
                    if (n2 == 0) {
                        return true;
                    }
                    --n2;
                }
                --n3;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        if (!bl) {
            int n = jTextComponent.getCaret().getDot();
            switch (string.charAt(0)) {
                case ' ': {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (n < 2) break;
                    int n2 = Math.max(n - 8, 0);
                    try {
                        String string2 = baseDocument.getText(n2, n - n2);
                        if (string2.endsWith("new ") && string2.length() > 4 && !Character.isJavaIdentifierPart(string2.charAt(string2.length() - 5))) {
                            return 0;
                        }
                        if (string2.endsWith("import ") && !Character.isJavaIdentifierPart(string2.charAt(0))) {
                            return 0;
                        }
                        if (string2.endsWith(", ") && this.insideMethod(jTextComponent, n)) {
                            return 0;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                case '.': {
                    return 0;
                }
                case ',': {
                    if (!this.insideMethod(jTextComponent, n)) break;
                    return 0;
                }
            }
            return 1;
        }
        switch (string.charAt(0)) {
            case ';': 
            case '=': 
            case '{': {
                return 4;
            }
        }
        return 3;
    }

    public static class JavaDeclarationTokenProcessor
    implements ExtSyntaxSupport.DeclarationTokenProcessor,
    ExtSyntaxSupport.VariableMapTokenProcessor {
        protected JavaSyntaxSupport sup;
        int decStartPos = -1;
        int decArrayDepth;
        int typeStartPos;
        int typeEndPos;
        int decVarNameOffset;
        int decVarNameLen;
        int parenthesisCounter;
        int arrayDepth;
        char[] buffer;
        int bufferStartPos;
        String varName;
        int state;
        HashMap varMap;

        public JavaDeclarationTokenProcessor(JavaSyntaxSupport javaSyntaxSupport, String string) {
            this.sup = javaSyntaxSupport;
            this.varName = string;
            if (string == null) {
                this.varMap = new HashMap();
            }
        }

        public int getDeclarationPosition() {
            return this.decStartPos;
        }

        public Map getVariableMap() {
            return this.varMap;
        }

        private void processDeclaration() {
            if (this.varName == null) {
                Object object;
                String string = new String(this.buffer, this.typeStartPos - this.bufferStartPos, this.typeEndPos - this.typeStartPos);
                if (string.indexOf(32) >= 0) {
                    string = Analyzer.removeSpaces(string);
                }
                String string2 = new String(this.buffer, this.decVarNameOffset, this.decVarNameLen);
                JCClass jCClass = null;
                JCClass jCClass2 = this.sup.getClass(this.decVarNameOffset);
                if (jCClass2 != null) {
                    object = jCClass2.getFullName();
                    jCClass = JavaCompletion.getFinder().getExactClass((String)object + "." + string);
                    if (jCClass != null) {
                        this.varMap.put(string2, JavaCompletion.getType(jCClass, this.decArrayDepth));
                    }
                }
                if (jCClass == null && (object = this.sup.getClassFromName(string, true)) != null) {
                    this.varMap.put(string2, JavaCompletion.getType((JCClass)object, this.decArrayDepth));
                }
            } else {
                this.decStartPos = this.typeStartPos;
            }
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            int n3 = this.bufferStartPos + n;
            if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
                this.state = 0;
                return true;
            }
            block0 : switch (tokenID.getNumericID()) {
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.typeStartPos = n3;
                    this.arrayDepth = 0;
                    this.typeEndPos = n3 + n2;
                    this.state = 1;
                    break;
                }
                case 48: {
                    switch (this.state) {
                        case 1: {
                            this.state = 4;
                            this.typeEndPos = n3 + n2;
                            break block0;
                        }
                        case 2: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 55: {
                    switch (this.state) {
                        case 1: {
                            this.state = 5;
                            ++this.arrayDepth;
                            break block0;
                        }
                        case 7: {
                            this.state = 6;
                            ++this.decArrayDepth;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 56: {
                    switch (this.state) {
                        case 5: {
                            this.state = 1;
                            break block0;
                        }
                        case 6: {
                            this.state = 7;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 53: {
                    ++this.parenthesisCounter;
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 54: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 57: 
                case 58: {
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    this.state = 0;
                    break;
                }
                case 49: {
                    if (this.parenthesisCounter > 0) {
                        if (this.parenthesisCounter == 1 && this.state == 7) {
                            this.processDeclaration();
                        }
                        if (this.state == 8) break;
                        this.state = 0;
                        break;
                    }
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: 
                        case 8: {
                            this.state = 3;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 95: {
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 17: {
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: {
                            this.state = 8;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 51: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    switch (this.state) {
                        case 1: 
                        case 3: {
                            if (this.varName == null || Analyzer.equals(this.varName, this.buffer, n, n2)) {
                                this.decArrayDepth = this.arrayDepth;
                                this.decVarNameOffset = n;
                                this.decVarNameLen = n2;
                                this.state = 7;
                                break block0;
                            }
                            this.state = 2;
                            break block0;
                        }
                        case 2: {
                            this.state = 0;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                        case 4: {
                            this.typeEndPos = n3 + n2;
                            this.state = 1;
                            break block0;
                        }
                        case 0: {
                            this.typeStartPos = n3;
                            this.arrayDepth = 0;
                            this.typeEndPos = n3 + n2;
                            this.state = 1;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
            }
            return true;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }
    }
}

