/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$DependencyChecker == null ? (class$org$netbeans$modules$autoupdate$DependencyChecker = DependencyChecker.class$("org.netbeans.modules.autoupdate.DependencyChecker")) : class$org$netbeans$modules$autoupdate$DependencyChecker));
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$DependencyChecker;

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate moduleUpdate, Enumeration enumeration, List list, StringBuffer stringBuffer) {
        ArrayList arrayList = new ArrayList();
        this.checkDependencies(moduleUpdate.getRemoteModule(), arrayList, enumeration, list, stringBuffer);
        return arrayList;
    }

    Collection modulesToRemove(ModuleUpdate moduleUpdate, ModuleUpdate moduleUpdate2) {
        ArrayList arrayList = new ArrayList();
        this.checkReverseDependencies(moduleUpdate.getRemoteModule(), arrayList, moduleUpdate2);
        return arrayList;
    }

    boolean checkDependencies(ModuleInfo moduleInfo, Collection collection, Enumeration enumeration, List list, StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2;
        Set set = moduleInfo.getDependencies();
        Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
        boolean[] blArray = new boolean[dependencyArray.length];
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        int n2 = 0;
        while (n2 < dependencyArray.length) {
            stringBuffer2 = null;
            if (dependencyArray[n2].getType() == 1 || dependencyArray[n2].getType() == 5) {
                ModuleUpdate moduleUpdate;
                boolean bl = false;
                n = 0;
                while (n < moduleInfoArray.length) {
                    bl = this.checkModuleDependency(dependencyArray[n2], moduleInfoArray[n]);
                    if (bl) break;
                    ++n;
                }
                if (!bl) {
                    int n3 = 0;
                    while (n3 < moduleInfoArray2.length) {
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleInfoArray2[n3]);
                        if (bl) break;
                        ++n3;
                    }
                }
                if (!bl && enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ModuleUpdate moduleUpdate2 = (ModuleUpdate)enumeration.nextElement();
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleUpdate2.getRemoteModule());
                        if (!bl) continue;
                        if (collection.contains(moduleUpdate2)) break;
                        collection.add(moduleUpdate2);
                        break;
                    }
                }
                if (!bl && list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        moduleUpdate = (ModuleUpdate)iterator.next();
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleUpdate.getRemoteModule());
                        if (!bl) continue;
                        if (collection.contains(moduleUpdate)) break;
                        collection.add(moduleUpdate);
                        break;
                    }
                }
                if (!bl) {
                    Iterator iterator = Wizard.getAllModules().iterator();
                    while (iterator.hasNext()) {
                        moduleUpdate = (ModuleUpdate)iterator.next();
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleUpdate.getRemoteModule());
                        if (!bl) continue;
                        if (collection.contains(moduleUpdate)) break;
                        collection.add(moduleUpdate);
                        break;
                    }
                }
                blArray[n2] = bl;
            } else if (dependencyArray[n2].getType() == 4) {
                if (this.checkIdeDependency(dependencyArray[n2], IdeDescription.getIdeDescription())) {
                    blArray[n2] = true;
                } else {
                    Iterator iterator = Wizard.getAllModules().iterator();
                    n = 0;
                    while (iterator.hasNext()) {
                        ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
                        n = this.checkModuleDependency(dependencyArray[n2], moduleUpdate.getRemoteModule()) ? 1 : 0;
                        if (n == 0) continue;
                        if (collection.contains(moduleUpdate)) break;
                        collection.add(moduleUpdate);
                        break;
                    }
                    blArray[n2] = n;
                }
            } else {
                blArray[n2] = true;
            }
            ++n2;
        }
        stringBuffer2 = new StringBuffer(280);
        stringBuffer2.append(bundle.getString("MSG_NotSatisfied") + "MODULE :" + moduleInfo.getCodeName());
        int n4 = 0;
        n = 0;
        while (n < dependencyArray.length) {
            if (!blArray[n]) {
                stringBuffer2.append(dependencyArray[n]);
                ++n4;
            }
            ++n;
        }
        if (n4 == 0) {
            return true;
        }
        stringBuffer2.append(bundle.getString("MSG_IncludeAnyway"));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)stringBuffer2.toString(), 0, 0);
        if (!TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
            stringBuffer.append(moduleInfo.getDisplayName());
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo moduleInfo, Collection collection, ModuleUpdate moduleUpdate) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate2 = (ModuleUpdate)iterator.next();
            ModuleInfo moduleInfo2 = moduleUpdate2.getRemoteModule();
            Set set = moduleInfo2.getDependencies();
            Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
            boolean bl = true;
            int n = 0;
            while (n < dependencyArray.length) {
                if (dependencyArray[n].getType() == 1 && (dependencyArray[n].getName() + "/").startsWith(moduleInfo.getCodeNameBase() + "/") || dependencyArray[n].getType() == 5 && Arrays.asList(moduleInfo.getProvides()).contains(dependencyArray[n].getName())) {
                    boolean bl2 = false;
                    int n2 = 0;
                    while (n2 < moduleInfoArray.length) {
                        bl2 = this.checkModuleDependency(dependencyArray[n], moduleInfoArray[n2]);
                        if (bl2) break;
                        ++n2;
                    }
                    if (!bl2 && moduleUpdate != null) {
                        bl2 = this.checkModuleDependency(dependencyArray[n], moduleUpdate.getRemoteModule());
                    }
                    if (!bl2) {
                        int n3 = 0;
                        while (n3 < moduleInfoArray2.length) {
                            bl2 = this.checkModuleDependency(dependencyArray[n], moduleInfoArray2[n3]);
                            if (bl2) break;
                            ++n3;
                        }
                    }
                    if (!bl2) {
                        bl = false;
                        break;
                    }
                } else if (dependencyArray[n].getType() == 4 && dependencyArray[n].getName().equals(moduleInfo.getCodeName()) && !this.checkModuleDependency(dependencyArray[n], IdeDescription.getIdeDescription())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl || collection.contains(moduleUpdate2)) continue;
            collection.add(moduleUpdate2);
        }
        return collection.size() == 0;
    }

    boolean checkModuleDependency(Dependency dependency, ModuleInfo moduleInfo) {
        if (dependency.getType() == 5) {
            return Arrays.asList(moduleInfo.getProvides()).contains(dependency.getName());
        }
        boolean bl = false;
        String string = dependency.getName();
        if (string.equals(moduleInfo.getCodeName())) {
            if (dependency.getComparison() == 3) {
                return true;
            }
            if (dependency.getComparison() == 1) {
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
            if (moduleInfo.getImplementationVersion() == null) {
                return false;
            }
            return moduleInfo.getImplementationVersion().equals(dependency.getVersion());
        }
        int n = string.indexOf(45);
        if (n != -1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1, n));
            int n4 = Integer.parseInt(string.substring(n + 1));
            if (string2.equals(moduleInfo.getCodeNameBase()) && n3 <= moduleInfo.getCodeNameRelease() && n4 >= moduleInfo.getCodeNameRelease()) {
                if (dependency.getComparison() == 3) {
                    return true;
                }
                if (moduleInfo.getCodeNameRelease() > n3) {
                    return true;
                }
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dependency, ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeName();
        SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
        String string2 = moduleInfo.getImplementationVersion();
        if (!string.equals(dependency.getName())) {
            return false;
        }
        if (dependency.getComparison() == 1) {
            return new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) <= 0;
        }
        if (dependency.getComparison() == 2) {
            return dependency.getVersion().equals(string2);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

