/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

public final class DummyModuleInfo
extends ModuleInfo {
    private final Attributes attr;
    private final Set deps;
    private final String[] provides;

    public DummyModuleInfo(Attributes attributes) throws IllegalArgumentException {
        this.attr = attributes;
        if (attributes.getValue("OpenIDE-Module") == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.getSpecificationVersion();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException.toString());
        }
        this.deps = DummyModuleInfo.parseDeps(attributes);
        String string = attributes.getValue("OpenIDE-Module-Provides");
        if (string == null) {
            this.provides = new String[0];
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            this.provides = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < this.provides.length) {
                this.provides[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
    }

    public boolean isEnabled() {
        return false;
    }

    public SpecificationVersion getSpecificationVersion() {
        String string = this.attr.getValue("OpenIDE-Module-Specification-Version");
        return string == null ? null : new SpecificationVersion(string);
    }

    public String getCodeName() {
        return this.attr.getValue("OpenIDE-Module");
    }

    public int getCodeNameRelease() {
        String string = this.getCodeName();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return -1;
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    public String getCodeNameBase() {
        String string = this.getCodeName();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public Object getLocalizedAttribute(String string) {
        return this.attr.getValue(string);
    }

    public Object getAttribute(String string) {
        return this.attr.getValue(string);
    }

    public Set getDependencies() {
        return this.deps;
    }

    private static final Set parseDeps(Attributes attributes) throws IllegalArgumentException {
        HashSet hashSet = new HashSet();
        hashSet.addAll(Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies")));
        hashSet.addAll(Dependency.create((int)2, (String)attributes.getValue("OpenIDE-Module-Package-Dependencies")));
        hashSet.addAll(Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies")));
        hashSet.addAll(Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies")));
        hashSet.addAll(Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Requires")));
        Iterator iterator = hashSet.iterator();
        SpecificationVersion specificationVersion = null;
        String string = null;
        String string2 = null;
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (dependency.getType() != 4) continue;
            if (dependency.getComparison() == 1) {
                if (specificationVersion != null) {
                    throw new IllegalArgumentException("Duplicate OpenIDE-Module-IDE-Dependencies found!");
                }
                specificationVersion = new SpecificationVersion(dependency.getVersion());
            } else {
                if (string != null) {
                    throw new IllegalArgumentException("Duplicate OpenIDE-Module-IDE-Dependencies found!");
                }
                string = dependency.getVersion();
            }
            String string3 = dependency.getName();
            int n = string3.lastIndexOf(47);
            String string4 = n == -1 ? "" : string3.substring(n);
            if (string2 != null && !string2.equals(string4)) {
                throw new IllegalArgumentException("Clashing OpenIDE-Module-IDE-Dependencies found!");
            }
            string2 = string4;
            iterator.remove();
        }
        if (specificationVersion != null) {
            hashSet.addAll(Dependency.create((int)1, (String)("org.openide" + string2 + " > " + specificationVersion)));
        }
        if (string != null) {
            hashSet.addAll(Dependency.create((int)1, (String)("org.openide" + string2 + " = " + string)));
        }
        return hashSet;
    }

    public boolean owns(Class clazz) {
        return false;
    }

    public String[] getProvides() {
        return this.provides;
    }
}

