/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.BeanBuilder;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.TreeBuilder;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.netbeans.modules.schema2beans.metadd.MetaElement;

public abstract class AbstractCodeGeneratorClass {
    protected GenBeans.Config config;
    protected String tab = "\t";
    protected String packageName;
    protected String className;
    protected BeanBuilder.BeanElement beanElement;
    protected MetaDD mdd;
    protected MetaElement metaElement;
    protected ArrayList attrList;
    protected static final int OUT_HEADER = 0;
    protected static final int OUT_DECL = 1;
    protected static final int OUT_CONSTRUCTOR = 2;
    protected static final int OUT_INITIALIZE = 3;
    protected static final int OUT_ACCESS = 4;
    protected static final int OUT_BODY = 5;
    protected static final int OUT_EQUALS = 6;
    protected static final int OUT_HASHCODE = 7;
    protected static final int OUT_TRAILER = 8;
    protected static final int OUT_MAXVALUE = 8;
    protected int curOut;
    protected boolean[] crDone;
    protected StringBuffer[] listOut;
    int[] indent;
    protected static final int PUBLIC = 0;
    protected static final int PRIVATE = 1;
    protected static final int VOID = 2;
    protected static final int CLASS = 3;
    protected static final int IMPORT = 4;
    protected static final int PACKAGE = 5;
    protected static final int STRING = 6;
    protected static final int BOOLEAN = 7;
    protected static final int STATIC = 8;
    protected static final int FINAL = 9;
    protected static final int INT = 10;
    protected static final int PROTECTED = 11;
    protected static String[] arrKeywords = new String[]{"public", "private", "void", "class", "import", "package", "String", "boolean", "static", "final", "int", "protected"};
    protected static final Signature.TypeOfMethod SETTER = Signature.TypeOfMethod.SETTER;
    protected static final Signature.TypeOfMethod SETTERINDEXED = Signature.TypeOfMethod.SETTERINDEXED;
    protected static final Signature.TypeOfMethod GETTER = Signature.TypeOfMethod.GETTER;
    protected static final Signature.TypeOfMethod GETTERINDEXED = Signature.TypeOfMethod.GETTERINDEXED;
    protected static final Signature.TypeOfMethod SIZE = Signature.TypeOfMethod.SIZE;
    protected static final Signature.TypeOfMethod ADD = Signature.TypeOfMethod.ADD;
    protected static final Signature.TypeOfMethod REMOVE = Signature.TypeOfMethod.REMOVE;
    protected static final Signature.TypeOfMethod OTHER = Signature.TypeOfMethod.OTHER;

    protected void init(BeanBuilder.BeanElement beanElement) {
        this.beanElement = beanElement;
        this.packageName = "";
        this.className = beanElement.getClassType();
        this.attrList = new ArrayList();
        this.resetGenBuffers();
    }

    protected void resetGenBuffers() {
        this.crDone = new boolean[9];
        this.listOut = new StringBuffer[9];
        this.indent = new int[9];
        int n = 0;
        while (n <= 8) {
            this.crDone[n] = true;
            this.listOut[n] = new StringBuffer();
            this.indent[n] = 1;
            ++n;
        }
        this.indent[0] = 0;
        this.curOut = 0;
    }

    protected void printGenBuffers(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n <= 8) {
            outputStream.write(this.listOut[n].toString().getBytes());
            ++n;
        }
    }

    public void setPackageName(String string) {
        this.packageName = string.replace('/', '.');
    }

    public void setIndent(String string) {
        this.tab = string;
    }

    protected void select(int n) {
        this.curOut = n;
    }

    protected void gen(String string) {
        if (this.crDone[this.curOut]) {
            int n = 0;
            while (n < this.indent[this.curOut]) {
                this.listOut[this.curOut].append(this.tab);
                ++n;
            }
            this.crDone[this.curOut] = false;
        }
        this.listOut[this.curOut].append(string);
    }

    protected void gen(StringBuffer stringBuffer) {
        if (this.crDone[this.curOut]) {
            int n = 0;
            while (n < this.indent[this.curOut]) {
                this.listOut[this.curOut].append(this.tab);
                ++n;
            }
            this.crDone[this.curOut] = false;
        }
        this.listOut[this.curOut].append((Object)stringBuffer);
    }

    protected void gen(String string, String string2) {
        this.gen(string);
        this.gen(string2);
    }

    protected void gen(String string, String string2, String string3) {
        this.gen(string);
        this.gen(string2);
        this.gen(string3);
    }

    protected void gen(int n) {
        this.gen(arrKeywords[n]);
    }

    protected void gen(int n, String string) {
        this.gen(n);
        this.sp();
        this.gen(string);
    }

    protected void gen(int n, String string, String string2) {
        this.gen(n, string);
        this.sp();
        this.gen(string2);
    }

    protected void gen(int n, int n2, String string, String string2) {
        this.gen(n, n2, string);
        this.gen(string2);
    }

    protected void gen(int n, int n2, String string) {
        this.gen(n);
        this.sp();
        this.gen(n2);
        this.sp();
        this.gen(string);
    }

    protected void gen(int n, int n2, int n3, String string) {
        this.gen(n);
        this.sp();
        this.gen(n2);
        this.sp();
        this.gen(n3);
        this.sp();
        this.gen(string);
    }

    protected void gen(int n, int n2, int n3, int n4, String string) {
        this.gen(n);
        this.sp();
        this.gen(n2);
        this.sp();
        this.gen(n3);
        this.sp();
        this.gen(n4);
        this.sp();
        this.gen(string);
    }

    protected void gencr(String string) {
        this.gen(string);
        this.cr();
    }

    protected void gencr(String string, String string2) {
        this.gen(string, string2);
        this.cr();
    }

    protected void gencr(int n, String string) {
        this.gen(n, string);
        this.cr();
    }

    protected void gencr(int n, String string, String string2) {
        this.gen(n, string, string2);
        this.cr();
    }

    protected void gencr(int n, int n2, String string, String string2) {
        this.gen(n, n2, string, string2);
        this.cr();
    }

    protected void gencr(int n, int n2, String string) {
        this.gen(n, n2, string);
        this.cr();
    }

    protected void gencr(int n, int n2, int n3, String string) {
        this.gen(n, n2, n3, string);
        this.cr();
    }

    protected void get(String string) {
        this.gen(" get");
        this.gen(string);
        this.PO();
        this.PC();
    }

    protected void geti(String string) {
        this.gen(" get");
        this.gen(string, "(int index)");
    }

    protected void getidx(String string, boolean bl) {
        if (bl) {
            this.geti(string);
        } else {
            this.get(string);
        }
    }

    protected void cr() {
        this.listOut[this.curOut].append("\n");
        this.crDone[this.curOut] = true;
    }

    protected void geneol(String string) {
        this.gen(string);
        this.eol();
    }

    protected void PO() {
        this.gen("(");
    }

    protected void PC() {
        this.gen(")");
    }

    protected void begin() {
        this.gencr("{");
        int n = this.curOut;
        this.indent[n] = this.indent[n] + 1;
    }

    protected void end() {
        this.end(true);
    }

    protected void end(boolean bl) {
        int n = this.curOut;
        this.indent[n] = this.indent[n] - 1;
        this.gen("}");
        if (bl) {
            this.cr();
        }
    }

    protected void comment() {
        this.gencr("//");
    }

    protected void gencrNoI18N(String string) {
        this.gen(string);
        this.noI18N();
    }

    protected void gencrNoI18N(String string, String string2) {
        this.gen(string);
        this.gen(string2);
        this.noI18N();
    }

    protected void beginNoI18N() {
        this.gencr("// BEGIN_NOI18N");
    }

    protected void endNoI18N() {
        this.gencr("// END_NOI18N");
    }

    protected void noI18N() {
        this.gencr("\t// NOI18N");
    }

    protected void comment(String string) {
        this.gencr("// ", string);
    }

    protected void comment(String string, String string2) {
        this.gen("// ", string, string2);
        this.cr();
    }

    protected void eol() {
        this.eol(true);
    }

    protected void eol(boolean bl) {
        this.gen(";");
        if (bl) {
            this.cr();
        }
    }

    protected void eolNoI18N() {
        this.eol(false);
        this.noI18N();
    }

    protected void sp() {
        this.gen(" ");
    }

    protected void genforprop() {
        this.gencr("for (int i=0; i<this.prop.length; i++)");
    }

    protected void gengetprop() {
        this.gencr("BeanProp p = this.beanProp();");
        this.gencr("if (p != null)");
    }

    protected void gengetpropbyname() {
        this.gencr("BeanProp p = this.beanProp(n);");
        this.gencr("if (p != null)");
    }

    protected void gensig1(String string) {
        this.gen("(", string, " l)");
        this.cr();
    }

    protected void gensig2(String string) {
        this.gen("(String n, ", string, " l)");
        this.cr();
    }

    protected void tabIn() {
        this.gen(this.tab);
    }

    protected void gentab(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.gen(this.tab);
            ++n2;
        }
    }

    protected void genSetValue(boolean bl, String string) {
        if (bl) {
            this.gen("new ", string, "(value))");
        } else {
            this.gen("value)");
        }
    }

    protected void genSetValP(boolean bl, String string, String string2) {
        if (bl) {
            this.gen(string);
        } else {
            this.gen(string2);
        }
        this.gen(" value");
    }

    public void addProperty(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, AttrProp[] attrPropArray, String string4) {
        Property property = new Property(string, string2, string3, n2, n3, n, n4, bl, attrPropArray, string4);
        this.attrList.add(property);
    }

    public void generate(String string, MetaDD metaDD, GenBeans.Config config) throws IOException {
        this.mdd = metaDD;
        if (this.className == null) {
            throw new NullPointerException();
        }
        this.metaElement = this.getMetaElementBeanName(this.className);
        if (this.metaElement != null && this.metaElement.isSkipGeneration()) {
            config.messageOut.println("Skipping generation of class " + string + " (as specified in the mdd file)");
            return;
        }
        config.messageOut.println("Generating class " + string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.generate(fileOutputStream, metaDD, config);
        ((OutputStream)fileOutputStream).close();
    }

    public abstract void generate(OutputStream var1, MetaDD var2, GenBeans.Config var3) throws IOException;

    private MetaElement getMetaElement(String string) {
        MetaElement metaElement = null;
        if (this.mdd != null) {
            int n = this.mdd.sizeMetaElement();
            int n2 = 0;
            while (n2 < n) {
                MetaElement metaElement2 = this.mdd.getMetaElement(n2);
                if (metaElement2 != null && string.equals(metaElement2.getDtdName())) {
                    metaElement = metaElement2;
                    break;
                }
                ++n2;
            }
        }
        return metaElement;
    }

    protected MetaElement getMetaElementBeanName(String string) {
        MetaElement metaElement = null;
        if (this.mdd != null) {
            int n = this.mdd.sizeMetaElement();
            int n2 = 0;
            while (n2 < n) {
                MetaElement metaElement2 = this.mdd.getMetaElement(n2);
                if (metaElement2 != null) {
                    String string2 = metaElement2.getBeanName();
                    if (string2 == null) {
                        string2 = Common.convertName(metaElement2.getDtdName());
                    }
                    if (string.equals(string2)) {
                        metaElement = metaElement2;
                        break;
                    }
                }
                ++n2;
            }
        }
        return metaElement;
    }

    protected void printSchema() throws IOException {
        if (this.config.filename == null) {
            return;
        }
        File file = new File(this.config.filename);
        FileInputStream fileInputStream = new FileInputStream(file);
        if (file.length() < 32000L) {
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            this.cr();
            this.gencr("/*");
            this.gentab(2);
            this.gencr("The following schema file has been used for generation:");
            this.cr();
            this.gen(new String(byArray));
            fileInputStream.close();
            this.cr();
            this.gencr("*/");
        }
    }

    protected void dumpAttributes(GraphNode graphNode, StringBuffer stringBuffer, String string) {
        AttrProp[] attrPropArray = graphNode.getAttributes();
        int n = 0;
        while (n < attrPropArray.length) {
            stringBuffer.append(string + "  [attr: " + attrPropArray[n] + "]\n");
            ++n;
        }
    }

    protected void beanTree(GraphLink graphLink, StringBuffer stringBuffer, String string) {
        while (graphLink != null) {
            if (graphLink.element != null) {
                BeanBuilder.BeanElement beanElement = (BeanBuilder.BeanElement)graphLink.element.getObject();
                if (beanElement == null) {
                    return;
                }
                String string2 = Common.isBean(beanElement.type) ? "" : (Common.isString(beanElement.type) ? " - " + beanElement.getClassType() : " - " + Common.wrapperClass(beanElement.type));
                stringBuffer.append(string + beanElement.getName() + TreeBuilder.instanceToString(graphLink.getElementInstance(), true) + string2 + (graphLink.element.marked ? "...\n" : "\n"));
                this.dumpAttributes(graphLink.element, stringBuffer, string);
                if (!graphLink.element.marked) {
                    graphLink.element.marked = true;
                    this.beanTree(graphLink.element.link, stringBuffer, string + "  " + TreeBuilder.instanceToString(graphLink.getGroupInstance(), true) + (graphLink.isSequenceOr() ? "or " : "   "));
                    graphLink.element.marked = false;
                }
            }
            this.beanTree(graphLink.child, stringBuffer, string + "  ");
            graphLink = graphLink.sibling;
        }
    }

    public String toString() {
        return "Class " + this.packageName + "." + this.className;
    }

    protected void gen(Signature signature) {
        this.gen(0, signature.toString());
    }

    protected Signatures getSignatures(Property property) {
        String string;
        Signatures signatures = new Signatures();
        boolean bl = property.isIndexed();
        boolean bl2 = property.isScalar();
        String string2 = string = property.getType();
        if (bl) {
            string = string2 + "[]";
        }
        Signature signature = new Signature("void", "set" + property.name, SETTER);
        signature.addParameter(string, "value");
        signatures.add(signature);
        if (bl) {
            signature = new Signature("void", "set" + property.name, SETTERINDEXED);
            signature.addParameter("int", "index");
            signature.addParameter(string2, "value");
            signatures.add(signature);
        }
        String string3 = bl2 && Common.isBoolean(property.type) ? "is" + property.name : "get" + property.name;
        signatures.add(new Signature(string, string3, GETTER));
        if (bl) {
            signature = new Signature(string2, string3, GETTERINDEXED);
            signature.addParameter("int", "index");
            signatures.add(signature);
            signatures.add(new Signature("int", "size" + property.name, SIZE));
            signature = new Signature("int", "add" + property.name, ADD);
            signature.addParameter(string2, "value");
            signatures.add(signature);
            signature = new Signature("int", "remove" + property.name, REMOVE);
            signature.addParameter(string2, "value");
            signatures.add(signature);
        }
        return signatures;
    }

    protected abstract Signatures getSystemSignatures();

    public void generateDelegator(OutputStream outputStream, MetaDD metaDD, GenBeans.Config config, String string) throws IOException {
        this.resetGenBuffers();
        this.select(0);
        if (this.packageName != null) {
            this.gen(5, this.packageName);
            this.eol();
            this.cr();
        }
        this.gen(0, 3, string);
        this.sp();
        this.begin();
        this.select(1);
        String string2 = "_" + this.className;
        this.gen(1, this.className, string2);
        this.eol();
        this.cr();
        this.generateDelegatorConstructors(string);
        this.generateDelegatorAccessors();
        this.select(5);
        this.generateDelegator(this.getSystemSignatures());
        this.select(8);
        this.end();
        this.printGenBuffers(outputStream);
    }

    protected void generateDelegatorConstructors(String string) {
        this.select(2);
        String string2 = "_" + this.className;
        this.gen(0, string);
        this.PO();
        this.PC();
        this.sp();
        this.begin();
        this.geneol(string2 + " = new " + this.className + "()");
        this.end();
        this.cr();
        this.gen(0, string);
        this.PO();
        this.gen(this.className);
        this.gen(" delegator");
        this.PC();
        this.sp();
        this.begin();
        this.geneol(string2 + " = delegator");
        this.end();
        this.cr();
    }

    protected void generateDelegatorAccessors() {
        this.select(4);
        int n = this.attrList.size();
        int n2 = 0;
        while (n2 < n) {
            Property property = (Property)this.attrList.get(n2);
            Signatures signatures = this.getSignatures(property);
            this.generateDelegator(signatures);
            ++n2;
        }
    }

    protected void generateDelegator(Signatures signatures) {
        Iterator iterator = signatures.iterator();
        while (iterator.hasNext()) {
            Signature signature = (Signature)iterator.next();
            this.generateDelegator(signature);
        }
    }

    protected void generateDelegator(Signature signature) {
        this.gen(signature);
        this.sp();
        this.begin();
        if (!signature.isVoidReturnType()) {
            this.gen("return ");
        }
        if (!signature.isStatic()) {
            this.gen("_");
        }
        this.gen(this.className);
        this.geneol("." + signature.callMethod());
        this.end();
        this.cr();
    }

    protected static class Signatures {
        Map signatureTable = new HashMap();
        List others = new LinkedList();

        public void add(Signature signature) {
            if (signature.getMethodType() == OTHER) {
                this.others.add(signature);
            } else {
                this.signatureTable.put(signature.getMethodType(), signature);
            }
        }

        public Signature findSignature(Signature.TypeOfMethod typeOfMethod) {
            Signature signature = null;
            if (typeOfMethod == OTHER) {
                Iterator iterator = this.others.iterator();
                if (iterator.hasNext()) {
                    signature = (Signature)iterator.next();
                }
            } else {
                signature = (Signature)this.signatureTable.get(typeOfMethod);
            }
            if (signature == null) {
                throw new IllegalStateException("Unable to find " + typeOfMethod);
            }
            return signature;
        }

        public Iterator iterator() {
            return new SignaturesIterator();
        }

        public class SignaturesIterator
        implements Iterator {
            Iterator tableIterator;
            Iterator othersIterator;

            public SignaturesIterator() {
                this.tableIterator = Signatures.this.signatureTable.values().iterator();
                this.othersIterator = Signatures.this.others.iterator();
            }

            public boolean hasNext() {
                if (this.tableIterator.hasNext()) {
                    return true;
                }
                return this.othersIterator.hasNext();
            }

            public Object next() {
                if (this.tableIterator.hasNext()) {
                    return this.tableIterator.next();
                }
                return this.othersIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class Signature {
        private String returnType;
        private String methodName;
        private TypeOfMethod methodType;
        private List parameterTypes;
        private List parameterNames;
        private List throwTypes;
        private boolean _isStatic;

        public Signature(String string, String string2, TypeOfMethod typeOfMethod) {
            this.returnType = string;
            this.methodName = string2;
            this.methodType = typeOfMethod;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public Signature(String string, String string2) {
            this.returnType = string;
            this.methodName = string2;
            this.methodType = OTHER;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public TypeOfMethod getMethodType() {
            return this.methodType;
        }

        public boolean isStatic() {
            return this._isStatic;
        }

        public void setStatic() {
            this._isStatic = true;
        }

        public boolean isVoidReturnType() {
            return "void".equals(this.returnType);
        }

        public void addParameter(String string, String string2) {
            this.parameterTypes.add(string);
            this.parameterNames.add(string2);
        }

        public void addThrows(String string) {
            this.throwTypes.add(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._isStatic) {
                stringBuffer.append("static ");
            }
            stringBuffer.append(this.returnType);
            stringBuffer.append(" ");
            stringBuffer.append(this.methodName);
            stringBuffer.append("(");
            Iterator iterator = this.parameterTypes.iterator();
            Iterator iterator2 = this.parameterNames.iterator();
            boolean bl = true;
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)iterator.next());
                stringBuffer.append(" ");
                stringBuffer.append((String)iterator2.next());
            }
            stringBuffer.append(")");
            Iterator iterator3 = this.throwTypes.iterator();
            if (iterator3.hasNext()) {
                stringBuffer.append(" throws ");
                bl = true;
                do {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((String)iterator3.next());
                } while (iterator3.hasNext());
            }
            return stringBuffer.toString();
        }

        public String callMethod() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.methodName);
            stringBuffer.append("(");
            Iterator iterator = this.parameterTypes.iterator();
            Iterator iterator2 = this.parameterNames.iterator();
            boolean bl = true;
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)iterator2.next());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public static class TypeOfMethod {
            private final String name;
            public static final TypeOfMethod SETTER = new TypeOfMethod("setter");
            public static final TypeOfMethod SETTERINDEXED = new TypeOfMethod("setterindexed");
            public static final TypeOfMethod GETTER = new TypeOfMethod("getter");
            public static final TypeOfMethod GETTERINDEXED = new TypeOfMethod("getterindexed");
            public static final TypeOfMethod SIZE = new TypeOfMethod("size");
            public static final TypeOfMethod ADD = new TypeOfMethod("add");
            public static final TypeOfMethod REMOVE = new TypeOfMethod("remove");
            public static final TypeOfMethod OTHER = new TypeOfMethod("other");

            private TypeOfMethod(String string) {
                this.name = string;
            }

            public String toString() {
                return "TypeOfMethod " + this.name;
            }
        }
    }

    static class Property {
        String dtdName;
        String name;
        String classType;
        int type;
        int elementInstance;
        int groupInstance;
        int level;
        boolean isBean;
        boolean ored;
        String constName;
        AttrProp[] attributes;

        Property(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, AttrProp[] attrPropArray, String string4) {
            if (n2 == 48) {
                n = n2;
            } else if (n2 == 64) {
                n = n == 16 ? 48 : 64;
            }
            this.name = string;
            this.dtdName = string2;
            this.classType = string3;
            this.type = n4;
            this.elementInstance = n;
            this.groupInstance = n2;
            this.level = n3;
            this.attributes = attrPropArray;
            this.ored = bl;
            this.constName = string4;
            this.isBean = Common.isBean(n4);
            if (this.isScalar()) {
                this.classType = Common.wrapperClass(n4);
            }
        }

        public boolean isIndexed() {
            if (this.elementInstance == 64) {
                return true;
            }
            return this.elementInstance == 48;
        }

        public boolean isScalar() {
            return Common.isScalar(this.type);
        }

        public String getScalarType() {
            if (!this.isScalar()) {
                return null;
            }
            return Common.scalarType(this.type);
        }

        public String getType() {
            if (this.isScalar()) {
                return this.getScalarType();
            }
            return this.classType;
        }
    }
}

