/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.netbeans.modules.schema2beans.AbstractCodeGeneratorClass;
import org.netbeans.modules.schema2beans.BeanBuilder;
import org.netbeans.modules.schema2beans.CodeGeneratorClass;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.netbeans.modules.schema2beans.metadd.MetaElement;

public class JavaBeanClass
extends AbstractCodeGeneratorClass
implements CodeGeneratorClass {
    static /* synthetic */ Class class$java$lang$Cloneable;

    JavaBeanClass(BeanBuilder.BeanElement beanElement) {
        this.init(beanElement);
    }

    public void generate(OutputStream outputStream, MetaDD metaDD, GenBeans.Config config) throws IOException {
        this.mdd = metaDD;
        this.config = config;
        this.metaElement = this.getMetaElementBeanName(this.className);
        if (this.metaElement != null && this.metaElement.isSkipGeneration()) {
            config.messageOut.println("Skipping generation of class  (as specified in the mdd file)");
            return;
        }
        this.genHeader(0);
        this.genPackage(0);
        this.genImports(0);
        this.genClassName(0);
        this.genConstructor();
        this.genAccessors();
        this.genDeepCopy();
        if (config.generateXMLIO) {
            this.genXMLIO();
        }
        this.genEqualsHashCode();
        this.genTrailer(8);
        this.genFinishClass(8);
        try {
            this.printSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.printGenBuffers(outputStream);
    }

    public void genHeader(int n) {
        this.select(n);
        this.gencr("/**");
        this.gencr(" *\tThis generated bean class " + this.className + " matches the schema element '" + this.beanElement.node.getName() + "'");
        this.gencr(" *");
        this.gencr(" *\tGenerated on " + new Date());
        if (this.beanElement.isRoot) {
            this.gencr(" *");
            this.gencr(" *\tThis class matches the root element of the " + (this.config.schemaType == 1 ? "DTD" : "XML Schema") + ",");
            this.gencr(" *\tand is the root of the bean graph.");
            this.gencr(" *");
            StringBuffer stringBuffer = new StringBuffer();
            this.beanTree(this.beanElement.getGraphNode().link, stringBuffer, " *" + this.tab);
            this.gen(stringBuffer);
            this.gencr(" *");
        }
        this.gencr(" */");
        this.cr();
    }

    public void genPackage(int n) {
        this.select(n);
        if (this.packageName != null) {
            this.gen(5, this.packageName);
            this.eol();
            this.cr();
        }
    }

    public void genImports(int n) {
        this.select(n);
    }

    public void genClassName(int n) {
        String string = null;
        String string2 = null;
        this.select(n);
        this.gen(0, 3, this.className);
        if (this.mdd != null) {
            if (this.metaElement != null) {
                string = this.metaElement.getExtends();
                string2 = this.metaElement.getImplements();
            }
            if (string == null) {
                string = this.mdd.getExtends();
            }
            if (string2 == null) {
                string2 = this.mdd.getImplements();
            }
        }
        if (string != null) {
            this.gen(" extends ");
            this.gencr(string);
        }
        if (string2 != null) {
            this.gentab(1);
            this.gencr(" implements ", string2);
        }
        this.sp();
        this.begin();
    }

    public void genDeclarations(int n) {
        this.select(n);
    }

    public void genConstructor() {
        this.select(2);
        this.gen(0, this.className);
        this.PO();
        this.PC();
        this.sp();
        this.begin();
        this.end();
        this.cr();
    }

    public void genAccessors() {
        int n = this.attrList.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            AbstractCodeGeneratorClass.Property property = (AbstractCodeGeneratorClass.Property)this.attrList.get(n2);
            boolean bl = property.isIndexed();
            boolean bl2 = false;
            boolean bl3 = property.isScalar();
            String string2 = property.getScalarType();
            String string3 = "_" + property.name;
            MetaElement metaElement = this.getMetaElementBeanName(property.name);
            String string4 = string = property.getType();
            if (bl) {
                string = string4 + "[]";
            }
            AbstractCodeGeneratorClass.Signatures signatures = this.getSignatures(property);
            this.select(1);
            this.gen(1, string, string3);
            if (bl) {
                this.geneol(" = new " + string4 + "[0]");
                this.gen(1, "int", "_size" + property.name + " = 0");
            }
            this.eol();
            this.select(4);
            this.comment("This attribute is ", Common.instanceToString(property.elementInstance));
            this.gen(signatures.findSignature(AbstractCodeGeneratorClass.SETTER));
            this.sp();
            this.begin();
            if (bl) {
                this.gen("if (value == null)");
                this.cr();
                this.tabIn();
                this.gen("value = new " + string4 + "[0]");
                this.eol();
            }
            this.gen(string3 + " = value");
            this.eol();
            this.end();
            this.cr();
            if (bl) {
                this.gen(signatures.findSignature(AbstractCodeGeneratorClass.SETTERINDEXED));
                this.sp();
                this.begin();
                this.gen(string3 + "[index] = value");
                this.eol();
                this.end();
                this.cr();
            }
            this.gen(signatures.findSignature(AbstractCodeGeneratorClass.GETTER));
            this.sp();
            this.begin();
            this.gen("return " + string3);
            this.eol();
            this.end();
            this.cr();
            if (bl) {
                this.gen(signatures.findSignature(AbstractCodeGeneratorClass.GETTERINDEXED));
                this.sp();
                this.begin();
                this.gen("return " + string3 + "[index]");
                this.eol();
                this.end();
                this.cr();
                this.comment("Return the number of " + property.name);
                this.gen(signatures.findSignature(AbstractCodeGeneratorClass.SIZE));
                this.sp();
                this.begin();
                this.geneol("return _size" + property.name);
                this.end();
                this.cr();
                this.gen(signatures.findSignature(AbstractCodeGeneratorClass.ADD));
                this.sp();
                this.begin();
                this.geneol("int size = size" + property.name + "()");
                this.gen("if (size == " + string3 + ".length) ");
                this.begin();
                this.comment("Need to expand the array");
                this.geneol(string + " newarray = new " + string4 + "[size == 0 ? 4 : size*2]");
                this.geneol("System.arraycopy(" + string3 + ", 0, newarray, 0, size)");
                this.geneol(string3 + " = newarray");
                this.end();
                this.geneol(string3 + "[size] = value");
                this.geneol("++_size" + property.name);
                this.geneol("return size");
                this.end();
                this.cr();
                this.comment("Search from the end looking for @param value, and then remove it.");
                this.gen(signatures.findSignature(AbstractCodeGeneratorClass.REMOVE));
                this.sp();
                this.begin();
                this.geneol("int size = size" + property.name + "()");
                this.geneol("int i = size-1");
                this.gen("for (; i >= 0; --i) ");
                this.begin();
                this.gen("if (" + string3 + "[i] == value || (value != null && value.equals(" + string3 + "[i]))) ");
                this.begin();
                this.comment("Found it.  Now shift the array contents down 1 to remove it.");
                this.gencr("for (int j = i+1; j < size; ++j)");
                this.tabIn();
                this.geneol(string3 + "[j-1] = " + string3 + "[j]");
                this.geneol(string3 + "[size-1] = " + this.nullValueForType(string4));
                this.geneol("--_size" + property.name);
                this.geneol("return i");
                this.end();
                this.end();
                this.geneol("return -1");
                this.end();
                this.cr();
            }
            ++n2;
        }
        this.select(1);
        this.cr();
    }

    public void genXMLIO() {
        String string;
        String string2;
        this.select(5);
        if (this.beanElement.isRoot) {
            this.gen(0, 2, "write");
            this.PO();
            this.gen("java.io.OutputStream out");
            this.PC();
            this.gen(" throws java.io.IOException ");
            this.begin();
            this.gen("write(out, null)");
            this.eol();
            this.end();
            this.cr();
            this.gen(0, 2, "write");
            this.PO();
            this.gen("java.io.OutputStream out, String encoding");
            this.PC();
            this.gen(" throws java.io.IOException ");
            this.begin();
            this.gen("java.io.Writer w");
            this.eol();
            this.gen("if (encoding == null)");
            this.cr();
            this.tabIn();
            this.gen("encoding = \"UTF-8\"");
            this.eolNoI18N();
            this.gen("w = new java.io.BufferedWriter(new java.io.OutputStreamWriter(out, encoding))");
            this.eol();
            this.gen("write(w, encoding)");
            this.eol();
            this.gen("w.flush()");
            this.eol();
            this.end();
            this.cr();
            this.comment("Print this Java Bean to @param out including an XML header.");
            this.comment("@param encoding is the encoding style that @param out was opened with.");
            this.gen(0, 2, "write");
            this.PO();
            this.gen("java.io.Writer out, String encoding");
            this.PC();
            this.gen(" throws java.io.IOException ");
            this.begin();
            this.gen("out.write(\"<?xml version='1.0'\")");
            this.eolNoI18N();
            this.gen("if (encoding != null)");
            this.cr();
            this.tabIn();
            this.gen("out.write(\" encoding='\"+encoding+\"'\")");
            this.eolNoI18N();
            this.gen("out.write(\" ?>\\n\")");
            this.eolNoI18N();
            this.gen("writeNode(out, \"\")");
            this.eol();
            this.end();
            this.cr();
        }
        this.gen(0, 2, "writeNode");
        this.PO();
        this.gen("java.io.Writer out, String indent");
        this.PC();
        this.gen(" throws java.io.IOException ");
        this.begin();
        int n = this.attrList.size();
        if (n > 0) {
            this.gen("String nextIndent = indent + \"" + this.tab + "\"");
            this.eol();
        }
        this.gen("out.write(indent)");
        this.eol();
        String string3 = this.beanElement.node.getName();
        this.gen("out.write(\"<" + string3 + ">\\n\")");
        this.eolNoI18N();
        int n2 = 0;
        while (n2 < n) {
            String string4;
            String string5;
            AbstractCodeGeneratorClass.Property property = (AbstractCodeGeneratorClass.Property)this.attrList.get(n2);
            boolean bl = property.isIndexed();
            string2 = string5 = "_" + property.name;
            boolean bl2 = property.isScalar();
            string = string4 = property.getType().intern();
            if (bl) {
                string4 = (string + "[]").intern();
            }
            if (bl) {
                this.gen("for (int index = 0, size = size" + property.name + "(); index < size; ++index) ");
                this.begin();
                string5 = string2 + "[index]";
            }
            if (!bl2) {
                this.gen("if (" + string5 + " != null) ");
                this.begin();
            }
            if (property.isBean) {
                this.gen(string5 + ".writeNode(out, nextIndent)");
                this.eol();
            } else if (string == "boolean") {
                this.gen("if (" + string5 + ") ");
                this.begin();
                this.gen("out.write(nextIndent)");
                this.eol();
                this.gen("out.write(\"<" + property.dtdName + "/>\\n\")");
                this.eolNoI18N();
                this.end();
            } else {
                this.gen("out.write(nextIndent)");
                this.eol();
                this.gen("out.write(\"<" + property.dtdName + ">\")");
                this.eolNoI18N();
                this.gen("out.write(");
                if (bl2) {
                    this.gen("\"\"+" + string5);
                } else if (string4 == "String" || string4 == "java.lang.String") {
                    this.gen(string5);
                } else {
                    this.gen(string5 + ".toString()");
                }
                this.gen(")");
                this.eol();
                this.gen("out.write(\"</" + property.dtdName + ">\\n\")");
                this.eolNoI18N();
            }
            if (!bl2) {
                this.end();
            }
            if (bl) {
                this.end();
            }
            ++n2;
        }
        this.gen("out.write(indent)");
        this.eol();
        this.gen("out.write(\"</" + string3 + ">\\n\")");
        this.eolNoI18N();
        this.end();
        this.cr();
        if (this.beanElement.isRoot) {
            this.gen(0, 8, this.className + " read");
            this.PO();
            this.gen("java.io.InputStream in");
            this.PC();
            this.gen(" throws javax.xml.parsers.ParserConfigurationException,org.xml.sax.SAXException, java.io.IOException ");
            this.begin();
            this.geneol("return read(new org.xml.sax.InputSource(in), false, null, null)");
            this.end();
            this.cr();
            this.gen(0, 8, this.className + " read");
            this.PO();
            this.gen("org.w3c.dom.Document document");
            this.PC();
            this.sp();
            this.begin();
            this.geneol(this.className + " a" + this.className + " = new " + this.className + "()");
            this.geneol("a" + this.className + ".readNode(document.getDocumentElement())");
            this.geneol("return a" + this.className);
            this.end();
            this.cr();
            this.gen(0, 8, this.className + " read");
            this.PO();
            this.gen("org.xml.sax.InputSource in, boolean validate, org.xml.sax.EntityResolver er, org.xml.sax.ErrorHandler eh");
            this.PC();
            this.gen(" throws javax.xml.parsers.ParserConfigurationException,org.xml.sax.SAXException, java.io.IOException ");
            this.begin();
            this.geneol("javax.xml.parsers.DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance()");
            this.geneol("dbf.setValidating(validate)");
            this.geneol("javax.xml.parsers.DocumentBuilder db = dbf.newDocumentBuilder()");
            this.gen("if (er != null)");
            this.tabIn();
            this.geneol("db.setEntityResolver(er)");
            this.gen("if (eh != null)");
            this.tabIn();
            this.geneol("db.setErrorHandler(eh)");
            this.geneol("org.w3c.dom.Document doc = db.parse(in)");
            this.geneol("return read(doc)");
            this.end();
            this.cr();
        }
        this.gen(0, 2, "readNode");
        this.PO();
        this.gen("org.w3c.dom.Node node");
        this.PC();
        this.sp();
        this.begin();
        this.geneol("String nodeName = node.getLocalName() == null ? node.getNodeName() : node.getLocalName()");
        this.gen("if (!\"" + string3 + "\".equals(nodeName))");
        this.noI18N();
        this.tabIn();
        this.geneol("throw new IllegalStateException(\"Expecting '" + string3 + "', but found \"+nodeName+\" instead.\")");
        this.geneol("org.w3c.dom.NodeList children = node.getChildNodes()");
        this.gen("for (int i = 0, size = children.getLength(); i < size; ++i) ");
        this.begin();
        this.geneol("org.w3c.dom.Node childNode = children.item(i)");
        this.geneol("String childNodeName = (childNode.getLocalName() == null ? childNode.getNodeName() : childNode.getLocalName()).intern()");
        int n3 = 0;
        while (n3 < n) {
            String string6;
            AbstractCodeGeneratorClass.Property property = (AbstractCodeGeneratorClass.Property)this.attrList.get(n3);
            boolean bl = property.isIndexed();
            String string7 = string2 = "_" + property.name;
            boolean bl3 = property.isScalar();
            String string8 = string = property.getType().intern();
            if (bl) {
                string = (string8 + "[]").intern();
            }
            if (n3 > 0) {
                this.gen("else ");
            }
            this.gen("if (childNodeName == \"" + property.dtdName + "\") ");
            this.begin();
            if (bl) {
                string6 = "a" + property.name;
                if (property.isBean) {
                    this.geneol(string8 + " " + string6 + " = new " + string8 + "()");
                } else {
                    this.geneol(string8 + " " + string6);
                }
            } else {
                string6 = string2;
                if (property.isBean) {
                    this.geneol(string6 + " = new " + string + "()");
                }
            }
            if (property.isBean) {
                this.geneol(string6 + ".readNode(childNode)");
            } else {
                if (string8 == "boolean" || string8 == "java.lang.Boolean") {
                    this.gencr("if (childNode.getFirstChild() == null)");
                    this.tabIn();
                    if (string8 == "boolean") {
                        this.geneol(string6 + " = true");
                    } else {
                        this.geneol(string6 + " = Boolean.TRUE");
                    }
                    this.gencr("else");
                    this.tabIn();
                }
                this.geneol(string6 + " = " + this.genParseText(string8, "childNode.getFirstChild().getNodeValue()"));
            }
            if (bl) {
                this.geneol("add" + property.name + "(" + string6 + ")");
            }
            this.end();
            ++n3;
        }
        if (n > 0) {
            this.gen("else ");
            this.begin();
            this.comment("Found extra unrecognized childNode");
            this.end();
        }
        this.end();
        this.end();
        this.cr();
    }

    private String genParseText(String string, String string2) {
        if ((string = string.intern()) == "java.lang.String" || string == "String") {
            return string2;
        }
        if (string == "java.lang.Integer" || string == "Integer" || string == "java.lang.Long" || string == "Long" || string == "java.lang.Short" || string == "Short" || string == "java.lang.Float" || string == "Float" || string == "java.lang.Double" || string == "Double" || string == "java.lang.Byte" || string == "Byte" || string == "java.lang.Boolean" || string == "Boolean" || string == "java.math.BigDecimal" || string == "BigDecimal" || string == "java.math.BigInteger" || string == "BigInteger" || string == "java.lang.StringBuffer" || string == "StringBuffer" || string == "java.text.MessageFormat" || string == "java.text.AttributedString" || string == "java.util.StringTokenizer") {
            return "new " + string + "(" + string2 + ")";
        }
        if (string == "java.lang.Character") {
            return "new java.lang.Character((" + string2 + ").charAt(0))";
        }
        if (string == "char[]" || string == "char []") {
            return "(" + string2 + ").toCharArray()";
        }
        if (string == "long") {
            return "Long.parseLong(" + string2 + ")";
        }
        if (string == "int") {
            return "Integer.parseInt(" + string2 + ")";
        }
        if (string == "byte") {
            return "Byte.parseByte(" + string2 + ")";
        }
        if (string == "short") {
            return "Short.parseShort(" + string2 + ")";
        }
        if (string == "float") {
            return "Float.parseFloat(" + string2 + ")";
        }
        if (string == "double") {
            return "Double.parseDouble(" + string2 + ")";
        }
        if (string == "boolean") {
            return "Boolean.valueOf(" + string2 + ").booleanValue()";
        }
        if (string == "char") {
            return "(" + string2 + ").charAt(0)";
        }
        return "/* UNKONWN type for parsing:" + string + "*/ " + string2;
    }

    private String nullValueForType(String string) {
        if ((string = string.intern()) == "long" || string == "int" || string == "short" || string == "char" || string == "byte") {
            return "0";
        }
        if (string == "double") {
            return "0.0";
        }
        if (string == "float") {
            return "0.0f";
        }
        if (string == "boolean") {
            return "false";
        }
        return "null";
    }

    public void genEqualsHashCode() {
        this.select(6);
        this.gen(0, 7, "equals");
        this.PO();
        this.gen("Object o");
        this.PC();
        this.sp();
        this.begin();
        this.gen("if (o == this)");
        this.cr();
        this.tabIn();
        this.gen("return true");
        this.eol();
        this.gen("if (!(o instanceof " + this.className + "))");
        this.cr();
        this.tabIn();
        this.gen("return false");
        this.eol();
        this.gen(this.className);
        this.sp();
        this.gen("inst = (" + this.className + ") o");
        this.eol();
        this.select(7);
        this.gen(0, 10, "hashCode");
        this.PO();
        this.PC();
        this.sp();
        this.begin();
        this.gen("int result = 17");
        this.eol();
        int n = this.attrList.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2;
            AbstractCodeGeneratorClass.Property property = (AbstractCodeGeneratorClass.Property)this.attrList.get(n2);
            boolean bl = property.isIndexed();
            boolean bl2 = false;
            MetaElement metaElement = this.getMetaElementBeanName(property.name);
            boolean bl3 = property.isScalar();
            String string3 = string2 = property.getType().intern();
            if (bl) {
                string2 = (string3 + "[]").intern();
            }
            String string4 = string = "_" + property.name;
            this.select(6);
            if (bl) {
                this.gen("if (size" + property.name + "() != inst.size" + property.name + "())");
                this.cr();
                this.tabIn();
                this.gen("return false");
                this.eol();
                this.comment("Compare every element.");
                this.gen("for (int index = 0, size = size" + property.name + "(); index < size; ++index) ");
                this.begin();
                string = string4 + "[index]";
            }
            this.gen("if (!(");
            if (bl3) {
                if (string3 == "float") {
                    this.gen("Float.floatToIntBits(" + string + ") == Float.floatToIntBits(inst." + string + ")");
                } else if (string3 == "double") {
                    this.gen("Double.doubleToLongBits(" + string + ") == Double.doubleToLongBits(inst." + string + ")");
                } else {
                    this.gen(string + " == inst." + string);
                }
            } else {
                this.gen(string + " == null ? inst." + string + " == null : " + string + ".equals(inst." + string + ")");
            }
            this.gen("))");
            this.cr();
            this.tabIn();
            this.gen("return false");
            this.eol();
            if (bl) {
                this.end();
            }
            this.select(7);
            if (bl) {
                this.gen("for (int index = 0, size = size" + property.name + "(); index < size; ++index) ");
                this.begin();
            }
            this.gen("result = 37*result + (");
            if (bl3) {
                this.gen(this.exprToInt(string3, string));
            } else {
                this.gen(string + " == null ? 0 : " + string + ".hashCode()");
            }
            this.gen(")");
            this.eol();
            if (bl) {
                this.end();
            }
            ++n2;
        }
        this.select(6);
        this.gen("return true");
        this.eol();
        this.end();
        this.cr();
        this.select(7);
        this.gen("return result");
        this.eol();
        this.end();
        this.cr();
    }

    private String exprToInt(String string, String string2) {
        if ((string = string.intern()) == "boolean") {
            return string2 + " ? 0 : 1";
        }
        if (string == "byte" || string == "char" || string == "short") {
            return "(int) " + string2;
        }
        if (string == "int") {
            return string2;
        }
        if (string == "long") {
            return "(int)(" + string2 + "^(" + string2 + ">>>32))";
        }
        if (string == "float") {
            return "Float.floatToIntBits(" + string2 + ")";
        }
        if (string == "double") {
            return this.exprToInt("long", "Double.doubleToIntBits(" + string2 + ")");
        }
        return "-1";
    }

    void genDeepCopy() {
        this.select(2);
        this.comment("Deep copy");
        this.gen(0, this.className);
        this.PO();
        this.gen(this.className);
        this.sp();
        this.gen("source");
        this.PC();
        this.sp();
        this.begin();
        int n = 0;
        int n2 = this.attrList.size();
        while (n < n2) {
            AbstractCodeGeneratorClass.Property property = (AbstractCodeGeneratorClass.Property)this.attrList.get(n);
            boolean bl = property.isIndexed();
            boolean bl2 = property.isScalar();
            String string = "_" + property.name;
            if (bl) {
                this.gen(string);
                this.gen(" = new " + property.classType + "[source.size" + property.name + "()]");
                this.eol();
                this.gen("for (int i = 0, size = source.size" + property.name + "(); i < size; ++i) ");
                this.begin();
            }
            boolean bl3 = false;
            boolean bl4 = true;
            if (bl2 || property.classType.equals("String") || property.classType.equals("java.lang.String")) {
                bl4 = false;
            } else if (!property.isBean) {
                bl3 = JavaBeanClass.isCloneable(property.classType);
            }
            this.gen(string);
            if (bl) {
                this.gen("[i]");
            }
            this.gen(" = ");
            StringBuffer stringBuffer = new StringBuffer("source.");
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append("[i]");
            }
            if (bl3) {
                this.gen(stringBuffer);
                this.gen(".clone()");
            } else if (bl4) {
                this.gen("new ");
                this.gen(property.classType);
                this.PO();
                this.gen(stringBuffer);
                this.PC();
            } else {
                this.gen(stringBuffer);
            }
            this.eol();
            if (bl) {
                this.end();
            }
            ++n;
        }
        this.end();
        this.cr();
    }

    public void genTrailer(int n) {
        this.select(n);
        if (this.metaElement != null && this.metaElement.getUserCode() != null) {
            String string = this.metaElement.getUserCode();
            this.cr();
            this.gencr(string);
        }
    }

    public void genFinishClass(int n) {
        this.select(n);
        this.end();
        this.cr();
    }

    private static boolean isCloneable(String string) {
        try {
            System.out.println("Looking for class: " + string);
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                return false;
            }
            System.out.println("Found class");
            if ((class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = JavaBeanClass.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).isAssignableFrom(clazz)) {
                System.out.println("Found cloneable: " + string);
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected AbstractCodeGeneratorClass.Signatures getSystemSignatures() {
        AbstractCodeGeneratorClass.Signature signature;
        AbstractCodeGeneratorClass.Signatures signatures = new AbstractCodeGeneratorClass.Signatures();
        if (this.config.generateXMLIO) {
            if (this.beanElement.isRoot) {
                signature = new AbstractCodeGeneratorClass.Signature("void", "write", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("java.io.OutputStream", "out");
                signature.addThrows("java.io.IOException");
                signatures.add(signature);
                signature = new AbstractCodeGeneratorClass.Signature("void", "write", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("java.io.OutputStream", "out");
                signature.addParameter("String", "encoding");
                signature.addThrows("java.io.IOException");
                signatures.add(signature);
                signature = new AbstractCodeGeneratorClass.Signature("void", "write", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("java.io.Writer", "out");
                signature.addParameter("String", "encoding");
                signature.addThrows("java.io.IOException");
                signatures.add(signature);
                signature = new AbstractCodeGeneratorClass.Signature(this.className, "read", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("java.io.InputStream", "in");
                signature.addThrows("javax.xml.parsers.ParserConfigurationException");
                signature.addThrows("org.xml.sax.SAXException");
                signature.addThrows("java.io.IOException");
                signature.setStatic();
                signatures.add(signature);
                signature = new AbstractCodeGeneratorClass.Signature(this.className, "read", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("org.xml.sax.InputSource", "in");
                signature.addParameter("boolean", "validate");
                signature.addParameter("org.xml.sax.EntityResolver", "er");
                signature.addParameter("org.xml.sax.ErrorHandler", "eh");
                signature.addThrows("javax.xml.parsers.ParserConfigurationException");
                signature.addThrows("org.xml.sax.SAXException");
                signature.addThrows("java.io.IOException");
                signature.setStatic();
                signatures.add(signature);
                signature = new AbstractCodeGeneratorClass.Signature(this.className, "read", AbstractCodeGeneratorClass.OTHER);
                signature.addParameter("org.w3c.dom.Document", "document");
                signature.setStatic();
                signatures.add(signature);
            }
            signature = new AbstractCodeGeneratorClass.Signature("void", "writeNode", AbstractCodeGeneratorClass.OTHER);
            signature.addParameter("java.io.Writer", "out");
            signature.addParameter("String", "indent");
            signature.addThrows("java.io.IOException");
            signatures.add(signature);
            signature = new AbstractCodeGeneratorClass.Signature("void", "readNode", AbstractCodeGeneratorClass.OTHER);
            signature.addParameter("org.w3c.dom.Node", "node");
            signatures.add(signature);
        }
        signature = new AbstractCodeGeneratorClass.Signature("boolean", "equals", AbstractCodeGeneratorClass.OTHER);
        signature.addParameter("Object", "o");
        signatures.add(signature);
        signatures.add(new AbstractCodeGeneratorClass.Signature("int", "hashCode", AbstractCodeGeneratorClass.OTHER));
        return signatures;
    }

    public void setInvalidPropertyNames(Map map) {
        map.put("Class", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

