/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings;
import org.netbeans.modules.debugger.jpda.Launcher;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.DebuggerInfoProducer;
import org.openide.TopManager;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.SharedClassObject;

class ConnectPanel
extends JPanel
implements DebuggerInfoProducer,
ActionListener {
    private JLabel lblConnectors;
    private JComboBox cbConnectors;
    private JLabel lblTransport;
    private JTextField tfTransport;
    private Map args;
    private int connectorCount;
    private List acs;
    private JTextField[] tfParams;
    private GridBagLayout gbl;
    private AttachingConnector ac;
    private JPDADebuggerProjectSettings jpdaSettings;
    private Map connectSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings;

    ConnectPanel() {
        int n;
        Object object;
        int n2;
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        this.acs = virtualMachineManager.attachingConnectors();
        this.connectorCount = this.acs.size();
        if (this.connectorCount == 0) {
            this.add(new JLabel(JPDADebugger.getLocString("CTL_No_Connector")));
            return;
        }
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        if (this.connectorCount > 1) {
            this.lblConnectors = new JLabel(JPDADebugger.getLocString("CTL_Connector"));
            this.cbConnectors = new JComboBox();
            this.cbConnectors.getAccessibleContext().setAccessibleDescription(JPDADebugger.getLocString("ACSD_CTL_Connector"));
            int n3 = this.acs.size();
            n2 = 0;
            while (n2 < n3) {
                object = (AttachingConnector)this.acs.get(n2);
                n = object.name().lastIndexOf(46);
                String string = n < 0 ? object.name() : object.name().substring(n + 1);
                this.cbConnectors.addItem(string + " (" + object.description() + ")");
                ++n2;
            }
            this.cbConnectors.setActionCommand("SwitchMe!");
        }
        this.tfTransport = new JTextField();
        this.tfTransport.setEditable(false);
        this.lblTransport = new JLabel(JPDADebugger.getLocString("CTL_Transport"));
        this.lblTransport.setDisplayedMnemonic(JPDADebugger.getLocString("CTL_Transport_Mnemonic").charAt(0));
        this.lblTransport.setLabelFor(this.tfTransport);
        n2 = 0;
        try {
            this.jpdaSettings = (JPDADebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings = ConnectPanel.class$("org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings")) : class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings), (boolean)true);
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
        }
        if (this.jpdaSettings != null && this.cbConnectors != null) {
            String string = this.jpdaSettings.getLastConnector();
            if (string != null) {
                object = this.acs.listIterator();
                n = 0;
                while (object.hasNext()) {
                    if (((AttachingConnector)object.next()).name().equals(string)) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            this.cbConnectors.setSelectedIndex(n2);
            this.cbConnectors.addActionListener(this);
        }
        this.refresh(n2);
    }

    private void refresh(int n) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Iterator iterator;
        GridBagConstraints gridBagConstraints;
        this.removeAll();
        if (this.cbConnectors != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 3, 3);
            this.gbl.setConstraints(this.lblConnectors, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 3, 3, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            this.gbl.setConstraints(this.cbConnectors, gridBagConstraints);
            this.add(this.lblConnectors);
            this.add(this.cbConnectors);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.gbl.setConstraints(this.lblTransport, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.gbl.setConstraints(this.tfTransport, gridBagConstraints);
        this.add(this.lblTransport);
        this.add(this.tfTransport);
        this.ac = (AttachingConnector)this.acs.get(n);
        this.tfTransport.setText(this.ac.transport().name());
        this.tfTransport.getAccessibleContext().setAccessibleDescription(JPDADebugger.getLocString("ACSD_CTL_Transport"));
        this.tfTransport.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ConnectPanel.this.tfTransport.selectAll();
            }
        });
        this.args = this.ac.defaultArguments();
        if (this.jpdaSettings != null) {
            this.connectSettings = this.jpdaSettings.getConnectionSettings();
            Iterator iterator2 = iterator = this.connectSettings == null ? null : (Map)this.connectSettings.get(this.ac.name());
            if (iterator != null) {
                Iterator iterator3 = this.args.keySet().iterator();
                while (iterator3.hasNext()) {
                    object3 = iterator3.next();
                    object2 = (String)iterator.get(object3);
                    if (object2 != null) {
                        ((Connector.Argument)this.args.get(object3)).setValue((String)object2);
                        continue;
                    }
                    string = (String)object3;
                    if (!string.equalsIgnoreCase("hostname") && !string.equalsIgnoreCase("host") && !string.equalsIgnoreCase("remotehost") || !Launcher.isUnknownHost((object = (Connector.Argument)this.args.get(object3)).value())) continue;
                    object.setValue("localhost");
                }
            }
        }
        this.tfParams = new JTextField[this.args.size()];
        iterator = this.args.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            char c;
            object3 = (String)iterator.next();
            object2 = (Connector.Argument)this.args.get(object3);
            string = object2.label();
            if (string.equalsIgnoreCase("Host")) {
                object = JPDADebugger.getLocString("CTL_Host");
                c = JPDADebugger.getLocString("CTL_Host_mnemonic").charAt(0);
            } else if (string.equalsIgnoreCase("Port")) {
                object = JPDADebugger.getLocString("CTL_Port");
                c = JPDADebugger.getLocString("CTL_Port_mnemonic").charAt(0);
            } else {
                object = string;
                c = ((String)object).charAt(0);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 0, 0, 3);
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel((String)object);
            jLabel.setDisplayedMnemonic(c);
            this.add((Component)jLabel, gridBagConstraints);
            JTextField jTextField = new JTextField(object2.value());
            jLabel.setLabelFor(jTextField);
            this.tfParams[n2++] = jTextField;
            jTextField.setName((String)object3);
            jTextField.getAccessibleContext().setAccessibleDescription(new MessageFormat(JPDADebugger.getLocString("ACSD_CTL_Argument")).format(new Object[]{object2.label()}));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 3, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jTextField, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        object3 = new JPanel();
        ((JComponent)object3).setPreferredSize(new Dimension(1, 1));
        this.add((Component)object3, gridBagConstraints);
    }

    public DebuggerInfo getDebuggerInfo() {
        if (this.jpdaSettings != null) {
            String string = this.ac.name();
            int n = this.tfParams.length;
            HashMap<String, String> hashMap = new HashMap<String, String>(n + 2);
            int n2 = 0;
            while (n2 < n) {
                JTextField jTextField = this.tfParams[n2];
                String string2 = jTextField.getName();
                String string3 = jTextField.getText();
                Connector.Argument argument = (Connector.Argument)this.args.get(string2);
                argument.setValue(string3);
                hashMap.put(string2, string3);
                ++n2;
            }
            this.connectSettings = this.connectSettings == null ? new HashMap(3) : new HashMap(this.connectSettings);
            this.connectSettings.put(string, hashMap);
            this.jpdaSettings.setLastConnector(string);
            this.jpdaSettings.setConnectionSettings(this.connectSettings);
        }
        return new RemoteDebuggerInfo(this.ac, this.args);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.refresh(((JComboBox)actionEvent.getSource()).getSelectedIndex());
        Container container = this.getParent();
        while (!(container instanceof Window)) {
            container = container.getParent();
        }
        if (container != null) {
            ((Window)container).pack();
        }
    }

    private String translate(String string) {
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

