/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;

public class StringList
extends JPanel
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.stringlist";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.stringlist", Locale.getDefault());
    protected JList list;
    protected DefaultListModel listModel = new DefaultListModel();
    protected JButton removeButton;
    protected JButton upButton;
    protected JButton downButton;
    protected Map listeners = new HashMap();

    public StringList(Action action) {
        super(new BorderLayout());
        this.listeners.put("AddButtonAction", action);
        this.listeners.put("RemoveButtonAction", new RemoveButtonAction());
        this.listeners.put("UpButtonAction", new UpButtonAction());
        this.listeners.put("DownButtonAction", new DownButtonAction());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionAdapter());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.list);
        this.add(jScrollPane);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.add("South", jPanel);
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("AddButton"));
        this.removeButton = buttonFactory.createJButton("RemoveButton");
        jPanel.add(this.removeButton);
        this.upButton = buttonFactory.createJButton("UpButton");
        jPanel.add(this.upButton);
        this.downButton = buttonFactory.createJButton("DownButton");
        jPanel.add(this.downButton);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    public String[] getStrings() {
        Object[] objectArray = this.listModel.toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public void setStrings(String[] stringArray) {
        this.listModel.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.listModel.addElement(stringArray[n]);
            ++n;
        }
    }

    public void add(String string) {
        this.listModel.addElement(string);
        this.updateButtons();
    }

    protected void updateButtons() {
        int n = this.listModel.size();
        int n2 = this.list.getSelectedIndex();
        boolean bl = n == 0;
        boolean bl2 = n2 != -1;
        boolean bl3 = n2 == 0;
        boolean bl4 = n2 == n - 1;
        this.removeButton.setEnabled(!bl && bl2);
        this.upButton.setEnabled(!bl && bl2 && !bl3);
        this.downButton.setEnabled(!bl && bl2 && !bl4);
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class ListSelectionAdapter
    implements ListSelectionListener {
        protected ListSelectionAdapter() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            StringList.this.removeButton.setEnabled(true);
            int n = StringList.this.list.getSelectedIndex();
            StringList.this.upButton.setEnabled(n != 0);
            StringList.this.downButton.setEnabled(n != StringList.this.listModel.size() - 1);
        }
    }

    protected class DownButtonAction
    extends AbstractAction {
        protected DownButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StringList.this.list.getSelectedIndex();
            Object e = StringList.this.listModel.getElementAt(n);
            StringList.this.listModel.removeElementAt(n);
            StringList.this.listModel.insertElementAt(e, n + 1);
            StringList.this.list.setSelectedIndex(n + 1);
        }
    }

    protected class UpButtonAction
    extends AbstractAction {
        protected UpButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StringList.this.list.getSelectedIndex();
            Object e = StringList.this.listModel.getElementAt(n);
            StringList.this.listModel.removeElementAt(n);
            StringList.this.listModel.insertElementAt(e, n - 1);
            StringList.this.list.setSelectedIndex(n - 1);
        }
    }

    protected class RemoveButtonAction
    extends AbstractAction {
        protected RemoveButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StringList.this.list.getSelectedIndex();
            StringList.this.listModel.removeElementAt(n);
            StringList.this.updateButtons();
        }
    }
}

