/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.Serializable;
import java.text.FieldPosition;
import java.util.Date;
import org.apache.tomcat.util.buf.DateTool;
import org.apache.tomcat.util.buf.MessageBytes;

public class ServerCookie
implements Serializable {
    private MessageBytes name = MessageBytes.newInstance();
    private MessageBytes value = MessageBytes.newInstance();
    private MessageBytes comment = MessageBytes.newInstance();
    private MessageBytes domain = MessageBytes.newInstance();
    private int maxAge = -1;
    private MessageBytes path = MessageBytes.newInstance();
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",;";
    private static final String ancientDate = DateTool.formatOldCookie(new Date(10000L));
    static final int dbg = 1;

    public static void appendCookieValue(StringBuffer buf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        buf.append(name);
        buf.append("=");
        ServerCookie.maybeQuote(version, buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                ServerCookie.maybeQuote(version, buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    DateTool.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
        }
        if (path != null) {
            buf.append("; Path=");
            ServerCookie.maybeQuote(version, buf, path);
        }
        if (isSecure) {
            buf.append("; Secure");
        }
    }

    public static boolean checkName(String name) {
        return ServerCookie.isToken(name) && !name.equalsIgnoreCase("Comment") && !name.equalsIgnoreCase("Discard") && !name.equalsIgnoreCase("Domain") && !name.equalsIgnoreCase("Expires") && !name.equalsIgnoreCase("Max-Age") && !name.equalsIgnoreCase("Path") && !name.equalsIgnoreCase("Secure") && !name.equalsIgnoreCase("Version");
    }

    public MessageBytes getComment() {
        return this.comment;
    }

    public String getCookieHeaderName() {
        return ServerCookie.getCookieHeaderName(this.version);
    }

    public static String getCookieHeaderName(int version) {
        ServerCookie.log(version == 1 ? "Set-Cookie2" : "Set-Cookie");
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    public MessageBytes getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public MessageBytes getName() {
        return this.name;
    }

    public MessageBytes getPath() {
        return this.path;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public MessageBytes getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void log(String s) {
        System.out.println("ServerCookie: " + s);
    }

    public static void maybeQuote(int version, StringBuffer buf, String value) {
        if (ServerCookie.isToken(value)) {
            buf.append(value);
        } else {
            if (version == 0) {
                throw new IllegalArgumentException(value);
            }
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }

    public void recycle() {
        this.path.recycle();
        this.name.recycle();
        this.value.recycle();
        this.comment.recycle();
        this.maxAge = -1;
        this.path.recycle();
        this.domain.recycle();
        this.version = 0;
        this.secure = false;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public String toString() {
        return "Cookie " + this.getName() + "=" + this.getValue() + " ; " + this.getVersion() + " " + this.getPath() + " " + this.getDomain();
    }
}

