/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.ServerSocketFactory;
import sun.security.provider.Sun;

public class JSSESocketFactory
extends ServerSocketFactory {
    private String keystoreType;
    static String defaultKeystoreType = "JKS";
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static boolean defaultClientAuth = false;
    private boolean clientAuth = false;
    private SSLServerSocketFactory sslProxy = null;
    static String defaultKeystoreFile = String.valueOf(System.getProperty("user.home")) + "/.keystore";
    static String defaultKeyPass = "changeit";

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        try {
            return socket.accept();
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    private KeyStore initKeyStore(String keystoreFile, String keyPass) throws IOException {
        FileInputStream istream = null;
        try {
            KeyStore kstore = KeyStore.getInstance(this.keystoreType);
            istream = new FileInputStream(keystoreFile);
            kstore.load(istream, keyPass.toCharArray());
            return kstore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Exception trying to load keystore " + keystoreFile + ": " + ex.getMessage());
        }
    }

    private void initProxy() throws IOException {
        try {
            String algorithm;
            String protocol;
            String keystorePass;
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            String keystoreFile = (String)this.attributes.get("keystore");
            if (keystoreFile == null) {
                keystoreFile = defaultKeystoreFile;
            }
            this.keystoreType = (String)this.attributes.get("keystoreType");
            if (this.keystoreType == null) {
                this.keystoreType = defaultKeystoreType;
            }
            this.clientAuth = (String)this.attributes.get("clientauth") != null;
            String keyPass = (String)this.attributes.get("keypass");
            if (keyPass == null) {
                keyPass = defaultKeyPass;
            }
            if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
                keystorePass = keyPass;
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            KeyStore kstore = this.initKeyStore(keystoreFile, keystorePass);
            SSLContext context = SSLContext.getInstance((String)protocol);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
            kmf.init(kstore, keyPass.toCharArray());
            TrustManager[] tm = null;
            if (this.clientAuth) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
                tmf.init(kstore);
                tm = tmf.getTrustManagers();
            }
            context.init(kmf.getKeyManagers(), tm, new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            return;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] cipherSuites = socket.getSupportedCipherSuites();
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setNeedClientAuth(this.clientAuth);
    }
}

