/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.tomcat.util.net.DefaultServerSocketFactory;

public abstract class ServerSocketFactory
implements Cloneable {
    private static ServerSocketFactory theFactory;
    protected Hashtable attributes = new Hashtable();

    protected ServerSocketFactory() {
    }

    public abstract Socket acceptSocket(ServerSocket var1) throws IOException;

    public abstract ServerSocket createSocket(int var1) throws IOException, InstantiationException;

    public abstract ServerSocket createSocket(int var1, int var2) throws IOException, InstantiationException;

    public abstract ServerSocket createSocket(int var1, int var2, InetAddress var3) throws IOException, InstantiationException;

    public static synchronized ServerSocketFactory getDefault() {
        if (theFactory == null) {
            theFactory = new DefaultServerSocketFactory();
        }
        try {
            return (ServerSocketFactory)theFactory.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public abstract void handshake(Socket var1) throws IOException;

    public void initSocket(Socket s) {
    }

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }
}

