/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.scm;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.util.Platform;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class AntStarTeamCheckOut
extends Task {
    public static final String DEFAULT_FORCESETTING = "false";
    public static final String DEFAULT_VERBOSESETTING = "false";
    public static final String DEFAULT_RECURSIONSETTING = "true";
    public static final String DEFAULT_INCLUDESETTING = "*";
    public static final String DEFAULT_EXCLUDESETTING = null;
    public static final String DEFAULT_FOLDERSETTING = null;
    private Folder prevFolder = null;
    private int checkedOut;
    private String serverName = null;
    private String serverPort = null;
    private String projectName = null;
    private String folderName = DEFAULT_FOLDERSETTING;
    private String viewName = null;
    private String username = null;
    private String password = null;
    private String targetFolder = null;
    private String force = "false";
    private String verbose = "false";
    private String recursion = "true";
    private String includes = "*";
    private String excludes = DEFAULT_EXCLUDESETTING;
    private String delim = Platform.getFilePathDelim();

    public void execute() throws BuildException {
        File dirExist;
        if (this.getServerName() == null) {
            ((ProjectComponent)this).project.log("ServerName must not be null.");
            return;
        }
        if (this.getServerPort() == null) {
            ((ProjectComponent)this).project.log("ServerPort must not be null.");
            return;
        }
        if (this.getProjectName() == null) {
            ((ProjectComponent)this).project.log("ProjectName must not be null.");
            return;
        }
        if (this.getViewName() == null) {
            ((ProjectComponent)this).project.log("ViewName must not be null.");
            return;
        }
        if (this.getUsername() == null) {
            ((ProjectComponent)this).project.log("Username must not be null.");
            return;
        }
        if (this.getPassword() == null) {
            ((ProjectComponent)this).project.log("Password must not be null.");
            return;
        }
        if (this.getTargetFolder() == null) {
            ((ProjectComponent)this).project.log("TargetFolder must not be null.");
            return;
        }
        if (null != this.getTargetFolder() && (this.getTargetFolder().endsWith("/") || this.getTargetFolder().endsWith("\\")) && this.getTargetFolder().length() > 1) {
            this.setTargetFolder(this.getTargetFolder().substring(0, this.getTargetFolder().length() - 1));
        }
        if (null != this.getFolderName() && (this.getFolderName().endsWith("/") || this.getFolderName().endsWith("\\")) && this.getFolderName().length() > 1) {
            this.setFolderName(this.getFolderName().substring(0, this.getFolderName().length() - 1));
        }
        if ((dirExist = new File(this.getTargetFolder())).isDirectory() && !this.getForceAsBoolean()) {
            ((ProjectComponent)this).project.log("Target directory exists. Set \"force\" to \"true\" to continue anyway.");
            return;
        }
        try {
            Server s = this.getServer();
            this.runServer(s);
            s.disconnect();
            ((ProjectComponent)this).project.log(this.checkedOut + " files checked out.");
        }
        catch (Throwable e) {
            ((ProjectComponent)this).project.log("    " + e.getMessage());
        }
    }

    protected Server getServer() {
        Server s = new Server(this.getServerName(), this.getServerPortAsInt());
        s.connect();
        s.logOn(this.getUsername(), this.getPassword());
        return s;
    }

    protected void runServer(Server s) {
        com.starbase.starteam.Project[] projects = s.getProjects();
        int i = 0;
        while (i < projects.length) {
            com.starbase.starteam.Project p = projects[i];
            if (p.getName().equals(this.getProjectName())) {
                if (this.getVerboseAsBoolean()) {
                    ((ProjectComponent)this).project.log("Found " + this.getProjectName() + this.delim);
                }
                this.runProject(s, p);
                break;
            }
            ++i;
        }
    }

    protected void runProject(Server s, com.starbase.starteam.Project p) {
        View[] views = p.getViews();
        int i = 0;
        while (i < views.length) {
            View v = views[i];
            if (v.getName().equals(this.getViewName())) {
                if (this.getVerboseAsBoolean()) {
                    ((ProjectComponent)this).project.log("Found " + this.getProjectName() + this.delim + this.getViewName() + this.delim);
                }
                this.runType(s, p, v, s.typeForName(s.getTypeNames().FILE));
                break;
            }
            ++i;
        }
    }

    protected void runType(Server s, com.starbase.starteam.Project p, View v, Type t) {
        Folder f = v.getRootFolder();
        if (this.getFolderName() != null) {
            if (this.getFolderName().equals("\\") || this.getFolderName().equals("/")) {
                this.setFolderName(null);
            } else {
                f = StarTeamFinder.findFolder((Folder)v.getRootFolder(), (String)this.getFolderName());
            }
        }
        if (this.getVerboseAsBoolean() && this.getFolderName() != null) {
            ((ProjectComponent)this).project.log("Found " + this.getProjectName() + this.delim + this.getViewName() + this.delim + this.getFolderName() + this.delim + "\n");
        }
        int nProperties = 2;
        Property p1 = this.getPrimaryDescriptor(t);
        Property p2 = this.getSecondaryDescriptor(t);
        if (p2 != null) {
            ++nProperties;
        }
        String[] strNames = new String[nProperties];
        int iProperty = 0;
        strNames[iProperty++] = s.getPropertyNames().OBJECT_ID;
        strNames[iProperty++] = p1.getName();
        if (p2 != null) {
            strNames[iProperty++] = p2.getName();
        }
        f.populateNow(t.getName(), strNames, -1);
        this.runFolder(s, p, v, t, f);
        f.discardItems(t.getName(), -1);
    }

    protected void runFolder(Server s, com.starbase.starteam.Project p, View v, Type t, Folder f) {
        Item[] items = f.getItems(t.getName());
        int i = 0;
        while (i < items.length) {
            this.runItem(s, p, v, t, f, items[i]);
            ++i;
        }
        if (this.getRecursionAsBoolean()) {
            Folder[] subfolders = f.getSubFolders();
            int i2 = 0;
            while (i2 < subfolders.length) {
                this.runFolder(s, p, v, t, subfolders[i2]);
                ++i2;
            }
        }
    }

    protected void runItem(Server s, com.starbase.starteam.Project p, View v, Type t, Folder f, Item item) {
        Property p1 = this.getPrimaryDescriptor(t);
        Property p2 = this.getSecondaryDescriptor(t);
        String pName = (String)item.get(p1.getName());
        boolean includeIt = false;
        boolean excludeIt = false;
        if (this.getIncludes() != null) {
            StringTokenizer inStr = new StringTokenizer(this.getIncludes(), " ");
            while (inStr.hasMoreTokens()) {
                if (!AntStarTeamCheckOut.match(inStr.nextToken(), pName)) continue;
                includeIt = true;
            }
        }
        if (this.getExcludes() != null) {
            StringTokenizer exStr = new StringTokenizer(this.getExcludes(), " ");
            while (exStr.hasMoreTokens()) {
                if (!AntStarTeamCheckOut.match(exStr.nextToken(), pName)) continue;
                excludeIt = true;
            }
        }
        if (!includeIt | excludeIt) {
            return;
        }
        if (this.getVerboseAsBoolean()) {
            int locker;
            boolean bShowHeader = true;
            if (f != this.prevFolder) {
                String strFolder = f.getFolderHierarchy();
                int i = strFolder.indexOf(this.delim);
                if (i >= 0) {
                    strFolder = strFolder.substring(i + 1);
                }
                System.out.println("            Folder: \"" + strFolder + "\"");
                this.prevFolder = f;
            } else {
                bShowHeader = false;
            }
            if (bShowHeader) {
                System.out.print("                Item");
                System.out.print(",\t" + p1.getDisplayName());
                if (p2 != null) {
                    System.out.print(",\t" + p2.getDisplayName());
                }
                System.out.println("");
            }
            System.out.print("                " + item.getItemID());
            System.out.print(",\t" + this.formatForDisplay(p1, item.get(p1.getName())));
            if (p2 != null) {
                System.out.print(",\t" + this.formatForDisplay(p2, item.get(p2.getName())));
            }
            if ((locker = item.getLocker()) > -1) {
                System.out.println(",\tLocked by " + locker);
            } else {
                System.out.println(",\tNot locked");
            }
        }
        com.starbase.starteam.File remote = (com.starbase.starteam.File)item;
        String dirName = v.getDefaultPath();
        dirName = dirName.replace('\\', '/');
        int endDirIndex = dirName.length();
        if (dirName.endsWith("/")) {
            --endDirIndex;
        }
        dirName = dirName.substring(dirName.lastIndexOf("/", dirName.length() - 2) + 1, endDirIndex);
        StringTokenizer pathTokenizer = new StringTokenizer(item.getParentFolder().getFolderHierarchy(), this.delim);
        String localName = this.delim;
        String currentToken = null;
        while (pathTokenizer.hasMoreTokens()) {
            currentToken = pathTokenizer.nextToken();
            if (currentToken.equals(this.getProjectName())) {
                currentToken = dirName;
            }
            localName = localName + currentToken + this.delim;
        }
        File local = new File(this.getTargetFolder() + localName + item.get(p1.getName()));
        try {
            remote.checkoutTo(local, 3, false, true, true);
        }
        catch (Throwable e) {
            ((ProjectComponent)this).project.log("    " + e.getMessage());
        }
        ++this.checkedOut;
    }

    protected Property getPrimaryDescriptor(Type t) {
        Property[] properties = t.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property p = properties[i];
            if (p.isPrimaryDescriptor()) {
                return p;
            }
            ++i;
        }
        return null;
    }

    protected Property getSecondaryDescriptor(Type t) {
        Property[] properties = t.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property p = properties[i];
            if (p.isDescriptor() && !p.isPrimaryDescriptor()) {
                return p;
            }
            ++i;
        }
        return null;
    }

    protected String formatForDisplay(Property p, Object value) {
        if (p.getTypeCode() == 8) {
            String str = value.toString();
            if (str.length() > 35) {
                str = str.substring(0, 32) + "...";
            }
            return "\"" + str + "\"";
        }
        if (p.getTypeCode() == 2) {
            return "\"" + p.getEnumDisplayName(((Integer)value).intValue()) + "\"";
        }
        return value.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean match(String pattern, String str) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && ch != strArr[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl32
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl32:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl33:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl45
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl45:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl46:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl86
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block24: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || ch == strArr[strIdxStart + i + j]) {
                            ++j;
                            continue;
                        }
                        break block24;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl86:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl87:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public int getServerPortAsInt() {
        return Integer.parseInt(this.serverPort);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public String getForce() {
        return this.force;
    }

    public boolean getForceAsBoolean() {
        return Project.toBoolean((String)this.force);
    }

    public void setRecursion(String recursion) {
        this.recursion = recursion;
    }

    public String getRecursion() {
        return this.recursion;
    }

    public boolean getRecursionAsBoolean() {
        return Project.toBoolean((String)this.recursion);
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    public String getVerbose() {
        return this.verbose;
    }

    public boolean getVerboseAsBoolean() {
        return Project.toBoolean((String)this.verbose);
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }
}

