/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import org.netbeans.modules.rmi.RMIModule;
import org.netbeans.modules.rmi.activation.ActivationItem;
import org.netbeans.modules.rmi.activation.ActivationNode;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public class InactivateAction
extends CookieAction {
    private static boolean debug = Boolean.getBoolean("org.netbeans.modules.rmi.test");
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationNode;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivateAction;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$InactivateAction;

    protected Class[] cookieClasses() {
        return new Class[]{class$org$netbeans$modules$rmi$activation$ActivationNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationNode = InactivateAction.class$("org.netbeans.modules.rmi.activation.ActivationNode")) : class$org$netbeans$modules$rmi$activation$ActivationNode};
    }

    protected int mode() {
        return 8;
    }

    protected void performAction(Node[] nodeArray) {
        int n = 0;
        while (n < nodeArray.length) {
            ActivationNode activationNode = (ActivationNode)nodeArray[n].getCookie(class$org$netbeans$modules$rmi$activation$ActivationNode == null ? InactivateAction.class$("org.netbeans.modules.rmi.activation.ActivationNode") : class$org$netbeans$modules$rmi$activation$ActivationNode);
            this.inactivate(activationNode.getItem());
            ++n;
        }
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$ActivateAction == null ? (class$org$netbeans$modules$rmi$activation$ActivateAction = InactivateAction.class$("org.netbeans.modules.rmi.activation.ActivateAction")) : class$org$netbeans$modules$rmi$activation$ActivateAction), (String)"LBL_InactivateAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/rmi/resources/InactivateActionIcon.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$InactivateAction == null ? (class$org$netbeans$modules$rmi$activation$InactivateAction = InactivateAction.class$("org.netbeans.modules.rmi.activation.InactivateAction")) : class$org$netbeans$modules$rmi$activation$InactivateAction), (String)string);
    }

    private void inactivate(final ActivationItem activationItem) {
        activationItem.getActivationSystemItem().getRP();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                try {
                    TopManager.getDefault().setStatusText(InactivateAction.this.getString("MSG_InactivateStart"));
                    activationItem.inactivate();
                    TopManager.getDefault().setStatusText(InactivateAction.this.getString("MSG_InactivateSuccessful"));
                }
                catch (ServerException serverException) {
                    try {
                        throw serverException.detail;
                    }
                    catch (ConnectException connectException) {
                        InactivateAction.this.failed(serverException, "ERR_ConnectException", activationItem);
                    }
                    catch (RemoteException remoteException) {
                        InactivateAction.this.failed(serverException, "ERR_InactivateRemoteException", activationItem);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        TopManager.getDefault().setStatusText(InactivateAction.this.getString("MSG_InactivateFailed"));
                        ErrorManager errorManager = RMIModule.getErrorManager(this.getClass());
                        errorManager.annotate(throwable, InactivateAction.this.getString("ERR_Inactivation"));
                        errorManager.notify(throwable);
                    }
                }
                catch (ConnectException connectException) {
                    InactivateAction.this.failed(connectException, "ERR_ConnectException", activationItem);
                }
                catch (RemoteException remoteException) {
                    InactivateAction.this.failed(remoteException, "ERR_InactivateRemoteException", activationItem);
                }
                catch (UnknownObjectException unknownObjectException) {
                    InactivateAction.this.failed((Exception)((Object)unknownObjectException), "ERR_InactivateUnknownObjectException", activationItem);
                }
                catch (UnknownGroupException unknownGroupException) {
                    InactivateAction.this.failed((Exception)((Object)unknownGroupException), "ERR_InactivateUnknownGroupException", activationItem);
                }
            }
        });
    }

    private void failed(Exception exception, String string, ActivationItem activationItem) {
        if (debug) {
            exception.printStackTrace();
        }
        TopManager.getDefault().setStatusText(this.getString("MSG_InactivateFailed"));
        activationItem.getActivationSystemItem().updateActivationItems();
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getString(string), 0));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

