/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfLoader;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.context.packager.WarServerArchiveBuilder;
import org.openide.TopManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.enum.SingletonEnumeration;

public class PackageWar
implements WebContextObject.WebContextPackager,
FileArchiveResource,
WebInfLoader.FileRecognizer {
    private static final String WARFILE = "_webmodule";
    private static final String WAREXT = "war";
    private static final String JARCONTENTEXT = "jarContent";
    private static File lastChosenFolder = null;
    private WebContextObject wco;
    private Server server = null;
    private J2eeAppStandardData appData = null;
    private File warFile;
    private static final FileFilter WARFILTER = new WarFileFilter();
    private static final FileObjectFilter WARCONTENTFILTER = new WarContentFilter();
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$PackageWar;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$actions$PackageWarAction;

    public PackageWar() {
        this.wco = null;
    }

    PackageWar(WebContextObject webContextObject, Server server, J2eeAppStandardData j2eeAppStandardData) {
        this(webContextObject, server, j2eeAppStandardData, null);
    }

    PackageWar(WebContextObject webContextObject, Server server, J2eeAppStandardData j2eeAppStandardData, File file) {
        this.wco = webContextObject;
        this.server = server;
        this.warFile = file == null ? this.getDefaultWarFile() : file;
    }

    public boolean recognizeFile(FileObject fileObject) {
        if (fileObject.getName().equals(WARFILE)) {
            String string = fileObject.getExt();
            return string.equals(WAREXT) || string.equals(JARCONTENTEXT);
        }
        return false;
    }

    public boolean isSignificant(FileObject fileObject) {
        return false;
    }

    public FileArchiveResource getResource(WebContextObject webContextObject, Server server, J2eeAppStandardData j2eeAppStandardData) {
        return this.getResource(webContextObject, server, j2eeAppStandardData, null);
    }

    public FileArchiveResource getResource(WebContextObject webContextObject, Server server, J2eeAppStandardData j2eeAppStandardData, File file) {
        if (webContextObject == null) {
            return null;
        }
        return new PackageWar(webContextObject, server, j2eeAppStandardData, file);
    }

    private void doPackage() throws Exception {
        if (this.warFile == null) {
            this.warFile = this.getDefaultWarFile();
        }
        PackageWar.doCompile(this.wco);
        this.runPackage();
    }

    public static void doCompile(WebContextObject webContextObject) throws Exception {
        PackageWar.doCompile(webContextObject.getInfObject());
    }

    public static void doCompile(WebInfObject webInfObject) throws Exception {
        CompilerTask compilerTask;
        CompilerCookie compilerCookie = (CompilerCookie)webInfObject.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = PackageWar.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (compilerCookie == null) {
            return;
        }
        CompilerJob compilerJob = AbstractCompileAction.createJob((Enumeration)new SingletonEnumeration((Object)compilerCookie), (Compiler.Depth)Compiler.DEPTH_INFINITE);
        compilerJob.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("MSG_WebModuleCompiling"));
        if (!compilerJob.isUpToDate() && !(compilerTask = compilerJob.start()).isSuccessful()) {
            throw new Exception(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("MSG_WebModuleCompilingFailed"));
        }
    }

    public File getFile() {
        try {
            this.doPackage();
            return PackageWar.ensureExtension(this.warFile, ".war");
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
            return null;
        }
    }

    public InputStream getJarFile() {
        try {
            this.doPackage();
            return new FileInputStream(PackageWar.ensureExtension(this.warFile, ".war"));
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
            return null;
        }
    }

    public InputStream getXML() {
        return null;
    }

    public String getArchiveFileName() {
        return null;
    }

    private void runPackage() throws Exception {
        OutputStream outputStream;
        block5: {
            File file = PackageWar.ensureExtension(this.warFile, ".war");
            ObjectOutputStream objectOutputStream = null;
            outputStream = null;
            WarServerArchiveBuilder warServerArchiveBuilder = null;
            JarCreator jarCreator = null;
            try {
                JarContent jarContent = new JarContent(WARCONTENTFILTER);
                jarContent.addDataObject((DataObject)this.wco);
                jarContent.setTargetResource(file.toURL());
                outputStream = new FileOutputStream(file);
                jarCreator = new JarCreator((ArchiveDescriptor)jarContent);
                warServerArchiveBuilder = new WarServerArchiveBuilder(this.wco, this.server, this.appData);
                jarCreator.addSpecificBuilder((ArchiveBuilder)warServerArchiveBuilder);
                jarCreator.createJar(outputStream, file);
                warServerArchiveBuilder.finish();
                Object var8_7 = null;
                if (objectOutputStream == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
            objectOutputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
    }

    protected File getDefaultWarFile() {
        File file = NbClassPath.toFile((FileObject)this.wco.getInfObject().getPrimaryFile());
        return new File(file, "_webmodule.war");
    }

    public static File ensureExtension(File file, String string) {
        String string2;
        if (file == null) {
            return null;
        }
        String string3 = file.getName();
        if (string3.length() <= 0) {
            return null;
        }
        String string4 = string2 = string.startsWith(".") ? string : "." + string;
        if (string3.endsWith(string2)) {
            return file;
        }
        int n = string3.lastIndexOf(".");
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        string3 = string3 + string2;
        return new File(file.getParentFile(), string3);
    }

    public static File fileChooseDialog() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(WARFILTER);
        if (lastChosenFolder != null) {
            jFileChooser.setCurrentDirectory(lastChosenFolder);
        }
        jFileChooser.setDialogTitle(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$actions$PackageWarAction == null ? (class$org$netbeans$modules$web$context$actions$PackageWarAction = PackageWar.class$("org.netbeans.modules.web.context.actions.PackageWarAction")) : class$org$netbeans$modules$web$context$actions$PackageWarAction)).getString("CTL_SelectWar"));
        if (jFileChooser.showDialog(TopManager.getDefault().getWindowManager().getMainWindow(), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$actions$PackageWarAction == null ? (class$org$netbeans$modules$web$context$actions$PackageWarAction = PackageWar.class$("org.netbeans.modules.web.context.actions.PackageWarAction")) : class$org$netbeans$modules$web$context$actions$PackageWarAction)).getString("CTL_SelectOk")) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            lastChosenFolder = jFileChooser.getCurrentDirectory();
            return PackageWar.ensureExtension(file, WAREXT);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class WarContentFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 2728555521505193570L;

        private WarContentFilter() {
        }

        public boolean accept(FileObject fileObject) {
            String string = fileObject.getExt();
            if (fileObject.getName().equals("web") && fileObject.getParent().getName().equals("WEB-INF")) {
                return string.equals("xml");
            }
            return !"java".equals(string) && !"form".equals(string);
        }

        private Object readResolve() throws ObjectStreamException {
            return WARCONTENTFILTER;
        }
    }

    private static final class WarFileFilter
    extends FileFilter {
        static /* synthetic */ Class class$org$netbeans$modules$web$context$actions$PackageWarAction;

        private WarFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".war");
        }

        public String getDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$actions$PackageWarAction == null ? (class$org$netbeans$modules$web$context$actions$PackageWarAction = WarFileFilter.class$("org.netbeans.modules.web.context.actions.PackageWarAction")) : class$org$netbeans$modules$web$context$actions$PackageWarAction)).getString("CTL_WarArchivesMask");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

