/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.web.context.PackageWar;
import org.netbeans.modules.web.context.WebAppObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfLoader;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class WebContextLoader
extends DataLoader {
    private static Set scheduledForAddition;
    private static final long serialVersionUID = -9190870926606500641L;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAllAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAllAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public WebContextLoader() {
        super("org.netbeans.modules.web.context.WebContextObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextLoader == null ? (class$org$netbeans$modules$web$context$WebContextLoader = WebContextLoader.class$("org.netbeans.modules.web.context.WebContextLoader")) : class$org$netbeans$modules$web$context$WebContextLoader), (String)"PROP_WebContextLoader_Name");
    }

    public static void install() {
        WebContextLoader.findWebApps();
        WebInfLoader.addFileRecognizer(new PackageWar());
    }

    public static void close() {
    }

    protected DataObject handleFindDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        if (fileObject.getParent() == null) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (WebContextLoader.isWebApplication(fileSystem) && WebContextLoader.canBeContext(fileSystem)) {
                    if (!WebContextLoader.isOrWillBeMounted(fileSystem)) {
                        return null;
                    }
                    WebContextObject webContextObject = new WebContextObject(fileObject, this);
                    return webContextObject;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)illegalArgumentException);
                return null;
            }
        }
        return null;
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = WebContextLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = WebContextLoader.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = WebContextLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = WebContextLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), SystemAction.get((Class)(class$org$openide$actions$CompileAllAction == null ? (class$org$openide$actions$CompileAllAction = WebContextLoader.class$("org.openide.actions.CompileAllAction")) : class$org$openide$actions$CompileAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = WebContextLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction)), SystemAction.get((Class)(class$org$openide$actions$BuildAllAction == null ? (class$org$openide$actions$BuildAllAction = WebContextLoader.class$("org.openide.actions.BuildAllAction")) : class$org$openide$actions$BuildAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = WebContextLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = WebContextLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = WebContextLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = WebContextLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = WebContextLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = WebContextLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), SystemAction.get((Class)(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = WebContextLoader.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = WebContextLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = WebContextLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected static void findWebApps() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                try {
                    Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
                    while (enumeration.hasMoreElements()) {
                        WebContextLoader.checkAndAddFs((FileSystem)enumeration.nextElement());
                    }
                }
                catch (Exception exception) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
                }
            }
        });
    }

    private static void checkAndAddFs(FileSystem fileSystem) throws Exception {
        if (WebContextLoader.isWebApplication(fileSystem) && !fileSystem.isHidden()) {
            try {
                DataObject.find((FileObject)fileSystem.getRoot()).setValid(false);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static WebContextObject findContext(FileSystem fileSystem) throws DataObjectNotFoundException {
        DataObject dataObject = DataObject.find((FileObject)fileSystem.getRoot());
        if (!(dataObject instanceof WebContextObject)) {
            try {
                dataObject.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            dataObject = DataObject.find((FileObject)fileSystem.getRoot());
        }
        if (dataObject instanceof WebContextObject) {
            return (WebContextObject)dataObject;
        }
        return null;
    }

    public static boolean isWebApplication(FileSystem fileSystem) {
        if (fileSystem == TopManager.getDefault().getRepository().getDefaultFileSystem()) {
            return false;
        }
        return fileSystem.findResource("WEB-INF/web.xml") != null;
    }

    public static boolean isWebApplication(DataObject dataObject) {
        if (dataObject == null) {
            return false;
        }
        if (dataObject instanceof WebAppObject) {
            return ((WebAppObject)dataObject).getContext() != null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            return fileObject.getParent() == null && WebContextLoader.isWebApplication(fileSystem);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean canBeContext(FileSystem fileSystem) {
        if (fileSystem.isHidden() || fileSystem.isReadOnly()) {
            return false;
        }
        return !(fileSystem instanceof JarFileSystem);
    }

    public static boolean canBeWebApplication(FileSystem fileSystem) {
        if (fileSystem == TopManager.getDefault().getRepository().getDefaultFileSystem()) {
            return false;
        }
        if (WebContextLoader.isWebApplication(fileSystem)) {
            return false;
        }
        return WebContextLoader.canBeContext(fileSystem);
    }

    static boolean isOrWillBeMounted(FileSystem fileSystem) {
        List<FileSystem> list = Arrays.asList(TopManager.getDefault().getRepository().toArray());
        if (list.contains(fileSystem)) {
            return true;
        }
        return scheduledForAddition != null && scheduledForAddition.contains(fileSystem);
    }

    public static void convert(FileSystem fileSystem) throws IOException {
        Class clazz;
        Class clazz2 = class$org$netbeans$modules$web$context$WebContextLoader == null ? (class$org$netbeans$modules$web$context$WebContextLoader = WebContextLoader.class$("org.netbeans.modules.web.context.WebContextLoader")) : class$org$netbeans$modules$web$context$WebContextLoader;
        synchronized (clazz2) {
            if (scheduledForAddition == null) {
                scheduledForAddition = new HashSet();
            }
            scheduledForAddition.add(fileSystem);
        }
        try {
            WebContextObject.checkOrCreateWebContext(fileSystem);
            TopManager.getDefault().getRepository().removeFileSystem(fileSystem);
            TopManager.getDefault().getRepository().addFileSystem(fileSystem);
            Object var4_3 = null;
            clazz = class$org$netbeans$modules$web$context$WebContextLoader == null ? (class$org$netbeans$modules$web$context$WebContextLoader = WebContextLoader.class$("org.netbeans.modules.web.context.WebContextLoader")) : class$org$netbeans$modules$web$context$WebContextLoader;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Class clazz3 = class$org$netbeans$modules$web$context$WebContextLoader == null ? (class$org$netbeans$modules$web$context$WebContextLoader = WebContextLoader.class$("org.netbeans.modules.web.context.WebContextLoader")) : class$org$netbeans$modules$web$context$WebContextLoader;
            synchronized (clazz3) {
                scheduledForAddition.remove(fileSystem);
            }
            throw throwable;
        }
        synchronized (clazz) {
            scheduledForAddition.remove(fileSystem);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

