/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.WebServerInstance;
import org.netbeans.modules.web.core.WebExecUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspParserAPI;
import org.netbeans.modules.web.core.jsploader.JspParserFactory;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebResourceImpl;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class JspCompileUtil {
    private static JspParserFactory parserFactory;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$JspCompileUtil;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public static FfjJspCompileContext getCurrentCompileContext(DataObject dataObject) {
        WebServerInstance webServerInstance = JspCompileUtil.getCurrentServerInstance(dataObject);
        if (webServerInstance == null) {
            return null;
        }
        return webServerInstance.getJspCompiler();
    }

    public static WebServerInstance getCurrentServerInstance(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        ServerInstance serverInstance = WebDataFactory.getFactory().findServerInstance((WebStandardData)JspCompileUtil.getResourceData(fileObject));
        if (serverInstance instanceof WebServerInstance) {
            return (WebServerInstance)serverInstance;
        }
        return null;
    }

    public static WebStandardData.WebResource getResourceData(FileObject fileObject) {
        WebStandardData.WebResource webResource = WebDataFactory.getFactory().findResource(fileObject.getPackageNameExt('/', '.'), WebDataFactory.getFactory().findWebModule(fileObject));
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject instanceof JspDataObject && !(webResource instanceof WebStandardData.WebJsp)) {
                webResource = WebDataFactory.getFactory().getWebJsp(fileObject.getPackageNameExt('/', '.'), WebDataFactory.getFactory().findWebModule(fileObject));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)dataObjectNotFoundException);
        }
        return webResource;
    }

    public static FileObject getFOForWebResource(WebStandardData.WebResource webResource) {
        return ((WebResourceImpl)webResource).getFileObject();
    }

    public static FileObject findFileObjectForFile(String string) {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = JspCompileUtil.findFileObjectForFile(fileSystem, string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public static FileObject findFileObjectForFile(String string, String string2) {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = JspCompileUtil.findFileObjectForFile(fileSystem, string);
            if (fileObject == null || !string2.equals(fileObject.getPackageNameExt('/', '.'))) continue;
            return fileObject;
        }
        return null;
    }

    public static FileObject findFileObjectForFile(FileSystem fileSystem, String string) {
        FileObject fileObject;
        String string2 = "";
        String string3 = "";
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        String string4 = string2.replace(File.separatorChar, '/');
        int n = -1;
        while (true) {
            File file;
            if ((n = string4.indexOf(47, n + 1)) == -1) {
                return null;
            }
            String string5 = string4.substring(n);
            fileObject = fileSystem.findResource(string5);
            if (fileObject == null || (file = NbClassPath.toFile((FileObject)fileObject)) == null) continue;
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                continue;
            }
            if (string3.equals(string2)) break;
        }
        return fileObject;
    }

    public static final String getFileObjectFileName(FileObject fileObject) throws FileStateInvalidException {
        File file = NbClassPath.toFile((FileObject)fileObject);
        if (file == null) {
            throw new FileStateInvalidException(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("CTL_NotLocalFile"));
        }
        return file.getAbsolutePath();
    }

    public static final FileObject getContextRoot(FileObject fileObject) throws FileStateInvalidException {
        return fileObject.getFileSystem().getRoot();
    }

    public static final String getContextPath(FileObject fileObject) {
        return "/" + fileObject.getPackageNameExt('/', '.');
    }

    public static final FileObject suggestContextOutputRoot(FileObject fileObject, Server server) throws IOException {
        File file = JspCompileUtil.suggestServerWorkDir(server);
        FileSystem fileSystem = fileObject.getFileSystem();
        int n = fileSystem.getSystemName().hashCode();
        String string = Long.toHexString(n <= 0 ? (long)(-n) : (long)n);
        File file2 = new File(file, URLEncoder.encode(string));
        return JspCompileUtil.getAsRootOfFileSystem(file2);
    }

    public static final File suggestServerWorkDir(Server server) {
        File file = JspCompileUtil.getOutputRootFolder();
        File file2 = server != null ? new File(file, URLEncoder.encode(server.getID())) : file;
        if (!file2.exists()) {
            boolean bl = WebExecUtil.myMkdirs(file2);
        }
        return file2;
    }

    public static File getOutputRootFolder() {
        String string = WebExecUtil.getUserNbHomeDirectory() + File.separator + "jspwork";
        File file = new File(string).getAbsoluteFile();
        return file;
    }

    static FileObject getAsRootOfFileSystem(File file) {
        File file2;
        FileSystem fileSystem;
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            fileSystem = (FileSystem)enumeration.nextElement();
            file2 = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            if (file2 == null || !file2.equals(file)) continue;
            return fileSystem.getRoot();
        }
        if (!file.exists()) {
            boolean bl = WebExecUtil.myMkdirs(file);
        }
        fileSystem = new FileSystemCapability.Bean();
        fileSystem.setCompile(true);
        fileSystem.setExecute(true);
        fileSystem.setDebug(true);
        fileSystem.setDoc(false);
        file2 = new LocalFileSystem((FileSystemCapability)fileSystem);
        try {
            file2.setRootDirectory(file);
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("EXC_JspFSNotCreated"), file.getAbsolutePath()), 0);
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
        file2.setHidden(true);
        TopManager.getDefault().getRepository().addFileSystem((FileSystem)file2);
        return file2.getRoot();
    }

    public static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = JspCompileUtil.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public static synchronized JspParserAPI getJspParser() {
        if (parserFactory == null) {
            FileObject fileObject = TopManager.getDefault().getRepository().findResource("/J2EE/JSPParser");
            if (fileObject != null) {
                try {
                    DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject).getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = JspCompileUtil.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                    parserFactory = new JspParserFactory(dataFolder);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify(4096, (Throwable)dataObjectNotFoundException);
                }
            } else {
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)new Exception(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("EXC_JspParserNotInstalled")));
            }
        }
        return parserFactory == null ? null : parserFactory.getJspParser();
    }

    public static FileObject findRelativeResource(FileObject fileObject, String string) throws FileStateInvalidException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException();
        }
        String string2 = fileObject.getPackageName('/');
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return fileObject.getFileSystem().findResource(string2 + string);
    }

    public static FileSystem mountJarIfNotMounted(String string) throws IOException {
        JarFileSystem jarFileSystem = new JarFileSystem();
        File file = new File(string);
        try {
            jarFileSystem.setJarFile(file);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        FileSystem fileSystem = JspCompileUtil.mountFS((FileSystem)jarFileSystem);
        return fileSystem;
    }

    private static FileSystem mountFS(FileSystem fileSystem) throws IOException {
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem2 = (FileSystem)enumeration.nextElement();
            if (!fileSystem2.getSystemName().equals(fileSystem.getSystemName())) continue;
            return fileSystem2;
        }
        fileSystem.setHidden(true);
        TopManager.getDefault().getRepository().addFileSystem(fileSystem);
        return fileSystem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

