/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.jndi.JndiNode;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.gui.AttributeCellRenderer;
import org.netbeans.modules.jndi.gui.CreateAttributePanel;
import org.netbeans.modules.jndi.utils.ExtAttribute;
import org.netbeans.modules.jndi.utils.SimpleListModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class AttributePanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private Dialog dlg;
    private DirContext ctx;
    private CompositeName offset;
    private SimpleListModel model;
    private JndiNode owner;
    private JButton addButton;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JList attrList;
    private JPanel jPanel1;
    private JButton editButton;
    private JButton removeButton;

    public AttributePanel(DirContext dirContext, CompositeName compositeName, JndiNode jndiNode) {
        this.ctx = dirContext;
        this.offset = compositeName;
        this.owner = jndiNode;
        this.initComponents();
        this.attrList.setCellRenderer(new AttributeCellRenderer());
        this.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_AttributePanel"));
        this.jLabel1.setDisplayedMnemonic(JndiRootNode.getLocalizedString("TXT_AttributeList_MNEM").charAt(0));
        this.addButton.addActionListener(this);
        this.addButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_AddAttribute"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.removeButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_RemoveAttribute"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this);
        this.editButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_ModifyAttribute"));
        this.attrList.addListSelectionListener(this);
        this.model = new SimpleListModel();
        this.attrList.setPrototypeCellValue("012345678901234567890123456789");
        this.attrList.setModel(this.model);
        this.attrList.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_AttributeList"));
        this.attrList.requestFocus();
        this.initData();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.attrList = new JList();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_AddAttribute_MNEM").charAt(0));
        this.addButton.setText(JndiRootNode.getLocalizedString("TXT_AddAttribute"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_RemoveAttribute_MNEM").charAt(0));
        this.removeButton.setText(JndiRootNode.getLocalizedString("TXT_RemoveAttribute"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        this.editButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_ModifyAttribute_MNEM").charAt(0));
        this.editButton.setText(JndiRootNode.getLocalizedString("TXT_ModifyAttribute"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.jPanel1.add((Component)this.editButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.attrList.setValueIsAdjusting(true);
        this.jScrollPane1.setViewportView(this.attrList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(4, 8, 8, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText(JndiRootNode.getLocalizedString("TXT_AttributeList"));
        this.jLabel1.setLabelFor(this.attrList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void initData() {
        try {
            Attributes attributes = this.ctx.getAttributes(this.offset);
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMoreElements()) {
                this.model.addElement(namingEnumeration.nextElement());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.attrList.getSelectedIndex() != -1) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            CreateAttributePanel createAttributePanel = new CreateAttributePanel();
            ExtAttribute extAttribute = new ExtAttribute();
            createAttributePanel.setModel(extAttribute);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createAttributePanel, JndiRootNode.getLocalizedString("TITLE_CreateAttribute"));
            this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
            ((Component)this.dlg).setVisible(true);
            if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
                try {
                    createAttributePanel.updateData();
                    BasicAttributes basicAttributes = new BasicAttributes();
                    basicAttributes.put(extAttribute);
                    this.ctx.modifyAttributes(this.offset, 1, (Attributes)basicAttributes);
                    this.model.addElement(extAttribute);
                    this.owner.updateData();
                }
                catch (NamingException namingException) {
                    JndiRootNode.notifyForeignException(namingException);
                }
            }
            this.dlg.dispose();
        } else if (actionEvent.getSource() == this.removeButton) {
            Attribute attribute = (Attribute)this.attrList.getSelectedValue();
            if (attribute != null) {
                try {
                    BasicAttributes basicAttributes = new BasicAttributes();
                    basicAttributes.put(attribute);
                    this.ctx.modifyAttributes(this.offset, 3, (Attributes)basicAttributes);
                    this.model.removeElementAt(this.attrList.getSelectedIndex());
                    this.owner.updateData();
                }
                catch (NamingException namingException) {
                    JndiRootNode.notifyForeignException(namingException);
                }
            }
        } else if (actionEvent.getSource() == this.editButton) {
            CreateAttributePanel createAttributePanel = new CreateAttributePanel();
            Attribute attribute = (Attribute)this.attrList.getSelectedValue();
            if (attribute != null) {
                ExtAttribute extAttribute = null;
                try {
                    extAttribute = new ExtAttribute(attribute);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                createAttributePanel.setModel(extAttribute);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createAttributePanel, JndiRootNode.getLocalizedString("TITLE_ModifyAttribute"));
                this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
                ((Component)this.dlg).setVisible(true);
                if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
                    try {
                        BasicAttributes basicAttributes;
                        createAttributePanel.updateData();
                        if (!attribute.getID().equals(extAttribute.getID())) {
                            basicAttributes = new BasicAttributes();
                            basicAttributes.put(attribute);
                            this.ctx.modifyAttributes(this.offset, 3, (Attributes)basicAttributes);
                        }
                        basicAttributes = new BasicAttributes();
                        basicAttributes.put(extAttribute);
                        this.ctx.modifyAttributes(this.offset, 2, (Attributes)basicAttributes);
                        this.model.changeElementAt(this.attrList.getSelectedIndex(), extAttribute);
                        this.owner.updateData();
                    }
                    catch (NamingException namingException) {
                        JndiRootNode.notifyForeignException(namingException);
                    }
                }
                this.dlg.dispose();
            }
        }
    }
}

