/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion.dtd;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

abstract class ContentModel {
    ContentModel() {
    }

    public static final ContentModel parseContentModel(String model) {
        if (model == null || model.length() == 0) {
            throw new IllegalArgumentException();
        }
        PushbackStringTokenizer tokens = new PushbackStringTokenizer(model, "|,*?+() \t\n", true);
        String next = tokens.nextToken();
        if (next.charAt(0) != '(') {
            throw new IllegalStateException();
        }
        return ContentModel.parseContentModel(tokens);
    }

    private static ContentModel parseContentModel(PushbackStringTokenizer tokens) {
        String next;
        char ch;
        ContentModel model = null;
        ArrayList<ContentModel> models = new ArrayList<ContentModel>(7);
        int type = 69;
        do {
            if ((ch = (next = tokens.nextToken()).charAt(0)) == ' ' || ch == '\t' || ch == '\n') continue;
            if (ch == '#') {
                while ((ch = tokens.nextToken().charAt(0)) == ' ' || ch == '\t' || ch == '\n') {
                }
                ch = tokens.nextToken().charAt(0);
                if (ch == '|') continue;
                throw new IllegalStateException();
            }
            if (ch == '(') {
                models.add(ContentModel.parseContentModel(tokens));
                continue;
            }
            if (ch == '|') {
                type = 124;
                continue;
            }
            if (ch == ',') {
                type = 44;
                continue;
            }
            if (ch == ')') break;
            model = new Element(next);
            while ((ch = (next = tokens.nextToken()).charAt(0)) == ' ' || ch == '\t' || ch == '\n') {
            }
            if (ch == '+') {
                model = new MultiplicityGroup(model, 1, -1);
            } else if (ch == '?') {
                model = new MultiplicityGroup(model, 0, 1);
            } else if (ch == '*') {
                model = new MultiplicityGroup(model, 0, -1);
            } else if (ch != ')') {
                tokens.pushback(next);
            }
            models.add(model);
        } while (ch != ')');
        if (type == 124) {
            model = new Choice(models.toArray(new ContentModel[0]));
        } else if (type == 44) {
            model = new Sequence(models.toArray(new ContentModel[0]));
        }
        while (tokens.hasMoreTokens() && ((ch = (next = tokens.nextToken()).charAt(0)) == ' ' || ch == '\t' || ch == '\n')) {
        }
        if (ch == '?') {
            model = new MultiplicityGroup(model, 0, 1);
        } else if (ch == '*') {
            model = new MultiplicityGroup(model, 0, -1);
        } else if (ch == '+') {
            model = new MultiplicityGroup(model, 1, -1);
        } else {
            tokens.pushback(next);
        }
        return model;
    }

    public final Enumeration whatCanFollow(Enumeration en) {
        this.reset();
        Food food = new Food(en);
        if (this.eat(food)) {
            return this.possibilities();
        }
        return null;
    }

    protected void reset() {
    }

    protected abstract boolean eat(Food var1);

    protected abstract Enumeration possibilities();

    protected boolean terminated() {
        return false;
    }

    protected boolean isOptional() {
        return false;
    }

    private static class PushbackStringTokenizer
    extends StringTokenizer {
        private String pushback = null;

        public PushbackStringTokenizer(String tokens, String delim, boolean inc) {
            super(tokens, delim, inc);
        }

        public String nextToken() {
            String next;
            if (this.pushback != null) {
                next = this.pushback;
                this.pushback = null;
            } else {
                next = super.nextToken();
            }
            return next;
        }

        public boolean hasMoreTokens() {
            if (this.pushback != null) {
                return true;
            }
            return super.hasMoreTokens();
        }

        public void pushback(String pushback) {
            if (this.pushback != null) {
                throw new IllegalStateException();
            }
            this.pushback = pushback;
        }
    }

    private static class Food {
        private final List list = new ArrayList(13);
        private final Enumeration en;
        private int current;

        public Food(Enumeration en) {
            this.en = en;
            this.current = 0;
        }

        public int mark() {
            return this.current;
        }

        public void reset(int pos) {
            this.current = pos;
        }

        public String next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            String next = (String)this.list.get(this.current);
            ++this.current;
            return next;
        }

        public boolean hasNext() {
            if (this.list.size() > this.current) {
                return true;
            }
            if (this.en.hasMoreElements()) {
                String next = (String)this.en.nextElement();
                return this.list.add(next);
            }
            return false;
        }
    }

    private static class Choice
    extends Sequence {
        public Choice(ContentModel[] models) {
            int i = 0;
            while (i < models.length) {
                models[i] = new MultiplicityGroup(models[i], 0, 1);
                ++i;
            }
            this.init(models);
        }

        public String toString() {
            return "Choice[" + super.toString() + "]";
        }
    }

    private static class MultiplicityGroup
    extends ContentModel {
        private final int min;
        private final int max;
        private final ContentModel peer;
        private int current = 0;

        public MultiplicityGroup(ContentModel model, int min, int max) {
            this.peer = model;
            this.min = min;
            this.max = max;
            this.current = 0;
        }

        protected void reset() {
            this.current = 0;
            this.peer.reset();
        }

        protected boolean eat(Food food) {
            while (food.hasNext()) {
                if (this.current == this.max) {
                    return true;
                }
                int store = food.mark();
                boolean accepted = this.peer.eat(food);
                if (!accepted) {
                    if (this.current < this.min) {
                        return false;
                    }
                    food.reset(store);
                    return true;
                }
                if (food.hasNext()) {
                    ++this.current;
                    this.peer.reset();
                    continue;
                }
                if (!this.peer.terminated()) continue;
                ++this.current;
            }
            return true;
        }

        public Enumeration possibilities() {
            if (!this.terminated()) {
                if (this.peer.terminated()) {
                    this.peer.reset();
                }
                return this.peer.possibilities();
            }
            return EmptyEnumeration.EMPTY;
        }

        protected boolean terminated() {
            boolean self;
            boolean bl = self = this.current == this.max;
            if (!self) {
                return false;
            }
            return this.peer.terminated();
        }

        protected boolean isOptional() {
            return this.current >= this.min && this.current != this.max;
        }

        public String toString() {
            return "MultiplicityGroup[peer=" + this.peer + ", min=" + this.min + ", max=" + this.max + ", current=" + this.current + "]";
        }
    }

    private static class Sequence
    extends ContentModel {
        private ContentModel[] models;
        private int current = 0;

        public Sequence(ContentModel[] models) {
            this.models = models;
        }

        protected Sequence() {
        }

        protected final void init(ContentModel[] models) {
            this.models = models;
        }

        protected void reset() {
            int i = 0;
            while (i <= this.current) {
                this.models[i].reset();
                ++i;
            }
            this.current = 0;
        }

        protected boolean eat(Food food) {
            while (food.hasNext()) {
                if (this.current == this.models.length) {
                    return true;
                }
                int store = food.mark();
                boolean accept = this.models[this.current].eat(food);
                boolean more = food.hasNext();
                if (!accept) {
                    return false;
                }
                if (more) {
                    ++this.current;
                    continue;
                }
                int i = this.current + 1;
                while (i < this.models.length) {
                    food.reset(store);
                    if (this.models[i].eat(food)) {
                        // empty if block
                    }
                    ++i;
                }
                if (!this.models[this.current].terminated()) continue;
                ++this.current;
            }
            return true;
        }

        protected boolean terminated() {
            if (this.current == this.models.length) {
                return true;
            }
            if (this.current < this.models.length - 1) {
                return false;
            }
            return this.models[this.current].terminated();
        }

        protected Enumeration possibilities() {
            if (!this.terminated()) {
                EmptyEnumeration en = EmptyEnumeration.EMPTY;
                int i = this.current;
                while (i < this.models.length) {
                    ContentModel next = this.models[i];
                    en = new SequenceEnumeration((Enumeration)en, next.possibilities());
                    if (!next.isOptional()) break;
                    ++i;
                }
                return en;
            }
            return EmptyEnumeration.EMPTY;
        }

        public String toString() {
            String ret = "Sequence[";
            int i = 0;
            while (i < this.models.length) {
                ret = ret + this.models[i].toString() + ", ";
                ++i;
            }
            return ret + " current=" + this.current + "]";
        }
    }

    private static class Element
    extends ContentModel {
        private final String name;
        private boolean full = false;

        public Element(String name) {
            this.name = name;
        }

        protected void reset() {
            this.full = false;
        }

        protected boolean eat(Food food) {
            if (!food.hasNext()) {
                return true;
            }
            String next = food.next();
            if (this.name.equals(next)) {
                this.full = true;
                return true;
            }
            return false;
        }

        protected Enumeration possibilities() {
            if (!this.terminated()) {
                return new SingletonEnumeration((Object)this.name);
            }
            return EmptyEnumeration.EMPTY;
        }

        protected boolean terminated() {
            return this.full;
        }

        public String toString() {
            return "Element[" + this.name + "]";
        }
    }
}

