/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting;

import bsh.BshClassManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.netbeans.modules.scripting.AbstractScriptType;
import org.openide.TopManager;
import org.openide.execution.ScriptType;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

public class BeanShellScriptType
extends AbstractScriptType {
    static final long serialVersionUID = -3650287473944191532L;
    private static final String BSH_EXTENSION = "bsh";
    private static final String BSH_DISPLAY_NAME = "BeanShell";
    private transient Interpreter bshInterpreter;
    private transient Set addedFss = new WeakSet(5);

    public BeanShellScriptType() {
        this.getExtensions().addExtension(BSH_EXTENSION);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new BeanShellScriptType();
    }

    private Interpreter getInterpreter() {
        if (this.bshInterpreter == null) {
            this.bshInterpreter = new Interpreter();
        }
        if (this.addedFss == null) {
            this.addedFss = new WeakSet(5);
        }
        FileSystem[] fileSystemArray = TopManager.getDefault().getRepository().toArray();
        int n = 0;
        while (n < fileSystemArray.length) {
            try {
                if (!this.addedFss.contains(fileSystemArray[n])) {
                    BshClassManager.getClassManager().addClassPath(fileSystemArray[n].getRoot().getURL());
                    this.addedFss.add(fileSystemArray[n]);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        return this.bshInterpreter;
    }

    protected String displayName() {
        return BSH_DISPLAY_NAME;
    }

    public void addVariable(String string, Object object) {
        this.getInterpreter().setVariable(string, object);
    }

    public Object eval(String string, ScriptType.Context context) throws InvocationTargetException {
        try {
            return this.getInterpreter().eval(this.saveConvert(string));
        }
        catch (TargetError targetError) {
            Throwable throwable = targetError.getTarget();
            throw new InvocationTargetException(throwable, throwable.getMessage());
        }
        catch (EvalError evalError) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                evalError.printStackTrace();
            }
            return null;
        }
    }

    public void exec(String string, ScriptType.Context context) throws InvocationTargetException {
        block3: {
            try {
                this.getInterpreter().eval(this.saveConvert(string));
            }
            catch (TargetError targetError) {
                Throwable throwable = targetError.getTarget();
                throw new InvocationTargetException(throwable, throwable.getMessage());
            }
            catch (EvalError evalError) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                evalError.printStackTrace();
            }
        }
    }
}

